/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.StiPacker;
import com.stimulsoft.base.helper.ISO9075;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.lib.commoninterface.IStiName;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.ICloneable;
import com.stimulsoft.report.IStiAlias;
import com.stimulsoft.report.IStiInherited;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.dictionary.enums.StiResourceType;
import com.stimulsoft.report.enums.StiComponentId;

public class StiResource
implements IStiName,
IStiInherited,
IStiJsonReportObject,
IStiSerializableToString,
IStiAlias,
ICloneable {
    public boolean inherited;
    private String name;
    private String alias;
    public byte[] content;
    public String key;
    public StiResourceType type = StiResourceType.Image;
    private boolean availableInTheViewer;

    @Override
    public Object clone() {
        try {
            JSONObject json = this.SaveToJsonObject(StiJsonSaveMode.Document);
            StiResource result = (StiResource)this.getClass().newInstance();
            result.LoadFromJsonObject(json);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject;
        block2: {
            jObject = new JSONObject();
            jObject.AddPropertyStringNullOfEmpty("Name", this.name);
            jObject.AddPropertyStringNullOfEmpty("Alias", this.alias);
            jObject.AddPropertyStringNullOfEmpty("Key", this.key);
            jObject.AddPropertyBool("Inherited", this.inherited);
            jObject.AddPropertyEnum("Type", (Enum)this.type, (Enum)StiResourceType.Image);
            jObject.AddPropertyBool("AvailableInTheViewer", this.availableInTheViewer);
            try {
                jObject.AddPropertyString("Image", StiPacker.packAndEncryptToString((byte[])this.content));
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) break block2;
                e.printStackTrace();
            }
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            block9: {
                if (property.Name.equals("Name")) {
                    this.name = (String)property.Value;
                }
                if (property.Name.equals("Alias")) {
                    this.alias = (String)property.Value;
                }
                if (property.Name.equals("Key")) {
                    this.key = (String)property.Value;
                }
                if (property.Name.equals("Inherited")) {
                    this.inherited = (Boolean)property.Value;
                }
                if (property.Name.equals("Type")) {
                    this.type = StiResourceType.valueOf((String)property.Value);
                }
                if (property.Name.equals("Image")) {
                    try {
                        this.content = StiPacker.unpackAndDecrypt((String)((String)property.Value));
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel < 10) break block9;
                        e.printStackTrace();
                    }
                }
            }
            if (!property.Name.equals("AvailableInTheViewer")) continue;
            this.availableInTheViewer = (Boolean)property.Value;
        }
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiResource;
    }

    public String getPropName() {
        return this.name;
    }

    @Override
    public boolean getInherited() {
        return this.inherited;
    }

    @Override
    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (!StiValidationUtil.equals((Object)this.name, (Object)value)) {
            if (StiValidationUtil.equals((Object)this.name, (Object)this.alias)) {
                this.setAlias(value);
            }
            this.name = value;
        }
        this.name = value;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public StiResourceType getType() {
        return this.type;
    }

    @StiSerializable
    public boolean isAvailableInTheViewer() {
        return this.availableInTheViewer;
    }

    public void setAvailableInTheViewer(boolean availableInTheViewer) {
        this.availableInTheViewer = availableInTheViewer;
    }

    public void setType(StiResourceType type) {
        this.type = type;
    }

    public StiImage getResourceAsImage() {
        if (this.content == null || this.type != StiResourceType.Image) {
            return null;
        }
        try {
            return new StiImage(this.content);
        }
        catch (Exception e) {
            if (StiOptions.Engine.logLevel >= 10) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public String toString() {
        if (StiOptions.Dictionary.isShowOnlyAliasForResource()) {
            return this.getAlias();
        }
        if (StiValidationUtil.equals((Object)this.getAlias(), (Object)this.getName())) {
            return this.getName();
        }
        return this.getName() + " [" + this.getAlias() + "]";
    }

    public StiResource() {
        this("", StiResourceType.Image, null);
    }

    public StiResource(String name, StiResourceType type, byte[] content) {
        this(name, name, false, type, content);
    }

    public StiResource(String name, String alias, StiResourceType type, byte[] content) {
        this(name, alias, false, type, content);
    }

    public StiResource(String name, String alias, boolean inherited, StiResourceType type, byte[] content) {
        this(name, alias, inherited, type, content, false);
    }

    public StiResource(String name, String alias, boolean inherited, StiResourceType type, byte[] content, boolean availableInTheViewer) {
        this.name = name;
        this.alias = alias;
        this.inherited = inherited;
        this.type = type;
        this.content = content;
        this.availableInTheViewer = availableInTheViewer;
    }

    public String serialize() {
        try {
            StringBuffer res = new StringBuffer();
            if (!StiValidationUtil.isNullOrWhiteSpace((String)this.name)) {
                res.append("Name=" + ISO9075.encode((String)this.name));
            }
            if (!StiValidationUtil.isNullOrWhiteSpace((String)this.alias)) {
                res.append((res.length() > 0 ? "," : "") + "Alias=" + ISO9075.encode((String)this.alias));
            }
            if (!StiValidationUtil.isNullOrWhiteSpace((String)this.key)) {
                res.append((res.length() > 0 ? "," : "") + "Key=" + ISO9075.encode((String)this.key));
            }
            if (this.inherited) {
                res.append((res.length() > 0 ? "," : "") + "Inherited=True");
            }
            if (this.availableInTheViewer) {
                res.append((res.length() > 0 ? "," : "") + "AvailableInTheViewer=True");
            }
            res.append((res.length() > 0 ? "," : "") + "Type=" + (Object)((Object)this.type));
            if (this.content != null) {
                res.append((res.length() > 0 ? "," : "") + "Content=" + ISO9075.encode((String)StiPacker.packAndEncryptToString((byte[])this.content)));
            }
            return res.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void deserialize(String strObject) {
        if (strObject == null) {
            return;
        }
        try {
            String[] values;
            for (String kv : values = strObject.split(",")) {
                String[] pv = kv.split("=");
                if (pv.length != 2) continue;
                String key = pv[0].trim();
                if ("Name".equals(key)) {
                    this.name = ISO9075.decode((String)pv[1]);
                    continue;
                }
                if ("Alias".equals(key)) {
                    this.alias = ISO9075.decode((String)pv[1]);
                    continue;
                }
                if ("Key".equals(key)) {
                    key = ISO9075.decode((String)pv[1]);
                    continue;
                }
                if ("Inherited".equals(key)) {
                    this.inherited = "True".equals(pv[1]);
                    continue;
                }
                if ("Type".equals(key)) {
                    this.type = StiResourceType.valueOf(pv[1]);
                    continue;
                }
                if ("Content".equals(key)) {
                    this.content = StiPacker.unpackAndDecrypt((String)ISO9075.decode((String)pv[1]));
                    continue;
                }
                if (!"AvailableInTheViewer".equals(key)) continue;
                this.availableInTheViewer = "True".equals(pv[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum Order {
        Name,
        Alias,
        Category;

    }
}

