/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.StiDataSortConditions;
import com.stimulsoft.report.dictionary.StiSort;
import com.stimulsoft.report.dictionary.data.DBNull;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.engine.parser.StiParser;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;

public class StiDataSort
implements Comparator<DataRow> {
    private StiDataSource dataSource;
    private List<StiSort> sortColumns;
    private Hashtable<DataRow, Object>[] hashValues;
    private Object value1;
    private Object value2;
    private DataRow row1;
    private DataRow row2;
    private final StiDataSortConditions sortConditions;
    private StiText textComp = null;

    public StiDataSort(Hashtable<DataRow, Integer> rowToConditions, Object[][][] conditions, List<StiSort> sortColumns, StiDataSource dataSource) {
        StiReport report;
        this.sortConditions = new StiDataSortConditions(rowToConditions, conditions);
        this.dataSource = dataSource;
        this.sortColumns = sortColumns;
        int count = sortColumns.size();
        this.hashValues = new Hashtable[count];
        for (int pos = 0; pos < count; ++pos) {
            this.hashValues[pos] = new Hashtable();
        }
        if (dataSource != null && dataSource.getDictionary() != null && (report = dataSource.getDictionary().getReport()) != null) {
            this.textComp = new StiText();
            this.textComp.setName("**StiDataSort**");
            this.textComp.setPage(report.getPages().get(0));
        }
    }

    @Override
    public int compare(DataRow row1, DataRow row2) {
        this.row1 = row1;
        this.row2 = row2;
        int res = this.CompareRows();
        return Math.max(-1, Math.min(1, res));
    }

    private int CompareRows() {
        try {
            if (this.row1.equals(this.row2)) {
                return 0;
            }
            int compareConditions = this.sortConditions.compare(this.row1, this.row2);
            if (compareConditions != 0) {
                return compareConditions;
            }
            return this.compareRow();
        }
        catch (Exception e) {
            if (StiOptions.Engine.logLevel >= 10) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    private int compareRow() {
        if (this.sortColumns == null || this.sortColumns.size() == 0) {
            return 0;
        }
        int sortIndex = 0;
        for (StiSort sort : this.sortColumns) {
            this.value1 = this.hashValues[sortIndex].containsKey(this.row1) ? this.hashValues[sortIndex].get(this.row1) : null;
            Object object = this.value2 = this.hashValues[sortIndex].containsKey(this.row2) ? this.hashValues[sortIndex].get(this.row2) : null;
            if (this.value1 == null || this.value2 == null) {
                String columnName = sort.column;
                if (this.existConditions(columnName)) {
                    this.getValueByConditions(columnName, this.row1, this.row2);
                } else if (sort.existRelations()) {
                    this.processParent(sort, sortIndex, columnName);
                } else {
                    this.setValues(this.row1, this.row2, sortIndex, columnName);
                }
            }
            ++sortIndex;
            int dataResult = StiDataSort.CompareValues(this.value1, this.value2, sort.order);
            if (dataResult == 0) continue;
            return dataResult;
        }
        return 0;
    }

    private void processParent(StiSort sort, int sortIndex, String columnName) {
        DataRow rowParent1 = this.row1;
        DataRow rowParent2 = this.row2;
        StiDataSource dataSourceParent = this.dataSource;
        for (String relationName : sort.relations) {
            StiDataRelation relation = dataSourceParent.getRelations(relationName);
            dataSourceParent = relation.getParentSource();
            rowParent1 = relation.getFirstParentRows(rowParent1);
            rowParent2 = relation.getFirstParentRows(rowParent2);
        }
        this.setValues(rowParent1, rowParent2, sortIndex, columnName);
    }

    private void setValues(DataRow row1, DataRow row2, int sortIndex, String columnName) {
        int columnIndex;
        int n = columnIndex = row1 != null ? row1.getColumnIndex(columnName) : -1;
        if (columnIndex < 0) {
            columnIndex = this.dataSource.GetColumnIndex(columnName);
        }
        if (this.value1 == null && columnIndex != -1) {
            this.value1 = row1.getValue(columnIndex);
            if (!this.hashValues[sortIndex].containsKey(row1)) {
                this.hashValues[sortIndex].put(row1, this.value1 == null ? "" : this.value1);
            }
        }
        if (columnIndex < 0) {
            int n2 = columnIndex = row2 != null ? row2.getColumnIndex(columnName) : -1;
        }
        if (this.value2 == null && columnIndex != -1 && row2 != null) {
            this.value2 = row2.getValue(columnIndex);
            if (!this.hashValues[sortIndex].containsKey(row2)) {
                this.hashValues[sortIndex].put(row2, this.value2 == null ? "" : this.value2);
            }
        }
    }

    private void getValueByConditions(String columnName, DataRow row1, DataRow row2) {
        String method = columnName.substring(1, 1 + columnName.length() - 2);
        int positionOfRow1 = this.sortConditions.getRowPositionConditions(row1);
        int positionOfRow2 = this.sortConditions.getRowPositionConditions(row2);
        int oldPosition = this.dataSource.getPosition();
        this.dataSource.setPosition(positionOfRow1);
        this.value1 = StiParser.ParseTextValue(columnName, (StiComponent)this.textComp);
        this.dataSource.setPosition(positionOfRow2);
        this.value2 = StiParser.ParseTextValue(columnName, (StiComponent)this.textComp);
        this.dataSource.setPosition(oldPosition);
    }

    private boolean existConditions(String columnName) {
        return columnName.startsWith("{") && columnName.endsWith("}");
    }

    private Object invokeMetod(Method methodInfo) {
        try {
            Object result = methodInfo.invoke((Object)this.dataSource.getDictionary().getReport(), new Object[0]);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Method getMetod(String metodName) {
        try {
            Method result = this.dataSource.getDictionary().getReport().getClass().getMethod(metodName, new Class[0]);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int CompareValues(Object value1, Object value2) {
        return StiDataSort.CompareValues(value1, value2, StiSort.Order.Asc);
    }

    public static int CompareValues(Object value1, Object value2, StiSort.Order order) {
        int direction = order.value;
        if (value1 instanceof String && value2 instanceof String) {
            return StiDataSort.compareStringValues((String)value1, (String)value2) * direction;
        }
        if (DBNull.Value.equals(value1) && DBNull.Value.equals(value2)) {
            return 0;
        }
        if (DBNull.Value.equals(value1)) {
            return -1 * direction;
        }
        if (DBNull.Value.equals(value2)) {
            return 1 * direction;
        }
        Comparable comparable1 = (Comparable)(value1 instanceof Comparable ? value1 : null);
        Comparable comparable2 = (Comparable)(value2 instanceof Comparable ? value2 : null);
        if (comparable1 == null && comparable2 == null) {
            return 0;
        }
        if (comparable1 == null) {
            return -1 * direction;
        }
        if (comparable2 == null) {
            return 1 * direction;
        }
        int result = 0;
        try {
            result = comparable1.compareTo(comparable2);
        }
        catch (ClassCastException e) {
            if (comparable1 instanceof Number && comparable2 instanceof Number) {
                result = new Double(comparable1.toString()).compareTo(new Double(comparable2.toString()));
            }
            throw e;
        }
        return result * order.value;
    }

    private static int compareStringValues(String value1, String value2) {
        if (value1 == null) {
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        int compareToIgnoreCase = value1.compareToIgnoreCase(value2);
        if (compareToIgnoreCase == 0) {
            return value1.compareTo(value2);
        }
        return compareToIgnoreCase;
    }

    public final void Clear() {
        this.sortColumns = null;
        this.hashValues = null;
        this.dataSource = null;
    }
}

