/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.IStiValueCollection;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.system.StiCollection;
import com.stimulsoft.lib.utils.StiCollectionsUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.dictionary.StiCalcDataColumn;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class StiDataColumnsCollection
extends StiCollection<StiDataColumn>
implements IStiValueCollection,
IStiJsonReportObject {
    private static final long serialVersionUID = 7003399120723721544L;
    private static final Comparator<StiDataColumn> BY_CORRECT_NAME = new Comparator<StiDataColumn>(){

        @Override
        public int compare(StiDataColumn value1, StiDataColumn value2) {
            return value1.getName().compareTo(value2.getName());
        }
    };

    public StiDataColumnsCollection() {
    }

    public StiDataColumnsCollection(StiBusinessObject stiBusinessObject) {
    }

    public StiDataColumnsCollection(StiDataSource stiDataSource) {
    }

    public StiDataColumn get(String columnName) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            StiDataColumn column = (StiDataColumn)iterator.next();
            if (!column.getNameInSource().equals(columnName)) continue;
            return column;
        }
        return (StiDataColumn)StiCollectionsUtil.getElementOrNull((ArrayList)((Object)this), (String)columnName, StiDataColumn.class);
    }

    public boolean add(StiDataColumn e) {
        boolean exists = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            StiDataColumn column = (StiDataColumn)iterator.next();
            if (!StiValidationUtil.equals((Object)column.getName(), (Object)e.getName())) continue;
            exists = true;
        }
        if (!exists) {
            return super.add((Object)e);
        }
        return false;
    }

    public int getIndexByName(String columnName) {
        return this.getIndexByName(columnName, true);
    }

    public int getIndexByName(String columnName, boolean sort) {
        StiDataColumn col;
        if (sort) {
            this.sort();
            StiDataColumn keyInstance = new StiDataColumn();
            keyInstance.setCorrectName(columnName);
            return Collections.binarySearch(this, keyInstance, BY_CORRECT_NAME);
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            col = (StiDataColumn)iterator.next();
            if (!columnName.equals(col.getNameInSource())) continue;
            return this.indexOf(col);
        }
        iterator = this.iterator();
        while (iterator.hasNext()) {
            col = (StiDataColumn)iterator.next();
            if (!columnName.equals(col.getName())) continue;
            return this.indexOf(col);
        }
        iterator = this.iterator();
        while (iterator.hasNext()) {
            col = (StiDataColumn)iterator.next();
            if (!columnName.equalsIgnoreCase(col.getName())) continue;
            return this.indexOf(col);
        }
        return -1;
    }

    public ArrayList<StiDataColumn> getCachedDataColumns() {
        return null;
    }

    public Class<?> getItemsType(String textContext) {
        String[] values = textContext.split(",", -1);
        return values.length == 4 ? StiCalcDataColumn.class : StiDataColumn.class;
    }

    public boolean contains(String columnName) {
        return this.getIndexByName(columnName, false) > -1;
    }

    protected Comparator<? super StiDataColumn> getComporator() {
        return BY_CORRECT_NAME;
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        if (this.size() == 0) {
            return null;
        }
        JSONObject jObject = new JSONObject();
        Integer index = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            StiDataColumn column = (StiDataColumn)iterator.next();
            jObject.AddPropertyJObject(index.toString(), column.SaveToJsonObject(mode));
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            StiDataColumn column = null;
            JSONObject propJObject = (JSONObject)property.Value;
            JProperty ident = propJObject.Properties().FirstOrDefault("Ident");
            column = ident != null && "Calc".equals(ident.Value) ? new StiCalcDataColumn() : new StiDataColumn();
            column.LoadFromJsonObject((JSONObject)property.Value);
            this.add(column);
        }
    }
}

