/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dialogs;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiEventHandlerArgs;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.enums.StiReportControlToolboxPosition;
import com.stimulsoft.report.components.interfaces.IStiDataSource;
import com.stimulsoft.report.dialogs.StiDataGridLineStyle;
import com.stimulsoft.report.dialogs.StiGridColumnsCollection;
import com.stimulsoft.report.dialogs.StiReportControl;
import com.stimulsoft.report.dictionary.IStiEnumerator;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.events.StiPositionChangedEvent;
import com.stimulsoft.report.options.EngineOptions;

public class StiGridControl
extends StiReportControl
implements IStiDataSource,
IStiEnumerator {
    private StiColor alternatingBackColor = StiColorEnum.Window.color();
    private StiColor backgroundColor = StiColorEnum.AppWorkspace.color();
    private StiColor gridLineColor = StiColorEnum.Control.color();
    private StiColor headerBackColor = StiColorEnum.Control.color();
    private StiColor headerForeColor = StiColorEnum.ControlText.color();
    private StiColor selectionBackColor = StiColorEnum.ActiveCaption.color();
    private StiColor selectionForeColor = StiColorEnum.ActiveCaptionText.color();
    private String filter = "";
    private StiFont headerFont = new StiFont("Microsoft Sans Serif", 8.0);
    private boolean columnHeadersVisible = true;
    private boolean rowHeadersVisible = true;
    private int preferredColumnWidth = 75;
    private int preferredRowHeight = 16;
    private int rowHeaderWidth = 35;
    private StiGridColumnsCollection columns;
    public boolean isEofValue = false;
    public boolean isBofValue = false;
    private String dataSourceName = "";
    private StiDataGridLineStyle gridLineStyle = StiDataGridLineStyle.Solid;
    private static final Object EventPositionChanged = new Object();

    public StiGridControl() {
        this(StiRectangle.empty());
    }

    public StiGridControl(StiRectangle rect) {
        super(rect);
        this.columns = new StiGridColumnsCollection(this);
        this.setPlaceOnToolbox(true);
    }

    @Override
    public int getToolboxPosition() {
        return StiReportControlToolboxPosition.GridControl.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Dialogs", (String)"StiGridControl");
    }

    @Override
    @StiSerializable
    public StiColor getForeColor() {
        return super.getForeColor();
    }

    @Override
    public void setForeColor(StiColor value) {
        super.setForeColor(value);
    }

    @Override
    @StiSerializable
    public StiColor getBackColor() {
        return super.getBackColor();
    }

    @Override
    public void setBackColor(StiColor value) {
        super.setBackColor(value);
    }

    @StiSerializable
    public StiColor getAlternatingBackColor() {
        return this.alternatingBackColor;
    }

    public void setAlternatingBackColor(StiColor value) {
        this.alternatingBackColor = value;
        this.UpdateReportControl("AlternatingBackColor");
    }

    @StiSerializable
    public StiColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(StiColor value) {
        this.backgroundColor = value;
        this.UpdateReportControl("BackgroundColor");
    }

    @StiSerializable
    public StiColor getGridLineColor() {
        return this.gridLineColor;
    }

    public void setGridLineColor(StiColor value) {
        this.gridLineColor = value;
        this.UpdateReportControl("GridLineColor");
    }

    @StiSerializable
    public StiColor getHeaderBackColor() {
        return this.headerBackColor;
    }

    public void setHeaderBackColor(StiColor value) {
        this.headerBackColor = value;
        this.UpdateReportControl("HeaderBackColor");
    }

    @StiSerializable
    public StiColor getHeaderForeColor() {
        return this.headerForeColor;
    }

    public void setHeaderForeColor(StiColor value) {
        this.headerForeColor = value;
        this.UpdateReportControl("HeaderForeColor");
    }

    @StiSerializable
    public StiColor getSelectionBackColor() {
        return this.selectionBackColor;
    }

    public void setSelectionBackColor(StiColor value) {
        this.selectionBackColor = value;
        this.UpdateReportControl("SelectionBackColor");
    }

    @StiSerializable
    public StiColor getSelectionForeColor() {
        return this.selectionForeColor;
    }

    public void setSelectionForeColor(StiColor value) {
        this.selectionForeColor = value;
        this.UpdateReportControl("SelectionForeColor");
    }

    private boolean ShouldSerializeAlternatingBackColor() {
        return this.alternatingBackColor != StiColorEnum.Window.color();
    }

    private boolean ShouldSerializeBackgroundColor() {
        return this.backgroundColor != StiColorEnum.AppWorkspace.color();
    }

    private boolean ShouldSerializeGridLineColor() {
        return this.gridLineColor != StiColorEnum.Control.color();
    }

    private boolean ShouldSerializeHeaderBackColor() {
        return this.headerBackColor != StiColorEnum.Control.color();
    }

    private boolean ShouldSerializeHeaderForeColor() {
        return this.headerForeColor != StiColorEnum.ControlText.color();
    }

    private boolean ShouldSerializeSelectionBackColor() {
        return this.selectionBackColor != StiColorEnum.ActiveCaption.color();
    }

    private boolean ShouldSerializeSelectionForeColor() {
        return this.selectionForeColor != StiColorEnum.ActiveCaptionText.color();
    }

    private boolean ShouldSerializeBackColor() {
        return this.getBackColor() != StiColorEnum.Control.color();
    }

    private boolean ShouldSerializeForeColor() {
        return this.getForeColor() != StiColorEnum.ControlText.color();
    }

    @StiDefaulValue(value="")
    @StiSerializable
    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String value) {
        this.filter = value;
        this.UpdateReportControl("Filter");
    }

    @StiSerializable
    public StiFont getHeaderFont() {
        return this.headerFont;
    }

    public void setHeaderFont(StiFont value) {
        this.headerFont = value;
        this.UpdateReportControl("HeaderFont");
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getColumnHeadersVisible() {
        return this.columnHeadersVisible;
    }

    public void setColumnHeadersVisible(boolean value) {
        this.columnHeadersVisible = value;
        this.UpdateReportControl("ColumnHeadersVisible");
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getRowHeadersVisible() {
        return this.rowHeadersVisible;
    }

    public void setRowHeadersVisible(boolean value) {
        this.rowHeadersVisible = value;
        this.UpdateReportControl("RowHeadersVisible");
    }

    @StiDefaulValue(value="Solid")
    @StiSerializable
    public StiDataGridLineStyle getGridLineStyle() {
        return this.gridLineStyle;
    }

    public void setGridLineStyle(StiDataGridLineStyle value) {
        this.gridLineStyle = value;
        this.UpdateReportControl("GridLineStyle");
    }

    @StiDefaulValue(value="75")
    @StiSerializable
    public int getPreferredColumnWidth() {
        return this.preferredColumnWidth;
    }

    public void setPreferredColumnWidth(int value) {
        this.preferredColumnWidth = value;
        this.UpdateReportControl("PreferredColumnWidth");
    }

    @StiDefaulValue(value="16")
    @StiSerializable
    public int getPreferredRowHeight() {
        return this.preferredRowHeight;
    }

    public void setPreferredRowHeight(int value) {
        this.preferredRowHeight = value;
        this.UpdateReportControl("PreferredRowHeight");
    }

    @StiDefaulValue(value="35")
    @StiSerializable
    public int getRowHeaderWidth() {
        return this.rowHeaderWidth;
    }

    public void setRowHeaderWidth(int value) {
        this.rowHeaderWidth = value;
        this.UpdateReportControl("RowHeaderWidth");
    }

    @StiSerializable
    public StiGridColumnsCollection getColumns() {
        return this.columns;
    }

    public void setColumns(StiGridColumnsCollection value) {
        this.columns = value;
    }

    public void MoveNext() {
        this.Next();
    }

    @Override
    public void First() {
        if (this.getDataSource() != null) {
            this.getDataSource().First();
        }
    }

    @Override
    public void Prior() {
        if (this.getDataSource() != null) {
            this.getDataSource().Prior();
        }
    }

    @Override
    public void Next() {
        if (this.getDataSource() != null) {
            this.getDataSource().Next();
        }
    }

    @Override
    public void Last() {
        if (this.getDataSource() != null) {
            this.getDataSource().Last();
        }
    }

    @Override
    public boolean getIsEof() {
        if (this.getDataSource() != null) {
            return this.getDataSource().getIsEof();
        }
        return true;
    }

    @Override
    public void setIsEof(boolean value) {
        if (this.getDataSource() != null) {
            this.getDataSource().setIsEof(value);
        } else {
            this.isEofValue = value;
        }
    }

    @Override
    public boolean getIsBof() {
        if (this.getDataSource() != null) {
            return this.getDataSource().getIsBof();
        }
        return false;
    }

    @Override
    public void setIsBof(boolean value) {
        if (this.getDataSource() != null) {
            this.getDataSource().setIsBof(value);
        } else {
            this.isBofValue = value;
        }
    }

    @Override
    public boolean getIsEmpty() {
        if (this.getDataSource() != null) {
            return this.getDataSource().getIsEmpty();
        }
        return false;
    }

    @Override
    public StiDataSource getDataSource() {
        if (this.getPage() == null || this.getReport() == null || this.getReport().getDataSources() == null || this.getDataSourceName() == null || this.getDataSourceName().length() == 0) {
            return null;
        }
        return this.getReport().getDataSources().get(this.getDataSourceName());
    }

    @Override
    @StiSerializable
    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public final void setDataSourceName(String value) {
        if (!this.dataSourceName.equals(value)) {
            this.dataSourceName = value;
            EngineOptions.GlobalEvents.InvokeDataSourceAssigned(this, StiEventHandlerArgs.Empty);
        }
    }

    public final boolean getIsDataSourceEmpty() {
        return this.getDataSourceName() == null || this.getDataSourceName().length() == 0 || this.getDataSource() == null;
    }

    @StiSerializable
    public StiPositionChangedEvent getPositionChangedEvent() {
        return new StiPositionChangedEvent(this);
    }

    public void setPositionChangedEvent(StiPositionChangedEvent value) {
        if (value != null) {
            value.Set(this, value.getScript());
        }
    }

    @Override
    public StiRectangle getDefaultClientRectangle() {
        return new StiRectangle(0L, 0L, 192L, 192L);
    }

    @Override
    public int getPosition() {
        return 0;
    }

    @Override
    public void setPosition(int value) {
    }

    @Override
    public int getCount() {
        return 0;
    }

    @Override
    public boolean isDataSourceEmpty() {
        return false;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyStringNullOfEmpty("AlternatingBackColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getAlternatingBackColor(), (StiColorEnum)StiColorEnum.Gray));
        jObject.AddPropertyStringNullOfEmpty("BackgroundColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getBackgroundColor(), (StiColorEnum)StiColorEnum.Gray));
        jObject.AddPropertyStringNullOfEmpty("GridLineColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getGridLineColor(), (StiColorEnum)StiColorEnum.Gray));
        jObject.AddPropertyStringNullOfEmpty("HeaderBackColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getHeaderBackColor(), (StiColorEnum)StiColorEnum.Gray));
        jObject.AddPropertyStringNullOfEmpty("HeaderForeColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getHeaderForeColor(), (StiColorEnum)StiColorEnum.Gray));
        jObject.AddPropertyStringNullOfEmpty("SelectionBackColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getSelectionBackColor(), (StiColorEnum)StiColorEnum.Gray));
        jObject.AddPropertyStringNullOfEmpty("SelectionForeColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getSelectionForeColor(), (StiColorEnum)StiColorEnum.Gray));
        jObject.AddPropertyStringNullOfEmpty("Filter", this.getFilter());
        jObject.AddPropertyBool("ColumnHeadersVisible", this.getColumnHeadersVisible(), true);
        jObject.AddPropertyBool("RowHeadersVisible", this.getRowHeadersVisible(), true);
        jObject.AddPropertyEnum("GridLineStyle", (Enum)this.getGridLineStyle(), (Enum)StiDataGridLineStyle.Solid);
        jObject.AddPropertyInt("PreferredColumnWidth", this.getPreferredColumnWidth(), 75);
        jObject.AddPropertyInt("PreferredRowHeight", this.getPreferredRowHeight(), 16);
        jObject.AddPropertyInt("RowHeaderWidth", this.getRowHeaderWidth(), 35);
        jObject.AddPropertyStringNullOfEmpty("DataSourceName", this.getDataSourceName());
        jObject.AddPropertyJObject("PositionChangedEvent", this.getPositionChangedEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Columns", this.getColumns().SaveToJsonObject(mode));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("AlternatingBackColor")) {
                this.alternatingBackColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("BackgroundColor")) {
                this.backgroundColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("GridLineColor")) {
                this.gridLineColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("HeaderBackColor")) {
                this.headerBackColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("HeaderForeColor")) {
                this.headerForeColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("SelectionBackColor")) {
                this.selectionBackColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("SelectionForeColor")) {
                this.selectionForeColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("Filter")) {
                this.filter = (String)property.Value;
                continue;
            }
            if (property.Name.equals("ColumnHeadersVisible")) {
                this.columnHeadersVisible = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("RowHeadersVisible")) {
                this.rowHeadersVisible = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("GridLineStyle")) {
                this.gridLineStyle = StiDataGridLineStyle.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("PreferredColumnWidth")) {
                this.preferredColumnWidth = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("PreferredRowHeight")) {
                this.preferredRowHeight = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("RowHeaderWidth")) {
                this.rowHeaderWidth = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("DataSourceName")) {
                this.dataSourceName = (String)property.Value;
                continue;
            }
            if (property.Name.equals("PositionChangedEvent")) {
                StiPositionChangedEvent _event = new StiPositionChangedEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setPositionChangedEvent(_event);
                continue;
            }
            if (!property.Name.equals("Columns")) continue;
            this.columns.LoadFromJsonObject((JSONObject)property.Value);
        }
    }
}

