/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dialogs;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.enums.StiReportControlToolboxPosition;
import com.stimulsoft.report.dialogs.IStiCheckBoxControl;
import com.stimulsoft.report.dialogs.StiReportControl;
import com.stimulsoft.report.events.StiCheckedChangedEvent;
import com.stimulsoft.report.events.StiEvent;

public class StiCheckBoxControl
extends StiReportControl
implements IStiCheckBoxControl {
    private String checkedBinding = "";
    private String textBinding = "";
    private boolean checkedValue = false;
    private String text = "CheckBox";

    @Override
    public int getToolboxPosition() {
        return StiReportControlToolboxPosition.CheckBoxControl.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Dialogs", (String)"StiCheckBoxControl");
    }

    @StiSerializable
    public StiCheckedChangedEvent getCheckedChangedEvent() {
        return new StiCheckedChangedEvent(this);
    }

    public void setCheckedChangedEvent(StiCheckedChangedEvent value) {
        if (value != null) {
            value.Set(this, value.getScript());
        }
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="")
    public final String getCheckedBinding() {
        return this.checkedBinding;
    }

    @Override
    public final void setCheckedBinding(String value) {
        this.checkedBinding = value;
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getTextBinding() {
        return this.textBinding;
    }

    public final void setTextBinding(String value) {
        this.textBinding = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getChecked() {
        return this.checkedValue;
    }

    public final void setChecked(boolean value) {
        this.checkedValue = value;
        this.UpdateReportControl("Checked");
    }

    @Override
    @StiSerializable
    public final String getText() {
        return this.text;
    }

    @Override
    public final void setText(String value) {
        this.text = value;
        this.UpdateReportControl("Text");
    }

    @Override
    public StiEvent GetDefaultEvent() {
        return this.getCheckedChangedEvent();
    }

    public StiCheckBoxControl() {
        this(StiRectangle.empty());
    }

    public StiCheckBoxControl(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(true);
        this.setText(this.getLocalizedName());
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyJObject("CheckedChangedEvent", this.getCheckedChangedEvent().SaveToJsonObject(mode));
        jObject.AddPropertyStringNullOfEmpty("CheckedBinding", this.getCheckedBinding());
        jObject.AddPropertyStringNullOfEmpty("TextBinding", this.getTextBinding());
        jObject.AddPropertyBool("Checked", this.getChecked());
        jObject.AddPropertyString("Text", this.getText());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("CheckedChangedEvent")) {
                StiCheckedChangedEvent _event = new StiCheckedChangedEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setCheckedChangedEvent(_event);
                continue;
            }
            if (property.Name.equals("CheckedBinding")) {
                this.checkedBinding = (String)property.Value;
                continue;
            }
            if (property.Name.equals("TextBinding")) {
                this.textBinding = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Checked")) {
                this.checkedValue = (Boolean)property.Value;
                continue;
            }
            if (!property.Name.equals("Text")) continue;
            this.text = (String)property.Value;
        }
    }
}

