/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.textFormats;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.design.IStiDefault;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.services.StiService;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.lib.utils.StiDateUtil;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiTextFormatState;
import com.stimulsoft.report.components.textFormats.StiCustomFormatService;
import com.stimulsoft.report.components.textFormats.StiDateFormatService;
import com.stimulsoft.report.components.textFormats.StiGeneralFormatService;
import com.stimulsoft.report.dictionary.data.DBNull;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public abstract class StiFormatService
extends StiService
implements IStiDefault,
IStiJsonReportObject {
    private String stringFormat = "";
    private StiEnumSet<StiTextFormatState> state = StiEnumSet.of((Enum)StiTextFormatState.None);

    public final boolean isDefault() {
        return this instanceof StiGeneralFormatService;
    }

    public final String getServiceCategory() {
        return StiLocalization.Get((String)"Services", (String)"categoryTextFormat");
    }

    public final Class<?> getServiceType() {
        return StiFormatService.class;
    }

    public abstract int getPosition();

    public abstract Object getSample();

    public String getNativeFormatString() {
        return "{0}";
    }

    public final boolean getIsFormatStringFromVariable() {
        if (this instanceof StiCustomFormatService && this.getStringFormat() != null) {
            String str = this.getStringFormat().trim();
            return str.length() > 2 && str.startsWith("{") && str.endsWith("}");
        }
        return false;
    }

    @StiSerializable
    public String getStringFormat() {
        return this.stringFormat;
    }

    public void setStringFormat(String value) {
        this.stringFormat = value;
    }

    public String Format(Object arg, Locale locale) {
        return this.format(this.getStringFormat(), arg, locale);
    }

    public String format(String format, Object arg, Locale locale) {
        try {
            if (arg == null || arg instanceof DBNull) {
                return "";
            }
            if (this.getStringFormat() == null || this.getStringFormat().length() == 0) {
                if (arg instanceof Calendar) {
                    return StiDateUtil.formatDateTime((Date)((Calendar)arg).getTime());
                }
                if (arg instanceof ZonedDateTime) {
                    return StiDateUtil.formatDateTime((ZonedDateTime)((ZonedDateTime)arg));
                }
                if (arg instanceof StiDateTime) {
                    return ((StiDateTime)arg).format(format, locale);
                }
                String result = arg.toString();
                return arg instanceof List ? result.substring(1, result.length() - 1) : result;
            }
            if (arg instanceof Date || arg instanceof StiDateTime) {
                return new StiDateFormatService().format(format, arg, locale);
            }
            return StiStringUtil.format((String)("{0:" + format + "}"), (Object)arg);
        }
        catch (Exception e) {
            return arg == null ? "" : arg.toString();
        }
    }

    public String toString() {
        return this.getServiceName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.stringFormat == null ? 0 : this.stringFormat.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        StiFormatService other = (StiFormatService)((Object)obj);
        return !(this.stringFormat == null ? other.stringFormat != null : !this.stringFormat.equals(other.stringFormat));
    }

    @StiSerializable
    public StiEnumSet<StiTextFormatState> getState() {
        return this.state;
    }

    public void setState(StiEnumSet<StiTextFormatState> state) {
        this.state = state;
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyIdent("Ident", ((Object)((Object)this)).getClass().getName());
        jObject.AddPropertyStringNullOfEmpty("StringFormat", this.getStringFormat());
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (!property.Name.equals("StringFormat")) continue;
            this.stringFormat = (String)property.Value;
        }
    }

    public static StiFormatService LoadFromJsonObjectInternal(JSONObject jObject) throws JSONException {
        StiFormatService[] formats = StiOptions.Services.getFormats();
        StiFormatService format = null;
        String ident = (String)jObject.Properties().FirstOrDefault((String)"Ident").Value;
        for (StiFormatService fs : formats) {
            String name = ((Object)((Object)fs)).getClass().getName();
            if (!name.substring(name.lastIndexOf(46) + 1).equals(ident)) continue;
            try {
                format = (StiFormatService)((Object)((Object)((Object)fs)).getClass().newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        format.LoadFromJsonObject(jObject);
        return format;
    }
}

