/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.textFormats;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.components.textFormats.StiFormatService;
import com.stimulsoft.report.dictionary.data.DBNull;
import java.util.Locale;

public class StiBooleanFormatService
extends StiFormatService {
    private BitsBooleanFormatService bits = new BitsBooleanFormatService();

    public StiBooleanFormatService() {
        this("False", "True", StiLocalization.Get((String)"FormFormatEditor", (String)"nameFalse"), StiLocalization.Get((String)"FormFormatEditor", (String)"nameTrue"), " ");
    }

    public StiBooleanFormatService(String falseValue, String trueValue, String falseDisplay, String trueDisplay, String nullDisplay) {
        this.setFalseValue(falseValue);
        this.setTrueValue(trueValue);
        this.setFalseDisplay(falseDisplay);
        this.setTrueDisplay(trueDisplay);
        this.setNullDisplay(nullDisplay);
    }

    public String getServiceName() {
        return StiLocalization.Get((String)"FormFormatEditor", (String)"Boolean");
    }

    @Override
    public int getPosition() {
        return 7;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final String getFalseValue() {
        if (this.bits == null) {
            return "False";
        }
        return this.bits.falseValue;
    }

    public final void setFalseValue(String value) {
        if (value.equals("False") && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.falseValue = value;
        } else {
            this.bits = new BitsBooleanFormatService(value, this.getTrueValue(), this.getFalseDisplay(), this.getTrueDisplay(), this.getNullDisplay());
        }
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final String getTrueValue() {
        if (this.bits == null) {
            return "True";
        }
        return this.bits.trueValue;
    }

    public final void setTrueValue(String value) {
        if (value.equals("True") && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.trueValue = value;
        } else {
            this.bits = new BitsBooleanFormatService(this.getFalseValue(), value, this.getFalseDisplay(), this.getTrueDisplay(), this.getNullDisplay());
        }
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final String getFalseDisplay() {
        if (this.bits == null) {
            return "False";
        }
        return this.bits.falseDisplay;
    }

    public final void setFalseDisplay(String value) {
        if (value.equals("False") && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.falseDisplay = value;
        } else {
            this.bits = new BitsBooleanFormatService(this.getFalseValue(), this.getTrueValue(), value, this.getTrueDisplay(), this.getNullDisplay());
        }
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final String getTrueDisplay() {
        if (this.bits == null) {
            return "True";
        }
        return this.bits.trueDisplay;
    }

    public final void setTrueDisplay(String value) {
        if (value.equals("True") && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.trueDisplay = value;
        } else {
            this.bits = new BitsBooleanFormatService(this.getFalseValue(), this.getTrueValue(), this.getFalseDisplay(), value, this.getNullDisplay());
        }
    }

    @StiSerializable
    public final String getNullDisplay() {
        if (this.bits == null) {
            return " ";
        }
        return this.bits.nullDisplay;
    }

    public final void setNullDisplay(String value) {
        if (value.equals(" ") && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.nullDisplay = value;
        } else {
            this.bits = new BitsBooleanFormatService(this.getFalseValue(), this.getTrueValue(), this.getFalseDisplay(), this.getTrueDisplay(), value);
        }
    }

    @Override
    public Object getSample() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        StiBooleanFormatService format = (StiBooleanFormatService)((Object)(obj instanceof StiBooleanFormatService ? obj : null));
        if (format == null) {
            return false;
        }
        if (!this.getFalseValue().equals(format.getFalseValue())) {
            return false;
        }
        if (!this.getTrueValue().equals(format.getTrueValue())) {
            return false;
        }
        if (!this.getFalseDisplay().equals(format.getFalseDisplay())) {
            return false;
        }
        if (!this.getTrueDisplay().equals(format.getTrueDisplay())) {
            return false;
        }
        if (!this.getNullDisplay().equals(format.getNullDisplay())) {
            return false;
        }
        return this.getStringFormat().equals(format.getStringFormat());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String format(String stringFormat, Object arg, Locale locale) {
        if (arg == null || arg instanceof DBNull) {
            return this.getNullDisplay();
        }
        String a = arg.toString();
        if (this.getTrueValue().equalsIgnoreCase(a)) {
            return this.getTrueDisplay();
        }
        if (this.getFalseValue().equalsIgnoreCase(a)) {
            return this.getFalseDisplay();
        }
        return this.getNullDisplay();
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        if (this.bits != null) {
            jObject.AddPropertyStringNullOfEmpty("FalseValue", this.getFalseValue());
            jObject.AddPropertyStringNullOfEmpty("TrueValue", this.getTrueValue());
            jObject.AddPropertyStringNullOfEmpty("FalseDisplay", this.getFalseDisplay());
            jObject.AddPropertyStringNullOfEmpty("TrueDisplay", this.getTrueDisplay());
            jObject.AddPropertyStringNullOfEmpty("NullDisplay", this.getNullDisplay());
        }
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("FalseValue")) {
                this.setFalseValue((String)property.Value);
                continue;
            }
            if (property.Name.equals("TrueValue")) {
                this.setTrueValue((String)property.Value);
                continue;
            }
            if (property.Name.equals("FalseDisplay")) {
                this.setFalseDisplay((String)property.Value);
                continue;
            }
            if (property.Name.equals("TrueDisplay")) {
                this.setTrueDisplay((String)property.Value);
                continue;
            }
            if (!property.Name.equals("NullDisplay")) continue;
            this.setNullDisplay((String)property.Value);
        }
    }

    private static class BitsBooleanFormatService
    implements Cloneable {
        public String falseValue;
        public String trueValue;
        public String falseDisplay;
        public String trueDisplay;
        public String nullDisplay;

        public BitsBooleanFormatService(String falseValue, String trueValue, String falseDisplay, String trueDisplay, String nullDisplay) {
            this.falseValue = falseValue;
            this.trueValue = trueValue;
            this.falseDisplay = falseDisplay;
            this.trueDisplay = trueDisplay;
            this.nullDisplay = nullDisplay;
        }

        private BitsBooleanFormatService() {
        }
    }
}

