/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.simplecomponents;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.interfaces.IStiBorderColor;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.interfaces.IStiShape;
import com.stimulsoft.report.components.shapeTypes.StiRectangleShapeType;
import com.stimulsoft.report.components.shapeTypes.StiShapeTypeService;
import com.stimulsoft.report.enums.StiExportFormat;

public class StiShape
extends StiComponent
implements IStiBrush,
IStiBorderColor,
IStiExportImageExtended,
IStiShape {
    private StiBrush brush = new StiSolidBrush();
    private StiColor borderColor = StiColor.Black;
    private StiPenStyle style = StiPenStyle.Solid;
    private double size = 1.0;
    private StiShapeTypeService shapeType = new StiRectangleShapeType();

    public StiShape() {
        this(StiRectangle.empty());
    }

    public StiShape(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(false);
    }

    @Override
    @StiSerializable(need=false)
    public boolean getCanShrink() {
        return super.getCanShrink();
    }

    @Override
    public void setCanShrink(boolean value) {
    }

    @Override
    @StiSerializable(need=false)
    public boolean getCanGrow() {
        return super.getCanGrow();
    }

    @Override
    public void setCanGrow(boolean value) {
    }

    @Override
    public Object clone(boolean cloneProperties) {
        StiShape shape = (StiShape)super.clone(cloneProperties);
        shape.shapeType = this.shapeType != null ? (StiShapeTypeService)((Object)this.shapeType.clone()) : null;
        return shape;
    }

    @Override
    public boolean isExportAsImage(StiExportFormat format) {
        return true;
    }

    @Override
    @StiSerializable(shortName="bh")
    public StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public void setBrush(StiBrush value) {
        this.brush = value;
    }

    @Override
    @StiSerializable
    public final StiColor getBorderColor() {
        return this.borderColor;
    }

    @Override
    public final void setBorderColor(StiColor value) {
        this.borderColor = value;
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.Shape.getValue();
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.Get((String)"Report", (String)"Components");
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiShape");
    }

    @Override
    public StiRectangle getDefaultClientRectangle() {
        return new StiRectangle(0L, 0L, 64L, 64L);
    }

    @StiDefaulValue(value="Solid")
    @StiSerializable
    public final StiPenStyle getStyle() {
        return this.style;
    }

    public final void setStyle(StiPenStyle value) {
        this.style = value;
    }

    @StiDefaulValue(value="1.0")
    @StiSerializable
    public final double getSize() {
        return this.size;
    }

    public final void setSize(double value) {
        if (value != this.size) {
            this.size = value < 1.0 ? 1.0 : value;
        }
    }

    @StiSerializable
    public final StiShapeTypeService getShapeType() {
        return this.shapeType;
    }

    public final void setShapeType(StiShapeTypeService value) {
        this.shapeType = value;
    }

    public boolean IsExportAsImage(StiExportFormat format) {
        return false;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("CanShrink");
        jObject.RemoveProperty("CanGrow");
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.getBrush()));
        jObject.AddPropertyStringNullOfEmpty("BorderColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getBorderColor(), (StiColorEnum)StiColorEnum.Black));
        jObject.AddPropertyEnum("Style", (Enum)this.getStyle(), (Enum)StiPenStyle.Solid);
        jObject.AddPropertyFloat("Size", this.getSize(), 1.0);
        jObject.AddPropertyJObject("ShapeType", this.getShapeType().SaveToJsonObject(mode));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Brush")) {
                this.brush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (property.Name.equals("BorderColor")) {
                this.borderColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("Style")) {
                this.style = StiPenStyle.valueOf((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("Size")) {
                this.size = property.floatValue().floatValue();
                continue;
            }
            if (!property.Name.equals("ShapeType")) continue;
            this.shapeType = StiShapeTypeService.LoadFromJsonObjectInternal((JSONObject)property.Value);
        }
    }
}

