/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.signature;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.enums.StiExportFormat;

public abstract class StiSignature
extends StiComponent
implements IStiBorder,
IStiBrush,
IStiExportImageExtended {
    public StiBrush brush = new StiSolidBrush();
    public StiBorder border = new StiBorder();

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("CanShrink");
        jObject.RemoveProperty("CanGrow");
        jObject.AddPropertyBrush("Brush", this.getBrush());
        jObject.AddPropertyBorder("Border", this.getBorder());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Brush")) {
                this.brush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (!property.Name.equals("Border")) continue;
            this.border = StiJsonReportObjectHelper.Deserialize.Border((JProperty)property);
        }
    }

    @Override
    public boolean isExportAsImage(StiExportFormat format) {
        return true;
    }

    @Override
    public Object clone() {
        StiSignature signature = (StiSignature)super.clone();
        if (this.getBorder() != null) {
            signature.setBorder((StiBorder)this.getBorder().clone());
        }
        if (this.getBrush() != null) {
            signature.setBrush((StiBrush)this.getBrush().clone());
        }
        return signature;
    }

    @Override
    @StiSerializable
    public StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public void setBrush(StiBrush brush) {
        this.brush = brush;
    }

    @Override
    @StiSerializable
    public StiBorder getBorder() {
        return this.border;
    }

    @Override
    public void setBorder(StiBorder border) {
        this.border = border;
    }

    private boolean shouldSerializeBrush() {
        return !(this.getBrush() instanceof StiSolidBrush) || !StiColor.Transparent.equals(((StiSolidBrush)this.getBrush()).getColor());
    }

    private boolean shouldSerializeBorder() {
        return this.getBorder() == null || !this.getBorder().isDefault();
    }

    @Override
    public StiRectangle getDefaultClientRectangle() {
        return new StiRectangle(0L, 0L, 380L, 110L);
    }

    public StiSignature() {
        this(StiRectangle.empty());
    }

    public StiSignature(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(false);
    }
}

