/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.conditions;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiSerializerUtil;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.components.conditions.StiBaseCondition;
import com.stimulsoft.report.components.enums.StiBrushType;
import com.stimulsoft.report.components.enums.StiDataBarDirection;
import com.stimulsoft.report.components.enums.StiMaximumType;
import com.stimulsoft.report.components.enums.StiMinimumType;
import com.stimulsoft.report.components.indicators.StiDataBarIndicator;
import com.stimulsoft.report.components.indicators.StiIndicator;
import com.stimulsoft.report.components.interfaces.IStiDataBarIndicator;
import com.stimulsoft.report.components.interfaces.IStiIndicatorCondition;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;

public class StiDataBarCondition
extends StiBaseCondition
implements IStiDataBarIndicator,
IStiIndicatorCondition {
    private StiBrushType brushType = StiBrushType.Gradient;
    private StiColor positiveColor = StiColorEnum.Green.color();
    private StiColor negativeColor = StiColorEnum.Red.color();
    private StiColor positiveBorderColor = StiColorEnum.DarkGray.color();
    private StiColor negativeBorderColor = StiColorEnum.Red.color();
    private boolean showBorder = false;
    private StiDataBarDirection direction = StiDataBarDirection.Default;
    private StiMinimumType minimumType;
    private float minimumValue = 0.0f;
    private StiMaximumType maximumType;
    private float maximumValue = 100.0f;
    private Float minimum = null;
    private Float maximum = null;

    public StiDataBarCondition() {
    }

    @Override
    public final StiIndicator CreateIndicator(StiText component) {
        if (StiValidationUtil.isNullOrEmpty((String)this.column)) {
            component.getReport().WriteToReportRenderingMessages(String.format("Column of Data Bar Condition of '%1$s' component is not specified!", component.getName()));
            return null;
        }
        if (!(this.getMinimumType() == StiMinimumType.Value && this.getMaximumType() == StiMaximumType.Value || this.minimum != null && this.maximum != null)) {
            this.minimum = Float.valueOf(0.0f);
            this.maximum = Float.valueOf(0.0f);
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(component.getReport().dictionary, this.column);
            if (dataSource != null) {
                dataSource.saveState("Indicator");
                dataSource.First();
                int index = 0;
                while (!dataSource.getIsEof()) {
                    String value = StiDataColumn.getDataFromDataColumnStr(component.getReport().dictionary, this.column);
                    float floatValue = 0.0f;
                    try {
                        floatValue = Float.parseFloat(value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (index == 0) {
                        this.minimum = Float.valueOf(floatValue);
                        this.maximum = Float.valueOf(floatValue);
                    } else {
                        this.minimum = Float.valueOf(Math.min(this.minimum == null ? 0.0f : this.minimum.floatValue(), floatValue));
                        this.maximum = Float.valueOf(Math.max(this.maximum == null ? 0.0f : this.maximum.floatValue(), floatValue));
                    }
                    ++index;
                    dataSource.Next();
                }
                dataSource.RestoreState("Indicator");
            }
            if (dataSource == null) {
                StiBusinessObject businessObject = StiDataColumn.GetBusinessObjectFromDataColumn(component.getReport().dictionary, this.column);
                if (businessObject == null) {
                    component.getReport().WriteToReportRenderingMessages(String.format("Column of Data Bar Condition of '%1$s' component is not found!", component.getName()));
                    return null;
                }
                businessObject.SaveState("Indicator");
                businessObject.CreateEnumerator();
                int index = 0;
                while (!businessObject.getIsEof()) {
                    String value = StiDataColumn.getDataFromDataColumnStr(component.getReport().dictionary, this.column);
                    float floatValue = 0.0f;
                    try {
                        floatValue = Float.parseFloat(value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (index == 0) {
                        this.minimum = Float.valueOf(floatValue);
                        this.maximum = Float.valueOf(floatValue);
                    } else {
                        this.minimum = Float.valueOf(Math.min(this.minimum == null ? 0.0f : this.minimum.floatValue(), floatValue));
                        this.maximum = Float.valueOf(Math.max(this.maximum == null ? 0.0f : this.maximum.floatValue(), floatValue));
                    }
                    ++index;
                    businessObject.next();
                }
                businessObject.RestoreState("Indicator");
            }
            if (this.minimum.floatValue() > 0.0f && this.getMinimumType() != StiMinimumType.Minimum) {
                this.minimum = Float.valueOf(0.0f);
            }
            if (this.maximum.floatValue() < 0.0f && this.getMaximumType() != StiMaximumType.Maximum) {
                this.maximum = Float.valueOf(0.0f);
            }
        }
        float minimumToUse = this.minimum == null ? 0.0f : this.minimum.floatValue();
        float maximumToUse = this.maximum == null ? 0.0f : this.maximum.floatValue();
        float dist = maximumToUse - minimumToUse;
        float minimumPercent = this.getMinimumValue();
        minimumPercent = Math.min(minimumPercent, 100.0f);
        minimumPercent = Math.max(minimumPercent, 0.0f);
        float maximumPercent = this.getMaximumValue();
        maximumPercent = Math.min(maximumPercent, 100.0f);
        if (minimumPercent > (maximumPercent = Math.max(maximumPercent, 0.0f))) {
            minimumPercent = maximumPercent;
        }
        if (this.getMinimumType() == StiMinimumType.Value) {
            minimumToUse = this.getMinimumValue();
        } else if (this.getMinimumType() == StiMinimumType.Percent) {
            minimumToUse += dist * minimumPercent / 100.0f;
        }
        if (this.getMaximumType() == StiMaximumType.Value) {
            maximumToUse = this.getMaximumValue();
        } else if (this.getMaximumType() == StiMaximumType.Percent) {
            maximumToUse = minimumToUse + dist * maximumPercent / 100.0f;
        }
        String currentValue = StiDataColumn.getDataFromDataColumnStr(component.getReport().getDictionary(), this.column);
        float floatCurrentValue = 0.0f;
        try {
            floatCurrentValue = Float.parseFloat(currentValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (floatCurrentValue > maximumToUse) {
            floatCurrentValue = maximumToUse;
        }
        if (floatCurrentValue < minimumToUse) {
            floatCurrentValue = minimumToUse;
        }
        if (minimumToUse > 0.0f) {
            floatCurrentValue -= minimumToUse;
            maximumToUse -= minimumToUse;
            minimumToUse = 0.0f;
        }
        if (maximumToUse < 0.0f) {
            floatCurrentValue -= maximumToUse;
            minimumToUse -= maximumToUse;
            maximumToUse = 0.0f;
        }
        StiDataBarIndicator indicator = new StiDataBarIndicator();
        indicator.setBrushType(this.getBrushType());
        indicator.setPositiveColor(this.getPositiveColor());
        indicator.setNegativeColor(this.getNegativeColor());
        indicator.setShowBorder(this.getShowBorder());
        indicator.setPositiveBorderColor(this.getPositiveBorderColor());
        indicator.setNegativeBorderColor(this.getNegativeBorderColor());
        indicator.setDirection(this.getDirection());
        indicator.setMinimum(minimumToUse);
        indicator.setMaximum(maximumToUse);
        indicator.setValue(floatCurrentValue);
        return indicator;
    }

    public StiDataBarCondition(String column, StiBrushType brushType, StiColor positiveColor, StiColor negativeColor, boolean showBorder, StiColor positiveBorderColor, StiColor negativeBorderColor, StiDataBarDirection direction, StiMinimumType minimumType, float minimumValue, StiMaximumType maximumType, float maximumValue) {
        this.column = column;
        this.brushType = brushType;
        this.positiveColor = positiveColor;
        this.negativeColor = negativeColor;
        this.showBorder = showBorder;
        this.positiveBorderColor = positiveBorderColor;
        this.negativeBorderColor = negativeBorderColor;
        this.direction = direction;
        this.minimumType = minimumType;
        this.minimumValue = minimumValue;
        this.maximumType = maximumType;
        this.maximumValue = maximumValue;
    }

    @Override
    public final void Reset() {
        this.minimum = null;
        this.maximum = null;
    }

    @Override
    @StiSerializable
    public final StiBrushType getBrushType() {
        return this.brushType;
    }

    @Override
    public final void setBrushType(StiBrushType value) {
        this.brushType = value;
    }

    @Override
    @StiSerializable
    public final StiColor getPositiveColor() {
        return this.positiveColor;
    }

    @Override
    public final void setPositiveColor(StiColor value) {
        this.positiveColor = value;
    }

    @Override
    @StiSerializable
    public final StiColor getNegativeColor() {
        return this.negativeColor;
    }

    @Override
    public final void setNegativeColor(StiColor value) {
        this.negativeColor = value;
    }

    @Override
    @StiSerializable
    public final StiColor getPositiveBorderColor() {
        return this.positiveBorderColor;
    }

    @Override
    public final void setPositiveBorderColor(StiColor value) {
        this.positiveBorderColor = value;
    }

    @Override
    @StiSerializable
    public final StiColor getNegativeBorderColor() {
        return this.negativeBorderColor;
    }

    @Override
    public final void setNegativeBorderColor(StiColor value) {
        this.negativeBorderColor = value;
    }

    @Override
    @StiSerializable
    public final boolean getShowBorder() {
        return this.showBorder;
    }

    @Override
    public final void setShowBorder(boolean value) {
        this.showBorder = value;
    }

    @Override
    @StiSerializable
    public final StiDataBarDirection getDirection() {
        return this.direction;
    }

    @Override
    public final void setDirection(StiDataBarDirection value) {
        this.direction = value;
    }

    @StiSerializable
    public final StiMinimumType getMinimumType() {
        return this.minimumType;
    }

    public final void setMinimumType(StiMinimumType value) {
        this.minimumType = value;
    }

    @StiSerializable
    public final float getMinimumValue() {
        return this.minimumValue;
    }

    public final void setMinimumValue(float value) {
        this.minimumValue = value;
    }

    @StiSerializable
    public final StiMaximumType getMaximumType() {
        return this.maximumType;
    }

    public final void setMaximumType(StiMaximumType value) {
        this.maximumType = value;
    }

    @StiSerializable
    public final float getMaximumValue() {
        return this.maximumValue;
    }

    public final void setMaximumValue(float value) {
        this.maximumValue = value;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        StiDataBarCondition condition = (StiDataBarCondition)(obj instanceof StiDataBarCondition ? obj : null);
        if (condition == null) {
            return false;
        }
        return this.column.equals(condition.column) && this.brushType.equals((Object)condition.brushType) && this.positiveColor.equals(condition.positiveColor) && this.negativeColor.equals(condition.negativeColor) && new Boolean(this.showBorder).equals(condition.showBorder) && this.positiveBorderColor.equals(condition.positiveBorderColor) && this.negativeBorderColor.equals(condition.negativeBorderColor) && this.minimumType.equals((Object)condition.minimumType) && new Float(this.minimumValue).equals(Float.valueOf(condition.minimumValue)) && this.maximumType.equals((Object)condition.maximumType) && new Float(this.maximumValue).equals(Float.valueOf(condition.maximumValue));
    }

    @Override
    public String serialize() {
        String data = StiSerializerUtil.serializFormat((String)"DataBar,{0},{1},{2},{3},{4},{5},{6},{7},{8},{9},{10},{11}", (Object[])new Object[]{StiXMLConvert.encodeName((String)this.column), StiXMLConvert.encodeName((Enum)this.brushType), this.positiveColor.serializeString(), this.negativeColor.serializeString(), this.showBorder, this.positiveBorderColor.serializeString(), this.negativeBorderColor.serializeString(), StiXMLConvert.encodeName((Enum)this.direction), StiXMLConvert.encodeName((Enum)this.minimumType), Float.valueOf(this.minimumValue), StiXMLConvert.encodeName((Enum)this.maximumType), Float.valueOf(this.maximumValue)});
        return data;
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        this.column = StiXMLConvert.decodeName((String)values[1]);
        this.brushType = StiBrushType.valueOf(StiXMLConvert.decodeName((String)values[2]));
        this.positiveColor = StiColor.deserializeString((String)values[3]);
        this.negativeColor = StiColor.deserializeString((String)values[4]);
        this.showBorder = StiSerializTypeConverter.stringToBoolean((String)values[5]);
        this.positiveBorderColor = StiColor.deserializeString((String)values[6]);
        this.negativeBorderColor = StiColor.deserializeString((String)values[7]);
        this.direction = StiDataBarDirection.valueOf(StiXMLConvert.decodeName((String)values[8]));
        this.minimumType = StiMinimumType.valueOf(StiXMLConvert.decodeName((String)values[9]));
        this.minimumValue = StiSerializTypeConverter.stringToFloat((String)values[10]);
        this.maximumType = StiMaximumType.valueOf(StiXMLConvert.decodeName((String)values[11]));
        this.maximumValue = StiSerializTypeConverter.stringToFloat((String)values[12]);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyEnum("BrushType", (Enum)this.getBrushType(), (Enum)StiBrushType.Gradient);
        jObject.AddPropertyStringNullOfEmpty("PositiveColor", StiJsonReportObjectHelper.Serialize.jColor((StiColor)this.getPositiveColor(), (StiColor)StiColorEnum.Green.color()));
        jObject.AddPropertyStringNullOfEmpty("NegativeColor", StiJsonReportObjectHelper.Serialize.jColor((StiColor)this.getNegativeColor(), (StiColor)StiColorEnum.Red.color()));
        jObject.AddPropertyStringNullOfEmpty("PositiveBorderColor", StiJsonReportObjectHelper.Serialize.jColor((StiColor)this.getPositiveBorderColor(), (StiColor)StiColorEnum.DarkGreen.color()));
        jObject.AddPropertyStringNullOfEmpty("NegativeBorderColor", StiJsonReportObjectHelper.Serialize.jColor((StiColor)this.getNegativeBorderColor(), (StiColor)StiColorEnum.DarkRed.color()));
        jObject.AddPropertyBool("ShowBorder", this.getShowBorder());
        jObject.AddPropertyEnum("Direction", (Enum)this.getDirection(), (Enum)StiDataBarDirection.Default);
        jObject.AddPropertyEnum("MinimumType", (Enum)this.getMinimumType(), (Enum)StiMinimumType.Auto);
        jObject.AddPropertyFloat("MinimumValue", (double)this.getMinimumValue(), 0.0);
        jObject.AddPropertyEnum("MaximumType", (Enum)this.getMaximumType(), (Enum)StiMaximumType.Auto);
        jObject.AddPropertyFloat("MaximumValue", (double)this.getMaximumValue(), 100.0);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("BrushType")) {
                this.brushType = StiBrushType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("PositiveColor")) {
                this.positiveColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("NegativeColor")) {
                this.negativeColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("PositiveBorderColor")) {
                this.positiveBorderColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("NegativeBorderColor")) {
                this.negativeBorderColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("ShowBorder")) {
                this.showBorder = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Direction")) {
                this.direction = StiDataBarDirection.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("MinimumType")) {
                this.minimumType = StiMinimumType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("MinimumValue")) {
                this.minimumValue = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("MaximumType")) {
                this.maximumType = StiMaximumType.valueOf((String)property.Value);
                continue;
            }
            if (!property.Name.equals("MaximumValue")) continue;
            this.maximumValue = property.floatValue().floatValue();
        }
    }
}

