/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.complexcomponents;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.drawing.enums.StiHorAlignment;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiShiftMode;
import com.stimulsoft.report.components.interfaces.IStiAutoWidth;
import com.stimulsoft.report.components.interfaces.IStiHorAlignment;
import com.stimulsoft.report.components.interfaces.IStiTextHorAlignment;
import com.stimulsoft.report.components.simplecomponents.StiCrossLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiHorizontalLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiStartPointPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.engine.StiEngineVersion;
import java.util.HashMap;
import java.util.Hashtable;

public class StiContainerHelper {
    public static void checkSize(StiComponent component) {
        StiContainerHelper.CheckSize(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CheckSize(StiComponent component) {
        StiComponentsCollection compsSorted;
        StiContainer cont = (StiContainer)(component instanceof StiContainer ? component : null);
        if (cont == null) {
            return;
        }
        if (component.getReport() != null && component.getReport().getEngineVersion() == StiEngineVersion.EngineV1) {
            StiComponentsCollection stiComponentsCollection = cont.getComponents();
            synchronized (stiComponentsCollection) {
                for (StiComponent comp : cont.getComponents()) {
                    if (!comp.getIsEnabled()) continue;
                    StiContainerHelper.CheckSize(comp);
                }
            }
        }
        Hashtable<StiComponent, Double> compDist = new Hashtable<StiComponent, Double>();
        Hashtable<Object, StiSize> compSizes = new Hashtable<Object, StiSize>();
        boolean changedHeights = false;
        StiComponentsCollection stiComponentsCollection = cont.getComponents();
        synchronized (stiComponentsCollection) {
            for (Object comp : cont.getComponents()) {
                if (((StiComponent)comp).getIsEnabled()) {
                    StiSize size;
                    if (comp instanceof StiContainer) {
                        double storedHeight = ((StiComponent)comp).getHeight();
                        if (StiOptions.Engine.getUseCheckSizeForContinuedContainers()) {
                            StiContainerHelper.CheckSize((StiComponent)comp);
                        }
                        StiRefObject needSecondPass = new StiRefObject((Object)false);
                        size = ((StiContainer)((Object)(comp instanceof StiContainer ? comp : null))).getActualSize(true, (StiRefObject<Boolean>)needSecondPass);
                        if (((Boolean)needSecondPass.argvalue).booleanValue()) {
                            double oldHeight = ((StiComponent)comp).getHeight();
                            if (((StiComponent)comp).getHeight() != size.getHeight()) {
                                ((StiComponent)comp).setHeight(size.height);
                            }
                            size = ((StiContainer)((Object)(comp instanceof StiContainer ? comp : null))).getActualSize(false, (StiRefObject<Boolean>)needSecondPass);
                            if (((StiComponent)comp).getHeight() != oldHeight) {
                                ((StiComponent)comp).setHeight(oldHeight);
                            }
                        }
                        if (StiOptions.Engine.getUseCheckSizeForContinuedContainers() && ((StiComponent)comp).getHeight() != storedHeight) {
                            ((StiComponent)comp).setHeight(storedHeight);
                        }
                    } else {
                        size = ((StiComponent)comp).getActualSize();
                    }
                    if (!(comp instanceof StiHorizontalLinePrimitive)) {
                        size.setHeight(StiMath.round((double)size.getHeight(), (int)2));
                    }
                    size.setWidth(StiMath.round((double)size.getWidth(), (int)2));
                    compSizes.put(comp, size);
                    if (size.height == ((StiComponent)comp).getHeight()) continue;
                    changedHeights = true;
                    continue;
                }
                compSizes.put(comp, new StiSize(0, 0));
            }
        }
        if (changedHeights) {
            Object comp;
            compsSorted = new StiComponentsCollection();
            if (cont instanceof StiPage) {
                HashMap startPoints = new HashMap();
                for (Object comp2 : cont.getComponents()) {
                    StiStartPointPrimitive sp = comp2 instanceof StiStartPointPrimitive ? (StiStartPointPrimitive)comp2 : null;
                    if (sp == null || StiValidationUtil.isNullOrWhiteSpace((String)sp.getReferenceToGuid())) continue;
                    startPoints.put(sp.getReferenceToGuid(), null);
                }
                if (startPoints.size() > 0) {
                    for (Object comp2 : cont.getComponents()) {
                        if (comp2 instanceof StiCrossLinePrimitive && startPoints.containsKey(((StiComponent)comp2).getGuid())) continue;
                        compsSorted.add((StiComponent)comp2);
                    }
                } else {
                    compsSorted.AddRange(cont.getComponents());
                }
            } else {
                compsSorted.AddRange(cont.getComponents());
            }
            compsSorted.SortByTopPosition();
            int index = 0;
            comp = compsSorted;
            synchronized (comp) {
                for (StiComponent comp3 : compsSorted) {
                    double dist = ((StiSize)compSizes.get((Object)comp3)).height - comp3.getHeight();
                    double masterLeft = StiMath.round((double)comp3.getLeft(), (int)2);
                    double masterRight = StiMath.round((double)comp3.getRight(), (int)2);
                    double masterBottom = StiMath.round((double)comp3.getBottom(), (int)2);
                    if (dist != 0.0) {
                        double parentDist = 0.0;
                        if (compDist.get(comp3) != null) {
                            parentDist = (Double)compDist.get(comp3);
                        }
                        for (int pos = index + 1; pos < compsSorted.size(); ++pos) {
                            StiComponent childComp = compsSorted.get(pos) instanceof StiComponent ? (StiComponent)compsSorted.get(pos) : null;
                            Double childLeft = StiMath.round((double)childComp.getLeft(), (int)2);
                            Double childTop = StiMath.round((double)childComp.getTop(), (int)2);
                            if (childComp.getShiftMode().contains((IStiEnum)StiShiftMode.OnlyInWidthOfComponent) && (masterLeft > childLeft || masterRight <= childLeft) || !(masterBottom <= childTop)) continue;
                            double childDist = 0.0;
                            if (compDist.get(childComp) != null) {
                                childDist = (Double)compDist.get(childComp);
                            }
                            if (dist > 0.0 && childComp.getShiftMode().contains((IStiEnum)StiShiftMode.IncreasingSize)) {
                                compDist.put(childComp, Math.max(dist + parentDist, childDist));
                            }
                            if (!(dist < 0.0) || !childComp.getShiftMode().contains((IStiEnum)StiShiftMode.DecreasingSize)) continue;
                            compDist.put(childComp, Math.min(dist + parentDist, childDist));
                        }
                    }
                    ++index;
                }
            }
        }
        compsSorted = cont.getComponents();
        synchronized (compsSorted) {
            for (Object comp : cont.getComponents()) {
                StiSize newSize = (StiSize)compSizes.get(comp);
                IStiAutoWidth autoWidth = (IStiAutoWidth)((Object)(comp instanceof IStiAutoWidth ? comp : null));
                if (autoWidth != null && autoWidth.getAutoWidth()) {
                    IStiHorAlignment horAlignment;
                    StiHorAlignment align = StiHorAlignment.Left;
                    IStiTextHorAlignment textHorAlignment = (IStiTextHorAlignment)((Object)(autoWidth instanceof IStiTextHorAlignment ? autoWidth : null));
                    if (textHorAlignment != null) {
                        switch (textHorAlignment.getHorAlignment()) {
                            case Left: {
                                align = StiHorAlignment.Left;
                                break;
                            }
                            case Center: 
                            case Width: {
                                align = StiHorAlignment.Center;
                                break;
                            }
                            case Right: {
                                align = StiHorAlignment.Right;
                            }
                        }
                    }
                    if ((horAlignment = (IStiHorAlignment)((Object)(autoWidth instanceof IStiHorAlignment ? autoWidth : null))) != null) {
                        switch (horAlignment.getHorAlignment()) {
                            case Left: {
                                align = StiHorAlignment.Left;
                                break;
                            }
                            case Center: {
                                align = StiHorAlignment.Center;
                                break;
                            }
                            case Right: {
                                align = StiHorAlignment.Right;
                            }
                        }
                    }
                    float angle = 0.0f;
                    if (comp instanceof StiText) {
                        angle = ((StiText)comp).getAngle();
                    }
                    if (angle == 90.0f || angle == 270.0f) {
                        double storedTop = ((StiComponent)comp).top;
                        switch (align) {
                            case Left: {
                                double compHeight2 = newSize.height;
                                ((StiComponent)comp).setTop(((StiComponent)comp).getBottom() - compHeight2);
                                ((StiComponent)comp).setHeight(compHeight2);
                                break;
                            }
                            case Center: {
                                double compHeight = newSize.height;
                                ((StiComponent)comp).setTop(((StiComponent)comp).getTop() + (((StiComponent)comp).getHeight() - compHeight) / 2.0);
                                ((StiComponent)comp).setHeight(compHeight);
                                break;
                            }
                            case Right: {
                                ((StiComponent)comp).setHeight(newSize.height);
                            }
                        }
                        if (storedTop >= 0.0 && ((StiComponent)comp).top < 0.0) {
                            double tempCompHeight = ((StiComponent)comp).getHeight();
                            ((StiComponent)comp).setTop(0.0);
                            ((StiComponent)comp).setHeight(tempCompHeight);
                        }
                    } else {
                        double storedLeft = ((StiComponent)comp).getLeft();
                        switch (align) {
                            case Left: {
                                ((StiComponent)comp).width = newSize.width;
                                break;
                            }
                            case Center: {
                                double compWidth = newSize.width;
                                ((StiComponent)comp).setLeft(((StiComponent)comp).getLeft() + (((StiComponent)comp).width - compWidth) / 2.0);
                                ((StiComponent)comp).width = compWidth;
                                break;
                            }
                            case Right: {
                                double compWidth2 = newSize.width;
                                ((StiComponent)comp).setLeft(((StiComponent)comp).getRight() - compWidth2);
                                ((StiComponent)comp).width = compWidth2;
                            }
                        }
                        if (storedLeft >= 0.0 && ((StiComponent)comp).getLeft() < 0.0) {
                            double tempCompWidth = ((StiComponent)comp).width;
                            ((StiComponent)comp).setLeft(0.0);
                            ((StiComponent)comp).width = tempCompWidth;
                        }
                    }
                }
                if (((StiComponent)comp).getCanGrow()) {
                    double tt = Math.max(newSize.getWidth(), ((StiComponent)comp).getWidth());
                    if (((StiComponent)comp).getWidth() != tt) {
                        ((StiComponent)comp).setWidth(tt);
                    }
                    tt = Math.max(newSize.getHeight(), ((StiComponent)comp).getHeight());
                    if (((StiComponent)comp).getHeight() != tt) {
                        ((StiComponent)comp).setHeight(tt);
                    }
                }
                if (((StiComponent)comp).getCanShrink()) {
                    if (!(comp instanceof StiContainer) || !((StiContainer)comp).ParentComponentIsBand) {
                        ((StiComponent)comp).width = Math.min(newSize.width, ((StiComponent)comp).width);
                    }
                    ((StiComponent)comp).setHeight(Math.min(newSize.height, ((StiComponent)comp).getHeight()));
                }
                StiContainerHelper.CheckContainerGrowToHeight(comp, false);
                if (!((StiComponent)comp).getShiftMode().contains((IStiEnum)StiShiftMode.IncreasingSize) && !((StiComponent)comp).getShiftMode().contains((IStiEnum)StiShiftMode.DecreasingSize) || compDist.get(comp) == null) continue;
                ((StiComponent)comp).top += ((Double)compDist.get(comp)).doubleValue();
            }
        }
        if (StiContainerHelper.ComponentPlacedOnBand(cont) || cont.ParentComponentIsBand) {
            StiRefObject needSecondPass = new StiRefObject((Object)false);
            StiSize size = cont.getActualSize(true, (StiRefObject<Boolean>)needSecondPass);
            if (!cont.ParentComponentIsBand || cont.ParentComponentIsCrossBand) {
                cont.width = size.width;
            }
            cont.setHeight(size.height);
            if (((Boolean)needSecondPass.argvalue).booleanValue()) {
                size = cont.getActualSize(false, (StiRefObject<Boolean>)needSecondPass);
                if (!cont.ParentComponentIsBand || cont.ParentComponentIsCrossBand) {
                    cont.width = size.width;
                }
                cont.setHeight(size.height);
            }
            StiContainerHelper.CheckContainerGrowToHeight(cont, (Boolean)needSecondPass.argvalue);
        }
        if (cont instanceof StiPage && ((StiPage)(cont instanceof StiPage ? cont : null)).getUnlimitedHeight()) {
            StiPage page = (StiPage)(cont instanceof StiPage ? cont : null);
            StiRefObject needSecondPass = new StiRefObject((Object)false);
            StiSize size = cont.getActualSize(true, (StiRefObject<Boolean>)needSecondPass);
            while (size.height > page.getHeight()) {
                StiPage stiPage = page;
                Integer n = stiPage.segmentPerHeight;
                Integer n2 = stiPage.segmentPerHeight = Integer.valueOf(stiPage.segmentPerHeight + 1);
            }
        }
    }

    private static boolean ComponentPlacedOnBand(StiComponent component) {
        StiContainer parent = component.getParent();
        while (!(parent instanceof StiBand)) {
            if (parent instanceof StiPage) {
                return false;
            }
            if (parent == null) {
                return false;
            }
            if (parent.ParentComponentIsBand) {
                return true;
            }
            parent = parent.getParent();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CheckContainerGrowToHeight(StiComponent component, boolean force) {
        StiContainer contGrowToHeight = (StiContainer)(component instanceof StiContainer ? component : null);
        if (contGrowToHeight != null) {
            StiComponentsCollection stiComponentsCollection = contGrowToHeight.getComponents();
            synchronized (stiComponentsCollection) {
                for (StiComponent comp : contGrowToHeight.getComponents()) {
                    double newHeight;
                    if (!comp.getGrowToHeight() || !comp.getIsEnabled() || !((newHeight = contGrowToHeight.getHeight() - comp.getTop()) > comp.getHeight()) && !force) continue;
                    comp.setHeight(newHeight);
                    StiContainerHelper.CheckContainerGrowToHeight(comp, force);
                }
            }
        }
    }
}

