/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.bands;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.bands.StiDynamicBand;
import com.stimulsoft.report.components.bands.StiHeaderBandInfoV1;
import com.stimulsoft.report.components.bands.StiHeaderBandInfoV2;
import com.stimulsoft.report.components.enums.StiComponentPriority;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiComponentType;
import com.stimulsoft.report.components.enums.StiPrintOnEvenOddPagesType;
import com.stimulsoft.report.components.interfaces.IStiKeepHeaderTogether;
import com.stimulsoft.report.components.interfaces.IStiPrintIfEmpty;
import com.stimulsoft.report.components.interfaces.IStiPrintOnAllPages;
import com.stimulsoft.report.components.interfaces.IStiPrintOnEvenOddPages;
import com.stimulsoft.report.components.interfaces.IStiStartNewPage;

public class StiHeaderBand
extends StiDynamicBand
implements IStiPrintIfEmpty,
IStiPrintOnAllPages,
IStiPrintOnEvenOddPages,
IStiStartNewPage,
IStiKeepHeaderTogether {
    public boolean keepHeaderTogether = true;
    private boolean startNewPage = false;
    private boolean printIfEmpty = false;
    private boolean printOnAllPages = true;
    private StiPrintOnEvenOddPagesType printOnEvenOddPages = StiPrintOnEvenOddPagesType.Ignore;
    private StiHeaderBandInfoV1 headerBandInfoV1;
    private StiHeaderBandInfoV2 headerBandInfoV2;

    @Override
    public StiColor getHeaderEndColor() {
        return StiColor.create((StiColorEnum)StiColorEnum.LightSteelBlue);
    }

    public StiHeaderBand() {
        this(StiRectangle.empty());
    }

    public StiHeaderBand(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(true);
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getKeepHeaderTogether() {
        return this.keepHeaderTogether;
    }

    @Override
    public void setKeepHeaderTogether(boolean value) {
        if (this.keepHeaderTogether != value) {
            this.CheckBlockedException("KeepHeaderTogether");
            this.keepHeaderTogether = value;
        }
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getCanBreak() {
        return super.getCanBreak();
    }

    @Override
    public void setCanBreak(boolean value) {
        super.setCanBreak(value);
        this.getHeaderBandInfoV1().ForceCanBreak = value;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getStartNewPage() {
        return this.startNewPage;
    }

    @Override
    public void setStartNewPage(boolean value) {
        this.startNewPage = value;
    }

    @Override
    @StiDefaulValue(value="100.0")
    @StiSerializable
    public float getStartNewPageIfLessThan() {
        return this.getBreakIfLessThan();
    }

    @Override
    public void setStartNewPageIfLessThan(float value) {
        this.setBreakIfLessThan(value);
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getResetPageNumber() {
        return super.getResetPageNumber();
    }

    @Override
    public void setResetPageNumber(boolean value) {
        super.setResetPageNumber(value);
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getPrintIfEmpty() {
        return this.printIfEmpty;
    }

    @Override
    public void setPrintIfEmpty(boolean value) {
        this.printIfEmpty = value;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getPrintOnAllPages() {
        return this.printOnAllPages;
    }

    @Override
    public void setPrintOnAllPages(boolean value) {
        this.printOnAllPages = value;
    }

    @Override
    @StiDefaulValue(value="Ignore")
    @StiSerializable
    public StiPrintOnEvenOddPagesType getPrintOnEvenOddPages() {
        return this.printOnEvenOddPages;
    }

    @Override
    public void setPrintOnEvenOddPages(StiPrintOnEvenOddPagesType value) {
        this.printOnEvenOddPages = value;
    }

    public final StiHeaderBandInfoV1 getHeaderBandInfoV1() {
        if (this.headerBandInfoV1 == null) {
            this.headerBandInfoV1 = new StiHeaderBandInfoV1();
        }
        return this.headerBandInfoV1;
    }

    public final StiHeaderBandInfoV2 getHeaderBandInfoV2() {
        if (this.headerBandInfoV2 == null) {
            this.headerBandInfoV2 = new StiHeaderBandInfoV2();
        }
        return this.headerBandInfoV2;
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.HeaderBand.getValue();
    }

    @Override
    public int getPriority() {
        return StiComponentPriority.HeaderBand.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiHeaderBand");
    }

    @Override
    public StiComponentType getComponentType() {
        return StiComponentType.Detail;
    }

    @Override
    public StiColor getHeaderStartColor() {
        return StiColor.create((StiColorEnum)StiColorEnum.Lavender);
    }

    @Override
    public Object clone() {
        Object tempVar = super.clone();
        StiHeaderBand band = (StiHeaderBand)(tempVar instanceof StiHeaderBand ? tempVar : null);
        Object tempVar2 = this.getHeaderBandInfoV1().clone();
        band.headerBandInfoV1 = (StiHeaderBandInfoV1)(tempVar2 instanceof StiHeaderBandInfoV1 ? tempVar2 : null);
        Object tempVar3 = this.getHeaderBandInfoV2().clone();
        band.headerBandInfoV2 = (StiHeaderBandInfoV2)(tempVar3 instanceof StiHeaderBandInfoV2 ? tempVar3 : null);
        return band;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyBool("CanBreak", this.getCanBreak());
        jObject.AddPropertyBool("KeepHeaderTogether", this.getKeepHeaderTogether(), true);
        jObject.AddPropertyBool("StartNewPage", this.getStartNewPage());
        jObject.AddPropertyFloat("StartNewPageIfLessThan", (double)this.getStartNewPageIfLessThan(), 100.0);
        jObject.AddPropertyBool("PrintIfEmpty", this.getPrintIfEmpty());
        jObject.AddPropertyBool("PrintOnAllPages", this.getPrintOnAllPages(), true);
        jObject.AddPropertyEnum("PrintOnEvenOddPages", (Enum)this.getPrintOnEvenOddPages(), (Enum)StiPrintOnEvenOddPagesType.Ignore);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("KeepHeaderTogether")) {
                this.keepHeaderTogether = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("StartNewPage")) {
                this.startNewPage = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("StartNewPageIfLessThan")) {
                this.setStartNewPageIfLessThan(property.floatValue().floatValue());
                continue;
            }
            if (property.Name.equals("PrintIfEmpty")) {
                this.printIfEmpty = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("PrintOnAllPages")) {
                this.printOnAllPages = (Boolean)property.Value;
                continue;
            }
            if (!property.Name.equals("PrintOnEvenOddPages")) continue;
            this.printOnEvenOddPages = StiPrintOnEvenOddPagesType.valueOf((String)property.Value);
        }
    }
}

