/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.design.IStiDefault;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableRef;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.expressions.StiExpression;

public class StiParameter
implements IStiDefault,
IStiJsonReportObject,
IStiSerializable,
IStiSerializableRef {
    private String name = "";
    private StiExpression expression = new StiExpression();
    private int reference = -1;

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyStringNullOfEmpty("Name", this.name);
        jObject.AddPropertyJObject("Expression", this.expression.SaveToJsonObject(mode));
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if ("Name".equals(property.Name)) {
                this.name = (String)property.Value;
                continue;
            }
            if (!"Expression".equals(property.Name)) continue;
            StiExpression exp = new StiExpression();
            exp.LoadFromJsonObject((JSONObject)property.Value);
            this.setExpression(exp);
        }
    }

    public boolean isDefault() {
        return StiValidationUtil.isNullOrEmpty((String)this.name) && (this.expression == null || this.expression.getValue().length() == 0);
    }

    public StiParameter() {
    }

    @StiSerializable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @StiSerializable
    public StiExpression getExpression() {
        return this.expression;
    }

    public void setExpression(StiExpression expression) {
        this.expression = expression;
    }

    public StiParameter(String name, StiExpression expression) {
        this.name = name;
        this.expression = expression;
    }

    public void setReference(int reference) {
        this.reference = reference;
    }

    public int getReference() {
        return this.reference;
    }

    public void cleanReference() {
        this.reference = -1;
    }
}

