/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBreakText;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiTextOptions;
import com.stimulsoft.base.drawing.StiTextUtil;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiFooterBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.bands.StiHeaderBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiTextQuality;
import com.stimulsoft.report.components.interfaces.IStiBreakable;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.engine.engineV2.StiNewPageContainer;
import java.util.ArrayList;

public class StiComponentDivider {
    public static StiBreakText BreakText(StiGraphics measureGraphics, StiRectangle rect, String text, StiFont font, StiTextOptions textOptions, StiTextQuality textQuality, boolean allowHtmlTags, StiText textComp) {
        if (!textOptions.getWordWrap()) {
            rect.setWidth(1.0E7);
        }
        return StiTextUtil.breakText((int)rect.getHi(), (int)rect.getWi(), (StiFont)font, (String)text, (boolean)allowHtmlTags, (float)textComp.getLineSpacing(), (StiTextHorAlignment)textComp.getHorAlignment(), (boolean)textComp.getWordWrap(), (StiGraphics)measureGraphics);
    }

    private static boolean AllowBreak(StiComponent comp) {
        if (!(!(comp instanceof StiContainer) || comp instanceof StiHeaderBand || comp instanceof StiGroupHeaderBand || comp instanceof StiDataBand || comp instanceof StiFooterBand)) {
            return false;
        }
        IStiBreakable breakableComp = (IStiBreakable)((Object)(comp instanceof IStiBreakable ? comp : null));
        if (breakableComp != null) {
            return breakableComp.getCanBreak();
        }
        return false;
    }

    public static StiComponentsCollection BreakContainer(StiContainer renderedContainer, StiContainer masterContainer, boolean firstPass) {
        StiComponent comp;
        StiComponentsCollection newComps = new StiComponentsCollection();
        StiComponentsCollection comps = renderedContainer.getComponents();
        double divideLine = renderedContainer.getHeight();
        StiRefObject divLine = new StiRefObject((Object)0.0);
        StiRefObject haveBreaked = new StiRefObject((Object)false);
        boolean failed = true;
        while (failed) {
            failed = false;
            for (int compIndex = 0; compIndex < comps.size(); ++compIndex) {
                comp = (StiComponent)comps.get(compIndex);
                if (!(comp.top < divideLine) || !(comp.getBottom() > divideLine)) continue;
                if (StiComponentDivider.AllowBreak(comp)) {
                    double height = comp.getHeight();
                    comp.setHeight(divideLine - comp.top);
                    Object tempVar = comp.clone();
                    StiComponent comp2 = (StiComponent)(tempVar instanceof StiComponent ? tempVar : null);
                    Object tempVar2 = comp.clone();
                    StiComponent newComp = (StiComponent)(tempVar2 instanceof StiComponent ? tempVar2 : null);
                    IStiBreakable breakableComp = (IStiBreakable)((Object)(comp2 instanceof IStiBreakable ? comp2 : null));
                    boolean tempVar3 = breakableComp.Break(newComp, comp.getHeight() / height, (StiRefObject<Double>)divLine, (StiRefObject<Boolean>)haveBreaked);
                    if (tempVar3) {
                        comp.setHeight(height);
                        continue;
                    }
                    comp.setHeight(height);
                }
                divideLine = Math.min(divideLine, comp.top);
                failed = true;
            }
        }
        int index = 0;
        while (index < comps.size()) {
            comp = (StiComponent)comps.get(index);
            if (comp.getBottom() > divideLine) {
                IStiBreakable breakableComp = (IStiBreakable)((Object)(comp instanceof IStiBreakable ? comp : null));
                if (comp.top < divideLine && breakableComp != null && breakableComp.getCanBreak()) {
                    boolean tempVar5;
                    double newHeight = divideLine - comp.top;
                    Object tempVar4 = comp.clone();
                    StiComponent newComp = (StiComponent)(tempVar4 instanceof StiComponent ? tempVar4 : null);
                    double oldHeight = comp.getHeight();
                    newComp.setHeight(comp.getHeight() - newHeight);
                    newComp.top = 0.0;
                    if (newComp instanceof StiImage) {
                        newComp.canGrow = false;
                        newComp.canShrink = false;
                    } else {
                        newComp.canGrow = true;
                        newComp.canShrink = false;
                    }
                    newComps.add(newComp);
                    comp.setHeight(newHeight);
                    boolean bl = tempVar5 = !breakableComp.Break(newComp, newHeight / oldHeight, (StiRefObject<Double>)divLine, (StiRefObject<Boolean>)haveBreaked);
                    if (tempVar5) {
                        comps.remove(comp);
                        newComp.canGrow = false;
                        continue;
                    }
                } else {
                    if (comp.getHeight() > 0.0) {
                        comp.top -= divideLine;
                        comps.remove(comp);
                        newComps.add(comp);
                        continue;
                    }
                    comp.setHeight(0.0);
                }
            }
            ++index;
        }
        if (newComps.size() > 0) {
            // empty if block
        }
        return newComps;
    }

    public static StiContainer BreakContainer(double maxAllowedHeight, StiContainer renderedContainer, StiRefObject<Boolean> haveBreaked) {
        IStiBreakable breakableComp;
        if (StiOptions.Engine.allowBreakContainerOptimization) {
            return StiComponentDivider.breakContainerV2(maxAllowedHeight, renderedContainer, haveBreaked);
        }
        Object tempVar = renderedContainer.clone(false, false);
        StiContainer breakedContainer = (StiContainer)(tempVar instanceof StiContainer ? tempVar : null);
        StiComponentsCollection newComps = breakedContainer.getComponents();
        StiComponentsCollection comps = renderedContainer.getComponents();
        double divideLine = maxAllowedHeight;
        StiRefObject divLine = new StiRefObject((Object)0.0);
        boolean divideFlag1 = false;
        boolean divideFlag2 = false;
        boolean failed = true;
        block0: while (failed) {
            failed = false;
            for (StiComponent comp : comps) {
                if (!(comp.getTop() < divideLine) || !(comp.getTop() + comp.getHeight() > divideLine)) continue;
                breakableComp = (IStiBreakable)((Object)(comp instanceof IStiBreakable ? comp : null));
                if (breakableComp != null && breakableComp.getCanBreak()) {
                    double oldHeight = comp.getHeight();
                    double newHeight = divideLine - comp.getTop();
                    comp.setHeight(newHeight);
                    Object tempVar2 = comp.clone();
                    StiComponent comp2 = (StiComponent)(tempVar2 instanceof StiComponent ? tempVar2 : null);
                    Object tempVar3 = comp.clone();
                    StiComponent newComp = (StiComponent)(tempVar3 instanceof StiComponent ? tempVar3 : null);
                    IStiBreakable breakableComp2 = (IStiBreakable)((Object)(comp2 instanceof IStiBreakable ? comp2 : null));
                    boolean tempVar4 = breakableComp2.Break(newComp, newHeight / oldHeight, (StiRefObject<Double>)divLine, haveBreaked);
                    if (tempVar4) {
                        if ((Double)divLine.argvalue > divideLine) {
                            divideLine = (Double)divLine.argvalue;
                        }
                        comp.setHeight(oldHeight);
                        if (divideFlag2 || !(comp2.getBottom() < divideLine)) continue;
                        if (!divideFlag1) {
                            divideLine = comp2.getBottom();
                            divideFlag1 = true;
                        } else {
                            divideLine = maxAllowedHeight;
                            divideFlag2 = true;
                        }
                        failed = true;
                        continue block0;
                    }
                    comp.setHeight(oldHeight);
                }
                if (comp instanceof StiNewPageContainer) {
                    divideLine = comp.getBottom();
                    divideFlag1 = true;
                    failed = true;
                    continue block0;
                }
                divideLine = Math.min(divideLine, comp.getTop());
                failed = true;
            }
        }
        int index = 0;
        while (index < comps.size()) {
            StiComponent comp;
            comp = (StiComponent)comps.get(index);
            if (comp.getTop() + comp.getHeight() > divideLine) {
                breakableComp = (IStiBreakable)((Object)(comp instanceof IStiBreakable ? comp : null));
                if (comp.getTop() < divideLine && breakableComp != null && breakableComp.getCanBreak()) {
                    boolean tempVar6;
                    double newHeight = divideLine - comp.getTop();
                    Object tempVar5 = comp.clone();
                    StiComponent newComp = (StiComponent)(tempVar5 instanceof StiComponent ? tempVar5 : null);
                    double oldHeight = comp.getHeight();
                    newComp.setHeight(comp.getHeight() - newHeight);
                    newComp.top = 0.0;
                    if (newComp instanceof StiImage) {
                        newComp.canGrow = false;
                        newComp.canShrink = false;
                    } else {
                        newComp.canGrow = true;
                        newComp.canShrink = false;
                    }
                    newComps.add(newComp);
                    comp.setHeight(newHeight);
                    boolean bl = tempVar6 = !breakableComp.Break(newComp, newHeight / oldHeight, (StiRefObject<Double>)divLine, haveBreaked);
                    if (tempVar6) {
                        comps.remove(comp);
                        newComp.canGrow = false;
                        continue;
                    }
                } else {
                    comp.top -= divideLine;
                    comps.remove(comp);
                    newComps.add(comp);
                    continue;
                }
            }
            ++index;
        }
        if (newComps.size() > 0) {
            // empty if block
        }
        renderedContainer.setHeight(divideLine);
        return breakedContainer;
    }

    static StiContainer breakContainerV2(double maxAllowedHeight, StiContainer renderedContainer, StiRefObject<Boolean> haveBreaked) {
        StiContainer breakedContainer = (StiContainer)renderedContainer.clone(false, false);
        StiComponentsCollection newComps = breakedContainer.getComponents();
        StiComponentsCollection comps = renderedContainer.getComponents();
        double divideLine = maxAllowedHeight;
        divideLine = StiComponentDivider.getDivideLine(renderedContainer, divideLine);
        Double firstDivLine = null;
        int index = 0;
        ArrayList<StiComponent> oldComps = new ArrayList<StiComponent>();
        while (index < comps.size()) {
            StiComponent comp;
            block9: {
                block10: {
                    StiRefObject divLine;
                    block11: {
                        IStiBreakable breakableComp;
                        comp = (StiComponent)comps.get(index);
                        if (!(comp.getTop() + comp.getHeight() > divideLine)) break block9;
                        IStiBreakable iStiBreakable = breakableComp = comp instanceof IStiBreakable ? (IStiBreakable)((Object)comp) : null;
                        if (!(comp.getTop() < divideLine) || breakableComp == null || !breakableComp.getCanBreak()) break block10;
                        double newHeight = divideLine - comp.getTop();
                        boolean isCont = comp instanceof StiContainer;
                        StiComponent newComp = (StiComponent)(isCont ? ((StiContainer)comp).clone(true, false) : comp.clone());
                        double oldHeight = comp.getHeight();
                        newComp.setHeight(comp.getHeight() - newHeight);
                        newComp.setTop(0.0);
                        if (newComp instanceof StiImage) {
                            newComp.setCanGrow(false);
                            newComp.setCanShrink(false);
                        } else {
                            newComp.setCanGrow(true);
                            newComp.setCanShrink(false);
                        }
                        newComps.add(newComp);
                        comp.setHeight(newHeight);
                        if (!isCont) {
                            haveBreaked.argvalue = true;
                        }
                        if (!breakableComp.Break(newComp, newHeight / oldHeight, (StiRefObject<Double>)(divLine = new StiRefObject((Object)divideLine)), haveBreaked)) {
                            ++index;
                            newComp.setCanGrow(false);
                            continue;
                        }
                        if (firstDivLine != null) break block11;
                        firstDivLine = (Double)divLine.argvalue;
                        break block9;
                    }
                    if (firstDivLine == divLine.argvalue) break block9;
                    haveBreaked.argvalue = true;
                    break block9;
                }
                comp.setTop(comp.getTop() - divideLine);
                ++index;
                newComps.add(comp);
                continue;
            }
            oldComps.add(comp);
            ++index;
        }
        if (oldComps.size() != comps.size()) {
            for (int index2 = 0; index2 < oldComps.size(); ++index2) {
                comps.set(index2, oldComps.get(index2));
            }
            while (comps.size() > oldComps.size()) {
                comps.remove(comps.size() - 1);
            }
        }
        if (StiOptions.Engine.removeBottomBorderOfSplitContainer && newComps.size() > 0) {
            renderedContainer.setBorder((StiBorder)renderedContainer.getBorder().clone());
            renderedContainer.getBorder().getSide().add((IStiEnum)StiBorderSides.Left);
            renderedContainer.getBorder().getSide().add((IStiEnum)StiBorderSides.Right);
            renderedContainer.getBorder().getSide().add((IStiEnum)StiBorderSides.Top);
        }
        renderedContainer.setHeight(divideLine);
        return breakedContainer;
    }

    private static double getDivideLine(StiContainer container, double divideLine) {
        StiRefObject breakCounter = new StiRefObject((Object)2);
        double divLine = StiComponentDivider.searchDivideLine(container, divideLine, divideLine, (StiRefObject<Integer>)breakCounter);
        if (divLine == divideLine) {
            return divideLine;
        }
        while (divLine > 0.0) {
            double divLine2 = StiComponentDivider.searchDivideLine(container, divLine, divideLine, (StiRefObject<Integer>)breakCounter);
            if (divLine2 == divLine) {
                return divLine;
            }
            divLine = divLine2;
        }
        return 0.0;
    }

    private static double searchDivideLine(StiContainer container, double divideLine, double maxAllowedHeight, StiRefObject<Integer> breakCounter) {
        StiRefObject divLine = new StiRefObject((Object)0.0);
        for (StiComponent comp : container.getComponents()) {
            IStiBreakable breakableComp;
            if (!(comp.getTop() < divideLine) || !(comp.getTop() + comp.getHeight() > divideLine)) continue;
            IStiBreakable iStiBreakable = breakableComp = comp instanceof IStiBreakable ? (IStiBreakable)((Object)comp) : null;
            if (breakableComp != null && breakableComp.getCanBreak()) {
                if ((Integer)breakCounter.argvalue == 0) continue;
                double oldHeight = comp.getHeight();
                double newHeight = divideLine - comp.getTop();
                if (comp instanceof StiContainer) {
                    divLine.argvalue = StiComponentDivider.getDivideLine((StiContainer)comp, newHeight);
                    if ((Double)divLine.argvalue < newHeight) {
                        StiRefObject<Integer> stiRefObject = breakCounter;
                        Integer n = (Integer)stiRefObject.argvalue;
                        stiRefObject.argvalue = (Integer)stiRefObject.argvalue - 1;
                        Integer n2 = stiRefObject.argvalue;
                        if ((Integer)breakCounter.argvalue == 0) {
                            return maxAllowedHeight;
                        }
                    }
                    if ((Double)divLine.argvalue == newHeight) continue;
                    return comp.getTop() + (Double)divLine.argvalue;
                }
                StiComponent comp2 = (StiComponent)comp.clone();
                StiComponent newComp = (StiComponent)comp.clone();
                comp2.setHeight(newHeight);
                newComp.setHeight(newHeight);
                IStiBreakable breakableComp2 = (IStiBreakable)((Object)comp2);
                StiRefObject haveBreaked = new StiRefObject((Object)false);
                if (breakableComp2.Break(newComp, newHeight / oldHeight, (StiRefObject<Double>)divLine, (StiRefObject<Boolean>)haveBreaked)) {
                    if (!(comp2.getBottom() < divideLine)) continue;
                    return comp2.getBottom();
                }
            }
            if (comp instanceof StiNewPageContainer) {
                return comp.getBottom();
            }
            divideLine = comp.getTop();
        }
        return divideLine;
    }
}

