/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check.page;

import com.stimulsoft.base.localization.StiLocalizationExt;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheckStatus;
import com.stimulsoft.report.check.actions.page.StiOrientationPageToLandscapeAction;
import com.stimulsoft.report.check.actions.page.StiOrientationPageToPortraitAction;
import com.stimulsoft.report.check.actions.page.StiSwitchWidthAndHeightOfPageAction;
import com.stimulsoft.report.check.page.StiPageCheck;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.enums.StiPageOrientation;

public class StiOrientationPageCheck
extends StiPageCheck {
    @Override
    public String getShortMessage() {
        return StiLocalizationExt.format((String)"CheckPage", (String)"StiOrientationPageCheckShort", (Object[])new Object[]{this.getElementName()});
    }

    @Override
    public String getLongMessage() {
        StiPage page;
        StiPage stiPage = page = this.getElement() instanceof StiPage ? (StiPage)this.getElement() : null;
        if (page != null) {
            if (page.getOrientation() == StiPageOrientation.Portrait) {
                return StiLocalizationExt.format((String)"CheckPage", (String)"StiOrientationPageCheckLongPortrait", (Object[])new Object[]{this.getElementName()});
            }
            return StiLocalizationExt.format((String)"CheckPage", (String)"StiOrientationPageCheckLongLandscape", (Object[])new Object[]{this.getElementName()});
        }
        return StiLocalizationExt.format((String)"CheckPage", (String)"StiOrientationPageCheckLongPortrait", (Object[])new Object[]{this.getElementName()});
    }

    @Override
    public StiCheckStatus getStatus() {
        return StiCheckStatus.Warning;
    }

    @Override
    public Object processCheck(StiReport report, Object obj) {
        StiPage page = obj instanceof StiPage ? (StiPage)obj : null;
        boolean failed = false;
        if (page.getOrientation() == StiPageOrientation.Portrait) {
            if (page.getPageWidth() > page.getPageHeight()) {
                failed = true;
            }
        } else if (page.getPageWidth() < page.getPageHeight()) {
            failed = true;
        }
        if (failed) {
            StiOrientationPageCheck check = new StiOrientationPageCheck();
            check.setElement(obj);
            if (page.getOrientation() == StiPageOrientation.Portrait) {
                check.getActions().add(new StiOrientationPageToLandscapeAction());
            } else {
                check.getActions().add(new StiOrientationPageToPortraitAction());
            }
            check.getActions().add(new StiSwitchWidthAndHeightOfPageAction());
            return check;
        }
        return null;
    }
}

