/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check.helper;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.complexcomponents.StiSubReport;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.dictionary.StiResource;
import com.stimulsoft.report.dictionary.databases.StiDatabase;
import com.stimulsoft.report.dictionary.databases.StiJsonDatabase;
import com.stimulsoft.report.dictionary.databases.StiXmlDatabase;
import com.stimulsoft.report.dictionary.enums.StiResourceType;
import java.util.ArrayList;
import java.util.List;

public class StiUsedResourceHelper {
    public static List<StiDatabase> getDatabasesUsedResource(StiReport report, StiResource resource) {
        String resName = "resource://" + resource.getName();
        ArrayList<StiDatabase> fileDatabases = new ArrayList<StiDatabase>();
        for (StiDatabase database : report.getDictionary().getDatabases()) {
            if (database instanceof StiXmlDatabase && resource.type == StiResourceType.Xsd) {
                if (!StiValidationUtil.equals((Object)((StiXmlDatabase)database).getPathSchema(), (Object)resName)) continue;
                fileDatabases.add(database);
                continue;
            }
            if (!(database instanceof StiJsonDatabase) || !StiValidationUtil.equals((Object)((StiJsonDatabase)database).getPathData(), (Object)resName)) continue;
            fileDatabases.add(database);
        }
        return fileDatabases;
    }

    public static List<StiComponent> getComponentsUsedResource(StiReport report, StiResource resource) {
        ArrayList<StiComponent> usedComponents = new ArrayList<StiComponent>();
        switch (resource.type) {
            case Image: {
                List<StiComponent> usedImages = StiUsedResourceHelper.getImageComponentsUsedResource(report, resource);
                usedComponents.addAll(usedImages);
                break;
            }
            case Rtf: 
            case Txt: {
                List<StiComponent> usedRichText = StiUsedResourceHelper.getRichTextComponentsUsedResource(report, resource);
                usedComponents.addAll(usedRichText);
                break;
            }
            case Report: 
            case ReportSnapshot: {
                List<StiComponent> usedReports = StiUsedResourceHelper.getReportsUsedResource(report, resource);
                usedComponents.addAll(usedReports);
                break;
            }
            case FontEot: 
            case FontOtf: 
            case FontTtc: 
            case FontTtf: 
            case FontWoff: {
                List<StiComponent> usedFonts = StiUsedResourceHelper.getTextsUsedResource(report, resource);
                usedComponents.addAll(usedFonts);
            }
        }
        return usedComponents;
    }

    private static List<StiComponent> getImageComponentsUsedResource(StiReport report, StiResource resource) {
        String resName = "resource://" + resource.getName();
        ArrayList<StiComponent> usedImages = new ArrayList<StiComponent>();
        for (StiComponent component : report.GetComponents()) {
            if (!(component instanceof StiImage) || !StiValidationUtil.equals((Object)((StiImage)component).getImageURL().getValue(), (Object)resName)) continue;
            usedImages.add(component);
        }
        return usedImages;
    }

    private static List<StiComponent> getRichTextComponentsUsedResource(StiReport report, StiResource resource) {
        return new ArrayList<StiComponent>();
    }

    private static List<StiComponent> getReportsUsedResource(StiReport report, StiResource resource) {
        String resName = "resource://" + resource.getName();
        ArrayList<StiComponent> usedReports = new ArrayList<StiComponent>();
        for (StiComponent component : report.GetComponents()) {
            if (!(component instanceof StiSubReport) || !StiValidationUtil.equals((Object)((StiSubReport)component).getSubReportUrl(), (Object)resName)) continue;
            usedReports.add(component);
        }
        return usedReports;
    }

    private static List<StiComponent> getTextsUsedResource(StiReport report, StiResource resource) {
        String resName = "resource://" + resource.getName();
        ArrayList<StiComponent> usedTextComp = new ArrayList<StiComponent>();
        for (StiComponent component : report.GetComponents()) {
            if (!(component instanceof StiText) || !StiValidationUtil.equals((Object)((StiText)component).getFont().getName(), (Object)resName)) continue;
            usedTextComp.add(component);
        }
        return usedTextComp;
    }
}

