/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check.component;

import com.stimulsoft.base.localization.StiLocalizationExt;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheckStatus;
import com.stimulsoft.report.check.actions.component.StiDeleteComponentAction;
import com.stimulsoft.report.check.actions.component.StiMoveComponentToPageAreaAction;
import com.stimulsoft.report.check.actions.component.StiMoveComponentToPrintablePageAreaAction;
import com.stimulsoft.report.check.component.StiComponentCheck;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.simplecomponents.StiHorizontalLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiVerticalLinePrimitive;

public class StiLocationOutsidePageCheck
extends StiComponentCheck {
    @Override
    public boolean getPreviewVisible() {
        return true;
    }

    @Override
    public String getShortMessage() {
        if (this.isOutsidePage()) {
            return StiLocalizationExt.format((String)"CheckComponent", (String)"StiLocationOutsidePageCheckShort", (Object[])new Object[]{this.getElementName()});
        }
        return StiLocalizationExt.format((String)"CheckComponent", (String)"StiLocationOutsidePrintableAreaCheckShort", (Object[])new Object[]{this.getElementName()});
    }

    @Override
    public String getLongMessage() {
        if (this.getElement() != null) {
            if (this.isOutsidePage()) {
                return StiLocalizationExt.format((String)"CheckComponent", (String)"StiLocationOutsidePageCheckLong", (Object[])new Object[]{this.getElementName()});
            }
            return StiLocalizationExt.format((String)"CheckComponent", (String)"StiLocationOutsidePrintableAreaCheckLong", (Object[])new Object[]{this.getElementName()});
        }
        return StiLocalizationExt.format((String)"CheckComponent", (String)"StiLocationOutsidePageCheckLong", (Object[])new Object[]{this.getElementName()});
    }

    @Override
    public StiCheckStatus getStatus() {
        return StiCheckStatus.Warning;
    }

    public boolean isOutsidePage() {
        StiComponent comp = this.getElement() instanceof StiComponent ? (StiComponent)this.getElement() : null;
        StiPage page = comp.getPage();
        if (page == null) {
            return false;
        }
        StiRectangle compRect = comp.getPaintRectangle(false, false);
        if (comp instanceof StiHorizontalLinePrimitive) {
            compRect.setHeight(0.0);
        }
        if (comp instanceof StiVerticalLinePrimitive) {
            compRect.setWidth(0.0);
        }
        double pageHeight = (page.getPageHeight() - page.getMargins().getTop() - page.getMargins().getBottom()) * (double)page.getSegmentPerHeight();
        StiRectangle pageRect = new StiRectangle(-page.getMargins().getLeft(), -page.getMargins().getTop(), page.getWidth() + page.getMargins().getLeft() + page.getMargins().getRight(), (pageHeight *= page.getLargeHeightAutoFactor()) + page.getMargins().getTop() + page.getMargins().getBottom());
        if (compRect.getLeft() < pageRect.getLeft() || compRect.getTop() < pageRect.getTop() || compRect.getRight() > pageRect.getRight()) {
            return true;
        }
        if (compRect.getBottom() > pageRect.getBottom()) {
            if (comp instanceof StiBand) {
                return false;
            }
            return comp.getParent() == comp.getPage() || !(comp.getBottom() < pageHeight);
        }
        return false;
    }

    public boolean isOutsidePrintableArea() {
        StiComponent comp = this.getElement() instanceof StiComponent ? (StiComponent)this.getElement() : null;
        StiPage page = comp.getPage();
        if (page == null) {
            return false;
        }
        StiRectangle compRect = comp.getPaintRectangle(false, false);
        if (comp instanceof StiHorizontalLinePrimitive) {
            compRect.setHeight(0.0);
        }
        if (comp instanceof StiVerticalLinePrimitive) {
            compRect.setWidth(0.0);
        }
        double pageHeight = (page.getPageHeight() - page.getMargins().getTop() - page.getMargins().getBottom()) * (double)page.getSegmentPerHeight();
        StiRectangle pageRect = new StiRectangle(0.0, 0.0, page.getWidth(), pageHeight *= page.getLargeHeightAutoFactor());
        if (compRect.getLeft() < pageRect.getLeft() || compRect.getTop() < pageRect.getTop() || compRect.getRight() > pageRect.getRight() * 1.01) {
            return true;
        }
        if (compRect.getBottom() > pageRect.getBottom() * 1.01) {
            if (comp instanceof StiBand) {
                return false;
            }
            return comp.getParent() == comp.getPage() || !(comp.getBottom() < pageHeight);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object processCheck(StiReport report, Object obj) {
        this.setElement(obj);
        try {
            boolean failed;
            boolean bl = failed = this.isOutsidePage() || this.isOutsidePrintableArea();
            if (failed) {
                StiLocationOutsidePageCheck check = new StiLocationOutsidePageCheck();
                check.setElement(obj);
                if (this.isOutsidePage()) {
                    check.getActions().add(new StiMoveComponentToPageAreaAction());
                }
                check.getActions().add(new StiMoveComponentToPrintablePageAreaAction());
                check.getActions().add(new StiDeleteComponentAction());
                StiLocationOutsidePageCheck stiLocationOutsidePageCheck = check;
                return stiLocationOutsidePageCheck;
            }
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            this.setElement(null);
        }
    }
}

