/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check.component;

import com.stimulsoft.base.localization.StiLocalizationExt;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheckStatus;
import com.stimulsoft.report.check.actions.component.StiCanGrowGrowToHeightComponentInContainerAction;
import com.stimulsoft.report.check.component.StiComponentCheck;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;

public class StiCanGrowGrowToHeightComponentInContainerCheck
extends StiComponentCheck {
    @Override
    public boolean isDefaultStateEnabled() {
        return false;
    }

    @Override
    public boolean getPreviewVisible() {
        return true;
    }

    @Override
    public String getShortMessage() {
        return StiLocalizationExt.Get((String)"CheckComponent", (String)"StiCanGrowGrowToHeightComponentInContainerShort");
    }

    @Override
    public String getLongMessage() {
        return StiLocalizationExt.format((String)"CheckComponent", (String)"StiCanGrowGrowToHeightComponentInContainerLong", (Object[])new Object[]{this.getElementName()});
    }

    @Override
    public StiCheckStatus getStatus() {
        return StiCheckStatus.Information;
    }

    private boolean check() {
        StiContainer container;
        StiContainer stiContainer = container = this.getElement() instanceof StiContainer ? (StiContainer)this.getElement() : null;
        if (container != null && container.getComponents().size() > 1) {
            boolean stateCanGrow = false;
            boolean stateGrowToHeight = false;
            for (StiComponent comp : container.getComponents()) {
                if (comp instanceof StiBand) continue;
                if (comp.getCanGrow()) {
                    stateCanGrow = true;
                }
                if (!comp.getGrowToHeight()) {
                    stateGrowToHeight = true;
                }
                if (!stateCanGrow || !stateGrowToHeight) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object processCheck(StiReport report, Object obj) {
        this.setElement(obj);
        try {
            boolean failed = this.check();
            if (failed) {
                StiCanGrowGrowToHeightComponentInContainerCheck check = new StiCanGrowGrowToHeightComponentInContainerCheck();
                check.setElement(obj);
                check.getActions().add(new StiCanGrowGrowToHeightComponentInContainerAction());
                StiCanGrowGrowToHeightComponentInContainerCheck stiCanGrowGrowToHeightComponentInContainerCheck = check;
                return stiCanGrowGrowToHeightComponentInContainerCheck;
            }
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            this.setElement(null);
        }
    }
}

