/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check.component;

import com.stimulsoft.base.localization.StiLocalizationExt;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheckStatus;
import com.stimulsoft.report.check.actions.component.StiAllowHtmlTagsInTextAction;
import com.stimulsoft.report.check.component.StiComponentCheck;
import com.stimulsoft.report.components.simplecomponents.StiText;

public class StiAllowHtmlTagsInTextCheck
extends StiComponentCheck {
    @Override
    public boolean getPreviewVisible() {
        return true;
    }

    @Override
    public String getShortMessage() {
        return StiLocalizationExt.Get((String)"CheckComponent", (String)"StiAllowHtmlTagsInTextCheckShort");
    }

    @Override
    public String getLongMessage() {
        return StiLocalizationExt.format((String)"CheckComponent", (String)"StiAllowHtmlTagsInTextCheckLong", (Object[])new Object[]{this.getElementName()});
    }

    @Override
    public StiCheckStatus getStatus() {
        return StiCheckStatus.Warning;
    }

    private boolean Check() {
        StiText comp;
        StiText stiText = comp = this.getElement() instanceof StiText ? (StiText)this.getElement() : null;
        if (comp != null && !comp.getAllowHtmlTags() && comp.getText().getValue().length() > 0) {
            if (comp.getText().getValue().contains("&amp;") || comp.getText().getValue().contains("&lt;") || comp.getText().getValue().contains("&gt;") || comp.getText().getValue().contains("&quot;") || comp.getText().getValue().contains("&nbsp;")) {
                return true;
            }
            int startIndex = 0;
            int endIndex = 0;
            while (startIndex < comp.getText().getValue().length() && (startIndex = comp.getText().getValue().indexOf("<", startIndex)) != -1 && (endIndex = comp.getText().getValue().indexOf(">", startIndex)) != -1) {
                String tag;
                if (endIndex > startIndex + 1 && (tag = comp.getText().getValue().substring(startIndex + 1, endIndex).trim()).length() > 0 && (tag.length() < 10 && (tag.equals("b") || tag.equals("/b") || tag.equals("i") || tag.equals("/i") || tag.equals("u") || tag.equals("/u") || tag.equals("s") || tag.equals("/s") || tag.equals("sub") || tag.equals("/sub") || tag.equals("sup") || tag.equals("/sup") || tag.equals("br") || tag.equals("/br") || tag.equals("strong") || tag.equals("/strong") || tag.equals("p") || tag.equals("/p") || tag.equals("em") || tag.equals("/em")) || tag.startsWith("font ") || tag.startsWith("/font") || tag.startsWith("font-face") || tag.startsWith("/font-face") || tag.startsWith("font-name") || tag.startsWith("/font-name") || tag.startsWith("font-family") || tag.startsWith("/font-family") || tag.startsWith("font-size") || tag.startsWith("/font-size") || tag.startsWith("font-color") || tag.startsWith("/font-color") || tag.startsWith("color") || tag.startsWith("/color") || tag.startsWith("background-color") || tag.startsWith("/background-color") || tag.startsWith("letter-spacing") || tag.startsWith("/letter-spacing") || tag.startsWith("word-spacing") || tag.startsWith("/word-spacing") || tag.startsWith("line-height") || tag.startsWith("/line-height") || tag.startsWith("text-align") || tag.startsWith("/text-align"))) {
                    return true;
                }
                ++startIndex;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object processCheck(StiReport report, Object obj) {
        this.setElement(obj);
        try {
            boolean failed = this.Check();
            if (failed) {
                StiAllowHtmlTagsInTextCheck check = new StiAllowHtmlTagsInTextCheck();
                check.setElement(obj);
                check.getActions().add(new StiAllowHtmlTagsInTextAction());
                StiAllowHtmlTagsInTextCheck stiAllowHtmlTagsInTextCheck = check;
                return stiAllowHtmlTagsInTextCheck;
            }
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            this.setElement(null);
        }
    }
}

