/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.view.trendLines;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.services.StiService;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.chart.core.trendLines.StiTrendLineCoreXF;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLine;
import java.util.List;

public abstract class StiTrendLine
extends StiService
implements IStiTrendLine,
Cloneable {
    private StiTrendLineCoreXF core;
    private StiColor lineColor = StiColor.Black;
    private float lineWidth = 1.0f;
    private StiPenStyle lineStyle = StiPenStyle.Solid;
    private boolean showShadow = true;
    private boolean allowApplyStyle = true;

    public Object clone() {
        Object tempVar = this.MemberwiseClone();
        IStiTrendLine line = (IStiTrendLine)(tempVar instanceof IStiTrendLine ? tempVar : null);
        if (this.core != null) {
            Object tempVar2 = this.core.clone();
            line.setCore((StiTrendLineCoreXF)(tempVar2 instanceof StiTrendLineCoreXF ? tempVar2 : null));
            line.getCore().setTrendLine(line);
        }
        return line;
    }

    public String getServiceName() {
        return this.getCore().getLocalizedName();
    }

    public final String getServiceCategory() {
        return "Chart";
    }

    public final Class getServiceType() {
        return StiTrendLine.class;
    }

    @Override
    public final StiTrendLineCoreXF getCore() {
        return this.core;
    }

    @Override
    public final void setCore(StiTrendLineCoreXF value) {
        this.core = value;
    }

    @Override
    @StiSerializable
    public StiColor getLineColor() {
        return this.lineColor;
    }

    @Override
    public void setLineColor(StiColor value) {
        this.lineColor = value;
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public final float getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public final void setLineWidth(float value) {
        this.lineWidth = value;
    }

    @Override
    @StiDefaulValue(value="Solid")
    @StiSerializable
    public final StiPenStyle getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public final void setLineStyle(StiPenStyle value) {
        this.lineStyle = value;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getShowShadow() {
        return this.showShadow;
    }

    @Override
    public final void setShowShadow(boolean value) {
        this.showShadow = value;
    }

    @Override
    @StiSerializable
    public boolean getAllowApplyStyle() {
        return this.allowApplyStyle;
    }

    @Override
    public void setAllowApplyStyle(boolean value) {
        if (this.allowApplyStyle != value) {
            this.allowApplyStyle = value;
        }
    }

    public String toString() {
        return this.getServiceName();
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyStringNullOfEmpty("LineColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getLineColor(), (StiColorEnum)StiColorEnum.Black));
        jObject.AddPropertyFloat("LineWidth", (double)this.lineWidth, 1.0);
        jObject.AddPropertyEnum("LineStyle", (Enum)this.lineStyle, (Enum)StiPenStyle.Solid);
        jObject.AddPropertyBool("ShowShadow", this.showShadow);
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("LineColor")) {
                this.setLineColor(StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value)));
                continue;
            }
            if (property.Name.equals("LineWidth")) {
                this.lineWidth = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("LineStyle")) {
                this.lineStyle = StiPenStyle.valueOf((String)((String)property.Value));
                continue;
            }
            if (!property.Name.equals("ShowShadow")) continue;
            this.showShadow = (Boolean)property.Value;
        }
    }

    public static IStiTrendLine LoadFromJsonObjectInternal(JSONObject jObject) throws JSONException {
        String ident = (String)jObject.Properties().FirstOrDefault((String)"Ident").Value;
        List<Class<?>> classes = StiOptions.Services.getChartTrendLines();
        Class<?> clazz = null;
        for (Class<?> claz : classes) {
            String name = claz.getName();
            if (!name.substring(name.lastIndexOf(46) + 1).equals(ident)) continue;
            clazz = claz;
        }
        IStiTrendLine line = null;
        if (clazz != null) {
            try {
                line = (IStiTrendLine)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return line;
    }
}

