/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.view.series.pie;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.core.series.pie.StiPieSeriesCoreXF;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.pie.IStiPieSeries;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLine;
import com.stimulsoft.report.chart.view.areas.pie.StiPieArea;
import com.stimulsoft.report.chart.view.events.StiGetCutPieListEvent;
import com.stimulsoft.report.chart.view.expressions.StiCutPieListExpression;
import com.stimulsoft.report.chart.view.series.StiSeries;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.enums.StiCalculationMode;
import com.stimulsoft.report.events.StiGetValueEventArgs;
import java.util.ArrayList;

public class StiPieSeries
extends StiSeries
implements IStiPieSeries {
    private boolean allowApplyBrush = true;
    private boolean allowApplyBorderColor = true;
    private float startAngle = 0.0f;
    private StiColor borderColor = StiColor.Gray;
    private StiBrush brush = new StiSolidBrush(StiColor.Gainsboro);
    private boolean lighting = true;
    private float diameter = 0.0f;
    private float distance = 0.0f;
    private ArrayList<Double> cutPieListValues = new ArrayList();
    private StiCutPieListExpression cutPieList = new StiCutPieListExpression();
    private StiGetCutPieListEvent getCutPieListEvent = new StiGetCutPieListEvent();

    @Override
    public StiSeries clone() {
        IStiSeries tempVar = super.clone();
        StiPieSeries series = (StiPieSeries)(tempVar instanceof StiPieSeries ? tempVar : null);
        return series;
    }

    @Override
    public Class GetDefaultAreaType() {
        return StiPieArea.class;
    }

    @Override
    @StiSerializable(need=false)
    public IStiTrendLine getTrendLine() {
        return super.getTrendLine();
    }

    @Override
    public void setTrendLine(IStiTrendLine value) {
        super.setTrendLine(value);
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getAllowApplyBrush() {
        return this.allowApplyBrush;
    }

    @Override
    public final void setAllowApplyBrush(boolean value) {
        if (this.allowApplyBrush != value) {
            this.allowApplyBrush = value;
        }
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getAllowApplyBorderColor() {
        return this.allowApplyBorderColor;
    }

    @Override
    public final void setAllowApplyBorderColor(boolean value) {
        if (this.allowApplyBorderColor != value) {
            this.allowApplyBorderColor = value;
        }
    }

    @Override
    public Object[] getArguments() {
        Object[] args = super.getArguments();
        if (args.length == 0 && this.getChart() != null && ((StiChart)this.getChart()).getReport() != null && ((StiChart)this.getChart()).getReport().getIsDesigning()) {
            return new Object[]{"Arg1", "Arg2", "Arg3"};
        }
        return args;
    }

    @Override
    public void setArguments(Object[] value) {
        super.setArguments(value);
    }

    @Override
    @StiDefaulValue(value="0.0")
    @StiSerializable
    public float getStartAngle() {
        return this.startAngle;
    }

    @Override
    public void setStartAngle(float value) {
        this.startAngle = value;
    }

    @Override
    @StiSerializable
    public final StiColor getBorderColor() {
        return this.borderColor;
    }

    @Override
    public final void setBorderColor(StiColor value) {
        this.borderColor = value;
    }

    @Override
    @StiSerializable(shortName="bh")
    public final StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public final void setBrush(StiBrush value) {
        this.brush = value;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getLighting() {
        return this.lighting;
    }

    @Override
    public final void setLighting(boolean value) {
        this.lighting = value;
    }

    @Override
    @StiDefaulValue(value="0.0")
    @StiSerializable
    public float getDiameter() {
        return this.diameter;
    }

    @Override
    public void setDiameter(float value) {
        this.diameter = value;
        if (value < 5.0f) {
            this.diameter = 0.0f;
        }
    }

    @Override
    @StiDefaulValue(value="0.0")
    @StiSerializable
    public float getDistance() {
        return this.distance;
    }

    @Override
    public void setDistance(float value) {
        this.distance = Math.max(0.0f, value);
    }

    @Override
    public final ArrayList<Double> getCutPieListValues() {
        if (this.getChart() != null && ((StiChart)this.getChart()).getReport() != null && this.getChart().getIsDesigning()) {
            if (this.getCutPieList().getValue() != null && this.getCutPieList().getValue().length() > 0) {
                return StiSeries.GetValuesFromString(this.getCutPieList().getValue());
            }
            return new ArrayList<Double>();
        }
        return this.cutPieListValues;
    }

    @Override
    public final void setCutPieListValues(ArrayList<Double> value) {
        this.cutPieListValues = value;
    }

    @Deprecated
    public final StiCutPieListExpression getCuttedPieList() {
        return this.getCutPieList();
    }

    @Deprecated
    public final void setCuttedPieList(StiCutPieListExpression value) {
        this.setCutPieList(value);
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public final StiCutPieListExpression getCutPieList() {
        return this.cutPieList;
    }

    public final void setCutPieList(StiCutPieListExpression value) {
        this.cutPieList = value;
    }

    protected void OnGetCutPieList(StiGetValueEventArgs e) {
    }

    public final void InvokeGetCutPieList(StiComponent sender, StiGetValueEventArgs e) {
        block3: {
            try {
                this.OnGetCutPieList(e);
                if (sender.getReport().getCalculationMode() == StiCalculationMode.Interpretation) {
                    StiText tempText = new StiText();
                    tempText.setName("**ChartPieSeriesCutPieList**");
                    tempText.setPage(sender.getReport().getPages().get(0));
                    Object parserResult = StiParser.ParseTextValue(this.getCutPieList().getValue(), (StiComponent)tempText);
                    e.setValue(sender.getReport().ToString(parserResult));
                }
            }
            catch (Exception e1) {
                if (StiOptions.Engine.logLevel < 10) break block3;
                e1.printStackTrace();
            }
        }
    }

    @StiSerializable
    public final StiGetCutPieListEvent getGetCutPieListEvent() {
        return this.getCutPieListEvent;
    }

    public final void setGetCutPieListEvent(StiGetCutPieListEvent value) {
        this.getCutPieListEvent = value;
    }

    public StiPieSeries() {
        this.setCore(new StiPieSeriesCoreXF(this));
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("TrendLine");
        jObject.RemoveProperty("AllowApplyStyle");
        jObject.AddPropertyBool("AllowApplyBrush", this.allowApplyBrush, true);
        jObject.AddPropertyBool("AllowApplyBorderColor", this.allowApplyBorderColor, true);
        jObject.AddPropertyFloat("StartAngle", (double)this.getStartAngle(), 0.0);
        jObject.AddPropertyStringNullOfEmpty("BorderColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.borderColor, (StiColorEnum)StiColorEnum.Gray));
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.brush));
        jObject.AddPropertyBool("Lighting", this.lighting, true);
        jObject.AddPropertyFloat("Diameter", (double)this.getDiameter(), 0.0);
        jObject.AddPropertyFloat("Distance", (double)this.getDistance(), 0.0);
        jObject.AddPropertyJObject("CutPieList", this.cutPieList.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetCutPieListEvent", this.getCutPieListEvent.SaveToJsonObject(mode));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("AllowApplyBrush")) {
                this.allowApplyBrush = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("AllowApplyBorderColor")) {
                this.allowApplyBorderColor = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("StartAngle")) {
                this.setStartAngle(property.floatValue().floatValue());
                continue;
            }
            if (property.Name.equals("BorderColor")) {
                this.borderColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("Brush")) {
                this.brush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (property.Name.equals("Lighting")) {
                this.lighting = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Diameter")) {
                this.setDiameter(property.floatValue().floatValue());
                continue;
            }
            if (property.Name.equals("Distance")) {
                this.setDistance(property.floatValue().floatValue());
                continue;
            }
            if (property.Name.equals("CutPieList")) {
                this.cutPieList.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (!property.Name.equals("GetCutPieListEvent")) continue;
            this.getCutPieListEvent.LoadFromJsonObject((JSONObject)property.Value);
        }
    }
}

