/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.view.series.funnel;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.chart.core.series.funnel.StiFunnelSeriesCoreXF;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.funnel.IStiFunnelSeries;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLine;
import com.stimulsoft.report.chart.view.areas.funnel.StiFunnelArea;
import com.stimulsoft.report.chart.view.series.StiSeries;

public class StiFunnelSeries
extends StiSeries
implements IStiFunnelSeries {
    private boolean showZeros = false;
    private boolean allowApplyBrush = true;
    private boolean allowApplyBorderColor = true;
    private StiBrush brush = new StiSolidBrush(StiColor.Gainsboro);
    private StiColor borderColor = StiColor.Gray;

    @Override
    public IStiFunnelSeries clone() {
        IStiSeries tempVar = super.clone();
        IStiFunnelSeries series = (IStiFunnelSeries)(tempVar instanceof IStiFunnelSeries ? tempVar : null);
        return series;
    }

    @Override
    public Class GetDefaultAreaType() {
        return StiFunnelArea.class;
    }

    @Override
    @StiSerializable(need=false)
    public IStiTrendLine getTrendLine() {
        return super.getTrendLine();
    }

    @Override
    public void setTrendLine(IStiTrendLine value) {
        super.setTrendLine(value);
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getShowZeros() {
        return this.showZeros;
    }

    @Override
    public void setShowZeros(boolean value) {
        this.showZeros = value;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getAllowApplyBrush() {
        return this.allowApplyBrush;
    }

    @Override
    public final void setAllowApplyBrush(boolean value) {
        if (this.allowApplyBrush != value) {
            this.allowApplyBrush = value;
        }
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getAllowApplyBorderColor() {
        return this.allowApplyBorderColor;
    }

    @Override
    public final void setAllowApplyBorderColor(boolean value) {
        if (this.allowApplyBorderColor != value) {
            this.allowApplyBorderColor = value;
        }
    }

    @Override
    @StiSerializable
    public final StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public final void setBrush(StiBrush value) {
        this.brush = value;
    }

    @Override
    @StiSerializable
    public final StiColor getBorderColor() {
        return this.borderColor;
    }

    @Override
    public final void setBorderColor(StiColor value) {
        this.borderColor = value;
    }

    public StiFunnelSeries() {
        this.setCore(new StiFunnelSeriesCoreXF(this));
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("TrendLine");
        jObject.AddPropertyBool("ShowZeros", this.getShowZeros());
        jObject.AddPropertyBool("AllowApplyBrush", this.allowApplyBrush, true);
        jObject.AddPropertyBool("AllowApplyBorderColor", this.allowApplyBorderColor, true);
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.brush));
        jObject.AddPropertyStringNullOfEmpty("BorderColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.borderColor, (StiColorEnum)StiColorEnum.Gray));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("ShowZeros")) {
                this.setShowZeros((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("AllowApplyBrush")) {
                this.allowApplyBrush = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("AllowApplyBorderColor")) {
                this.allowApplyBorderColor = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Brush")) {
                this.brush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (!property.Name.equals("BorderColor")) continue;
            this.borderColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
        }
    }
}

