/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.seriesLabels.axis;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.drawing.enums.StiStringAlignment;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;

public class StiOutsideAxisLabelsGeom
extends StiSeriesLabelsGeom {
    private final StiColor labelColor;
    private final StiColor labelBorderColor;
    private final StiBrush seriesBrush;
    private final StiColor seriesBorderColor;
    private final StiFontGeom font;
    private final String text;
    private final StiPoint startPoint;
    private final StiPoint endPoint;

    public final StiColor getLabelColor() {
        return this.labelColor;
    }

    public final StiColor getLabelBorderColor() {
        return this.labelBorderColor;
    }

    public final StiBrush getSeriesBrush() {
        return this.seriesBrush;
    }

    public final StiColor getSeriesBorderColor() {
        return this.seriesBorderColor;
    }

    public final StiFontGeom getFont() {
        return this.font;
    }

    public final String getText() {
        return this.text;
    }

    public final StiPoint getStartPoint() {
        return this.startPoint;
    }

    public final StiPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle labelRect = StiRectangle.round((StiRectangle)this.getClientRectangle());
        StiSolidBrush labelBrush = new StiSolidBrush(this.getLabelColor());
        StiPenGeom borderPen = new StiPenGeom((Object)this.getLabelBorderColor());
        StiStringFormatGeom sf = context.GetDefaultStringFormat();
        this.DrawMarker(context, labelRect, this.getSeriesBorderColor(), this.getSeriesBrush());
        if (this.getSeriesLabels().getDrawBorder()) {
            context.DrawLine(borderPen, this.endPoint.x, this.endPoint.y, this.startPoint.x, this.startPoint.y);
        }
        context.PushTranslateTransform(labelRect.x + labelRect.width / 2.0, labelRect.y + labelRect.height / 2.0);
        context.PushRotateTransform(this.getSeriesLabels().getAngle());
        StiRectangle rect = labelRect.clone();
        rect.x = -rect.width / 2.0;
        rect.y = -rect.height / 2.0;
        context.FillRectangle((Object)this.getSeriesLabels().getBrush(), rect, null);
        if (this.getSeriesLabels().getDrawBorder()) {
            context.DrawRectangle(borderPen, rect.x, rect.y, rect.width, rect.height);
        }
        sf.setAlignment(StiStringAlignment.Center);
        sf.setLineAlignment(StiStringAlignment.Center);
        context.PopTransform();
        context.PopTransform();
        context.DrawRotatedString(this.getText(), this.font, (Object)labelBrush, labelRect, sf, StiRotationMode.CenterCenter, (double)this.getSeriesLabels().getAngle(), this.getSeriesLabels().getAntialiasing());
        if (this.getIsMouseOver()) {
            context.FillRectangle((Object)StiMouseOverHelper.GetLineMouseOverColor(), labelRect, null);
        }
    }

    public StiOutsideAxisLabelsGeom(IStiSeriesLabels seriesLabels, IStiSeries series, int index, double value, StiRectangle clientRectangle, String text, StiColor labelColor, StiColor labelBorderColor, StiBrush seriesBrush, StiColor seriesBorderColor, StiFontGeom font, StiPoint startPoint, StiPoint endPoint) {
        super(seriesLabels, series, index, value, clientRectangle);
        this.text = text;
        this.labelColor = labelColor;
        this.labelBorderColor = labelBorderColor;
        this.seriesBrush = seriesBrush;
        this.seriesBorderColor = seriesBorderColor;
        this.font = font;
        this.startPoint = startPoint.clone();
        this.endPoint = endPoint.clone();
    }
}

