/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.stackedColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiPointHelper;
import com.stimulsoft.report.chart.geoms.StiNullableDrawing;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiBaseLineSeriesGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.stackedColumn.IStiStackedSplineSeries;

public class StiStackedSplineSeriesGeom
extends StiBaseLineSeriesGeom {
    @Override
    public boolean Contains(double x, double y) {
        if (this.getInvisible()) {
            return false;
        }
        for (int pointIndex = 0; pointIndex < this.getPoints().length - 1; ++pointIndex) {
            boolean result;
            StiPoint point1 = this.getPoints()[pointIndex];
            StiPoint point2 = this.getPoints()[pointIndex + 1];
            if (point1 == null || point2 == null || !(result = StiPointHelper.IsLineContainsPoint(point1.getValue(), point2.getValue(), StiMouseOverHelper.MouseOverSplineDistance, new StiPoint(x, y)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void Draw(StiContext context) {
        if (this.getPoints().length == 0) {
            return;
        }
        StiChart chart = (StiChart)this.getSeries().getChart();
        IStiSeries tempVar = this.getSeries();
        IStiStackedSplineSeries lineSeries = (IStiStackedSplineSeries)(tempVar instanceof IStiStackedSplineSeries ? tempVar : null);
        context.PushSmoothingModeToAntiAlias();
        StiPenStyle dashStyle = lineSeries.getLineStyle();
        float scaledLineWidth = lineSeries.getLineWidth();
        StiPenGeom pen = new StiPenGeom((Object)lineSeries.getLineColor(), (double)scaledLineWidth);
        pen.setPenStyle(dashStyle);
        if (this.getPoints() != null && this.getPoints().length > 1) {
            if (lineSeries.getShowShadow()) {
                StiPenGeom penShadow = new StiPenGeom((Object)StiColor.fromArgb((int)50, (int)0, (int)0, (int)0), (double)scaledLineWidth + 0.5 * context.Options.zoom);
                penShadow.setPenStyle(dashStyle);
                context.PushTranslateTransform((double)scaledLineWidth, (double)scaledLineWidth);
                StiNullableDrawing.DrawCurve(context, penShadow, this.getPoints(), lineSeries.getTension(), chart.isAnimation);
                context.PopTransform();
            }
            StiNullableDrawing.DrawCurve(context, pen, this.getPoints(), lineSeries.getTension(), chart.isAnimation);
            if (scaledLineWidth >= 2.0f && lineSeries.getLighting()) {
                double step = 0.5 * context.Options.zoom;
                context.PushTranslateTransform(-step, -step);
                StiPenGeom penLight = new StiPenGeom((Object)StiColorUtils.light((StiColor)lineSeries.getLineColor(), (int)70), (double)scaledLineWidth);
                penLight.setPenStyle(dashStyle);
                StiNullableDrawing.DrawCurve(context, penLight, this.getPoints(), lineSeries.getTension(), chart.isAnimation);
                context.PopTransform();
            }
            if (lineSeries != null && lineSeries.getAllowApplyColorNegative()) {
                StiPenGeom penNegative = new StiPenGeom((Object)lineSeries.getLineColorNegative(), (double)scaledLineWidth);
                penNegative.setPenStyle(dashStyle);
                IStiArea tempVar2 = this.getSeries().getChart().getArea();
                IStiAxisArea axisArea = (IStiAxisArea)(tempVar2 instanceof IStiAxisArea ? tempVar2 : null);
                double posY = axisArea.getAxisCore().GetDividerY();
                double width = axisArea.getAxisCore().getScrollRangeX() * axisArea.getAxisCore().getScrollDpiX();
                double height = axisArea.getAxisCore().getScrollRangeY() * axisArea.getAxisCore().getScrollDpiY() - posY;
                StiRectangle clipRect = new StiRectangle(0.0, posY, width, height);
                context.PushClip(clipRect);
                StiNullableDrawing.DrawCurve(context, penNegative, this.getPoints(), lineSeries.getTension(), chart.isAnimation);
                if (scaledLineWidth >= 2.0f && lineSeries.getLighting()) {
                    double step = 0.5 * context.Options.zoom;
                    context.PushTranslateTransform(-step, -step);
                    StiPenGeom penLight = new StiPenGeom((Object)StiColorUtils.light((StiColor)lineSeries.getLineColorNegative(), (int)70), (double)scaledLineWidth);
                    penLight.setPenStyle(dashStyle);
                    StiNullableDrawing.DrawCurve(context, penLight, this.getPoints(), lineSeries.getTension(), chart.isAnimation);
                    context.PopTransform();
                }
                context.PopClip();
            }
        }
        context.PopSmoothingMode();
    }

    public StiStackedSplineSeriesGeom(StiAreaGeom areaGeom, StiPoint[] pointsStart, StiPoint[] points, IStiSeries series) {
        super(areaGeom, pointsStart, points, series);
    }
}

