/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.stackedBar;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.StiSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;

public class StiStackedBarSeriesElementGeom
extends StiSeriesElementGeom {
    private StiBrush seriesBrush;
    private StiColor seriesBorderColor;
    private Integer beginTime;

    public final StiBrush getSeriesBrush() {
        return this.seriesBrush;
    }

    public final StiColor getSeriesBorderColor() {
        return this.seriesBorderColor;
    }

    public Integer getBeginTime() {
        return this.beginTime;
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = this.getClientRectangle();
        StiRectangle rectColumn = this.getClientRectangle();
        StiPenGeom pen = new StiPenGeom((Object)this.getSeriesBorderColor(), 1.0);
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (chart.isAnimation) {
            Double valueStart = this.getSeries().getValuesStart().length > this.getIndex() ? this.getSeries().getValuesStart()[this.getIndex()] : 0.0;
            if (this.getSeries().getShowShadow()) {
                StiOpacityAnimation animationOpacityShadow = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, Integer.valueOf(this.beginTime + StiChartHelper.GlobalDurationElement));
                context.DrawShadowRect(rectColumn, 5, (StiAnimation)animationOpacityShadow);
            }
            StiOpacityAnimation animationOpacity = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, this.beginTime);
            context.DrawAnimationBar((Object)this.seriesBrush, pen, (Object)rectColumn, Double.valueOf(this.getValue()), this.GetToolTip(), (Object)this, (StiAnimation)animationOpacity, this.getInteractionData());
        } else {
            this.getSeries().getChart().getStyle().getCore().FillColumn(context, rect, this.seriesBrush, this.getInteractionData());
            StiPoint[] points = null;
            if (this.getIsMouseOver() || this.getSeries().getCore().getIsMouseOver()) {
                context.FillRectangle((Object)StiMouseOverHelper.GetMouseOverColor(), rect.x, rect.y, rect.width, rect.height, null);
            }
            points = this.getValue() > 0.0 ? new StiPoint[]{new StiPoint(rect.getRight(), rect.y), new StiPoint(rect.x, rect.y), new StiPoint(rect.x, rect.getBottom()), new StiPoint(rect.getRight(), rect.getBottom())} : new StiPoint[]{new StiPoint(rect.x, rect.y), new StiPoint(rect.getRight(), rect.y), new StiPoint(rect.getRight(), rect.getBottom()), new StiPoint(rect.x, rect.getBottom())};
            context.DrawLines(pen, points);
        }
    }

    public StiStackedBarSeriesElementGeom(StiAreaGeom areaGeom, double value, int index, StiBrush seriesBrush, StiColor seriesBorderColor, IStiSeries series, StiRectangle clientRectangle, Integer beginTime) {
        super(areaGeom, value, index, series, clientRectangle);
        this.seriesBrush = seriesBrush;
        this.seriesBorderColor = seriesBorderColor;
        this.beginTime = beginTime;
    }
}

