/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.scatter;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.enums.StiPenLineCap;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiPointHelper;
import com.stimulsoft.report.chart.geoms.StiNullableDrawing;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiBaseLineSeriesGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.scatter.IStiScatterSplineSeries;

public class StiScatterSplineSeriesGeom
extends StiBaseLineSeriesGeom {
    @Override
    public boolean Contains(double x, double y) {
        if (this.getInvisible()) {
            return false;
        }
        for (int pointIndex = 0; pointIndex < this.getPoints().length - 1; ++pointIndex) {
            boolean result;
            StiPoint point1 = this.getPoints()[pointIndex];
            StiPoint point2 = this.getPoints()[pointIndex + 1];
            if (point1 == null || point2 == null || !(result = StiPointHelper.IsLineContainsPoint(point1.getValue(), point2.getValue(), StiMouseOverHelper.MouseOverLineDistance, new StiPoint(x, y)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = this.getClientRectangle();
        IStiSeries tempVar = this.getSeries();
        IStiScatterSplineSeries splineSeries = (IStiScatterSplineSeries)(tempVar instanceof IStiScatterSplineSeries ? tempVar : null);
        context.PushSmoothingModeToAntiAlias();
        StiPenStyle dashStyle = splineSeries.getLineStyle();
        double scaledLineWidth = (double)splineSeries.getLineWidth() * context.Options.zoom;
        StiPenGeom pen = new StiPenGeom((Object)splineSeries.getLineColor(), (double)splineSeries.getLineWidth());
        pen.setPenStyle(dashStyle);
        if (splineSeries.getShowShadow()) {
            StiPenGeom penShadow = new StiPenGeom((Object)StiColor.fromArgb((int)50, (int)0, (int)0, (int)0), scaledLineWidth + 0.5 * context.Options.zoom);
            penShadow.setPenStyle(dashStyle);
            context.PushTranslateTransform(scaledLineWidth, scaledLineWidth);
            StiNullableDrawing.DrawCurve(context, penShadow, this.getPoints(), splineSeries.getTension());
            context.PopTransform();
        }
        if (this.getSeries().getCore().getIsMouseOver()) {
            float lineWidth = splineSeries.getLineWidth();
            double zoom = context.Options.zoom;
            float pointSize = 11.0f + lineWidth;
            for (StiPoint point : this.getPoints()) {
                if (point == null) continue;
                StiRectangle pointRect = new StiRectangle(point.getValue().x - (double)(pointSize / 2.0f) * zoom, point.getValue().y - (double)(pointSize / 2.0f) * zoom, (double)pointSize * zoom, (double)pointSize * zoom);
                context.FillEllipse((Object)StiMouseOverHelper.GetLineMouseOverColor(), pointRect, null);
            }
            StiPenGeom penMouseOver = new StiPenGeom((Object)StiMouseOverHelper.GetLineMouseOverColor(), (double)(4.0f + lineWidth) * context.Options.zoom);
            penMouseOver.setStartCap(StiPenLineCap.Round);
            penMouseOver.setEndCap(StiPenLineCap.Round);
            StiNullableDrawing.DrawCurve(context, penMouseOver, this.getPoints(), splineSeries.getTension());
        }
        StiNullableDrawing.DrawCurve(context, pen, this.getPoints(), splineSeries.getTension());
        if (scaledLineWidth >= 2.0 && splineSeries.getLighting()) {
            double step = 0.5 * context.Options.zoom;
            context.PushTranslateTransform(-step, -step);
            StiPenGeom penLight = new StiPenGeom((Object)StiColorUtils.light((StiColor)splineSeries.getLineColor(), (int)70), 1.0);
            penLight.setPenStyle(dashStyle);
            StiNullableDrawing.DrawCurve(context, penLight, this.getPoints(), splineSeries.getTension());
            context.PopTransform();
        }
        context.PopSmoothingMode();
    }

    public StiScatterSplineSeriesGeom(StiAreaGeom areaGeom, StiPoint[] pointsStart, StiPoint[] points, IStiSeries series) {
        super(areaGeom, pointsStart, points, series);
    }
}

