/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.funnel;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.StiSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.enums.StiPenAlignment;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.StiSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import java.util.ArrayList;

public class StiFunnelSeriesElementGeom
extends StiSeriesElementGeom {
    private final ArrayList<StiSegmentGeom> path;
    private final StiColor borderColor;
    private final StiBrush brush;
    private Integer beginTime;

    public final ArrayList<StiSegmentGeom> getPath() {
        return this.path;
    }

    public final StiColor getBorderColor() {
        return this.borderColor;
    }

    public final StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rectPie = this.getClientRectangle();
        StiRectangle rect = this.getClientRectangle();
        StiPenGeom pen = new StiPenGeom((Object)StiColorUtils.dark((StiColor)this.borderColor, (int)10));
        pen.setAlignment(StiPenAlignment.Inset);
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (chart.isAnimation) {
            StiOpacityAnimation animationOpacity = new StiOpacityAnimation(Integer.valueOf(1000), this.beginTime);
            context.DrawAnimationPathElement((Object)this.getBrush(), pen, this.path, (Object)rect, this.GetToolTip(), (Object)this, (StiAnimation)animationOpacity, this.getInteractionData());
        } else {
            context.PushSmoothingModeToAntiAlias();
            if (this.getSeries().getShowShadow()) {
                context.PushTranslateTransform(4.0, 4.0);
                context.FillPath((Object)StiColor.fromArgb((int)50, (int)100, (int)100, (int)100), this.getPath(), (Object)rectPie, null);
                context.PopTransform();
            }
            context.FillPath((Object)this.getBrush(), this.getPath(), (Object)rectPie, this.getInteractionData());
            if (this.getIsMouseOver() || this.getSeries().getCore().getIsMouseOver()) {
                context.FillPath((Object)StiMouseOverHelper.GetMouseOverColor(), this.getPath(), (Object)rectPie, null);
            }
            if (!StiColor.Transparent.equals(this.getBorderColor())) {
                context.DrawPath(pen, this.path, null);
            }
            context.PopSmoothingMode();
        }
    }

    public StiFunnelSeriesElementGeom(StiAreaGeom areaGeom, double value, int index, IStiSeries series, StiRectangle clientRectangle, StiBrush brush, StiColor borderColor, ArrayList<StiSegmentGeom> path, Integer beginTime) {
        super(areaGeom, value, index, series, clientRectangle);
        this.path = path;
        this.borderColor = borderColor;
        this.brush = brush;
        this.beginTime = beginTime;
    }
}

