/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.clusteredColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.enums.StiPenLineCap;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiPointHelper;
import com.stimulsoft.report.chart.geoms.StiNullableDrawing;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiBaseLineSeriesGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.marker.IStiLineMarker;
import com.stimulsoft.report.chart.interfaces.marker.IStiMarker;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiBaseLineSeries;
import com.stimulsoft.report.chart.interfaces.series.radar.IStiRadarAreaSeries;
import com.stimulsoft.report.chart.interfaces.series.radar.IStiRadarLineSeries;
import com.stimulsoft.report.chart.view.series.clusteredColumn.StiLineSeries;
import java.util.ArrayList;

public class StiLineSeriesGeom
extends StiBaseLineSeriesGeom {
    @Override
    public boolean Contains(double x, double y) {
        if (this.getInvisible()) {
            return false;
        }
        for (int pointIndex = 0; pointIndex < this.getPoints().length - 1; ++pointIndex) {
            boolean result;
            StiPoint point1 = this.getPoints()[pointIndex];
            StiPoint point2 = this.getPoints()[pointIndex + 1];
            if (point1 == null || point2 == null || !(result = StiPointHelper.IsLineContainsPoint(point1.getValue(), point2.getValue(), StiMouseOverHelper.MouseOverLineDistance, new StiPoint(x, y)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void Draw(StiContext context) {
        IStiSeries tempVar3;
        IStiRadarAreaSeries radarAreaSeries;
        IStiSeries tempVar2;
        IStiRadarLineSeries radarLineSeries;
        StiRectangle rect = this.getClientRectangle();
        StiPenStyle coreLineStyle = StiPenStyle.Solid;
        float lineWidth = 1.0f;
        StiColor coreLineColor = StiColor.Black;
        boolean showShadow = true;
        IStiLineMarker lineMarker = null;
        IStiMarker marker = null;
        boolean lighting = true;
        IStiSeries tempVar = this.getSeries();
        IStiBaseLineSeries lineSeries = (IStiBaseLineSeries)(tempVar instanceof IStiBaseLineSeries ? tempVar : null);
        if (lineSeries != null) {
            coreLineStyle = lineSeries.getLineStyle();
            lineWidth = lineSeries.getLineWidth();
            coreLineColor = lineSeries.getLineColor();
            showShadow = lineSeries.getShowShadow();
            lineMarker = lineSeries.getLineMarker();
            marker = lineSeries.getMarker();
            lighting = lineSeries.getLighting();
        }
        if ((radarLineSeries = (IStiRadarLineSeries)((tempVar2 = this.getSeries()) instanceof IStiRadarLineSeries ? tempVar2 : null)) != null) {
            coreLineStyle = radarLineSeries.getLineStyle();
            lineWidth = radarLineSeries.getLineWidth();
            coreLineColor = radarLineSeries.getLineColor();
            showShadow = radarLineSeries.getShowShadow();
            marker = radarLineSeries.getMarker();
            lighting = radarLineSeries.getLighting();
        }
        if ((radarAreaSeries = (IStiRadarAreaSeries)((tempVar3 = this.getSeries()) instanceof IStiRadarAreaSeries ? tempVar3 : null)) != null) {
            coreLineStyle = radarAreaSeries.getLineStyle();
            lineWidth = radarAreaSeries.getLineWidth();
            coreLineColor = radarAreaSeries.getLineColor();
            showShadow = radarAreaSeries.getShowShadow();
            marker = radarAreaSeries.getMarker();
            lighting = radarAreaSeries.getLighting();
        }
        context.PushSmoothingModeToAntiAlias();
        StiPenStyle dashStyle = coreLineStyle;
        float scaledLineWidth = lineWidth;
        StiPenGeom pen = new StiPenGeom((Object)coreLineColor, (double)scaledLineWidth);
        pen.setPenStyle(dashStyle);
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (showShadow) {
            StiPenGeom penShadow = new StiPenGeom((Object)StiColor.fromArgb((int)50, (int)0, (int)0, (int)0), (double)(scaledLineWidth + 0.5f));
            penShadow.setPenStyle(dashStyle);
            context.PushTranslateTransform((double)scaledLineWidth, (double)scaledLineWidth);
            StiNullableDrawing.DrawLines(context, penShadow, this.getPointsFrom(), this.getPoints(), chart.isAnimation);
            if (lineMarker != null && lineMarker.getVisible()) {
                StiSolidBrush brushShadow = new StiSolidBrush(StiColor.fromArgb((int)50, (int)0, (int)0, (int)0));
                lineMarker.getCore().DrawLines(context, this.getPoints(), context.Options.zoom, brushShadow, null, lineMarker.getType(), (float)lineMarker.getStep(), lineMarker.getSize(), lineMarker.getAngle());
            }
            context.PopTransform();
        }
        if (this.getSeries().getCore().getIsMouseOver()) {
            double zoom = context.Options.zoom;
            double pointSize = 11.0f + lineWidth;
            for (StiPoint point : this.getPoints()) {
                if (point == null) continue;
                StiRectangle pointRect = new StiRectangle(point.getValue().x - pointSize / 2.0 * zoom, point.getValue().y - pointSize / 2.0 * zoom, pointSize * zoom, pointSize * zoom);
                context.FillEllipse((Object)StiMouseOverHelper.GetLineMouseOverColor(), pointRect, null);
            }
            StiPenGeom penMouseOver = new StiPenGeom((Object)StiMouseOverHelper.GetLineMouseOverColor(), (double)(4.0f + lineWidth) * context.Options.zoom);
            penMouseOver.setStartCap(StiPenLineCap.Round);
            penMouseOver.setEndCap(StiPenLineCap.Round);
            StiNullableDrawing.DrawLines(context, penMouseOver, this.getPointsFrom(), this.getPoints(), chart.isAnimation);
        }
        if (this.getSeries() instanceof StiLineSeries && ((StiLineSeries)this.getSeries()).getAllowApplyColorNegative()) {
            StiColor coreLineColorNegative = ((StiLineSeries)this.getSeries()).getLineColorNegative();
            StiPenGeom penNegative = new StiPenGeom((Object)coreLineColorNegative, (double)scaledLineWidth);
            penNegative.setPenStyle(dashStyle);
            IStiArea tempVar4 = this.getSeries().getChart().getArea();
            IStiAxisArea axisArea = (IStiAxisArea)(tempVar4 instanceof IStiAxisArea ? tempVar4 : null);
            double posY = axisArea.getAxisCore().GetDividerY();
            ArrayList<StiPoint> pointsNegative = new ArrayList<StiPoint>();
            ArrayList<StiPoint> pointsPositive = new ArrayList<StiPoint>();
            for (int index = 0; index < this.getPoints().length; ++index) {
                StiPenGeom penLight;
                StiPoint point0;
                StiPoint pointNext;
                StiPoint point = this.getPoints()[index];
                StiPoint stiPoint = pointNext = index != this.getPoints().length - 1 ? this.getPoints()[index + 1] : null;
                if (point.getValue().y > posY) {
                    pointsNegative.add(point);
                    if (pointNext != null && !(pointNext.getValue().y < posY) && (pointNext.getValue().y != posY || index + 2 >= this.getPoints().length || !(this.getPoints()[index + 2].getValue().y <= posY))) continue;
                    if (pointNext != null) {
                        point0 = this.GetPointCross(point, this.getPoints()[index + 1], posY);
                        pointsNegative.add(point0);
                        if (pointNext.getValue().y == posY && index + 2 < this.getPoints().length && this.getPoints()[index + 2].getValue().y <= posY) {
                            pointsNegative.add(this.getPoints()[index + 2]);
                        }
                        pointsPositive.add(point0);
                    }
                    this.DrawLine(context, penNegative, pointsNegative);
                    if ((double)scaledLineWidth >= 2.0 * context.Options.zoom && lighting) {
                        double step = 0.5 * context.Options.zoom;
                        context.PushTranslateTransform(-step, -step);
                        penLight = new StiPenGeom((Object)StiColorUtils.light((StiColor)coreLineColorNegative, (int)70), (double)scaledLineWidth);
                        penLight.setPenStyle(dashStyle);
                        this.DrawLine(context, penLight, pointsNegative);
                        context.PopTransform();
                    }
                    pointsNegative.clear();
                    continue;
                }
                pointsPositive.add(point);
                if (pointNext != null && !(pointNext.getValue().y > posY)) continue;
                if (pointNext != null) {
                    point0 = this.GetPointCross(point, this.getPoints()[index + 1], posY);
                    pointsNegative.add(point0);
                    pointsPositive.add(point0);
                    pointsPositive.add(pointNext);
                }
                this.DrawLine(context, pen, pointsPositive);
                if ((double)scaledLineWidth >= 2.0 * context.Options.zoom && lighting) {
                    double step = 0.5 * context.Options.zoom;
                    context.PushTranslateTransform(-step, -step);
                    penLight = new StiPenGeom((Object)StiColorUtils.light((StiColor)coreLineColor, (int)70), (double)scaledLineWidth);
                    penLight.setPenStyle(dashStyle);
                    this.DrawLine(context, penLight, pointsPositive);
                    context.PopTransform();
                }
                pointsPositive.clear();
            }
        } else {
            StiNullableDrawing.DrawLines(context, pen, this.getPointsFrom(), this.getPoints(), chart.isAnimation);
            if ((double)scaledLineWidth >= 2.0 * context.Options.zoom && lighting) {
                double step = 0.5 * context.Options.zoom;
                context.PushTranslateTransform(-step, -step);
                StiPenGeom penLight = new StiPenGeom((Object)StiColorUtils.light((StiColor)coreLineColor, (int)70), (double)scaledLineWidth);
                penLight.setPenStyle(dashStyle);
                StiNullableDrawing.DrawLines(context, penLight, this.getPointsFrom(), this.getPoints(), chart.isAnimation);
                context.PopTransform();
            }
        }
        if (lineMarker != null && lineMarker.getVisible()) {
            StiPenGeom borderPen = new StiPenGeom((Object)lineMarker.getBorderColor());
            lineMarker.getCore().DrawLines(context, this.getPoints(), context.Options.zoom, lineMarker.getBrush(), borderPen, lineMarker.getType(), (float)lineMarker.getStep(), lineMarker.getSize(), lineMarker.getAngle());
        }
        context.PopSmoothingMode();
    }

    private StiPoint GetPointCross(StiPoint point1, StiPoint point2, double posY) {
        double y1 = point1.y;
        double x1 = point1.x;
        double y2 = point2.y;
        double x2 = point2.x;
        double x0 = Math.tan(Math.atan((x2 - x1) / (y1 - y2))) * (y1 - posY) + x1;
        return new StiPoint((double)((float)x0), posY);
    }

    private void DrawLine(StiContext context, StiPenGeom pen, ArrayList<StiPoint> listPoints) {
        StiPoint[] points = new StiPoint[listPoints.size()];
        points = listPoints.toArray(new StiPoint[listPoints.size()]);
        StiChart chart = (StiChart)this.getSeries().getChart();
        StiNullableDrawing.DrawLines(context, pen, null, points, chart.isAnimation);
    }

    public StiLineSeriesGeom(StiAreaGeom areaGeom, StiPoint[] pointsFrom, StiPoint[] points, IStiSeries series) {
        super(areaGeom, pointsFrom, points, series);
    }
}

