/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.clusteredColumn;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.enums.StiShadowSides;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.StiSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;

public class StiClusteredColumnSeriesElementGeom
extends StiSeriesElementGeom {
    private final StiBrush seriesBrush;
    private final StiColor seriesBorderColor;
    private StiAnimation animation;

    public final StiBrush getSeriesBrush() {
        return this.seriesBrush;
    }

    public final StiColor getSeriesBorderColor() {
        return this.seriesBorderColor;
    }

    public StiAnimation getAnimation() {
        return this.animation;
    }

    @Override
    public void Draw(StiContext context) {
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (chart.isAnimation) {
            StiRectangle columnRect = this.getClientRectangle();
            StiPenGeom pen = new StiPenGeom((Object)this.getSeriesBorderColor(), 1.0);
            if (this.getSeries().getShowShadow() && columnRect.getWidth() > 1.0) {
                StiOpacityAnimation animationOpacity = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, Integer.valueOf(this.animation.getBeginTime() + this.animation.getDuration()));
                context.DrawShadowRect(columnRect, 5, (StiAnimation)animationOpacity);
            }
            context.DrawAnimationColumn((Object)this.seriesBrush, pen, (Object)columnRect, Double.valueOf(this.getValue()), this.GetToolTip(), (Object)this, this.animation, this.getInteractionData());
        } else {
            StiRectangle rect = this.getClientRectangle();
            if (this.getSeries().getShowShadow() && rect.width > 4.0 && rect.height > 4.0) {
                StiEnumSet shadows = new StiEnumSet((Enum)StiShadowSides.Right);
                if (this.getValue() > 0.0) {
                    shadows.add((IStiEnum)StiShadowSides.Top);
                    context.drawCachedShadow(rect, shadows, context.Options.isPrinting);
                } else if (this.getValue() < 0.0) {
                    shadows.add((IStiEnum)StiShadowSides.Edge);
                    shadows.add((IStiEnum)StiShadowSides.Bottom);
                    shadows.add((IStiEnum)StiShadowSides.Left);
                    context.drawCachedShadow(new StiRectangle(rect.x, rect.y - 8.0, rect.width, rect.height + 8.0), shadows, context.Options.isPrinting);
                }
            }
            StiPenGeom pen = new StiPenGeom((Object)this.getSeriesBorderColor(), 1.0);
            this.getSeries().getChart().getStyle().getCore().FillColumn(context, rect, this.seriesBrush, this.getInteractionData());
            if (this.getIsMouseOver() || this.getSeries().getCore().getIsMouseOver()) {
                context.FillRectangle((Object)StiMouseOverHelper.GetMouseOverColor(), rect.x, rect.y, rect.width, rect.height, null);
            }
            StiPoint[] points = null;
            points = this.getValue() > 0.0 ? new StiPoint[]{new StiPoint(rect.x, rect.getBottom()), new StiPoint(rect.x, rect.y), new StiPoint(rect.getRight(), rect.y), new StiPoint(rect.getRight(), rect.getBottom())} : new StiPoint[]{new StiPoint(rect.x, rect.y), new StiPoint(rect.x, rect.getBottom()), new StiPoint(rect.getRight(), rect.getBottom()), new StiPoint(rect.getRight(), rect.y)};
            context.DrawLines(pen, points);
        }
    }

    public StiClusteredColumnSeriesElementGeom(StiAreaGeom areaGeom, double value, int index, StiBrush seriesBrush, StiColor seriesBorderColor, IStiSeries series, StiRectangle clientRectangle, StiAnimation animation) {
        super(areaGeom, value, index, series, clientRectangle);
        this.seriesBrush = seriesBrush;
        this.seriesBorderColor = seriesBorderColor;
        this.animation = animation;
    }
}

