/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiInteractionDataGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiInteractionOptions;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.interfaces.IStiSeriesElement;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredBar.IStiClusteredBarSeries;
import com.stimulsoft.report.chart.interfaces.series.fullStackedBar.IStiFullStackedBarSeries;
import com.stimulsoft.report.chart.interfaces.series.stackedBar.IStiStackedBarSeries;
import com.stimulsoft.report.chart.view.series.StiSeries;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;

public class StiSeriesElementGeom
extends StiCellGeom
implements IStiSeriesElement {
    private final double value;
    private final int index;
    private final IStiSeries series;
    private StiSeriesInteractionData interaction;
    private StiAreaGeom areaGeom;
    private String elementIndex;

    @Override
    public void InvokeMouseEnter(StiInteractionOptions options) {
        if (!this.getAllowMouseOver()) {
            return;
        }
        if (!this.getIsMouseOver()) {
            this.setIsMouseOver(true);
            options.setUpdateContext(this.series.getInteraction().getDrillDownEnabled());
        }
        int valueIndex = this.GetValueIndex();
        options.setInteractionToolTip(this.GetToolTip(valueIndex));
        options.setInteractionHyperlink(this.GetHyperlink(valueIndex));
    }

    @Override
    public void InvokeMouseLeave(StiInteractionOptions options) {
        if (!this.getAllowMouseOver()) {
            return;
        }
        if (this.getIsMouseOver()) {
            this.setIsMouseOver(false);
            options.setUpdateContext(this.series.getInteraction().getDrillDownEnabled());
        }
    }

    @Override
    public void InvokeClick(StiInteractionOptions options) {
        int valueIndex = this.GetValueIndex();
        if (this.getSeries().getHyperlinks() != null && valueIndex < this.getSeries().getHyperlinks().length) {
            options.setInteractionHyperlink(this.series.getHyperlinks()[valueIndex]);
        }
        if (this.getSeries().getInteraction().getDrillDownEnabled()) {
            options.setSeriesInteractionData(this.getInteraction());
            this.setIsMouseOver(false);
            options.setUpdateContext(this.series.getInteraction().getDrillDownEnabled());
        }
    }

    private int GetValueIndex() {
        int valueIndex = this.getIndex();
        if (this.getSeries() instanceof IStiClusteredBarSeries || this.getSeries() instanceof IStiStackedBarSeries || this.getSeries() instanceof IStiFullStackedBarSeries) {
            if (this.getSeries().getChart().getArea() instanceof IStiAxisArea && !((IStiAxisArea)this.series.getChart().getArea()).getReverseVert()) {
                valueIndex = this.getSeries().getValues().length - valueIndex - 1;
            }
        } else if (this.getSeries().getChart().getArea() instanceof IStiAxisArea && ((IStiAxisArea)this.series.getChart().getArea()).getReverseHor()) {
            valueIndex = this.getSeries().getValues().length - valueIndex - 1;
        }
        return valueIndex;
    }

    private String GetHyperlink(int valueIndex) {
        if (this.getSeries().getHyperlinks() != null && valueIndex < this.getSeries().getHyperlinks().length) {
            return this.series.getHyperlinks()[valueIndex];
        }
        return null;
    }

    public String GetToolTip() {
        Integer valueIndex = this.GetValueIndex();
        if (this.getSeries().getToolTips() != null && valueIndex < this.getSeries().getToolTips().length) {
            return this.series.getToolTips()[valueIndex];
        }
        return null;
    }

    private String GetToolTip(int valueIndex) {
        if (this.getSeries().getToolTips() != null && valueIndex < this.getSeries().getToolTips().length) {
            return this.series.getToolTips()[valueIndex];
        }
        return null;
    }

    public boolean getAllowMouseOver() {
        int index = this.GetValueIndex();
        return this.getSeries().getHyperlinks() != null && index < this.getSeries().getHyperlinks().length || this.getSeries().getToolTips() != null && index < this.getSeries().getToolTips().length || this.getSeries().getInteraction().getDrillDownEnabled() && this.getSeries().getInteraction().getAllowSeriesElements();
    }

    public boolean getIsMouseOver() {
        return this.getSeries().getCore().GetIsMouseOverSeriesElement(this.getIndex());
    }

    public void setIsMouseOver(boolean value) {
        this.getSeries().getCore().SetIsMouseOverSeriesElement(this.getIndex(), value);
    }

    public final double getValue() {
        return this.value;
    }

    public final int getIndex() {
        return this.index;
    }

    public final IStiSeries getSeries() {
        return this.series;
    }

    public final StiSeriesInteractionData getInteraction() {
        return this.interaction;
    }

    public final void setInteraction(StiSeriesInteractionData value) {
        this.interaction = value;
    }

    public final StiAreaGeom getAreaGeom() {
        return this.areaGeom;
    }

    public final void setAreaGeom(StiAreaGeom value) {
        this.areaGeom = value;
    }

    @Override
    public String getElementIndex() {
        return this.elementIndex;
    }

    @Override
    public void setElementIndex(String elementIndex) {
        this.elementIndex = elementIndex;
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = this.getClientRectangle();
        context.DrawRectangle(new StiPenGeom((Object)StiColor.Blue), rect.x, rect.y, rect.width, rect.height);
    }

    public StiInteractionDataGeom getInteractionData() {
        StiChart chart = (StiChart)this.getSeries().getChart();
        StiInteractionDataGeom interaction = new StiInteractionDataGeom(chart.getName(), String.valueOf(chart.getPage().getComponents().indexOf(chart)), ((StiSeries)this.getSeries()).getDrillDownPageGuid(), String.valueOf(chart.getPage().getReport().getRenderedPages().indexOf(chart.getPage())), String.valueOf(this.elementIndex));
        return interaction;
    }

    public StiSeriesElementGeom(StiAreaGeom areaGeom, double value, int index, IStiSeries series, StiRectangle clientRectangle) {
        super(clientRectangle);
        this.areaGeom = areaGeom;
        this.series = series;
        this.value = value;
        this.index = index;
    }
}

