/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.axis.scrollBars;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiInteractionOptions;
import com.stimulsoft.report.chart.core.area.StiAreaCoreXF;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.axis.scrollBars.StiVertScrollBarGeom;
import com.stimulsoft.report.chart.interfaces.axis.IStiXAxis;
import com.stimulsoft.report.chart.interfaces.axis.IStiYAxis;

public class StiVertTrackBarGeom
extends StiCellGeom {
    private final IStiYAxis axis;
    private final StiVertScrollBarGeom scrollBar;

    @Override
    public void InvokeMouseEnter(StiInteractionOptions options) {
        if (!this.getAxis().getInteraction().getRangeScrollEnabled()) {
            return;
        }
        if (!this.getAxis().getCore().getIsMouseOverTrackBar()) {
            this.getAxis().getCore().setIsMouseOverTrackBar(true);
            options.setUpdateContext(true);
        }
    }

    @Override
    public void InvokeMouseLeave(StiInteractionOptions options) {
        if (!this.getAxis().getInteraction().getRangeScrollEnabled()) {
            return;
        }
        if (this.getAxis().getCore().getIsMouseOverTrackBar()) {
            this.getAxis().getCore().setIsMouseOverTrackBar(false);
            options.setUpdateContext(true);
        }
    }

    @Override
    public void InvokeMouseDown(StiInteractionOptions options) {
        if (!this.getAxis().getInteraction().getRangeScrollEnabled()) {
            return;
        }
        StiAreaCoreXF tempVar = this.getAxis().getArea().getCore();
        StiAxisAreaCoreXF axisCore = (StiAxisAreaCoreXF)(tempVar instanceof StiAxisAreaCoreXF ? tempVar : null);
        options.setDragEnabled(true);
        axisCore.setScrollDragStartValue(axisCore.getScrollValueY());
    }

    @Override
    public void InvokeDrag(StiInteractionOptions options) {
        if (!this.getAxis().getInteraction().getRangeScrollEnabled()) {
            return;
        }
        StiAreaCoreXF tempVar = this.getAxis().getArea().getCore();
        StiAxisAreaCoreXF axisCore = (StiAxisAreaCoreXF)(tempVar instanceof StiAxisAreaCoreXF ? tempVar : null);
        axisCore.setBlockScrollValueY(true);
        double buttonSize = this.getScrollBar().getClientRectangle().height;
        double height = this.getScrollBar().getClientRectangle().height - buttonSize * 2.0;
        axisCore.setScrollValueY(-options.getDragDelta().height / height * axisCore.getScrollRangeY() + axisCore.getScrollDragStartValue());
        if (axisCore.getScrollValueY() < 0.0) {
            axisCore.setScrollValueY(0.0);
        }
        if (axisCore.getScrollValueY() >= axisCore.getScrollRangeY() - axisCore.getScrollViewY()) {
            axisCore.setScrollValueY(axisCore.getScrollRangeY() - axisCore.getScrollViewY());
        }
        options.setUpdateContext(true);
    }

    @Override
    public void Draw(StiContext context) {
        double zoom = context.Options.zoom;
        StiRectangle rect = this.getClientRectangle();
        StiPenGeom penLine = new StiPenGeom((Object)this.getAxis().getLineColor());
        StiPenGeom penWhite = new StiPenGeom((Object)StiColor.White);
        StiAreaCoreXF tempVar = this.getAxis().getArea().getCore();
        StiAxisAreaCoreXF axisCore = (StiAxisAreaCoreXF)(tempVar instanceof StiAxisAreaCoreXF ? tempVar : null);
        IStiXAxis rollAxis = this.getAxis().getArea().getXAxis();
        if (this.getAxis().getCore().getIsMouseOverTrackBar()) {
            context.FillRectangle((Object)StiColorUtils.light((StiColor)this.getAxis().getLineColor(), (int)50), rect.x, rect.y, rect.width, rect.height, null);
        } else {
            context.FillRectangle((Object)this.getAxis().getLineColor(), rect.x, rect.y, rect.width, rect.height, null);
        }
        context.DrawRectangle(penLine, rect.x, rect.y, rect.width, rect.height);
        if (rect.height > 10.0 && rect.width > 4.0) {
            double rollerCenterY = rect.y + rect.height / 2.0;
            context.DrawLine(penWhite, rect.x + 2.0, rollerCenterY - 2.0, rect.getRight() - 2.0, rollerCenterY - 2.0);
            context.DrawLine(penWhite, rect.x + 2.0, rollerCenterY, rect.getRight() - 2.0, rollerCenterY);
            context.DrawLine(penWhite, rect.x + 2.0, rollerCenterY + 2.0, rect.getRight() - 2.0, rollerCenterY + 2.0);
        }
    }

    public final IStiYAxis getAxis() {
        return this.axis;
    }

    public final StiVertScrollBarGeom getScrollBar() {
        return this.scrollBar;
    }

    public StiVertTrackBarGeom(IStiYAxis axis, StiRectangle clientRectangle, StiVertScrollBarGeom scrollBar) {
        super(clientRectangle);
        this.axis = axis;
        this.scrollBar = scrollBar;
    }
}

