/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.axis.scrollBars;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiLineSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiInteractionOptions;
import com.stimulsoft.report.chart.core.area.StiAreaCoreXF;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.core.axis.StiAxisCoreXF;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.interfaces.axis.IStiYAxis;
import java.util.ArrayList;

public class StiUpButtonGeom
extends StiCellGeom {
    private final IStiYAxis axis;

    @Override
    public void InvokeMouseEnter(StiInteractionOptions options) {
        if (!this.getAxis().getInteraction().getRangeScrollEnabled()) {
            return;
        }
        if (!this.getAxis().getCore().getIsMouseOverDecreaseButton()) {
            this.getAxis().getCore().setIsMouseOverDecreaseButton(true);
            options.setUpdateContext(true);
        }
    }

    @Override
    public void InvokeMouseLeave(StiInteractionOptions options) {
        if (!this.getAxis().getInteraction().getRangeScrollEnabled()) {
            return;
        }
        if (this.getAxis().getCore().getIsMouseOverDecreaseButton()) {
            this.getAxis().getCore().setIsMouseOverDecreaseButton(false);
            options.setUpdateContext(true);
        }
    }

    @Override
    public void InvokeMouseDown(StiInteractionOptions options) {
        if (!this.getAxis().getInteraction().getRangeScrollEnabled()) {
            return;
        }
        options.setUpdateContext(this.MoveUp());
        if (options.getUpdateContext()) {
            if (!options.getIsRecalled()) {
                options.setRecallTime(StiTimeSpan.FromSeconds((double)StiAxisCoreXF.DefaultScrollBarFirstRecallTime));
            } else {
                options.setRecallTime(StiTimeSpan.FromSeconds((double)StiAxisCoreXF.DefaultScrollBarOtherRecallTime));
            }
            options.setRecallEvent(true);
        }
    }

    private boolean MoveUp() {
        StiAreaCoreXF tempVar = this.getAxis().getArea().getCore();
        StiAxisAreaCoreXF axisCore = (StiAxisAreaCoreXF)(tempVar instanceof StiAxisAreaCoreXF ? tempVar : null);
        if (axisCore.getScrollValueY() == 0.0) {
            return false;
        }
        axisCore.setScrollValueY(axisCore.getScrollValueY() - axisCore.getScrollViewY() * (double)StiAxisCoreXF.DefaultScrollBarSmallFactor);
        if (axisCore.getScrollValueY() < 0.0) {
            axisCore.setScrollValueY(0.0);
        }
        axisCore.setBlockScrollValueY(true);
        return true;
    }

    public final IStiYAxis getAxis() {
        return this.axis;
    }

    @Override
    public void Draw(StiContext context) {
        double zoom = context.Options.zoom;
        StiRectangle rect = this.getClientRectangle();
        double centerX = rect.x + rect.width / 2.0;
        StiColor colorArrow = StiColor.White;
        if (this.getAxis().getCore().getIsMouseOverDecreaseButton()) {
            context.FillRectangle((Object)StiColorUtils.light((StiColor)this.getAxis().getLineColor(), (int)50), rect.x, rect.y, rect.width, rect.height, null);
            context.DrawRectangle(new StiPenGeom((Object)this.getAxis().getLineColor()), rect.x, rect.y, rect.width, rect.height);
        } else {
            colorArrow = this.getAxis().getLineColor();
        }
        double arrowWidth = rect.width / 3.0;
        double arrowHeight = rect.height / 4.0;
        StiPoint arrowStart = new StiPoint(rect.x + rect.width / 2.0, rect.y + rect.height / 2.0);
        context.PushSmoothingModeToAntiAlias();
        ArrayList<StiLineSegmentGeom> path = new ArrayList<StiLineSegmentGeom>();
        path.add(new StiLineSegmentGeom(arrowStart.x - arrowWidth, arrowStart.y + arrowHeight, arrowStart.x, arrowStart.y - arrowHeight));
        path.add(new StiLineSegmentGeom(arrowStart.x, arrowStart.y - arrowHeight, arrowStart.x + arrowWidth, arrowStart.y + arrowHeight));
        context.FillPath((Object)colorArrow, path, (Object)rect, null);
        context.PopSmoothingMode();
    }

    public StiUpButtonGeom(IStiYAxis axis, StiRectangle clientRectangle) {
        super(clientRectangle);
        this.axis = axis;
    }
}

