/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.areas;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiArcSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiLineSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.area.StiAreaCoreXF;
import com.stimulsoft.report.chart.core.area.radar.StiRadarAreaCoreXF;
import com.stimulsoft.report.chart.enums.StiRadarStyle;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.radar.IStiRadarArea;
import java.util.ArrayList;

public class StiRadarAreaGeom
extends StiAreaGeom {
    private final int valuesCount;

    public final int getValuesCount() {
        return this.valuesCount;
    }

    private void DrawHor(StiContext context, boolean fill, boolean draw) {
        StiRectangle rect = this.getClientRectangle();
        IStiArea tempVar = this.getArea();
        IStiRadarArea radarArea = (IStiRadarArea)(tempVar instanceof IStiRadarArea ? tempVar : null);
        if (radarArea.getYAxis().getInfo().StripPositions == null) {
            return;
        }
        StiAreaCoreXF tempVar2 = radarArea.getCore();
        StiRadarAreaCoreXF radarAreaCore = (StiRadarAreaCoreXF)(tempVar2 instanceof StiRadarAreaCoreXF ? tempVar2 : null);
        int index = 0;
        for (double radius : radarArea.getYAxis().getInfo().StripPositions) {
            if (radius != 0.0) {
                StiRectangle arcRect = new StiRectangle(radarAreaCore.CenterPoint.x - radius, radarAreaCore.CenterPoint.y - radius, radius * 2.0, radius * 2.0);
                if (radarArea.getRadarStyle() == StiRadarStyle.Circle) {
                    if (fill && radarArea.getInterlacingHor().getVisible() && index != radarArea.getYAxis().getInfo().StripPositions.length - 1 && (index & 1) == 0) {
                        ArrayList<StiArcSegmentGeom> path = new ArrayList<StiArcSegmentGeom>();
                        double radius2 = radarArea.getYAxis().getInfo().StripPositions[index + 1];
                        StiRectangle arcRect2 = new StiRectangle(radarAreaCore.CenterPoint.x - radius2, radarAreaCore.CenterPoint.y - radius2, radius2 * 2.0, radius2 * 2.0);
                        path.add(new StiArcSegmentGeom(arcRect, 0.0f, 360.0f));
                        path.add(new StiArcSegmentGeom(arcRect2, 0.0f, 360.0f));
                        context.FillPath((Object)radarArea.getInterlacingHor().getInterlacedBrush(), path, (Object)rect, null);
                    }
                    if (draw && radarArea.getGridLinesHor().getVisible()) {
                        StiPenGeom pen;
                        if (index == radarArea.getYAxis().getInfo().StripPositions.length - 1) {
                            pen = new StiPenGeom((Object)radarArea.getBorderColor());
                        } else {
                            pen = new StiPenGeom((Object)radarArea.getGridLinesHor().getColor());
                            pen.setPenStyle(radarArea.getGridLinesHor().getStyle());
                        }
                        context.DrawEllipse(pen, arcRect);
                    }
                } else {
                    if (fill && radarArea.getInterlacingHor().getVisible() && index != radarArea.getYAxis().getInfo().StripPositions.length - 1 && (index & 1) == 1) {
                        ArrayList<StiLineSegmentGeom> path = new ArrayList<StiLineSegmentGeom>();
                        int pointIndex2 = 0;
                        for (StiPoint curPoint : radarAreaCore.Points) {
                            StiPoint nextPoint = pointIndex2 == radarAreaCore.Points.size() - 1 ? radarAreaCore.Points.get(0) : radarAreaCore.Points.get(pointIndex2 + 1);
                            StiPoint point1 = new StiPoint(radarAreaCore.CenterPoint.x + radius * curPoint.x, radarAreaCore.CenterPoint.y + radius * curPoint.y);
                            StiPoint point2 = new StiPoint(radarAreaCore.CenterPoint.x + radius * nextPoint.x, radarAreaCore.CenterPoint.y + radius * nextPoint.y);
                            path.add(new StiLineSegmentGeom(point1, point2));
                            ++pointIndex2;
                        }
                        double radius2 = radarArea.getYAxis().getInfo().StripPositions[index + 1];
                        pointIndex2 = 0;
                        for (StiPoint curPoint : radarAreaCore.Points) {
                            StiPoint nextPoint = pointIndex2 == radarAreaCore.Points.size() - 1 ? radarAreaCore.Points.get(0) : radarAreaCore.Points.get(pointIndex2 + 1);
                            StiPoint point1 = new StiPoint(radarAreaCore.CenterPoint.x + radius2 * curPoint.x, radarAreaCore.CenterPoint.y + radius2 * curPoint.y);
                            StiPoint point2 = new StiPoint(radarAreaCore.CenterPoint.x + radius2 * nextPoint.x, radarAreaCore.CenterPoint.y + radius2 * nextPoint.y);
                            path.add(new StiLineSegmentGeom(point1, point2));
                            ++pointIndex2;
                        }
                        context.FillPath((Object)radarArea.getInterlacingHor().getInterlacedBrush(), path, (Object)rect, null);
                    }
                    if (draw && radarArea.getGridLinesHor().getVisible()) {
                        int pointIndex = 0;
                        for (StiPoint curPoint : radarAreaCore.Points) {
                            StiPenGeom pen;
                            StiPoint nextPoint = pointIndex == radarAreaCore.Points.size() - 1 ? radarAreaCore.Points.get(0) : radarAreaCore.Points.get(pointIndex + 1);
                            if (index == radarArea.getYAxis().getInfo().StripPositions.length - 1) {
                                pen = new StiPenGeom((Object)radarArea.getBorderColor());
                            } else {
                                pen = new StiPenGeom((Object)radarArea.getGridLinesHor().getColor());
                                pen.setPenStyle(radarArea.getGridLinesHor().getStyle());
                            }
                            context.DrawLine(pen, radarAreaCore.CenterPoint.x + radius * curPoint.x, radarAreaCore.CenterPoint.y + radius * curPoint.y, radarAreaCore.CenterPoint.x + radius * nextPoint.x, radarAreaCore.CenterPoint.y + radius * nextPoint.y);
                            ++pointIndex;
                        }
                    }
                }
            }
            ++index;
        }
    }

    private void DrawVert(StiContext context, boolean fill, boolean draw) {
        StiRectangle rect = this.getClientRectangle();
        IStiArea tempVar = this.getArea();
        IStiRadarArea radarArea = (IStiRadarArea)(tempVar instanceof IStiRadarArea ? tempVar : null);
        StiAreaCoreXF tempVar2 = radarArea.getCore();
        StiRadarAreaCoreXF radarAreaCore = (StiRadarAreaCoreXF)(tempVar2 instanceof StiRadarAreaCoreXF ? tempVar2 : null);
        int index = 0;
        float sweepAngle = 360 / radarAreaCore.Points.size();
        float startAngle = 0.0f;
        for (StiPoint endPoint : radarAreaCore.Points) {
            StiPoint point1 = radarAreaCore.CenterPoint;
            StiPoint point2 = new StiPoint(point1.x + rect.width / 2.0 * endPoint.x, point1.y + rect.width / 2.0 * endPoint.y);
            if (fill && radarArea.getInterlacingVert().getVisible()) {
                StiPoint point3;
                StiPoint stiPoint = point3 = index < radarAreaCore.Points.size() - 1 ? new StiPoint(point1.x + rect.width / 2.0 * radarAreaCore.Points.get((int)(index + 1)).x, point1.y + rect.height / 2.0 * radarAreaCore.Points.get((int)(index + 1)).y) : new StiPoint(point1.x + rect.width / 2.0 * radarAreaCore.Points.get((int)0).x, point1.y + rect.height / 2.0 * radarAreaCore.Points.get((int)0).y);
                if ((index & 1) == 1) {
                    ArrayList<Object> path = new ArrayList<Object>();
                    if (radarArea.getRadarStyle() == StiRadarStyle.Circle) {
                        path.add(new StiLineSegmentGeom(point1, point2));
                        path.add(new StiArcSegmentGeom(rect, startAngle - 90.0f, sweepAngle));
                        path.add(new StiLineSegmentGeom(point3, point1));
                    } else {
                        path.add(new StiLineSegmentGeom(point1, point2));
                        path.add(new StiLineSegmentGeom(point2, point3));
                        path.add(new StiLineSegmentGeom(point3, point1));
                    }
                    context.FillPath((Object)radarArea.getInterlacingVert().getInterlacedBrush(), path, (Object)rect, null);
                }
            }
            if (draw && radarArea.getGridLinesVert().getVisible()) {
                StiPenGeom pen = new StiPenGeom((Object)radarArea.getGridLinesVert().getColor());
                pen.setPenStyle(radarArea.getGridLinesVert().getStyle());
                context.DrawLine(pen, point1.x, point1.y, point2.x, point2.y);
            }
            startAngle += sweepAngle;
            ++index;
        }
    }

    private void DrawBackground(StiContext context) {
        StiRectangle rect = this.getClientRectangle();
        IStiArea tempVar = this.getArea();
        IStiRadarArea radarArea = (IStiRadarArea)(tempVar instanceof IStiRadarArea ? tempVar : null);
        if (radarArea.getYAxis().getInfo().StripPositions == null) {
            return;
        }
        StiAreaCoreXF tempVar2 = radarArea.getCore();
        StiRadarAreaCoreXF radarAreaCore = (StiRadarAreaCoreXF)(tempVar2 instanceof StiRadarAreaCoreXF ? tempVar2 : null);
        if (radarArea.getRadarStyle() == StiRadarStyle.Circle) {
            context.FillEllipse((Object)radarArea.getBrush(), rect, null);
        } else {
            double radius = radarArea.getYAxis().getInfo().StripPositions[radarArea.getYAxis().getInfo().StripPositions.length - 1];
            ArrayList<StiLineSegmentGeom> path = new ArrayList<StiLineSegmentGeom>();
            int pointIndex = 0;
            for (StiPoint curPoint : radarAreaCore.Points) {
                StiPoint nextPoint = pointIndex == radarAreaCore.Points.size() - 1 ? radarAreaCore.Points.get(0) : radarAreaCore.Points.get(pointIndex + 1);
                path.add(new StiLineSegmentGeom(radarAreaCore.CenterPoint.x + radius * curPoint.x, radarAreaCore.CenterPoint.y + radius * curPoint.y, radarAreaCore.CenterPoint.x + radius * nextPoint.x, radarAreaCore.CenterPoint.y + radius * nextPoint.y));
                ++pointIndex;
            }
            context.FillPath((Object)radarArea.getBrush(), path, (Object)rect, null);
        }
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = this.getClientRectangle();
        IStiArea tempVar = this.getArea();
        IStiRadarArea radarArea = (IStiRadarArea)(tempVar instanceof IStiRadarArea ? tempVar : null);
        StiAreaCoreXF tempVar2 = radarArea.getCore();
        StiRadarAreaCoreXF radarAreaCore = (StiRadarAreaCoreXF)(tempVar2 instanceof StiRadarAreaCoreXF ? tempVar2 : null);
        if (rect.width > 0.0 && rect.height > 0.0) {
            context.PushSmoothingModeToAntiAlias();
            this.DrawBackground(context);
            this.DrawVert(context, true, false);
            this.DrawHor(context, true, false);
            this.DrawVert(context, false, true);
            this.DrawHor(context, false, true);
            context.PopSmoothingMode();
        }
    }

    public StiRadarAreaGeom(IStiArea area, StiRectangle clientRectangle, int valuesCount) {
        super(area, clientRectangle);
        this.valuesCount = valuesCount;
    }
}

