/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.seriesLabels;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiTextUtil;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.StiChartOptions;
import com.stimulsoft.report.chart.enums.StiSeriesLabelsType;
import com.stimulsoft.report.chart.enums.StiSeriesLabelsValueType;
import com.stimulsoft.report.chart.interfaces.IStiApplyStyle;
import com.stimulsoft.report.chart.interfaces.areas.clusteredBar.IStiClusteredBarArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.range.IStiRangeSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.conditions.StiChartCondition;
import com.stimulsoft.report.components.StiComponent;
import java.util.Locale;

public abstract class StiSeriesLabelsCoreXF
implements Cloneable,
IStiApplyStyle {
    private IStiSeriesLabels seriesLabels;

    public StiSeriesLabelsCoreXF(IStiSeriesLabels seriesLabels) {
        this.seriesLabels = seriesLabels;
    }

    @Override
    public void applyStyle(IStiChartStyle style) {
        if (this.getSeriesLabels().getAllowApplyStyle()) {
            this.getSeriesLabels().setLabelColor(style.getCore().getSeriesLabelsColor());
            this.getSeriesLabels().setBorderColor(style.getCore().getSeriesLabelsBorderColor());
            this.getSeriesLabels().setBrush(style.getCore().getSeriesLabelsBrush());
            this.getSeriesLabels().setFont(style.getCore().getSeriesLabelsFont());
        }
    }

    public abstract int getPosition();

    public abstract StiSeriesLabelsType getSeriesLabelsType();

    public final IStiSeriesLabels getSeriesLabels() {
        return this.seriesLabels;
    }

    public final void setSeriesLabels(IStiSeriesLabels value) {
        this.seriesLabels = value;
    }

    public abstract String getLocalizedName();

    public final StiBrush ProcessSeriesColors(int pointIndex, StiBrush brush, IStiSeries series) {
        StiBrush seriesBrush = brush;
        if (this.getSeriesLabels() == null) {
            return seriesBrush;
        }
        for (StiChartCondition condition : this.getSeriesLabels().getChart().getSeriesLabelsConditions()) {
            Object data;
            Object itemValueHigh;
            Object itemValueLow;
            Object itemValueClose;
            Object itemValueOpen;
            if (series.getValues() == null || series.getValues().length <= pointIndex) continue;
            Double itemValue = series.getValues()[pointIndex];
            Object itemArgument = null;
            if (series.getArguments() != null && pointIndex < series.getArguments().length) {
                itemArgument = series.getArguments()[pointIndex];
            }
            Double itemValueEnd = null;
            if (series instanceof IStiRangeSeries && pointIndex < ((IStiRangeSeries)series).getValuesEnd().length) {
                itemValueEnd = ((IStiRangeSeries)series).getValuesEnd()[pointIndex];
            }
            if (!StiChartHelper.GetFilterResult(condition, itemArgument, itemValue, itemValueEnd, itemValueOpen = null, itemValueClose = null, itemValueLow = null, itemValueHigh = null, data = StiChartHelper.GetFilterData(null, condition, null))) continue;
            seriesBrush = this.getSeriesLabels().getChart().getStyle().getCore().GetColumnBrush(condition.getColor());
            if (this.getSeriesLabels().getChart().getArea() instanceof IStiClusteredBarArea) {
                if (seriesBrush instanceof StiGradientBrush) {
                    ((StiGradientBrush)seriesBrush).angle += 90.0;
                }
                if (seriesBrush instanceof StiGlareBrush) {
                    ((StiGlareBrush)seriesBrush).angle += 90.0;
                }
            }
            return seriesBrush;
        }
        return seriesBrush;
    }

    public final StiColor GetSeriesLabelColor(IStiSeries series, int colorIndex, int colorCount) {
        return StiColorUtils.light((StiColor)((StiColor)series.getCore().GetSeriesBorderColor(colorIndex, colorCount)), (int)100);
    }

    protected final StiColor GetBorderColor(IStiSeries series, int colorIndex, int colorCount) {
        if (this.getSeriesLabels().getUseSeriesColor()) {
            return this.GetSeriesLabelColor(series, colorIndex, colorCount);
        }
        return this.getSeriesLabels().getBorderColor();
    }

    protected final StiColor GetLabelColor(IStiSeries series, int colorIndex, int colorCount) {
        if (this.getSeriesLabels().getUseSeriesColor()) {
            return this.GetSeriesLabelColor(series, colorIndex, colorCount);
        }
        return this.getSeriesLabels().getLabelColor();
    }

    protected double RecalcValue(double value, int signs) {
        return value;
    }

    public final String GetLabelText(IStiSeries series, Double value, String argument, String tag, String seriesName) {
        return this.GetLabelText(series, value, argument, tag, seriesName, false);
    }

    public final String GetLabelText(IStiSeries series, Double value, String argument, String tag, String seriesName, boolean useLegendValueType) {
        return this.GetLabelText(series, value, argument, tag, seriesName, 0.0, useLegendValueType);
    }

    public final String GetLabelText(IStiSeries series, Double value, String argument, String tag, String seriesName, double weight, boolean useLegendValueType) {
        String text = null;
        StiSeriesLabelsValueType type = this.getSeriesLabels().getValueType();
        if (useLegendValueType) {
            type = this.getSeriesLabels().getLegendValueType();
        }
        switch (type) {
            case Argument: {
                text = argument;
                break;
            }
            case Value: {
                text = this.GetFormattedValue(series, value);
                break;
            }
            case SeriesTitle: {
                text = seriesName;
                break;
            }
            case Tag: {
                text = tag;
                break;
            }
            case Weight: {
                text = new Double(weight).toString();
                break;
            }
            case ValueArgument: {
                text = String.format("%1$s %2$s %3$s", this.GetFormattedValue(series, value), this.getSeriesLabels().getValueTypeSeparator(), argument);
                break;
            }
            case ArgumentValue: {
                text = String.format("%1$s %2$s %3$s", argument, this.getSeriesLabels().getValueTypeSeparator(), this.GetFormattedValue(series, value));
                break;
            }
            case SeriesTitleArgument: {
                text = String.format("%1$s %2$s %3$s", seriesName, this.getSeriesLabels().getValueTypeSeparator(), argument);
                break;
            }
            case SeriesTitleValue: {
                text = String.format("%1$s %2$s %3$s", seriesName, this.getSeriesLabels().getValueTypeSeparator(), this.GetFormattedValue(series, value));
            }
        }
        if (useLegendValueType) {
            return text;
        }
        return String.format("%1$s%2$s%3$s", this.getSeriesLabels().getTextBefore(), StiTextUtil.toString((Object)text), this.getSeriesLabels().getTextAfter());
    }

    protected String GetFormattedValue(IStiSeries series, Double value) {
        block13: {
            if (value == null) {
                return "";
            }
            try {
                Double objectValue = value;
                if (series.getCore().getIsDateTimeValues()) {
                    // empty if block
                }
                String format = null;
                if (series != null) {
                    format = series.getFormat();
                }
                if (format == null || format.trim().length() == 0) {
                    format = this.getSeriesLabels().getFormat();
                }
                if (format == null || format.trim().length() == 0) break block13;
                String culture = null;
                Locale locale = Locale.ENGLISH;
                try {
                    StiReport report = ((StiComponent)((Object)this.getSeriesLabels().getChart())).getReport();
                    culture = report.getCulture();
                    if (culture != null) {
                        locale = report.getLocale();
                    }
                }
                catch (Exception report) {
                    // empty catch block
                }
                if (format.startsWith("P") && this.getSeriesLabels().getChart() != null && !StiChartOptions.getOldChartPercentMode()) {
                    double percentValue;
                    int decimals = 0;
                    try {
                        if (format.length() > 1) {
                            decimals = Integer.parseInt(format.substring(0, 0) + format.substring(1));
                        }
                        percentValue = this.RecalcValue(value, decimals);
                    }
                    catch (Exception e) {
                        percentValue = this.RecalcValue(value, 2);
                    }
                    return StiStringUtil.format((String)String.format("{0:N%s}", decimals), (Object)percentValue, (Locale)locale, (String)culture) + "%";
                }
                return StiStringUtil.format((String)String.format("{0:%s}", format), (Object)objectValue, (Locale)locale, (String)culture);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return StiTextUtil.toString((Object)new Double(this.RecalcValue(value, 2)));
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

