/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.stackedColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.series.StiSeriesCoreXF;
import com.stimulsoft.report.chart.core.series.fullStackedColumn.StiFullStackedColumnSeriesCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.axis.StiAxisSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.enums.StiSeriesYAxis;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAxisAreaGeom;
import com.stimulsoft.report.chart.geoms.series.stackedColumn.StiStackedColumnSeriesElementGeom;
import com.stimulsoft.report.chart.geoms.series.stackedColumn.StiStackedColumnSeriesShadowElementGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.fullStackedColumn.IStiFullStackedColumnSeries;
import com.stimulsoft.report.chart.interfaces.series.stackedColumn.IStiStackedColumnSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.axis.IStiAxisSeriesLabels;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;
import java.util.ArrayList;

public class StiStackedColumnSeriesCoreXF
extends StiSeriesCoreXF {
    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        IStiSeries tempVar = this.getSeries();
        IStiStackedColumnSeries columnSeries = (IStiStackedColumnSeries)(tempVar instanceof IStiStackedColumnSeries ? tempVar : null);
        if (columnSeries.getAllowApplyStyle()) {
            columnSeries.setBrush(style.getCore().GetColumnBrush(color));
            columnSeries.setBorderColor(style.getCore().GetColumnBorder(color));
        }
    }

    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] series) {
        if (series == null || series.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        ArrayList<StiSeriesLabelsGeom> labelList = new ArrayList<StiSeriesLabelsGeom>();
        ArrayList<StiStackedColumnSeriesElementGeom> seriesList = new ArrayList<StiStackedColumnSeriesElementGeom>();
        IStiArea area = geom.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(area instanceof IStiAxisArea ? area : null);
        IStiSeries tempVar = this.getSeries();
        IStiStackedColumnSeries columnSeries = (IStiStackedColumnSeries)(tempVar instanceof IStiStackedColumnSeries ? tempVar : null);
        double posY = axisArea.getAxisCore().GetDividerY();
        int colorIndex = 0;
        int colorCount = axisArea.getAxisCore().ValuesCount * series.length;
        double dpiY = (float)axisArea.getYAxis().getInfo().Dpi;
        if (this.getSeries().getYAxis() == StiSeriesYAxis.RightYAxis) {
            dpiY = (float)axisArea.getYRightAxis().getInfo().Dpi;
        }
        for (int pointIndex = 0; pointIndex < axisArea.getAxisCore().ValuesCount; ++pointIndex) {
            double totalPositiveHeight = 0.0;
            double totalNegativeHeight = 0.0;
            StiRefObject tempRef_totalPositiveHeight = new StiRefObject((Object)totalPositiveHeight);
            StiRefObject tempRef_totalNegativeHeight = new StiRefObject((Object)totalNegativeHeight);
            this.CalculateTotalHeight(series, pointIndex, (StiRefObject<Double>)tempRef_totalPositiveHeight, (StiRefObject<Double>)tempRef_totalNegativeHeight);
            totalPositiveHeight = (Double)tempRef_totalPositiveHeight.argvalue;
            totalNegativeHeight = (Double)tempRef_totalNegativeHeight.argvalue;
            double posX = axisArea.getXAxis().getCore().GetStartFromZero() ? axisArea.getXAxis().getInfo().StripPositions[pointIndex + 1] : axisArea.getXAxis().getInfo().StripPositions[pointIndex];
            double seriesWidth = axisArea.getXAxis().getInfo().Step - axisArea.getXAxis().getInfo().Step * (double)(1.0f - columnSeries.getWidth());
            double seriesLeftPos = (posX -= axisArea.getXAxis().getInfo().Step / 2.0) + (axisArea.getXAxis().getInfo().Step - seriesWidth) / 2.0;
            float posYMax = 0.0f;
            float posYMin = 0.0f;
            if (series.length == 0) {
                return;
            }
            boolean showShadow = ((IStiStackedColumnSeries)series[0]).getShowShadow();
            if (showShadow) {
                for (int seriesIndex = 0; seriesIndex < series.length; ++seriesIndex) {
                    Double value;
                    if (pointIndex >= series[seriesIndex].getValues().length) continue;
                    IStiSeries currentSeries = series[seriesIndex];
                    Double d = value = axisArea.getReverseHor() ? currentSeries.getValues()[currentSeries.getValues().length - pointIndex - 1] : currentSeries.getValues()[pointIndex];
                    if (value == null) continue;
                    if (axisArea.getReverseVert()) {
                        value = -value.doubleValue();
                    }
                    if (value > 0.0) {
                        posYMax = (float)((double)posYMax + value);
                        continue;
                    }
                    posYMin = (float)((double)posYMin + value);
                }
                if (this instanceof StiFullStackedColumnSeriesCoreXF) {
                    StiStackedColumnSeriesShadowElementGeom shadowGeom;
                    StiRectangle shadowRect;
                    double totalNegativeHeight2;
                    double totalPositiveHeight2 = axisArea.getReverseVert() ? totalNegativeHeight : totalPositiveHeight;
                    double d = totalNegativeHeight2 = axisArea.getReverseVert() ? totalPositiveHeight : totalNegativeHeight;
                    if (totalPositiveHeight2 > 0.0 && totalNegativeHeight2 > 0.0) {
                        shadowRect = new StiRectangle(seriesLeftPos, -8.0, seriesWidth, rect.height + 8.0);
                        shadowGeom = new StiStackedColumnSeriesShadowElementGeom(series[0], shadowRect, false, false);
                        geom.CreateChildGeoms();
                        geom.getChildGeoms().add(shadowGeom);
                    } else if (totalPositiveHeight2 > 0.0) {
                        shadowRect = new StiRectangle(seriesLeftPos, -8.0, seriesWidth, axisArea.getAxisCore().GetDividerY() + 8.0);
                        shadowGeom = new StiStackedColumnSeriesShadowElementGeom(series[0], shadowRect, false, false);
                        geom.CreateChildGeoms();
                        geom.getChildGeoms().add(shadowGeom);
                    } else if (totalNegativeHeight2 > 0.0) {
                        shadowRect = new StiRectangle(seriesLeftPos, axisArea.getAxisCore().GetDividerY() - 8.0, seriesWidth, rect.height - axisArea.getAxisCore().GetDividerY() + 8.0);
                        shadowGeom = new StiStackedColumnSeriesShadowElementGeom(series[0], shadowRect, false, false);
                        geom.CreateChildGeoms();
                        geom.getChildGeoms().add(shadowGeom);
                    }
                } else {
                    StiStackedColumnSeriesShadowElementGeom shadowGeom;
                    if (posYMax > 0.0f) {
                        StiRectangle shadowRect = new StiRectangle(seriesLeftPos, (double)(-posYMax) * dpiY + posY, seriesWidth, (double)posYMax * dpiY);
                        shadowGeom = new StiStackedColumnSeriesShadowElementGeom(series[0], shadowRect, true, false);
                        geom.CreateChildGeoms();
                        geom.getChildGeoms().add(shadowGeom);
                    }
                    if (posYMin < 0.0f) {
                        StiRectangle shadowRect = new StiRectangle(seriesLeftPos, posY, seriesWidth, (double)(-posYMin) * dpiY);
                        shadowRect.y -= 7.0;
                        shadowRect.height += 7.0;
                        shadowGeom = new StiStackedColumnSeriesShadowElementGeom(series[0], shadowRect, false, true);
                        geom.CreateChildGeoms();
                        geom.getChildGeoms().add(shadowGeom);
                    }
                }
            }
            posYMax = 0.0f;
            posYMin = 0.0f;
            Integer time = StiChartHelper.GlobalBeginTimeElement;
            for (int seriesIndex = 0; seriesIndex < series.length; ++seriesIndex) {
                Double value;
                IStiStackedColumnSeries currentSeries = (IStiStackedColumnSeries)(series[seriesIndex] instanceof IStiStackedColumnSeries ? series[seriesIndex] : null);
                if (pointIndex >= currentSeries.getValues().length) continue;
                Double d = value = axisArea.getReverseHor() ? currentSeries.getValues()[currentSeries.getValues().length - pointIndex - 1] : currentSeries.getValues()[pointIndex];
                if (this.getSeries() instanceof IStiFullStackedColumnSeries && (totalPositiveHeight != 0.0 || totalNegativeHeight != 0.0) && value != null) {
                    dpiY = value >= 0.0 ? axisArea.getAxisCore().GetDividerY() / (double)((float)totalPositiveHeight) : (double)((float)(rect.height - axisArea.getAxisCore().GetDividerY()) / (float)totalNegativeHeight);
                }
                if (axisArea.getReverseVert() && value != null) {
                    value = -value.doubleValue();
                }
                double seriesHeight = (double)((float)(value == null ? 0.0 : value)) * dpiY;
                double seriesTop = -seriesHeight + posY;
                if (value > 0.0) {
                    seriesTop -= (double)posYMax;
                } else {
                    seriesTop = (double)posYMin + posY;
                    seriesHeight = -seriesHeight;
                }
                if (columnSeries.getShowZeros() && (value.equals(0) || value == null)) {
                    seriesHeight = Math.max(context.Options.zoom, 1.0);
                    if (!axisArea.getReverseVert()) {
                        seriesTop -= seriesHeight;
                    }
                }
                StiRectangle columnRect = new StiRectangle(seriesLeftPos, seriesTop, seriesWidth, seriesHeight);
                columnRect = this.CorrectRect(columnRect, rect);
                StiRectangle clipRect = ((StiAxisAreaGeom)geom).getView().getClientRectangle();
                clipRect.x = 0.0;
                clipRect.y = 0.0;
                StiRectangle columnRectCheck = columnRect;
                columnRectCheck.x += geom.getClientRectangle().x;
                columnRectCheck.y += geom.getClientRectangle().y;
                if (columnRectCheck.getRight() > clipRect.x && columnRectCheck.x < clipRect.getRight() || ((IStiAxisArea)this.getSeries().getChart().getArea()).getXAxis().getRange().getAuto()) {
                    IStiAxisSeriesLabels labels;
                    StiBrush seriesBrush = currentSeries.getCore().GetSeriesBrush(colorIndex, colorCount);
                    if (currentSeries.getAllowApplyBrushNegative() && value < 0.0) {
                        seriesBrush = currentSeries.getBrushNegative();
                    }
                    seriesBrush = currentSeries.ProcessSeriesColors(pointIndex, seriesBrush);
                    if (columnRect.width != 0.0 && (double)Math.round(columnRect.height * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0) > 0.0 && seriesBrush != null) {
                        StiColor seriesBorderColor = (StiColor)currentSeries.getCore().GetSeriesBorderColor(colorIndex, colorCount);
                        StiStackedColumnSeriesElementGeom seriesColumnGeom = new StiStackedColumnSeriesElementGeom(geom, value == null ? 0.0 : value, pointIndex, seriesBrush, seriesBorderColor, currentSeries, columnRect, time / ((StiAxisAreaCoreXF)axisArea.getCore()).ValuesCount * pointIndex);
                        if (currentSeries.getCore().getInteraction() != null) {
                            StiSeriesInteractionData data = new StiSeriesInteractionData();
                            data.Fill(axisArea, currentSeries, pointIndex);
                            seriesColumnGeom.setInteraction(data);
                        }
                        seriesList.add(seriesColumnGeom);
                    }
                    if ((labels = currentSeries.getCore().GetSeriesLabels()) != null && labels.getVisible() && (double)Math.round(columnRect.height * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0) > 0.0) {
                        StiSeriesLabelsGeom seriesLabelsGeom;
                        StiPoint endPoint = new StiPoint(columnRect.x + columnRect.width / 2.0, columnRect.y);
                        StiPoint startPoint = new StiPoint(columnRect.x + columnRect.width / 2.0, columnRect.getBottom());
                        Double seriesValue = currentSeries.getValues()[pointIndex];
                        if (axisArea.getReverseVert() && seriesValue != null) {
                            seriesValue = -value.doubleValue();
                        }
                        if (value < 0.0) {
                            startPoint.y = columnRect.y;
                            endPoint.y = columnRect.getBottom();
                        }
                        if ((labels.getStep() == 0 || pointIndex % labels.getStep() == 0) && (seriesLabelsGeom = ((StiAxisSeriesLabelsCoreXF)labels.getCore()).RenderLabel(currentSeries, context, endPoint, startPoint, pointIndex, value, seriesValue, axisArea.getAxisCore().GetArgumentLabel((StiStripLineXF)axisArea.getXAxis().getInfo().StripLines.get(pointIndex), currentSeries), this.GetTag(pointIndex), colorIndex, colorCount, rect, null)) != null) {
                            labelList.add(seriesLabelsGeom);
                        }
                    }
                }
                if (value > 0.0) {
                    posYMax = (float)((double)posYMax + seriesHeight);
                } else {
                    posYMin = (float)((double)posYMin + seriesHeight);
                }
                ++colorIndex;
            }
        }
        for (int index = seriesList.size() - 1; index >= 0; --index) {
            StiStackedColumnSeriesElementGeom seriesGeom = (StiStackedColumnSeriesElementGeom)seriesList.get(index);
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(seriesGeom);
        }
        for (StiSeriesLabelsGeom seriesLabelsGeom : labelList) {
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(seriesLabelsGeom);
            seriesLabelsGeom.setClientRectangle(this.CheckLabelsRect(seriesLabelsGeom.getSeriesLabels(), geom, seriesLabelsGeom.getClientRectangle()));
        }
    }

    private void CalculateTotalHeight(IStiSeries[] series, int pointIndex, StiRefObject<Double> totalPositiveHeight, StiRefObject<Double> totalNegativeHeight) {
        totalPositiveHeight.argvalue = 0.0;
        totalNegativeHeight.argvalue = 0.0;
        if (this.getSeries() instanceof IStiFullStackedColumnSeries) {
            for (IStiSeries currentSeries : series) {
                StiRefObject<Double> stiRefObject;
                Double value;
                if (pointIndex >= currentSeries.getValues().length) continue;
                Double d = value = ((IStiAxisArea)this.getSeries().getChart().getArea()).getReverseHor() ? currentSeries.getValues()[currentSeries.getValues().length - pointIndex - 1] : currentSeries.getValues()[pointIndex];
                if (value != null && value > 0.0) {
                    stiRefObject = totalPositiveHeight;
                    Double.valueOf((Double)stiRefObject.argvalue + (value == null ? 0.0 : value));
                    stiRefObject.argvalue = stiRefObject.argvalue;
                    continue;
                }
                stiRefObject = totalNegativeHeight;
                Double.valueOf((Double)stiRefObject.argvalue + Math.abs(value == null ? 0.0 : value));
                stiRefObject.argvalue = stiRefObject.argvalue;
            }
        }
    }

    private StiRectangle CorrectRect(StiRectangle columnRect, StiRectangle rect) {
        double dist;
        if (columnRect.y > rect.height || columnRect.getBottom() < 0.0) {
            columnRect.height = 0.0;
            return columnRect;
        }
        if (columnRect.getTop() < 0.0) {
            dist = -columnRect.getTop();
            columnRect.y += dist;
            columnRect.height -= dist;
        }
        if (columnRect.getBottom() > rect.height) {
            dist = columnRect.getBottom() - rect.height;
            columnRect.height -= dist;
        }
        return columnRect;
    }

    @Override
    public StiBrush GetSeriesBrush(int colorIndex, int colorCount) {
        IStiSeries tempVar = this.getSeries();
        IStiStackedColumnSeries columnSeries = (IStiStackedColumnSeries)(tempVar instanceof IStiStackedColumnSeries ? tempVar : null);
        StiBrush brush = super.GetSeriesBrush(colorIndex, colorCount);
        if (brush == null) {
            return columnSeries.getBrush();
        }
        return brush;
    }

    @Override
    public Object GetSeriesBorderColor(int colorIndex, int colorCount) {
        IStiSeries tempVar = this.getSeries();
        IStiStackedColumnSeries columnSeries = (IStiStackedColumnSeries)(tempVar instanceof IStiStackedColumnSeries ? tempVar : null);
        Object color = super.GetSeriesBorderColor(colorIndex, colorCount);
        if (color == null) {
            return columnSeries.getBorderColor();
        }
        return color;
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"StackedColumn");
    }

    public StiStackedColumnSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

