/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.stackedColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.series.StiSeriesCoreXF;
import com.stimulsoft.report.chart.core.series.fullStackedColumn.StiFullStackedAreaSeriesCoreXF;
import com.stimulsoft.report.chart.core.series.fullStackedColumn.StiFullStackedLineSeriesCoreXF;
import com.stimulsoft.report.chart.core.series.fullStackedColumn.StiFullStackedSplineAreaSeriesCoreXF;
import com.stimulsoft.report.chart.core.series.fullStackedColumn.StiFullStackedSplineSeriesCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.axis.StiAxisSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.enums.StiSeriesYAxis;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAxisAreaGeom;
import com.stimulsoft.report.chart.geoms.marker.StiMarkerGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.stackedColumn.IStiStackedBaseLineSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.axis.IStiAxisSeriesLabels;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;
import java.util.ArrayList;
import java.util.Hashtable;

public abstract class StiStackedBaseLineSeriesCoreXF
extends StiSeriesCoreXF {
    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        IStiSeries tempVar = this.getSeries();
        IStiStackedBaseLineSeries lineSeries = (IStiStackedBaseLineSeries)(tempVar instanceof IStiStackedBaseLineSeries ? tempVar : null);
        if (lineSeries.getAllowApplyStyle()) {
            lineSeries.setLineColor(color);
            lineSeries.setLighting(style.getCore().isSeriesLighting());
            if (lineSeries.getMarker() != null) {
                lineSeries.getMarker().setBrush((StiBrush)new StiSolidBrush(StiColorUtils.light((StiColor)color, (int)100)));
                lineSeries.getMarker().setBorderColor(StiColorUtils.dark((StiColor)color, (int)100));
            }
            if (lineSeries.getLineMarker() != null) {
                lineSeries.getLineMarker().setBrush((StiBrush)new StiSolidBrush(StiColorUtils.light((StiColor)color, (int)50)));
                lineSeries.getLineMarker().setBorderColor(StiColorUtils.dark((StiColor)color, (int)150));
            }
        }
    }

    protected final void ClipLinePoints(StiContext context, StiAreaGeom geom, StiPoint[] startPoints, StiPoint[] endPoints, StiRefObject<StiPoint[]> newStartPoints, StiRefObject<StiPoint[]> newEndPoints, StiRefObject<Integer> startIndex, StiRefObject<Integer> endIndex) {
        int i;
        int newCount;
        if (((IStiAxisArea)this.getSeries().getChart().getArea()).getXAxis().getRange().getAuto()) {
            startIndex.argvalue = 0;
            endIndex.argvalue = ((StiPoint[])startPoints).length;
            newStartPoints.argvalue = startPoints;
            newEndPoints.argvalue = endPoints;
            return;
        }
        startIndex.argvalue = -1;
        endIndex.argvalue = -1;
        StiRectangle clipRect = ((StiAxisAreaGeom)geom).getView().getClientRectangle();
        clipRect.x = 0.0;
        clipRect.y = 0.0;
        int pointIndex = 0;
        StiRefObject<Integer> stiRefObject = startPoints;
        int n = ((StiPoint[])stiRefObject).length;
        for (int j = 0; j < n; ++j) {
            StiPoint point;
            StiPoint valuePoint = point = stiRefObject[j];
            valuePoint.x += geom.getClientRectangle().x;
            valuePoint.y += geom.getClientRectangle().y;
            if (clipRect.x <= valuePoint.x && valuePoint.x < clipRect.getRight() && (Integer)startIndex.argvalue == -1) {
                startIndex.argvalue = pointIndex;
            }
            if (!(clipRect.x <= valuePoint.x && valuePoint.x < clipRect.getRight() || (Integer)startIndex.argvalue == -1)) {
                endIndex.argvalue = pointIndex;
                break;
            }
            ++pointIndex;
        }
        if ((Integer)endIndex.argvalue == -1) {
            endIndex.argvalue = ((StiRefObject<Integer>)startPoints).length - 1;
        }
        stiRefObject = startIndex;
        Integer n2 = (Integer)stiRefObject.argvalue;
        stiRefObject.argvalue = (Integer)stiRefObject.argvalue - 1;
        Integer n3 = stiRefObject.argvalue;
        stiRefObject = endIndex;
        n2 = (Integer)stiRefObject.argvalue;
        stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
        n3 = stiRefObject.argvalue;
        if ((Integer)startIndex.argvalue < 0) {
            startIndex.argvalue = 0;
        }
        if ((Integer)endIndex.argvalue >= ((StiRefObject<Integer>)startPoints).length) {
            endIndex.argvalue = ((StiRefObject<Integer>)startPoints).length - 1;
        }
        if ((newCount = (Integer)endIndex.argvalue - (Integer)startIndex.argvalue + 1) == ((StiRefObject<Integer>)startPoints).length) {
            newStartPoints.argvalue = startPoints;
            newEndPoints.argvalue = endPoints;
            return;
        }
        newStartPoints.argvalue = new StiPoint[newCount];
        for (i = ((Integer)startIndex.argvalue).intValue(); i < newCount; ++i) {
            ((StiPoint[])newStartPoints.argvalue)[i - ((Integer)startIndex.argvalue).intValue()] = startPoints[i].clone();
        }
        if (endPoints != null) {
            newEndPoints.argvalue = new StiPoint[newCount];
            for (i = ((Integer)startIndex.argvalue).intValue(); i < newCount; ++i) {
                ((StiPoint[])newEndPoints.argvalue)[i - ((Integer)startIndex.argvalue).intValue()] = startPoints[i].clone();
            }
        } else {
            newEndPoints.argvalue = null;
        }
    }

    protected void RenderMarkers(StiContext context, StiAreaGeom geom, StiPoint[] points) {
        IStiArea tempVar = geom.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        IStiSeries tempVar2 = this.getSeries();
        IStiStackedBaseLineSeries lineSeries = (IStiStackedBaseLineSeries)(tempVar2 instanceof IStiStackedBaseLineSeries ? tempVar2 : null);
        if (points.length == 0) {
            return;
        }
        if (lineSeries.getMarker() != null && lineSeries.getMarker().getVisible()) {
            int index = 0;
            for (StiPoint point : points) {
                if (point != null) {
                    StiMarkerGeom markerGeom;
                    Double value;
                    Double d = value = axisArea.getReverseHor() ? this.getSeries().getValues()[this.getSeries().getValues().length - index - 1] : this.getSeries().getValues()[index];
                    if (value == null && lineSeries.getShowNulls()) {
                        value = 0.0;
                    }
                    StiRectangle clipRect = ((StiAxisAreaGeom)geom).getView().getClientRectangle();
                    clipRect.x = 0.0;
                    clipRect.y = 0.0;
                    clipRect.inflate(10, 10);
                    StiPoint valuePoint = point.getValue();
                    valuePoint.x += geom.getClientRectangle().x;
                    valuePoint.y += geom.getClientRectangle().y;
                    if (clipRect.contains(valuePoint) && (markerGeom = new StiMarkerGeom(this.getSeries(), index, value == null ? 0.0 : value, point.getValue(), lineSeries.getMarker(), this.getSeries().getShowShadow(), context.Options.zoom)) != null) {
                        if (lineSeries.getCore().getInteraction() != null) {
                            StiSeriesInteractionData data = new StiSeriesInteractionData();
                            data.Fill(axisArea, lineSeries, index);
                            markerGeom.setInteraction(data);
                        }
                        geom.CreateChildGeoms();
                        geom.getChildGeoms().add(markerGeom);
                    }
                }
                ++index;
            }
        }
    }

    protected void RenderLines(StiContext context, StiAreaGeom geom, StiPoint[] points) {
    }

    protected void RenderAreas(StiContext context, StiAreaGeom geom, StiPoint[] startPoints, StiPoint[] endPoints) {
    }

    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] series) {
        StiPoint[] newEndPoints;
        int startIndex;
        IStiArea area;
        IStiSeries tempVar = this.getSeries();
        IStiStackedBaseLineSeries lineSeries = (IStiStackedBaseLineSeries)(tempVar instanceof IStiStackedBaseLineSeries ? tempVar : null);
        ArrayList<StiSeriesLabelsGeom> labelList = new ArrayList<StiSeriesLabelsGeom>();
        IStiArea tempVar2 = geom.getArea();
        IStiArea iStiArea = area = tempVar2 instanceof IStiArea ? tempVar2 : null;
        if (series == null || series.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        IStiAxisArea axisArea = (IStiAxisArea)(area instanceof IStiAxisArea ? area : null);
        double posY = axisArea.getAxisCore().GetDividerY();
        Hashtable<Integer, Double> pointMaxStack = new Hashtable<Integer, Double>();
        Hashtable<Integer, Double> pointMinStack = new Hashtable<Integer, Double>();
        ArrayList<StiPoint[]> pointLists = new ArrayList<StiPoint[]>();
        double dpiY = (float)axisArea.getYAxis().getInfo().Dpi;
        if (this.getSeries().getYAxis() == StiSeriesYAxis.RightYAxis) {
            dpiY = (float)axisArea.getYRightAxis().getInfo().Dpi;
        }
        for (int seriesIndex = 0; seriesIndex < series.length; ++seriesIndex) {
            IStiStackedBaseLineSeries currentSeries = (IStiStackedBaseLineSeries)(series[seriesIndex] instanceof IStiStackedBaseLineSeries ? series[seriesIndex] : null);
            int pointsCount = currentSeries.getValues().length;
            StiPoint[] endPoints = new StiPoint[pointsCount];
            StiPoint[] startPoints = new StiPoint[pointsCount];
            for (int pointIndex = 0; pointIndex < pointsCount; ++pointIndex) {
                Double value;
                double posX = axisArea.getXAxis().getCore().GetStartFromZero() ? axisArea.getXAxis().getInfo().StripPositions[pointIndex + 1] : axisArea.getXAxis().getInfo().StripPositions[pointIndex];
                Double d = value = axisArea.getReverseHor() ? currentSeries.getValues()[currentSeries.getValues().length - pointIndex - 1] : currentSeries.getValues()[pointIndex];
                if (value == null && !currentSeries.getShowNulls()) {
                    startPoints[pointIndex] = null;
                    endPoints[pointIndex] = null;
                    continue;
                }
                if (value == null && currentSeries.getShowNulls()) {
                    value = 0.0;
                }
                double totalPositiveHeight = 0.0;
                double totalNegativeHeight = 0.0;
                StiRefObject tempRef_totalPositiveHeight = new StiRefObject((Object)totalPositiveHeight);
                StiRefObject tempRef_totalNegativeHeight = new StiRefObject((Object)totalNegativeHeight);
                this.CalculateTotalHeight(series, pointIndex, (StiRefObject<Double>)tempRef_totalPositiveHeight, (StiRefObject<Double>)tempRef_totalNegativeHeight);
                totalPositiveHeight = (Double)tempRef_totalPositiveHeight.argvalue;
                totalNegativeHeight = (Double)tempRef_totalNegativeHeight.argvalue;
                if (((StiStackedBaseLineSeriesCoreXF)lineSeries.getCore()).getIsFullStacked() && (totalPositiveHeight != 0.0 || totalNegativeHeight != 0.0) && value != null) {
                    dpiY = value >= 0.0 ? axisArea.getAxisCore().GetDividerY() / (double)((float)totalPositiveHeight) : (rect.height - axisArea.getAxisCore().GetDividerY()) / (double)((float)totalNegativeHeight);
                }
                if (axisArea.getReverseVert() && value != null) {
                    value = -value.doubleValue();
                }
                double srY = -(value == null ? 0.0 : value) * dpiY;
                double srYStack = 0.0;
                if (value != null && value >= 0.0) {
                    if (pointMaxStack.get(pointIndex) != null) {
                        srYStack = (Double)pointMaxStack.get(pointIndex);
                    }
                } else if (pointMinStack.get(pointIndex) != null) {
                    srYStack = (Double)pointMinStack.get(pointIndex);
                }
                srY += srYStack;
                if (value >= 0.0) {
                    pointMaxStack.put(pointIndex, srY);
                } else {
                    pointMinStack.put(pointIndex, srY);
                }
                startPoints[pointIndex] = new StiPoint(posX, srYStack + axisArea.getAxisCore().GetDividerY());
                endPoints[pointIndex] = new StiPoint(posX, srY + axisArea.getAxisCore().GetDividerY());
            }
            if (endPoints.length > 0 && startPoints.length > 0) {
                startIndex = 0;
                int endIndex = 0;
                StiPoint[] newStartPoints = null;
                newEndPoints = null;
                StiRefObject tempRef_newStartPoints = new StiRefObject(newStartPoints);
                StiRefObject tempRef_newEndPoints = new StiRefObject(newEndPoints);
                StiRefObject tempRef_startIndex = new StiRefObject((Object)startIndex);
                StiRefObject tempRef_endIndex = new StiRefObject((Object)endIndex);
                this.ClipLinePoints(context, geom, startPoints, endPoints, (StiRefObject<StiPoint[]>)tempRef_newStartPoints, (StiRefObject<StiPoint[]>)tempRef_newEndPoints, (StiRefObject<Integer>)tempRef_startIndex, (StiRefObject<Integer>)tempRef_endIndex);
                newStartPoints = (StiPoint[])tempRef_newStartPoints.argvalue;
                newEndPoints = (StiPoint[])tempRef_newEndPoints.argvalue;
                startIndex = (Integer)tempRef_startIndex.argvalue;
                endIndex = (Integer)tempRef_endIndex.argvalue;
                ((StiStackedBaseLineSeriesCoreXF)currentSeries.getCore()).RenderAreas(context, geom, newStartPoints, newEndPoints);
            }
            pointLists.add(endPoints);
        }
        int index = 0;
        double[] prevMaxHeights = new double[axisArea.getAxisCore().ValuesCount];
        double[] prevMinHeights = new double[axisArea.getAxisCore().ValuesCount];
        for (int pointIndex = 0; pointIndex < axisArea.getAxisCore().ValuesCount; ++pointIndex) {
            prevMaxHeights[pointIndex] = posY;
            prevMinHeights[pointIndex] = posY;
        }
        for (StiPoint[] pointList : pointLists) {
            startIndex = 0;
            int endIndex = 0;
            StiPoint[] newPoints = null;
            newEndPoints = null;
            StiRefObject tempRef_newPoints = new StiRefObject(newPoints);
            StiRefObject tempRef_newEndPoints2 = new StiRefObject(newEndPoints);
            StiRefObject tempRef_startIndex2 = new StiRefObject((Object)startIndex);
            StiRefObject tempRef_endIndex2 = new StiRefObject((Object)endIndex);
            this.ClipLinePoints(context, geom, pointList, null, (StiRefObject<StiPoint[]>)tempRef_newPoints, (StiRefObject<StiPoint[]>)tempRef_newEndPoints2, (StiRefObject<Integer>)tempRef_startIndex2, (StiRefObject<Integer>)tempRef_endIndex2);
            newPoints = (StiPoint[])tempRef_newPoints.argvalue;
            newEndPoints = (StiPoint[])tempRef_newEndPoints2.argvalue;
            startIndex = (Integer)tempRef_startIndex2.argvalue;
            endIndex = (Integer)tempRef_endIndex2.argvalue;
            IStiStackedBaseLineSeries currentSeries = (IStiStackedBaseLineSeries)(series[index] instanceof IStiStackedBaseLineSeries ? series[index] : null);
            ((StiStackedBaseLineSeriesCoreXF)currentSeries.getCore()).RenderLines(context, geom, newPoints);
            IStiAxisSeriesLabels labels = currentSeries.getCore().GetSeriesLabels();
            if (labels != null && labels.getVisible()) {
                for (int pointIndex = startIndex; pointIndex <= endIndex; ++pointIndex) {
                    StiSeriesLabelsGeom seriesLabelsGeom;
                    StiPoint endPoint;
                    if (pointIndex >= currentSeries.getValues().length) continue;
                    Double value = currentSeries.getValues()[pointIndex];
                    if (value == null && lineSeries.getShowNulls()) {
                        value = 0.0;
                    }
                    double y = posY;
                    if (value > 0.0) {
                        y = prevMaxHeights[pointIndex];
                        if (pointList[pointIndex] != null) {
                            prevMaxHeights[pointIndex] = pointList[pointIndex].getValue().y;
                        }
                    } else {
                        y = prevMinHeights[pointIndex];
                        if (pointList[pointIndex] != null) {
                            prevMinHeights[pointIndex] = pointList[pointIndex].getValue().y;
                        }
                    }
                    Double seriesValue = value;
                    if (axisArea.getReverseVert() && value != null) {
                        seriesValue = -seriesValue.doubleValue();
                    }
                    if ((endPoint = pointList[pointIndex]) == null) continue;
                    StiPoint startPoint = new StiPoint(endPoint.getValue().x, y);
                    if (labels.getStep() != 0 && pointIndex % labels.getStep() != 0 || (seriesLabelsGeom = ((StiAxisSeriesLabelsCoreXF)labels.getCore()).RenderLabel(currentSeries, context, endPoint.getValue(), startPoint, pointIndex, seriesValue, value, axisArea.getAxisCore().GetArgumentLabel((StiStripLineXF)axisArea.getXAxis().getInfo().StripLines.get(pointIndex), currentSeries), this.GetTag(pointIndex), 0, 1, rect, null)) == null) continue;
                    labelList.add(seriesLabelsGeom);
                }
            }
            ++index;
        }
        for (StiSeriesLabelsGeom seriesLabelsGeom : labelList) {
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(seriesLabelsGeom);
            seriesLabelsGeom.setClientRectangle(this.CheckLabelsRect(seriesLabelsGeom.getSeriesLabels(), geom, seriesLabelsGeom.getClientRectangle()));
        }
    }

    private void CalculateTotalHeight(IStiSeries[] series, int pointIndex, StiRefObject<Double> totalPositiveHeight, StiRefObject<Double> totalNegativeHeight) {
        IStiSeries tempVar = this.getSeries();
        IStiStackedBaseLineSeries lineSeries = (IStiStackedBaseLineSeries)(tempVar instanceof IStiStackedBaseLineSeries ? tempVar : null);
        totalPositiveHeight.argvalue = 0.0;
        if (((StiStackedBaseLineSeriesCoreXF)lineSeries.getCore()).getIsFullStacked()) {
            for (IStiSeries currentSeries : series) {
                StiRefObject<Double> stiRefObject;
                Double value;
                if (pointIndex >= currentSeries.getValues().length) continue;
                Double d = value = ((IStiAxisArea)this.getSeries().getChart().getArea()).getReverseHor() ? currentSeries.getValues()[currentSeries.getValues().length - pointIndex - 1] : currentSeries.getValues()[pointIndex];
                if (value == null && lineSeries.getShowNulls()) {
                    value = 0.0;
                }
                if (value != null && value > 0.0) {
                    stiRefObject = totalPositiveHeight;
                    Double.valueOf((Double)stiRefObject.argvalue + (value == null ? 0.0 : value));
                    stiRefObject.argvalue = stiRefObject.argvalue;
                    continue;
                }
                stiRefObject = totalNegativeHeight;
                Double.valueOf((Double)stiRefObject.argvalue + Math.abs(value == null ? 0.0 : value));
                stiRefObject.argvalue = stiRefObject.argvalue;
            }
        }
    }

    private StiPoint CorrectPoint(StiPoint point, StiRectangle rect) {
        if (point.y < 0.0) {
            return new StiPoint(point.x, 0.0);
        }
        if (point.y > rect.height) {
            return new StiPoint(point.x, rect.height);
        }
        return point;
    }

    @Override
    public StiBrush GetSeriesBrush(int colorIndex, int colorCount) {
        IStiSeries tempVar = this.getSeries();
        IStiStackedBaseLineSeries lineSeries = (IStiStackedBaseLineSeries)(tempVar instanceof IStiStackedBaseLineSeries ? tempVar : null);
        StiBrush brush = super.GetSeriesBrush(colorIndex, colorCount);
        if (brush == null) {
            return new StiSolidBrush(StiColorUtils.dark((StiColor)lineSeries.getLineColor(), (int)20));
        }
        return brush;
    }

    @Override
    public Object GetSeriesBorderColor(int colorIndex, int colorCount) {
        IStiSeries tempVar = this.getSeries();
        IStiStackedBaseLineSeries lineSeries = (IStiStackedBaseLineSeries)(tempVar instanceof IStiStackedBaseLineSeries ? tempVar : null);
        Object color = super.GetSeriesBorderColor(colorIndex, colorCount);
        if (color == null) {
            return lineSeries.getLineColor();
        }
        return color;
    }

    public final boolean getIsFullStacked() {
        return this instanceof StiFullStackedAreaSeriesCoreXF || this instanceof StiFullStackedLineSeriesCoreXF || this instanceof StiFullStackedSplineSeriesCoreXF || this instanceof StiFullStackedSplineAreaSeriesCoreXF;
    }

    public StiStackedBaseLineSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

