/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.radar;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.core.area.StiAreaCoreXF;
import com.stimulsoft.report.chart.core.area.radar.StiRadarAreaCoreXF;
import com.stimulsoft.report.chart.core.series.StiSeriesCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.axis.StiAxisSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.radar.StiRadarPointSeriesElementGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.radar.IStiRadarArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.radar.IStiRadarSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.axis.IStiAxisSeriesLabels;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import java.util.ArrayList;
import java.util.List;

public abstract class StiRadarSeriesCoreXF
extends StiSeriesCoreXF {
    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        IStiSeries tempVar = this.getSeries();
        IStiRadarSeries radarSeries = (IStiRadarSeries)(tempVar instanceof IStiRadarSeries ? tempVar : null);
        if (radarSeries.getAllowApplyStyle() && radarSeries.getMarker() != null) {
            radarSeries.getMarker().setBrush((StiBrush)new StiSolidBrush(StiColorUtils.light((StiColor)color, (int)100)));
            radarSeries.getMarker().setBorderColor(StiColorUtils.dark((StiColor)color, (int)100));
        }
    }

    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] seriesArray) {
        List<StiPoint> pointsFrom;
        ArrayList points;
        IStiRadarSeries series;
        if (seriesArray == null || seriesArray.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        boolean isAnimationChangingValues = ((StiChart)this.getSeries().getChart()).isAnimationChangingValues();
        IStiArea tempVar = geom.getArea();
        IStiRadarArea area = (IStiRadarArea)(tempVar instanceof IStiRadarArea ? tempVar : null);
        StiAreaCoreXF tempVar2 = area.getCore();
        StiRadarAreaCoreXF core = (StiRadarAreaCoreXF)(tempVar2 instanceof StiRadarAreaCoreXF ? tempVar2 : null);
        ArrayList<List<StiPoint>> pointsList = this.GetPointsList(this.getSeries().getValues(), geom, seriesArray);
        ArrayList<List<StiPoint>> pointsListFrom = isAnimationChangingValues ? this.GetPointsList(this.getSeries().getValuesStart(), geom, seriesArray) : null;
        int seriesIndex = 0;
        for (IStiSeries series1 : seriesArray) {
            series = (IStiRadarSeries)series1;
            points = (ArrayList)pointsList.get(seriesIndex);
            points.add(points.get(0));
            pointsFrom = null;
            if (isAnimationChangingValues) {
                pointsFrom = pointsListFrom.get(seriesIndex);
                pointsFrom.add(pointsFrom.get(0));
            }
            this.RenderAreas(context, series, pointsFrom, points, geom);
            points.remove(points.size() - 1);
            ++seriesIndex;
        }
        seriesIndex = 0;
        for (IStiSeries series1 : seriesArray) {
            series = (IStiRadarSeries)series1;
            points = (ArrayList)pointsList.get(seriesIndex);
            points.add(points.get(0));
            pointsFrom = null;
            if (isAnimationChangingValues) {
                pointsFrom = pointsListFrom.get(seriesIndex);
                pointsFrom.add(pointsFrom.get(0));
            }
            this.RenderLines(context, series, pointsFrom, points, geom);
            points.remove(points.size() - 1);
            ++seriesIndex;
        }
        seriesIndex = 0;
        for (IStiSeries series1 : seriesArray) {
            series = (IStiRadarSeries)series1;
            points = (ArrayList)pointsList.get(seriesIndex);
            this.RenderPoints(context, series, points, geom);
            ++seriesIndex;
        }
    }

    public void RenderAreas(StiContext context, IStiRadarSeries series, List<StiPoint> pointsFrom, ArrayList<StiPoint> points, StiAreaGeom geom) {
    }

    public void RenderLines(StiContext context, IStiRadarSeries series, List<StiPoint> pointsFrom, ArrayList<StiPoint> points, StiAreaGeom geom) {
    }

    public void RenderPoints(StiContext context, IStiRadarSeries series, ArrayList<StiPoint> points, StiAreaGeom geom) {
        IStiArea tempVar = geom.getArea();
        IStiRadarArea area = (IStiRadarArea)(tempVar instanceof IStiRadarArea ? tempVar : null);
        StiAreaCoreXF tempVar2 = area.getCore();
        StiRadarAreaCoreXF core = (StiRadarAreaCoreXF)(tempVar2 instanceof StiRadarAreaCoreXF ? tempVar2 : null);
        int pointIndex = 0;
        for (StiPoint point : points) {
            if (point != null) {
                IStiAxisSeriesLabels labels;
                Double value = pointIndex < series.getValues().length ? series.getValues()[pointIndex] : null;
                StiRadarPointSeriesElementGeom radarGeom = new StiRadarPointSeriesElementGeom(geom, value == null ? 0.0 : value, pointIndex, series, point.getValue(), context.Options.zoom);
                if (geom != null) {
                    geom.CreateChildGeoms();
                    geom.getChildGeoms().add(radarGeom);
                }
                if ((labels = series.getCore().GetSeriesLabels()) != null && labels.getVisible() && value != null) {
                    StiSeriesLabelsGeom seriesLabelsGeom;
                    StiPoint startPoint;
                    StiPoint stiPoint = startPoint = point == null ? null : point;
                    if ((labels.getStep() == 0 || pointIndex % labels.getStep() == 0) && (seriesLabelsGeom = ((StiAxisSeriesLabelsCoreXF)labels.getCore()).RenderLabel(series, context, startPoint, startPoint, pointIndex, value, value, this.GetArgument(series, pointIndex), this.GetTag(pointIndex), 0, 1, geom.getClientRectangle(), null)) != null) {
                        geom.CreateChildGeoms();
                        geom.getChildGeoms().add(seriesLabelsGeom);
                        seriesLabelsGeom.setClientRectangle(this.CheckLabelsRect((IStiSeriesLabels)labels, geom, seriesLabelsGeom.getClientRectangle()));
                    }
                }
            }
            ++pointIndex;
        }
    }

    private String GetArgument(IStiRadarSeries series, int pointIndex) {
        if (series.getArguments().length > pointIndex) {
            return series.getArguments()[pointIndex].toString();
        }
        return "";
    }

    @Override
    public StiBrush GetSeriesBrush(int colorIndex, int colorCount) {
        IStiSeries tempVar = this.getSeries();
        IStiRadarSeries radarSeries = (IStiRadarSeries)(tempVar instanceof IStiRadarSeries ? tempVar : null);
        StiBrush brush = super.GetSeriesBrush(colorIndex, colorCount);
        if (brush == null) {
            return new StiSolidBrush(StiColorUtils.dark((StiColor)StiColor.White, (int)20));
        }
        return brush;
    }

    @Override
    public Object GetSeriesBorderColor(int colorIndex, int colorCount) {
        IStiSeries tempVar = this.getSeries();
        IStiRadarSeries lineSeries = (IStiRadarSeries)(tempVar instanceof IStiRadarSeries ? tempVar : null);
        Object color = super.GetSeriesBorderColor(colorIndex, colorCount);
        if (color == null) {
            return StiColor.Black;
        }
        return color;
    }

    public StiRadarSeriesCoreXF(IStiSeries series) {
        super(series);
    }

    private ArrayList<List<StiPoint>> GetPointsList(Double[] values, StiAreaGeom geom, IStiSeries[] seriesArray) {
        ArrayList<List<StiPoint>> pointsList = new ArrayList<List<StiPoint>>();
        IStiRadarArea area = (IStiRadarArea)geom.getArea();
        StiRadarAreaCoreXF core = (StiRadarAreaCoreXF)area.getCore();
        for (IStiSeries series1 : seriesArray) {
            IStiRadarSeries series = (IStiRadarSeries)series1;
            ArrayList<StiPoint> points = new ArrayList<StiPoint>();
            pointsList.add(points);
            int pointIndex = 0;
            for (StiPoint curPoint : core.Points) {
                Double value;
                Double d = value = pointIndex < series.getValues().length ? series.getValues()[pointIndex] : null;
                if (value == null && series.getShowNulls()) {
                    value = 0.0;
                }
                if (value == null) {
                    points.add(null);
                } else {
                    if (value != null) {
                        value = value * area.getYAxis().getInfo().Dpi;
                    }
                    StiPoint point = new StiPoint((double)((float)(core.CenterPoint.x + (value == null ? 0.0 : value) * curPoint.getValue().x)), (double)((float)(core.CenterPoint.y + (value == null ? 0.0 : value) * curPoint.getValue().y)));
                    point.x -= geom.getClientRectangle().x;
                    point.y -= geom.getClientRectangle().y;
                    points.add(point);
                }
                ++pointIndex;
            }
        }
        return pointsList;
    }
}

