/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.clusteredColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.report.chart.core.series.clusteredColumn.StiLineSeriesCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiAreaSeriesGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiAreaSeries;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;

public class StiAreaSeriesCoreXF
extends StiLineSeriesCoreXF {
    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        IStiSeries tempVar = this.getSeries();
        IStiAreaSeries areaSeries = (IStiAreaSeries)(tempVar instanceof IStiAreaSeries ? tempVar : null);
        if (areaSeries.getAllowApplyStyle()) {
            areaSeries.setBrush(style.getCore().GetAreaBrush(color));
        }
    }

    @Override
    protected void RenderAreas(StiContext context, StiAreaGeom geom, StiPoint[] pointsFrom, StiPoint[] points) {
        if (points == null || points.length <= 1) {
            return;
        }
        StiAreaSeriesGeom seriesGeom = new StiAreaSeriesGeom(geom, pointsFrom, points, this.getSeries());
        if (seriesGeom != null) {
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(seriesGeom);
        }
    }

    @Override
    public StiBrush GetSeriesBrush(int colorIndex, int colorCount) {
        IStiSeries tempVar = this.getSeries();
        IStiAreaSeries areaSeries = (IStiAreaSeries)(tempVar instanceof IStiAreaSeries ? tempVar : null);
        StiBrush brush = super.GetSeriesBrush(colorIndex, colorCount);
        if (brush == null) {
            return areaSeries.getBrush();
        }
        return brush;
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"Area");
    }

    public StiAreaSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

