/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.clusteredBar;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiLabelAnimation;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.series.clusteredColumn.StiClusteredColumnSeriesCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.axis.StiAxisSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAxisAreaGeom;
import com.stimulsoft.report.chart.geoms.series.clusteredBar.StiClusteredBarSeriesElementGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.IStiApplyStyleSeries;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredBar.IStiClusteredBarSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiClusteredColumnSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.axis.IStiAxisSeriesLabels;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLine;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLineNone;
import com.stimulsoft.report.chart.view.series.StiSeries;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;
import java.util.ArrayList;

public class StiClusteredBarSeriesCoreXF
extends StiClusteredColumnSeriesCoreXF
implements IStiApplyStyleSeries {
    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        IStiSeries tempVar = this.getSeries();
        IStiClusteredBarSeries barSeries = (IStiClusteredBarSeries)(tempVar instanceof IStiClusteredBarSeries ? tempVar : null);
        if (barSeries.getAllowApplyStyle()) {
            barSeries.setBrush(style.getCore().GetColumnBrush(color));
            if (barSeries.getBrush() instanceof StiGradientBrush) {
                ((StiGradientBrush)barSeries.getBrush()).angle += 90.0;
            }
            if (barSeries.getBrush() instanceof StiGlareBrush) {
                ((StiGlareBrush)barSeries.getBrush()).angle += 90.0;
            }
            barSeries.setBorderColor(style.getCore().GetColumnBorder(color));
        }
    }

    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] series) {
        ArrayList<StiSeriesLabelsGeom> seriesLabelsList = new ArrayList<StiSeriesLabelsGeom>();
        IStiArea area = geom.getArea();
        if (series == null || series.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        boolean isAnimationChangingValues = ((StiChart)this.getSeries().getChart()).isAnimationChangingValues();
        IStiAxisArea axisArea = (IStiAxisArea)(area instanceof IStiAxisArea ? area : null);
        double posX = axisArea.getAxisCore().GetDividerX();
        int colorIndex = 0;
        int colorCount = axisArea.getAxisCore().ValuesCount * series.length;
        int pointCount = axisArea.getAxisCore().ValuesCount;
        ArrayList pointsLists = new ArrayList();
        for (int index = 0; index < series.length; ++index) {
            pointsLists.add(new ArrayList());
        }
        for (int pointIndex = 0; pointIndex < pointCount; ++pointIndex) {
            double posY = axisArea.getYAxis().getInfo().StripPositions[pointIndex + 1] - axisArea.getYAxis().getInfo().Step / 2.0;
            float sumSeriesHeight = 0.0f;
            for (IStiSeries ser : series) {
                sumSeriesHeight = (float)((double)sumSeriesHeight + axisArea.getYAxis().getInfo().Step / (double)series.length * (double)((IStiClusteredColumnSeries)ser).getWidth());
            }
            double seriesTopPos = posY + (axisArea.getYAxis().getInfo().Step - (double)sumSeriesHeight) / 2.0;
            int seriesIndex = 0;
            if (axisArea.getReverseVert()) {
                seriesIndex = series.length - 1;
            }
            Integer time = StiChartHelper.GlobalBeginTimeElement;
            while (seriesIndex < series.length && !axisArea.getReverseVert() || seriesIndex >= 0 && axisArea.getReverseVert()) {
                IStiClusteredBarSeries currentSeries = (IStiClusteredBarSeries)(series[seriesIndex] instanceof IStiClusteredBarSeries ? series[seriesIndex] : null);
                double seriesHeight = axisArea.getYAxis().getInfo().Step / (double)series.length * (double)currentSeries.getWidth();
                if (pointIndex < currentSeries.getValues().length) {
                    Double value = -(!axisArea.getReverseVert() ? currentSeries.getValues()[currentSeries.getValues().length - pointIndex - 1] : currentSeries.getValues()[pointIndex]).doubleValue();
                    if (axisArea.getReverseHor() && value != null) {
                        value = -value.doubleValue();
                    }
                    StiRectangle rectFrom = StiRectangle.empty();
                    Double valueFrom = null;
                    if (isAnimationChangingValues) {
                        if (currentSeries.getValuesStart().length > pointIndex) {
                            valueFrom = -(!axisArea.getReverseVert() ? currentSeries.getValuesStart()[currentSeries.getValuesStart().length - pointIndex - 1] : currentSeries.getValuesStart()[pointIndex]).doubleValue();
                        }
                        rectFrom = this.GetBarRect(context, currentSeries, valueFrom, seriesTopPos, seriesHeight);
                    }
                    double seriesWidth = (value == null ? 0.0 : value) * axisArea.getXAxis().getInfo().Dpi;
                    double seriesLeftPos = -seriesWidth + posX;
                    if (((IStiClusteredBarSeries)this.getSeries()).getShowZeros() && (value == 0.0 || value == null)) {
                        seriesWidth = Math.max(context.Options.zoom, 2.0);
                        if (axisArea.getReverseHor()) {
                            seriesLeftPos -= seriesWidth;
                        }
                    }
                    if (value < 0.0) {
                        seriesLeftPos = posX;
                        seriesWidth = -seriesWidth;
                    }
                    StiRectangle columnRect = new StiRectangle(seriesLeftPos, seriesTopPos, seriesWidth, seriesHeight);
                    if (!(((StiSeries)((Object)currentSeries)).getTrendLine() instanceof IStiTrendLineNone)) {
                        ((ArrayList)pointsLists.get(seriesIndex)).add(new StiPoint((double)((float)seriesWidth), seriesTopPos + seriesHeight / 2.0));
                    }
                    StiRectangle clipRect = ((StiAxisAreaGeom)geom).getView().getClientRectangle();
                    clipRect.x = 0.0;
                    clipRect.y = 0.0;
                    StiRectangle columnRectCheck = columnRect;
                    columnRectCheck.x += geom.getClientRectangle().x;
                    columnRectCheck.y += geom.getClientRectangle().y;
                    if (columnRectCheck.getBottom() > clipRect.y && columnRectCheck.y < clipRect.getBottom() || ((IStiAxisArea)this.getSeries().getChart().getArea()).getYAxis().getRange().getAuto()) {
                        IStiAxisSeriesLabels labels;
                        if (this.getSeries().getChart() != null && this.getSeries().getChart().getStyle() != null && columnRect.width > 0.0) {
                            StiBrush seriesBrush = currentSeries.getCore().GetSeriesBrush(colorIndex, colorCount);
                            if (currentSeries.getAllowApplyBrushNegative() && value > 0.0) {
                                seriesBrush = currentSeries.getBrushNegative();
                            }
                            seriesBrush = currentSeries.ProcessSeriesColors(pointCount - 1 - pointIndex, seriesBrush);
                            StiColor seriesBorderColor = (StiColor)currentSeries.getCore().GetSeriesBorderColor(colorIndex, colorCount);
                            Integer beginTime = valueFrom != null ? 0 : time / ((StiAxisAreaCoreXF)axisArea.getCore()).ValuesCount * pointIndex;
                            StiClusteredBarSeriesElementGeom seriesColumnGeom = new StiClusteredBarSeriesElementGeom(geom, value == null ? 0.0 : value, value == null ? 0.0 : value, pointIndex, seriesBrush, seriesBorderColor, currentSeries, rectFrom, columnRect, beginTime);
                            if (currentSeries.getCore().getInteraction() != null) {
                                StiSeriesInteractionData data = new StiSeriesInteractionData();
                                data.Fill(axisArea, currentSeries, pointIndex);
                                seriesColumnGeom.setInteraction(data);
                            }
                            geom.CreateChildGeoms();
                            geom.getChildGeoms().add(seriesColumnGeom);
                        }
                        if ((labels = currentSeries.getCore().GetSeriesLabels()) != null && labels.getVisible()) {
                            StiSeriesLabelsGeom seriesLabelsGeom;
                            StiPoint endPoint = new StiPoint((double)(-((float)((value == null ? 0.0 : value) * axisArea.getXAxis().getInfo().Dpi))) + posX, seriesTopPos + seriesHeight / 2.0);
                            Double seriesValue = value;
                            if (value != null) {
                                seriesValue = axisArea.getReverseHor() ? value : -value.doubleValue();
                            }
                            StiLabelAnimation animation = null;
                            if (isAnimationChangingValues) {
                                StiPoint endPointFrom = new StiPoint(-(valueFrom != null ? valueFrom : 0.0) * axisArea.getXAxis().getInfo().Dpi + posX, seriesTopPos + seriesHeight / 2.0);
                                Double animationValueFrom = null;
                                Double animationValue = null;
                                if (valueFrom != null) {
                                    animationValueFrom = axisArea.getReverseHor() ? valueFrom : -valueFrom.doubleValue();
                                }
                                if (value != null) {
                                    animationValue = axisArea.getReverseHor() ? value : -value.doubleValue();
                                }
                                animation = new StiLabelAnimation(animationValueFrom, animationValue, new StiPoint(endPointFrom.x, endPointFrom.y), new StiPoint(endPoint.x, endPoint.y), time, Integer.valueOf(0));
                            }
                            if ((labels.getStep() == 0 || pointIndex % labels.getStep() == 0) && (seriesLabelsGeom = ((StiAxisSeriesLabelsCoreXF)labels.getCore()).RenderLabel(currentSeries, context, this.CorrectPoint(endPoint, rect), this.CorrectPoint(new StiPoint(posX, endPoint.y), rect), pointIndex, value, seriesValue, axisArea.getAxisCore().GetArgumentLabel((StiStripLineXF)axisArea.getYAxis().getInfo().StripLines.get(pointIndex), currentSeries), currentSeries.getCore().GetTag(pointIndex), colorIndex, colorCount, rect, (StiAnimation)animation)) != null) {
                                seriesLabelsList.add(seriesLabelsGeom);
                                seriesLabelsGeom.setClientRectangle(this.CheckLabelsRect((IStiSeriesLabels)labels, geom, seriesLabelsGeom.getClientRectangle()));
                            }
                        }
                    }
                }
                seriesTopPos += seriesHeight;
                ++colorIndex;
                if (axisArea.getReverseVert()) {
                    --seriesIndex;
                    continue;
                }
                ++seriesIndex;
            }
        }
        for (int indexSeries = 0; indexSeries < series.length; ++indexSeries) {
            IStiTrendLine trendLine = ((StiSeries)series[indexSeries]).getTrendLine();
            if (trendLine instanceof IStiTrendLineNone) continue;
            ArrayList pointsList = (ArrayList)pointsLists.get(indexSeries);
            if (trendLine == null) continue;
            trendLine.getCore().RenderTrendLine(geom, pointsList.toArray(new StiPoint[0]), axisArea.getAxisCore().GetDividerY());
        }
        for (StiSeriesLabelsGeom seriesLabelsGeom : seriesLabelsList) {
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(seriesLabelsGeom);
        }
    }

    private StiPoint CorrectPoint(StiPoint point, StiRectangle rect) {
        if (point.x < 0.0) {
            return new StiPoint(0.0, point.y);
        }
        if (point.x > rect.width) {
            return new StiPoint(rect.width, point.y);
        }
        return point;
    }

    private StiRectangle GetBarRect(StiContext context, IStiClusteredColumnSeries currentSeries, Double value, double seriesTopPos, double seriesHeight) {
        IStiAxisArea axisArea = (IStiAxisArea)currentSeries.getChart().getArea();
        double posX = axisArea.getAxisCore().GetDividerX();
        if (axisArea.getReverseHor() && value != null) {
            value = -value.doubleValue();
        }
        double seriesWidth = (value != null ? value : 0.0) * axisArea.getXAxis().getInfo().Dpi;
        double seriesLeftPos = -seriesWidth + posX;
        if (((IStiClusteredBarSeries)this.getSeries()).getShowZeros() && (value == 0.0 || value == null)) {
            seriesWidth = Math.max(context.Options.zoom, 2.0);
            if (axisArea.getReverseHor()) {
                seriesLeftPos -= seriesWidth;
            }
        }
        if (value < 0.0) {
            seriesLeftPos = posX;
            seriesWidth = -seriesWidth;
        }
        return new StiRectangle((double)((float)seriesLeftPos), seriesTopPos, (double)((float)seriesWidth), seriesHeight);
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"ClusteredBar");
    }

    public StiClusteredBarSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

