/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.bubble;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.core.series.scatter.StiScatterSeriesCoreXF;
import com.stimulsoft.report.chart.enums.StiSeriesYAxis;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.bubble.StiBubbleSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.areas.scatter.IStiScatterArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.bubble.IStiBubbleSeries;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.dictionary.data.DBNull;
import java.util.ArrayList;
import java.util.Date;

public class StiBubbleSeriesCoreXF
extends StiScatterSeriesCoreXF {
    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        if (this.getSeries().getAllowApplyStyle()) {
            ((IStiBubbleSeries)this.getSeries()).setBrush(style.getCore().GetColumnBrush(color));
            ((IStiBubbleSeries)this.getSeries()).setBorderColor(style.getCore().GetColumnBorder(color));
        }
    }

    protected final void RenderBubbles(StiContext context, StiAreaGeom geom, IStiBubbleSeries series, StiPoint[] points, double[] weights) {
        double max = 0.0;
        int index = 0;
        for (IStiSeries serie : series.getChart().getSeries()) {
            IStiBubbleSeries bubbleSeries = (IStiBubbleSeries)(serie instanceof IStiBubbleSeries ? serie : null);
            if (bubbleSeries == null) continue;
            for (double weight : bubbleSeries.getWeights()) {
                max = index == 0 ? weight : Math.max(weight, max);
                ++index;
            }
        }
        IStiArea tempVar = geom.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        double step = Math.min(axisArea.getXAxis().getInfo().Step, axisArea.getYAxis().getInfo().Step) * 0.9;
        double dpi = step / max;
        Integer time = StiChartHelper.GlobalBeginTimeElement;
        index = 0;
        for (double weight : weights) {
            StiPoint point = points[index];
            if (point != null && weight > 0.0) {
                double size = weight * dpi;
                StiRectangle rect = new StiRectangle(point.getValue().x - size / 2.0, point.getValue().y - size / 2.0, size, size);
                StiBubbleSeriesElementGeom seriesColumnGeom = new StiBubbleSeriesElementGeom(geom, weight, index, series.getBrush(), series.getBorderColor(), series, rect, time / ((StiAxisAreaCoreXF)axisArea.getCore()).ValuesCount * index);
                geom.CreateChildGeoms();
                geom.getChildGeoms().add(seriesColumnGeom);
            }
            ++index;
        }
    }

    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] seriesArray) {
        if (seriesArray == null || seriesArray.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        IStiArea tempVar = geom.getArea();
        IStiScatterArea dotArea = (IStiScatterArea)(tempVar instanceof IStiScatterArea ? tempVar : null);
        double posY = 0.0;
        ArrayList pointLists = new ArrayList();
        ArrayList weightLists = new ArrayList();
        for (int seriesIndex = 0; seriesIndex < seriesArray.length; ++seriesIndex) {
            IStiBubbleSeries currentSeries = (IStiBubbleSeries)(seriesArray[seriesIndex] instanceof IStiBubbleSeries ? seriesArray[seriesIndex] : null);
            int n = Math.min(currentSeries.getValues().length, currentSeries.getArguments().length);
            ArrayList<StiPoint> points = new ArrayList<StiPoint>();
            ArrayList<Double> weights = new ArrayList<Double>();
            for (int pointIndex = 0; pointIndex < n; ++pointIndex) {
                Double value = currentSeries.getValues()[pointIndex];
                if (value == null && currentSeries.getShowNulls()) {
                    value = 0.0;
                }
                if (dotArea.getReverseVert() && value != null) {
                    value = -value.doubleValue();
                }
                double srY = 0.0;
                srY = currentSeries.getYAxis() == StiSeriesYAxis.LeftYAxis ? -(value == null ? 0.0 : value) * (double)((float)dotArea.getYAxis().getInfo().Dpi) + dotArea.getAxisCore().GetDividerY() : -(value == null ? 0.0 : value) * (double)((float)dotArea.getYRightAxis().getInfo().Dpi) + dotArea.getAxisCore().GetDividerRightY();
                Double argument = null;
                if (currentSeries.getArguments()[pointIndex] instanceof Date) {
                    Date tempDateTime = (Date)currentSeries.getArguments()[pointIndex];
                    argument = Double.parseDouble(String.valueOf(tempDateTime.getTime()));
                } else {
                    try {
                        if (currentSeries.getArguments()[pointIndex] != null && currentSeries.getArguments()[pointIndex] != DBNull.Value) {
                            argument = (Double)currentSeries.getArguments()[pointIndex];
                        }
                    }
                    catch (Exception e) {
                        argument = null;
                    }
                }
                if (argument == null && currentSeries.getShowNulls()) {
                    argument = 0.0;
                }
                if (value != null && argument != null) {
                    double posX = (argument - dotArea.getXAxis().getInfo().Minimum) * dotArea.getXAxis().getInfo().Dpi + dotArea.getAxisCore().GetDividerX();
                    if (dotArea.getReverseHor()) {
                        posX = rect.width - posX;
                    }
                    points.add(new StiPoint((double)((float)posX), (double)((float)srY)));
                } else {
                    points.add(null);
                }
                weights.add(pointIndex < currentSeries.getWeights().size() ? currentSeries.getWeights().get(pointIndex) : Double.valueOf(0.0));
            }
            pointLists.add(points);
            weightLists.add(weights);
        }
        boolean index = false;
        for (ArrayList arrayList : pointLists) {
        }
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"Bubble");
    }

    public StiBubbleSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

