/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.marker;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiInteractionDataGeom;
import com.stimulsoft.base.context.chart.animation.StiScaleAnimation;
import com.stimulsoft.base.context.chart.geoms.StiCloseFigureSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiLinesSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPathGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.enums.StiMarkerType;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.interfaces.marker.IStiMarker;
import java.util.ArrayList;

public class StiMarkerCoreXF
implements Cloneable {
    private IStiMarker marker;

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public final void DrawMarkers(StiContext context, StiPoint[] points, boolean showShadow) {
        if (points.length == 0) {
            return;
        }
        if (this.marker != null && this.marker.getVisible()) {
            context.PushSmoothingModeToAntiAlias();
            double chartZoom = context.Options.zoom;
            for (StiPoint point : points) {
                this.marker.getCore().Draw(context, this.marker, point, chartZoom, showShadow, false, false, "", null, null);
            }
            context.PopSmoothingMode();
        }
    }

    public static StiRectangle GetMarkerRect(StiPoint position, float markerSize, double zoom) {
        double dx = (double)markerSize * zoom / 2.0;
        return new StiRectangle(position.x - dx, position.y - dx, dx * 2.0, dx * 2.0);
    }

    public final void Draw(StiContext context, IStiMarker marker, StiPoint position, double zoom, boolean showShadow, boolean isMouseOver, boolean isAnimation, String toolTip, Object tag, StiInteractionDataGeom interaction) {
        StiPenGeom pen = new StiPenGeom((Object)marker.getBorderColor());
        StiSolidBrush shadowBrush = new StiSolidBrush(StiColor.FromArgb((int)55, (StiColor)StiColorEnum.Black.color()));
        StiRectangle rect = StiMarkerCoreXF.GetMarkerRect(position, marker.getSize(), zoom);
        if (showShadow) {
            rect.x += 2.0 * zoom;
            rect.y += 2.0 * zoom;
            this.DrawPoint(context, rect.x + rect.width / 2.0, rect.y + rect.height / 2.0, zoom, shadowBrush, null, marker.getType(), marker.getSize(), marker.getAngle(), false, isAnimation, toolTip, null, null);
            rect.x -= 2.0 * zoom;
            rect.y -= 2.0 * zoom;
        }
        this.DrawPoint(context, rect.x + rect.width / 2.0, rect.y + rect.height / 2.0, zoom, marker.getBrush(), pen, marker.getType(), marker.getSize(), marker.getAngle(), isMouseOver, isAnimation, toolTip, tag, interaction);
    }

    public final void DrawLine(StiContext context, float x1, float y1, float x2, float y2, float scale, StiBrush brushMarker, StiPenGeom penMarker, StiMarkerType markerType, float markerStep, float markerSize, float angle) {
        this.DrawLines(context, new StiPoint[]{new StiPoint((double)x1, (double)y1), new StiPoint((double)x2, (double)y2)}, scale, brushMarker, penMarker, markerType, markerStep, markerSize, angle);
    }

    public final void DrawLines(StiContext context, StiPoint[] points, double scale, Object brushMarker, StiPenGeom penMarker, StiMarkerType markerType, float markerStep, float markerSize, float angle) {
        context.PushSmoothingModeToAntiAlias();
        if (points.length < 2) {
            return;
        }
        float pos = 0.0f;
        for (int index = 0; index < points.length - 1; ++index) {
            StiPoint point = points[index];
            StiPoint nextPoint = points[index + 1];
            if (point == null || nextPoint == null) continue;
            double x1 = point.getValue().x;
            double y1 = point.getValue().y;
            double x2 = nextPoint.getValue().x;
            double y2 = nextPoint.getValue().y;
            double dx = x2 - x1;
            double dy = y2 - y1;
            float length = (float)Math.sqrt(dx * dx + dy * dy);
            double step = markerStep;
            while (pos < length) {
                double x = x1 + dx * (double)pos / (double)length;
                double y = y1 + dy * (double)pos / (double)length;
                this.DrawPoint(context, x, y, scale, brushMarker, penMarker, markerType, markerSize, angle, false, false, "", null, null);
                pos = (float)((double)pos + step * scale);
            }
            pos -= length;
        }
        context.PopSmoothingMode();
    }

    public final void DrawPoint(StiContext context, double x, double y, double scale, Object brush, StiPenGeom pen, StiMarkerType markerType, double markerSize, double angle, boolean isMouseOver, boolean isAnimation, String toolTip, Object tag, StiInteractionDataGeom interaction) {
        double step = markerSize * scale / 2.0;
        double x1 = x - step;
        double x2 = x + step;
        double y1 = y - step;
        double y2 = y + step;
        switch (markerType) {
            case Star5: {
                this.DrawPolygon(context, brush, pen, x, y, step, 10, angle, true, isMouseOver);
                break;
            }
            case Star6: {
                this.DrawPolygon(context, brush, pen, x, y, step, 12, angle, true, isMouseOver);
                break;
            }
            case Star7: {
                this.DrawPolygon(context, brush, pen, x, y, step, 14, angle, true, isMouseOver);
                break;
            }
            case Star8: {
                this.DrawPolygon(context, brush, pen, x, y, step, 16, angle, true, isMouseOver);
                break;
            }
            case Hexagon: {
                this.DrawPolygon(context, brush, pen, x, y, step, 6, 30.0 + angle, false, isMouseOver);
                break;
            }
            case Rectangle: {
                this.DrawPolygon(context, brush, pen, x, y, step, 4, 45.0 + angle, false, isMouseOver);
                break;
            }
            case Circle: {
                if (isAnimation) {
                    StiScaleAnimation animation = new StiScaleAnimation(StiChartHelper.GlobalDurationElement, Integer.valueOf(0));
                    context.FillDrawAnimationEllipse(brush, pen, x1, y1, x2 - x1, y2 - y1, toolTip, tag, (StiAnimation)animation, interaction);
                    break;
                }
                if (brush != null) {
                    context.FillEllipse(brush, x1, y1, x2 - x1, y2 - y1, interaction);
                }
                if (isMouseOver) {
                    context.FillEllipse((Object)StiMouseOverHelper.GetMouseOverColor(), x1, y1, x2 - x1, y2 - y1, null);
                }
                if (pen == null) break;
                context.DrawEllipse(pen, x1, y1, x2 - x1, y2 - y1);
                break;
            }
            case Triangle: {
                this.DrawPolygon(context, brush, pen, x, y, step, 3, angle, false, isMouseOver);
            }
        }
    }

    private void DrawPolygon(StiContext context, Object fillBrush, StiPenGeom borderPen, double centerX, double centerY, double radius, int count, double startAngle, boolean isStar, boolean isMouseOver) {
        startAngle = -startAngle;
        ArrayList<Object> path = new ArrayList<Object>();
        double angle = -90.0 + startAngle;
        StiPoint[] points = new StiPoint[count];
        if (isStar) {
            for (int index = 0; index < count; index += 2) {
                points[index] = new StiPoint();
                points[index].x = centerX + radius * (double)((float)Math.cos(angle * Math.PI / 180.0));
                points[index].y = centerY + radius * (double)((float)Math.sin(angle * Math.PI / 180.0));
                points[index + 1].x = centerX + radius / 2.0 * (double)((float)Math.cos((angle += (double)(360 / count)) * Math.PI / 180.0));
                points[index + 1].y = centerY + radius / 2.0 * (double)((float)Math.sin(angle * Math.PI / 180.0));
                angle += (double)(360 / count);
            }
        } else {
            for (int index = 0; index < count; ++index) {
                points[index] = new StiPoint();
                points[index].x = centerX + radius * (double)((float)Math.cos(angle * Math.PI / 180.0));
                points[index].y = centerY + radius * (double)((float)Math.sin(angle * Math.PI / 180.0));
                angle += (double)(360 / count);
            }
        }
        path.add(new StiLinesSegmentGeom(points));
        path.add(new StiCloseFigureSegmentGeom());
        if (fillBrush != null) {
            context.FillPath(fillBrush, path, StiPathGeom.GetBoundsState, null);
        }
        if (isMouseOver) {
            context.FillPath((Object)StiMouseOverHelper.GetMouseOverColor(), path, StiPathGeom.GetBoundsState, null);
        }
        if (borderPen != null) {
            context.DrawPath(borderPen, path, null);
        }
    }

    public final IStiMarker getMarker() {
        return this.marker;
    }

    public final void setMarker(IStiMarker value) {
        this.marker = value;
    }

    public StiMarkerCoreXF(IStiMarker marker) {
        this.marker = marker;
    }
}

