/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.axis.stripLines;

import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLinesXF;
import java.util.Date;

public final class StiStripLineCalculatorXF {
    private static double GetInterval(double interval) {
        double tick;
        block5: {
            int count;
            block4: {
                tick = Math.abs(interval);
                count = 0;
                if (!(interval > 1.0)) break block4;
                while (tick > 1.0) {
                    tick /= 10.0;
                    ++count;
                }
                tick = tick < 0.15 ? 0.1 : (tick < 0.3 ? 0.2 : (tick < 0.75 ? 0.5 : 1.0));
                while (count > 0) {
                    tick *= 10.0;
                    --count;
                }
                break block5;
            }
            if (!(interval > 0.0)) break block5;
            while (tick * 10.0 < 1.0) {
                tick *= 10.0;
                ++count;
            }
            tick = tick < 0.15 ? 0.1 : (tick < 0.3 ? 0.2 : (tick < 0.75 ? 0.5 : 1.0));
            while (count > 0) {
                tick /= 10.0;
                --count;
            }
        }
        return tick;
    }

    public static double GetInterval(double minValue, double maxValue, int num) {
        if (maxValue == minValue) {
            return 0.0;
        }
        return StiStripLineCalculatorXF.GetInterval((maxValue - minValue) / (double)num);
    }

    public static StiStripLinesXF GetStripLines(double minValue, double maxValue, double step, boolean asDateTimeValue) {
        StiStripLinesXF list = new StiStripLinesXF();
        if (minValue == maxValue) {
            return list;
        }
        double minValueD = minValue;
        double maxValueD = maxValue;
        double stepD = step;
        double pos = 0.0;
        pos = (double)((int)(minValueD / stepD)) * stepD;
        while (minValueD < pos + stepD) {
            pos -= stepD;
        }
        while (pos < maxValueD) {
            pos += stepD;
            if (asDateTimeValue) {
                list.add(0, new StiStripLineXF(new Date((long)pos), pos));
                continue;
            }
            list.add(0, new StiStripLineXF(pos, pos));
        }
        return list;
    }

    public static StiStripLinesXF GetStripLinesLogScale(double minValue, double maxValue) {
        double pos;
        double minValueScale;
        StiStripLinesXF list = new StiStripLinesXF();
        if (minValue == maxValue) {
            return list;
        }
        double minValueD = minValue;
        double maxValueD = maxValue;
        double maxValueScale = 1.0;
        if (0.0 < minValue && minValue < 1.0) {
            for (minValueScale = 1.0; minValueD < minValueScale; minValueScale /= 10.0) {
            }
        }
        if (minValue > 1.0) {
            while (minValueD > minValueScale) {
                minValueScale *= 10.0;
            }
            minValueScale /= 10.0;
        }
        if (0.0 < maxValueD && maxValueD < 1.0) {
            while (maxValueScale > maxValueD) {
                maxValueScale /= 10.0;
            }
            maxValueScale *= 10.0;
        }
        if (maxValueD > 1.0) {
            while (maxValueD > maxValueScale) {
                maxValueScale *= 10.0;
            }
        }
        double startStepValue = pos = minValueScale;
        int index = 1;
        while (pos <= maxValueScale) {
            list.add(0, new StiStripLineXF(new Double(pos).toString(), pos));
            pos += startStepValue;
            if (++index != 10) continue;
            index = 1;
            startStepValue = pos;
        }
        return list;
    }
}

