/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.area;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.area.StiAreaCoreXF;
import com.stimulsoft.report.chart.core.area.clusteredBar.StiClusteredBarAreaCoreXF;
import com.stimulsoft.report.chart.core.area.gantt.StiGanttAreaCoreXF;
import com.stimulsoft.report.chart.core.axis.StiAxisInfoXF;
import com.stimulsoft.report.chart.core.axis.StiXAxisCoreXF;
import com.stimulsoft.report.chart.core.axis.StiXTopAxisCoreXF;
import com.stimulsoft.report.chart.core.axis.StiYAxisCoreXF;
import com.stimulsoft.report.chart.core.axis.StiYRightAxisCoreXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineCalculatorXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLinesXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripPositionXF;
import com.stimulsoft.report.chart.enums.StiChartSeriesOrientation;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAxisAreaGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAxisAreaViewGeom;
import com.stimulsoft.report.chart.geoms.axis.StiXAxisGeom;
import com.stimulsoft.report.chart.geoms.axis.StiXAxisViewGeom;
import com.stimulsoft.report.chart.geoms.axis.StiYAxisGeom;
import com.stimulsoft.report.chart.geoms.axis.StiYAxisViewGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.areas.clusteredBar.IStiClusteredBarArea;
import com.stimulsoft.report.chart.interfaces.axis.IStiAxis;
import com.stimulsoft.report.chart.interfaces.axis.IStiXAxis;
import com.stimulsoft.report.chart.interfaces.axis.IStiYAxis;
import com.stimulsoft.report.chart.interfaces.constantLines.IStiConstantLines;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.strips.IStiStrips;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.series.gantt.StiGanttSeries;
import com.stimulsoft.report.chart.view.series.scatter.StiScatterLineSeries;
import com.stimulsoft.report.chart.view.seriesLabels.axis.StiOutsideEndAxisLabels;
import java.util.ArrayList;
import java.util.Hashtable;

public abstract class StiAxisAreaCoreXF
extends StiAreaCoreXF {
    public int ValuesCount = 0;
    private double scrollRangeX = 0.0;
    private double scrollRangeY = 0.0;
    private double scrollViewX = 0.0;
    private double scrollViewY = 0.0;
    private boolean blockScrollValueX = false;
    private boolean blockScrollValueY = false;
    private double scrollValueX = 0.0;
    private double scrollValueY = 0.0;
    private double scrollDpiX = 1.0;
    private double scrollDpiY = 1.0;
    private double scrollDragStartValue = 0.0;

    @Override
    public void applyStyle(IStiChartStyle style) {
        super.applyStyle(style);
        IStiArea tempVar = this.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        if (axisArea.getAllowApplyStyle()) {
            if (axisArea.getInterlacingHor() != null) {
                axisArea.getInterlacingHor().getCore().applyStyle(style);
            }
            if (axisArea.getInterlacingVert() != null) {
                axisArea.getInterlacingVert().getCore().applyStyle(style);
            }
            if (axisArea.getGridLinesHor() != null) {
                axisArea.getGridLinesHor().getCore().applyStyle(style);
            }
            if (axisArea.getGridLinesVert() != null) {
                axisArea.getGridLinesVert().getCore().applyStyle(style);
            }
            if (axisArea.getXAxis() != null) {
                axisArea.getXAxis().getCore().applyStyle(style);
            }
            if (axisArea.getXTopAxis() != null) {
                axisArea.getXTopAxis().getCore().applyStyle(style);
            }
            if (axisArea.getYAxis() != null) {
                axisArea.getYAxis().getCore().applyStyle(style);
            }
            if (axisArea.getYRightAxis() != null) {
                axisArea.getYRightAxis().getCore().applyStyle(style);
            }
        }
    }

    @Override
    public StiCellGeom Render(StiContext context, StiRectangle rect) {
        IStiArea tempVar = this.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        axisArea.getYAxis().getInfo().Minimum = 0.0;
        axisArea.getYAxis().getInfo().Maximum = 0.0;
        axisArea.getYRightAxis().getInfo().Minimum = 0.0;
        axisArea.getYRightAxis().getInfo().Maximum = 0.0;
        axisArea.getXAxis().getInfo().Minimum = 0.0;
        axisArea.getXAxis().getInfo().Maximum = 0.0;
        axisArea.getXTopAxis().getInfo().Minimum = 0.0;
        axisArea.getXTopAxis().getInfo().Maximum = 0.0;
        this.PrepareInfo(rect);
        StiCellGeom axisYLeftViewGeom = null;
        StiCellGeom axisYCenterViewGeom = null;
        StiCellGeom axisYRightViewGeom = null;
        StiCellGeom axisXTopViewGeom = null;
        StiCellGeom axisXCenterViewGeom = null;
        StiCellGeom axisXBottomViewGeom = null;
        StiYAxisGeom axisYLeftGeom = null;
        StiYAxisGeom axisYCenterGeom = null;
        StiYAxisGeom axisYRightGeom = null;
        StiXAxisGeom axisXTopGeom = null;
        StiXAxisGeom axisXCenterGeom = null;
        StiXAxisGeom axisXBottomGeom = null;
        StiRectangle rectYLeftAxis = StiRectangle.getEmpty();
        StiRectangle rectYCenterAxis = StiRectangle.getEmpty();
        StiRectangle rectYRightAxis = StiRectangle.getEmpty();
        StiRectangle rectXTopAxis = StiRectangle.getEmpty();
        StiRectangle rectXCenterAxis = StiRectangle.getEmpty();
        StiRectangle rectXBottomAxis = StiRectangle.getEmpty();
        StiRectangle viewRect = StiRectangle.getEmpty();
        ArrayList<IStiSeries> seriesCollection = axisArea.getCore().GetSeries();
        if (seriesCollection.size() > 0) {
            double widhtLegendTableChart;
            rectYLeftAxis = ((StiYAxisCoreXF)axisArea.getYAxis().getCore()).GetAxisRect(context, rect, true, true, false, true);
            rectYCenterAxis = ((StiYAxisCoreXF)axisArea.getYAxis().getCore()).GetCenterAxisRect(context, rect, true, true, false);
            rectYRightAxis = ((StiYRightAxisCoreXF)axisArea.getYRightAxis().getCore()).GetAxisRect(context, rect, true, true, false, true);
            rectXTopAxis = ((StiXTopAxisCoreXF)axisArea.getXTopAxis().getCore()).GetAxisRect(context, rect, true, true, false, true);
            rectXCenterAxis = ((StiXAxisCoreXF)axisArea.getXAxis().getCore()).GetCenterAxisRect(context, rect, true, true, false);
            rectXBottomAxis = ((StiXAxisCoreXF)axisArea.getXAxis().getCore()).GetAxisRect(context, rect, true, true, false, true);
            if (this.getArea().getChart().getTable().getCore().ShowTable() && (widhtLegendTableChart = this.getArea().getChart().getTable().getCore().GetWidthCellLegend(context)) > rectYLeftAxis.getWidth()) {
                rectYLeftAxis.width = widhtLegendTableChart;
                rectYLeftAxis.x = -widhtLegendTableChart;
                if (rectYLeftAxis.height == 0.0) {
                    rectYLeftAxis.height = 1.0;
                }
            }
            if (!rectYLeftAxis.isEmpty().booleanValue()) {
                rectYLeftAxis.x += rect.x;
                rectYLeftAxis.y += rect.y;
            }
            if (!rectYCenterAxis.isEmpty().booleanValue()) {
                rectYCenterAxis.x += rect.x;
                rectYCenterAxis.y += rect.y;
            }
            if (!rectYRightAxis.isEmpty().booleanValue()) {
                rectYRightAxis.x += rect.x;
                rectYRightAxis.y += rect.y;
            }
            if (!rectXTopAxis.isEmpty().booleanValue()) {
                rectXTopAxis.x += rect.x;
                rectXTopAxis.y += rect.y;
            }
            if (!rectXCenterAxis.isEmpty().booleanValue()) {
                rectXCenterAxis.x += rect.x;
                rectXCenterAxis.y += rect.y;
            }
            if (!rectXBottomAxis.isEmpty().booleanValue()) {
                rectXBottomAxis.x += rect.x;
                rectXBottomAxis.y += rect.y;
            }
            double distTop = 0.0;
            double distBottom = 0.0;
            double distLeft = 0.0;
            double distRight = 0.0;
            if (!rectYLeftAxis.isEmpty().booleanValue()) {
                distLeft = rectYLeftAxis.width;
                if (rectYLeftAxis.getTop() < rect.getTop()) {
                    distTop = Math.abs(rect.getTop() - rectYLeftAxis.getTop());
                }
                if (rect.getBottom() < rectYLeftAxis.getBottom()) {
                    distBottom = Math.abs(rectYLeftAxis.getBottom() - rect.getBottom());
                }
            }
            if (!rectYRightAxis.isEmpty().booleanValue()) {
                distRight = rectYRightAxis.width;
                if (rectYRightAxis.getTop() < rect.getTop()) {
                    distTop = Math.max(distTop, Math.abs(rect.getTop() - rectYRightAxis.getTop()));
                }
                if (rect.getBottom() < rectYRightAxis.getBottom()) {
                    distBottom = Math.max(distBottom, Math.abs(rectYRightAxis.getBottom() - rect.getBottom()));
                }
            }
            if (!rectXTopAxis.isEmpty().booleanValue()) {
                distTop = Math.max(rectXTopAxis.height, distTop);
                if (rectXTopAxis.x < rect.x) {
                    distLeft = Math.max(distLeft, Math.abs(rect.getLeft() - rectXTopAxis.getLeft()));
                }
                if (rect.getRight() < rectXTopAxis.getRight()) {
                    distRight = Math.max(distRight, Math.abs(rectXTopAxis.getRight() - rect.getRight()));
                }
            }
            if (!rectXBottomAxis.isEmpty().booleanValue()) {
                distBottom = Math.max(rectXBottomAxis.height, distBottom);
                if (rectXBottomAxis.x < rect.x) {
                    distLeft = Math.max(distLeft, Math.abs(rect.getLeft() - rectXBottomAxis.getLeft()));
                }
                if (rect.getRight() < rectXBottomAxis.getRight()) {
                    distRight = Math.max(distRight, Math.abs(rectXBottomAxis.getRight() - rect.getRight()));
                }
            }
            if (axisArea.getReverseHor()) {
                StiRefObject tempRef_distLeft = new StiRefObject((Object)distLeft);
                StiRefObject tempRef_distRight = new StiRefObject((Object)distRight);
                this.Swap((StiRefObject<Double>)tempRef_distLeft, (StiRefObject<Double>)tempRef_distRight);
                distLeft = (Double)tempRef_distLeft.argvalue;
                distRight = (Double)tempRef_distRight.argvalue;
            }
            if (axisArea.getReverseVert()) {
                StiRefObject tempRef_distTop = new StiRefObject((Object)distTop);
                StiRefObject tempRef_distBottom = new StiRefObject((Object)distBottom);
                this.Swap((StiRefObject<Double>)tempRef_distTop, (StiRefObject<Double>)tempRef_distBottom);
                distTop = (Double)tempRef_distTop.argvalue;
                distBottom = (Double)tempRef_distBottom.argvalue;
            }
            rect.x += distLeft;
            rect.width -= distLeft + distRight;
            rect.y += distTop;
            rect.height -= distTop + distBottom;
            this.PrepareInfo(rect);
            StiCellGeom tempVar2 = axisArea.getYAxis().getCore().RenderView(context, rect);
            axisYLeftViewGeom = (StiYAxisViewGeom)(tempVar2 instanceof StiYAxisViewGeom ? tempVar2 : null);
            StiCellGeom tempVar3 = ((StiYAxisCoreXF)axisArea.getYAxis().getCore()).RenderCenterView(context, rect);
            axisYCenterViewGeom = (StiYAxisViewGeom)(tempVar3 instanceof StiYAxisViewGeom ? tempVar3 : null);
            StiCellGeom tempVar4 = axisArea.getYRightAxis().getCore().RenderView(context, rect);
            axisYRightViewGeom = (StiYAxisViewGeom)(tempVar4 instanceof StiYAxisViewGeom ? tempVar4 : null);
            StiCellGeom tempVar5 = axisArea.getXTopAxis().getCore().RenderView(context, rect);
            axisXTopViewGeom = (StiXAxisViewGeom)(tempVar5 instanceof StiXAxisViewGeom ? tempVar5 : null);
            StiCellGeom tempVar6 = ((StiXAxisCoreXF)axisArea.getXAxis().getCore()).RenderCenterView(context, rect);
            axisXCenterViewGeom = (StiXAxisViewGeom)(tempVar6 instanceof StiXAxisViewGeom ? tempVar6 : null);
            StiCellGeom tempVar7 = axisArea.getXAxis().getCore().RenderView(context, rect);
            axisXBottomViewGeom = (StiXAxisViewGeom)(tempVar7 instanceof StiXAxisViewGeom ? tempVar7 : null);
        }
        viewRect = rect.clone();
        double scrollFactorX = this.CalculateScrollValuesX(rect, axisArea);
        double scrollFactorY = this.CalculateScrollValuesY(rect, axisArea);
        rect.x = -((float)this.getScrollDistanceX());
        rect.y = -((float)this.getScrollDistanceY());
        rect.width *= (double)((float)scrollFactorX);
        rect.height *= (double)((float)scrollFactorY);
        this.PrepareInfo(rect);
        if (seriesCollection.size() > 0) {
            StiCellGeom tempVar8 = axisArea.getYAxis().getCore().Render(context, rect);
            axisYLeftGeom = (StiYAxisGeom)(tempVar8 instanceof StiYAxisGeom ? tempVar8 : null);
            StiCellGeom tempVar9 = ((StiYAxisCoreXF)axisArea.getYAxis().getCore()).RenderCenter(context, rect);
            axisYCenterGeom = (StiYAxisGeom)(tempVar9 instanceof StiYAxisGeom ? tempVar9 : null);
            StiCellGeom tempVar10 = axisArea.getYRightAxis().getCore().Render(context, rect);
            axisYRightGeom = (StiYAxisGeom)(tempVar10 instanceof StiYAxisGeom ? tempVar10 : null);
            StiCellGeom tempVar11 = axisArea.getXTopAxis().getCore().Render(context, rect);
            axisXTopGeom = (StiXAxisGeom)(tempVar11 instanceof StiXAxisGeom ? tempVar11 : null);
            StiCellGeom tempVar12 = ((StiXAxisCoreXF)axisArea.getXAxis().getCore()).RenderCenter(context, rect);
            axisXCenterGeom = (StiXAxisGeom)(tempVar12 instanceof StiXAxisGeom ? tempVar12 : null);
            StiCellGeom tempVar13 = axisArea.getXAxis().getCore().Render(context, rect);
            axisXBottomGeom = (StiXAxisGeom)(tempVar13 instanceof StiXAxisGeom ? tempVar13 : null);
            if (axisYLeftGeom != null) {
                axisYLeftGeom.setView((StiYAxisViewGeom)axisYLeftViewGeom);
            }
            if (axisYCenterGeom != null) {
                axisYCenterGeom.setView((StiYAxisViewGeom)axisYCenterViewGeom);
            }
            if (axisYRightGeom != null) {
                axisYRightGeom.setView((StiYAxisViewGeom)axisYRightViewGeom);
            }
            if (axisXTopGeom != null) {
                axisXTopGeom.setView((StiXAxisViewGeom)axisXTopViewGeom);
            }
            if (axisXCenterGeom != null) {
                axisXCenterGeom.setView((StiXAxisViewGeom)axisXCenterViewGeom);
            }
            if (axisXBottomGeom != null) {
                axisXBottomGeom.setView((StiXAxisViewGeom)axisXBottomViewGeom);
            }
        }
        if (axisXBottomViewGeom != null) {
            ((StiXAxisCoreXF)axisArea.getXAxis().getCore()).RenderScrollBar(context, axisXBottomViewGeom.getClientRectangle(), (StiXAxisViewGeom)axisXBottomViewGeom);
        }
        if (axisXTopViewGeom != null) {
            ((StiXAxisCoreXF)axisArea.getXTopAxis().getCore()).RenderScrollBar(context, axisXTopViewGeom.getClientRectangle(), (StiXAxisViewGeom)axisXTopViewGeom);
        }
        if (axisYLeftViewGeom != null) {
            ((StiYAxisCoreXF)axisArea.getYAxis().getCore()).RenderScrollBar(context, axisYLeftViewGeom.getClientRectangle(), (StiYAxisViewGeom)axisYLeftViewGeom);
        }
        if (axisYRightViewGeom != null) {
            ((StiYAxisCoreXF)axisArea.getYRightAxis().getCore()).RenderScrollBar(context, axisYRightViewGeom.getClientRectangle(), (StiYAxisViewGeom)axisYRightViewGeom);
        }
        StiAxisAreaViewGeom viewGeom = new StiAxisAreaViewGeom(axisArea, viewRect);
        StiAxisAreaGeom geom = new StiAxisAreaGeom(viewGeom, axisArea, rect);
        viewGeom.CreateChildGeoms();
        viewGeom.getChildGeoms().add(geom);
        for (IStiStrips strip : this.getArea().getChart().getStrips()) {
            if (!strip.getShowBehind()) continue;
            strip.getCore().Render(context, geom, rect);
        }
        for (IStiConstantLines line : this.getArea().getChart().getConstantLines()) {
            if (!line.getShowBehind()) continue;
            line.getCore().Render(context, geom, rect);
        }
        this.RenderSeries(context, rect, geom, seriesCollection);
        for (IStiStrips strip : this.getArea().getChart().getStrips()) {
            if (strip.getShowBehind()) continue;
            strip.getCore().Render(context, geom, rect);
        }
        for (IStiConstantLines line : this.getArea().getChart().getConstantLines()) {
            if (line.getShowBehind()) continue;
            line.getCore().Render(context, geom, rect);
        }
        if (axisYLeftGeom != null) {
            viewGeom.CreateChildGeoms();
            axisYLeftViewGeom.CreateChildGeoms();
            viewGeom.getChildGeoms().add(axisYLeftViewGeom);
            axisYLeftViewGeom.getChildGeoms().add(axisYLeftGeom);
        }
        if (axisYCenterGeom != null) {
            viewGeom.CreateChildGeoms();
            axisYCenterViewGeom.CreateChildGeoms();
            viewGeom.getChildGeoms().add(axisYCenterViewGeom);
            axisYCenterViewGeom.getChildGeoms().add(axisYCenterGeom);
        }
        if (axisYRightGeom != null) {
            viewGeom.CreateChildGeoms();
            axisYRightViewGeom.CreateChildGeoms();
            viewGeom.getChildGeoms().add(axisYRightViewGeom);
            axisYRightViewGeom.getChildGeoms().add(axisYRightGeom);
        }
        if (axisXTopGeom != null) {
            viewGeom.CreateChildGeoms();
            axisXTopViewGeom.CreateChildGeoms();
            viewGeom.getChildGeoms().add(axisXTopViewGeom);
            axisXTopViewGeom.getChildGeoms().add(axisXTopGeom);
        }
        if (axisXCenterGeom != null) {
            viewGeom.CreateChildGeoms();
            axisXCenterViewGeom.CreateChildGeoms();
            viewGeom.getChildGeoms().add(axisXCenterViewGeom);
            axisXCenterViewGeom.getChildGeoms().add(axisXCenterGeom);
        }
        if (axisXBottomGeom != null && !this.getArea().getChart().getTable().getCore().ShowTable()) {
            viewGeom.CreateChildGeoms();
            axisXBottomViewGeom.CreateChildGeoms();
            viewGeom.getChildGeoms().add(axisXBottomViewGeom);
            axisXBottomViewGeom.getChildGeoms().add(axisXBottomGeom);
        }
        return viewGeom;
    }

    private double CalculateScrollValuesX(StiRectangle rect, IStiAxisArea axisArea) {
        double maximum;
        double minimum;
        double scrollFactorX = 1.0;
        if (!this.IsAutoRangeXAxis(axisArea.getXAxis())) {
            minimum = axisArea.getXAxis().getRange().getMinimum();
            if (minimum > (maximum = axisArea.getXAxis().getRange().getMaximum())) {
                minimum = axisArea.getXAxis().getInfo().Minimum;
                maximum = axisArea.getXAxis().getInfo().Maximum;
            }
        } else {
            minimum = axisArea.getXAxis().getInfo().Minimum;
            maximum = axisArea.getXAxis().getInfo().Maximum;
        }
        this.scrollRangeX = axisArea.getXAxis().getInfo().Maximum - axisArea.getXAxis().getInfo().Minimum;
        this.scrollViewX = maximum - minimum;
        if (!axisArea.getXAxis().getCore().GetStartFromZero() || axisArea.getXAxis().getLogarithmicScale()) {
            this.setBlockScrollValueX(true);
        } else {
            this.setBlockScrollValueX(false);
        }
        if (!this.getBlockScrollValueX() && !axisArea.getXAxis().getInteraction().getShowScrollBar()) {
            double value = minimum + Math.abs(axisArea.getXAxis().getInfo().Minimum);
            this.scrollValueX = !axisArea.getReverseHor() ? value : this.scrollRangeX - value - this.scrollViewX;
        }
        scrollFactorX = this.getScrollRangeX() / this.getScrollViewX();
        this.scrollDpiX = rect.width * scrollFactorX / this.getScrollRangeX();
        return scrollFactorX;
    }

    private double CalculateScrollValuesY(StiRectangle rect, IStiAxisArea axisArea) {
        double maximum;
        double minimum;
        double scrollFactorY = 1.0;
        if (!this.IsAutoRangeYAxis(axisArea.getYAxis())) {
            minimum = axisArea.getYAxis().getRange().getMinimum();
            if (minimum > (maximum = axisArea.getYAxis().getRange().getMaximum())) {
                minimum = axisArea.getYAxis().getInfo().Minimum;
                maximum = axisArea.getYAxis().getInfo().Maximum;
            }
        } else {
            minimum = axisArea.getYAxis().getInfo().Minimum;
            maximum = axisArea.getYAxis().getInfo().Maximum;
        }
        this.scrollRangeY = axisArea.getYAxis().getInfo().Maximum - axisArea.getYAxis().getInfo().Minimum;
        this.scrollViewY = maximum - minimum;
        if (!axisArea.getYAxis().getCore().GetStartFromZero() || axisArea.getYAxis().getLogarithmicScale()) {
            this.setBlockScrollValueY(true);
        } else {
            this.setBlockScrollValueY(false);
        }
        if (!this.getBlockScrollValueY()) {
            double value = minimum + Math.abs(axisArea.getYAxis().getInfo().Minimum);
            this.scrollValueY = axisArea.getReverseVert() ? value : this.scrollRangeY - value - this.scrollViewY;
        } else {
            this.scrollValueY = 0.0;
        }
        scrollFactorY = this.getScrollRangeY() / this.getScrollViewY();
        this.scrollDpiY = rect.height * scrollFactorY / this.getScrollRangeY();
        return scrollFactorY;
    }

    @Override
    protected void PrepareInfo(StiRectangle rect) {
        ArrayList<IStiSeries> seriesCollection = this.GetSeries();
        if (seriesCollection.size() > 0) {
            Object tempVar10;
            IStiArea tempVar = this.getArea();
            IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
            this.ValuesCount = 0;
            IStiAxis specXAxis = this instanceof StiClusteredBarAreaCoreXF ? axisArea.getYAxis() : axisArea.getXAxis();
            IStiAxis specXTopAxis = this instanceof StiClusteredBarAreaCoreXF ? axisArea.getYRightAxis() : axisArea.getXTopAxis();
            IStiAxis specYAxis = this instanceof StiClusteredBarAreaCoreXF ? axisArea.getXAxis() : axisArea.getYAxis();
            IStiAxis specYRightAxis = this instanceof StiClusteredBarAreaCoreXF ? axisArea.getXTopAxis() : axisArea.getYRightAxis();
            specXAxis.getInfo().StripLines = new StiStripLinesXF();
            specYAxis.getInfo().StripLines = new StiStripLinesXF();
            specYRightAxis.getInfo().StripLines = new StiStripLinesXF();
            boolean isDateTimeValues = false;
            for (int index = 0; index < seriesCollection.size(); ++index) {
                Double[] values = seriesCollection.get(index).getValues();
                if (values != null) {
                    this.ValuesCount = Math.max(values.length, this.ValuesCount);
                }
                if (!seriesCollection.get(index).getCore().getIsDateTimeValues()) continue;
                isDateTimeValues = true;
            }
            this.PrepareRange(specXAxis, specXTopAxis, specYAxis, specYRightAxis);
            if (!specYAxis.getRange().getAuto() && specYAxis.getRange().getMaximum() > specYAxis.getInfo().Maximum) {
                specYAxis.getInfo().Maximum = specYAxis.getRange().getMaximum();
            }
            if (!specYAxis.getRange().getAuto() && specYAxis.getRange().getMinimum() < specYAxis.getInfo().Minimum) {
                specYAxis.getInfo().Minimum = specYAxis.getRange().getMinimum();
            }
            if (!specYRightAxis.getRange().getAuto() && specYRightAxis.getRange().getMaximum() > specYRightAxis.getInfo().Maximum) {
                specYRightAxis.getInfo().Maximum = specYRightAxis.getRange().getMaximum();
            }
            if (!specYRightAxis.getRange().getAuto() && specYRightAxis.getRange().getMinimum() < specYRightAxis.getInfo().Minimum) {
                specYRightAxis.getInfo().Minimum = specYRightAxis.getRange().getMinimum();
            }
            boolean isScatterSeries = false;
            if (this.getArea().getChart().getSeries().size() > 0 && this.getArea().getChart().getSeries().get(0) instanceof StiScatterLineSeries) {
                isScatterSeries = true;
            }
            if (!specYAxis.getLogarithmicScale() || !isScatterSeries) {
                this.CheckStartFromZeroYAxis(specYAxis);
                this.CheckStartFromZeroYAxis(specYRightAxis);
                this.CalculateMinimumAndMaximumYAxis(specYAxis);
                if (specYRightAxis.getRange().getAuto()) {
                    this.CalculateMinimumAndMaximumYAxis(specYRightAxis);
                }
            }
            this.CalculateMinimumAndMaximumXAxis(specXAxis);
            this.CreateStripLinesXAxis(specXAxis);
            this.CreateStripLinesYAxis(specYAxis, isDateTimeValues);
            this.CreateStripLinesYAxis(specYRightAxis, isDateTimeValues);
            this.CheckStripLinesAndMaximumMinimumXAxis(specXAxis);
            this.CheckStripLinesAndMaximumMinimumYAxis(specYAxis);
            this.CheckStripLinesAndMaximumMinimumYAxis(specYRightAxis);
            if (axisArea instanceof IStiClusteredBarArea) {
                StiAxisAreaCoreXF.RotateStripLines(specXAxis);
                StiAxisAreaCoreXF.RotateStripLines(specYAxis);
                StiAxisAreaCoreXF.RotateStripLines(specYRightAxis);
            }
            specXTopAxis.setInfo((StiAxisInfoXF)((tempVar10 = specXAxis.getInfo().clone()) instanceof StiAxisInfoXF ? tempVar10 : null));
            if (axisArea.getReverseHor()) {
                StiAxisAreaCoreXF.RotateStripLines(axisArea.getXAxis());
                StiAxisAreaCoreXF.RotateStripLines(axisArea.getXTopAxis());
            }
            if (axisArea.getReverseVert()) {
                StiAxisAreaCoreXF.RotateStripLines(axisArea.getYAxis());
                StiAxisAreaCoreXF.RotateStripLines(axisArea.getYRightAxis());
            }
            axisArea.getXAxis().getInfo().Dpi = rect.width / axisArea.getXAxis().getInfo().getRange();
            axisArea.getXTopAxis().getInfo().Dpi = rect.width / axisArea.getXTopAxis().getInfo().getRange();
            axisArea.getYAxis().getInfo().Dpi = rect.height / axisArea.getYAxis().getInfo().getRange();
            axisArea.getYRightAxis().getInfo().Dpi = rect.height / axisArea.getYRightAxis().getInfo().getRange();
            this.CalculateStepX(axisArea.getXAxis(), rect.getLeft(), rect.getRight());
            this.CalculateStepX(axisArea.getXTopAxis(), rect.getLeft(), rect.getRight());
            this.CalculateStepY(axisArea.getYAxis(), rect.getTop(), rect.getBottom());
            this.CalculateStepY(axisArea.getYRightAxis(), rect.getTop(), rect.getBottom());
            StiRefObject tempRef_LabelsCollection = new StiRefObject(axisArea.getXAxis().getInfo().LabelsCollection);
            this.CalculatePositions(axisArea.getXAxis(), (StiRefObject<ArrayList<StiStripPositionXF>>)tempRef_LabelsCollection, axisArea.getXAxis().getLabels().getStep() > 0.0 ? (int)axisArea.getXAxis().getLabels().getStep() : 1);
            axisArea.getXAxis().getInfo().LabelsCollection = (ArrayList)tempRef_LabelsCollection.argvalue;
            StiRefObject tempRef_LabelsCollection2 = new StiRefObject(axisArea.getXTopAxis().getInfo().LabelsCollection);
            this.CalculatePositions(axisArea.getXTopAxis(), (StiRefObject<ArrayList<StiStripPositionXF>>)tempRef_LabelsCollection2, axisArea.getXTopAxis().getLabels().getStep() > 0.0 ? (int)axisArea.getXTopAxis().getLabels().getStep() : 1);
            axisArea.getXTopAxis().getInfo().LabelsCollection = (ArrayList)tempRef_LabelsCollection2.argvalue;
            StiRefObject tempRef_LabelsCollection3 = new StiRefObject(axisArea.getYAxis().getInfo().LabelsCollection);
            this.CalculatePositions(axisArea.getYAxis(), (StiRefObject<ArrayList<StiStripPositionXF>>)tempRef_LabelsCollection3, axisArea.getYAxis().getLabels().getStep() > 0.0 ? (int)axisArea.getYAxis().getLabels().getStep() : 1);
            axisArea.getYAxis().getInfo().LabelsCollection = (ArrayList)tempRef_LabelsCollection3.argvalue;
            StiRefObject tempRef_LabelsCollection4 = new StiRefObject(axisArea.getYRightAxis().getInfo().LabelsCollection);
            this.CalculatePositions(axisArea.getYRightAxis(), (StiRefObject<ArrayList<StiStripPositionXF>>)tempRef_LabelsCollection4, axisArea.getYRightAxis().getLabels().getStep() > 0.0 ? (int)axisArea.getYRightAxis().getLabels().getStep() : 1);
            axisArea.getYRightAxis().getInfo().LabelsCollection = (ArrayList)tempRef_LabelsCollection4.argvalue;
            StiRefObject tempRef_TicksCollection = new StiRefObject(axisArea.getXAxis().getInfo().TicksCollection);
            this.CalculatePositions(axisArea.getXAxis(), (StiRefObject<ArrayList<StiStripPositionXF>>)tempRef_TicksCollection, axisArea.getXAxis().getTicks().getStep() > 0 ? axisArea.getXAxis().getTicks().getStep() : 1);
            axisArea.getXAxis().getInfo().TicksCollection = (ArrayList)tempRef_TicksCollection.argvalue;
            StiRefObject tempRef_TicksCollection2 = new StiRefObject(axisArea.getXTopAxis().getInfo().TicksCollection);
            this.CalculatePositions(axisArea.getXTopAxis(), (StiRefObject<ArrayList<StiStripPositionXF>>)tempRef_TicksCollection2, axisArea.getXTopAxis().getTicks().getStep() > 0 ? axisArea.getXTopAxis().getTicks().getStep() : 1);
            axisArea.getXTopAxis().getInfo().TicksCollection = (ArrayList)tempRef_TicksCollection2.argvalue;
            StiRefObject tempRef_TicksCollection3 = new StiRefObject(axisArea.getYAxis().getInfo().TicksCollection);
            this.CalculatePositions(axisArea.getYAxis(), (StiRefObject<ArrayList<StiStripPositionXF>>)tempRef_TicksCollection3, axisArea.getYAxis().getTicks().getStep() > 0 ? axisArea.getYAxis().getTicks().getStep() : 1);
            axisArea.getYAxis().getInfo().TicksCollection = (ArrayList)tempRef_TicksCollection3.argvalue;
            StiRefObject tempRef_TicksCollection4 = new StiRefObject(axisArea.getYRightAxis().getInfo().TicksCollection);
            this.CalculatePositions(axisArea.getYRightAxis(), (StiRefObject<ArrayList<StiStripPositionXF>>)tempRef_TicksCollection4, axisArea.getYRightAxis().getTicks().getStep() > 0 ? axisArea.getYRightAxis().getTicks().getStep() : 1);
            axisArea.getYRightAxis().getInfo().TicksCollection = (ArrayList)tempRef_TicksCollection4.argvalue;
        }
    }

    private void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, ArrayList<IStiSeries> seriesCollection) {
        ArrayList<ArrayList<IStiSeries>> seriesTypes = new ArrayList<ArrayList<IStiSeries>>();
        Hashtable seriesTypesHash = new Hashtable();
        for (IStiSeries iStiSeries : seriesCollection) {
            if (!this.IsAcceptableSeries(iStiSeries.getClass())) continue;
            ArrayList<IStiSeries> list = seriesTypesHash.get(iStiSeries.getClass()) instanceof ArrayList ? seriesTypesHash.get(iStiSeries.getClass()) : null;
            if (list == null) {
                list = new ArrayList<IStiSeries>();
                seriesTypes.add(list);
                seriesTypesHash.put(iStiSeries.getClass(), list);
            }
            list.add(iStiSeries);
        }
        for (ArrayList arrayList : seriesTypes) {
            IStiSeries[] seriesArray = new IStiSeries[arrayList.size()];
            seriesArray = arrayList.toArray(seriesArray);
            seriesArray[0].getCore().RenderSeries(context, rect, geom, seriesArray);
        }
    }

    public final boolean IsAutoRangeXAxis(IStiAxis axis) {
        return axis.getRange().getAuto() || axis.getRange().getMinimum() >= axis.getRange().getMaximum() || axis.getLogarithmicScale();
    }

    public final boolean IsAutoRangeYAxis(IStiAxis axis) {
        return axis.getRange().getAuto() || axis.getRange().getMaximum() == axis.getRange().getMinimum() || this.getArea().getIsDefaultSeriesTypeFullStackedColumnSeries() || axis.getLogarithmicScale();
    }

    public final void CalculateMinimumAndMaximumXAxis(IStiAxis axis) {
        if (!axis.getRange().getAuto()) {
            axis.getInfo().Maximum = axis.getRange().getMaximum();
            axis.getInfo().Minimum = axis.getRange().getMinimum();
        }
    }

    public final void CalculateMinimumAndMaximumYAxis(IStiAxis axis) {
        if (this.GetSeries().size() > 0 && this.GetSeries().get(0) instanceof StiGanttSeries) {
            if (!axis.getRange().getAuto()) {
                axis.getInfo().Maximum = axis.getRange().getMaximum();
                axis.getInfo().Minimum = axis.getRange().getMinimum();
            }
            return;
        }
        if (!axis.getStartFromZero() && axis.getRange().getAuto() && axis instanceof IStiYAxis) {
            double range = (axis.getInfo().Maximum - axis.getInfo().Minimum) * 0.05;
            axis.getInfo().Minimum -= range;
            axis.getInfo().Maximum += range;
            if (axis.getInfo().Minimum < 0.0 && axis.getInfo().Minimum + range >= 0.0) {
                axis.getInfo().Minimum = 0.0;
            }
        } else {
            double minDelts = 0.1;
            if (this.GetSeries().size() > 0 && this.GetSeries().get(0).getSeriesLabels() instanceof StiOutsideEndAxisLabels) {
                minDelts = 0.15;
            }
            double delta = Math.min(minDelts, Math.abs(4.0 / ((axis.getInfo().Maximum + axis.getInfo().Minimum) / 2.0)));
            axis.getInfo().Maximum *= 1.0 + delta * Math.signum(axis.getInfo().Maximum);
            axis.getInfo().Minimum *= 1.0 - delta * Math.signum(axis.getInfo().Minimum);
        }
        if (axis.getInfo().Minimum == axis.getInfo().Maximum) {
            if (axis.getInfo().Maximum == 0.0) {
                axis.getInfo().Maximum = 100.0;
            } else {
                axis.getInfo().Minimum -= axis.getInfo().Minimum * 0.1;
                axis.getInfo().Maximum += axis.getInfo().Maximum * 0.1;
            }
        }
    }

    public final String GetArgumentLabel(StiStripLineXF line, IStiSeries series) {
        if (line == null) {
            return "";
        }
        IStiArea tempVar = this.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        if (axisArea.getCore().getSeriesOrientation() == StiChartSeriesOrientation.Vertical) {
            return ((StiXAxisCoreXF)axisArea.getXAxis().getCore()).GetLabelText(line, series);
        }
        return ((StiYAxisCoreXF)axisArea.getYAxis().getCore()).GetLabelText(line, series);
    }

    public final void SwitchOff() {
        IStiArea tempVar = this.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        axisArea.getGridLinesHor().setVisible(false);
        axisArea.getGridLinesVert().setVisible(false);
        axisArea.getInterlacingHor().setVisible(false);
        axisArea.getInterlacingVert().setVisible(false);
        axisArea.getXAxis().setVisible(false);
        axisArea.getYAxis().setVisible(false);
        axisArea.getXTopAxis().setVisible(false);
        axisArea.getYRightAxis().setVisible(false);
    }

    private void Swap(StiRefObject<Double> value1, StiRefObject<Double> value2) {
        double temp = (Double)value1.argvalue;
        value1.argvalue = value2.argvalue;
        value2.argvalue = temp;
    }

    protected void PrepareRange(IStiAxis specXAxis, IStiAxis specXTopAxis, IStiAxis specYAxis, IStiAxis specYRightAxis) {
    }

    protected void CreateStripLinesXAxis(IStiAxis axis) {
        boolean getStartFromZero = axis.getCore().GetStartFromZero();
        int fromValue = getStartFromZero ? 0 : 1;
        int toValue = getStartFromZero ? this.ValuesCount + 1 : this.ValuesCount;
        for (int index = fromValue; index <= toValue; ++index) {
            axis.getInfo().StripLines.add(new StiStripLineXF(index, index));
        }
        ArrayList<IStiSeries> seriesCollection = this.GetSeries();
        for (IStiSeries series : seriesCollection) {
            for (int index = 0; index < this.ValuesCount; ++index) {
                int finalIndex;
                Object valueObject = null;
                if (series.getArguments() != null && index < series.getArguments().length && (valueObject = series.getArguments()[index]) == null || valueObject == null) continue;
                int n = finalIndex = getStartFromZero ? 1 + index : index;
                if (finalIndex >= axis.getInfo().StripLines.size()) continue;
                ((StiStripLineXF)axis.getInfo().StripLines.get(finalIndex)).setValueObject(valueObject);
            }
        }
        if (axis.getInfo().StripLines.size() > 0 && !axis.getArea().getXAxis().getShowEdgeValues()) {
            ((StiStripLineXF)axis.getInfo().StripLines.get(0)).setValueObject(null);
            ((StiStripLineXF)axis.getInfo().StripLines.get(axis.getInfo().StripLines.size() - 1)).setValueObject(null);
        }
    }

    protected void CreateStripLinesYAxis(IStiAxis axis, boolean isDateTimeValues) {
        if (this.getArea().getIsDefaultSeriesTypeFullStackedColumnSeries() || this.getArea().getIsDefaultSeriesTypeFullStackedBarSeries()) {
            double step;
            double maximum;
            boolean positivePresent = false;
            boolean negativePresent = false;
            ArrayList<IStiSeries> seriesCollection = this.GetSeries();
            for (IStiSeries series : seriesCollection) {
                for (Double value : series.getValues()) {
                    if (value > 0.0) {
                        positivePresent = true;
                    }
                    if (!(value < 0.0)) continue;
                    negativePresent = true;
                }
            }
            double minimum = negativePresent ? -100.0 : 0.0;
            double d = maximum = positivePresent ? 100.0 : 0.0;
            if (minimum == 0.0 && maximum == 0.0) {
                maximum = 100.0;
            }
            if ((step = axis.getLabels().getStep()) == 0.0) {
                step = StiStripLineCalculatorXF.GetInterval(minimum, maximum, 6);
            }
            axis.getInfo().StripLines = StiStripLineCalculatorXF.GetStripLines(minimum, maximum, step, false);
            for (StiStripLineXF stripLine : axis.getInfo().StripLines) {
                stripLine.setValueObject(String.format("%1$s%%", stripLine.getValueObject()));
            }
        } else {
            double step = axis.getLabels().getStep();
            if (step > 0.0 && axis.getInfo().getRange() > 0.0 && axis.getInfo().getRange() / step > 500.0) {
                step = 0.0;
            }
            if (step == 0.0) {
                step = StiStripLineCalculatorXF.GetInterval(axis.getInfo().Minimum, axis.getInfo().Maximum, 6);
            }
            axis.getInfo().StripLines = StiStripLineCalculatorXF.GetStripLines(axis.getInfo().Minimum, axis.getInfo().Maximum, step, isDateTimeValues);
        }
    }

    protected void CheckStripLinesAndMaximumMinimumXAxis(IStiAxis axis) {
        if (axis.getInfo().StripLines.size() > 0) {
            axis.getInfo().Minimum = ((StiStripLineXF)axis.getInfo().StripLines.get(0)).getValue();
            axis.getInfo().Maximum = ((StiStripLineXF)axis.getInfo().StripLines.get(axis.getInfo().StripLines.size() - 1)).getValue();
        } else {
            axis.getInfo().Minimum = 0.0;
            axis.getInfo().Maximum = 1.0;
        }
    }

    protected void CheckStripLinesAndMaximumMinimumYAxis(IStiAxis axis) {
        if (axis.getInfo().StripLines.size() > 0) {
            axis.getInfo().Maximum = ((StiStripLineXF)axis.getInfo().StripLines.get(0)).getValue();
            axis.getInfo().Minimum = ((StiStripLineXF)axis.getInfo().StripLines.get(axis.getInfo().StripLines.size() - 1)).getValue();
        } else {
            axis.getInfo().Maximum = 100.0;
            axis.getInfo().Minimum = 0.0;
        }
    }

    private void CalculateStepX(IStiAxis axis, double topPosition, double bottomPosition) {
        if (axis.getInfo().StripLines.size() >= 2) {
            axis.getInfo().Step = Math.abs((float)((((StiStripLineXF)axis.getInfo().StripLines.get(0)).getValue() - ((StiStripLineXF)axis.getInfo().StripLines.get(1)).getValue()) * axis.getInfo().Dpi));
            axis.getCore().CalculateStripPositions(topPosition, bottomPosition);
        } else {
            axis.getInfo().Step = 1.0;
            axis.getInfo().StripPositions = new double[0];
        }
    }

    private void CalculateStepY(IStiAxis axis, double topPosition, double bottomPosition) {
        if (axis.getInfo().StripLines.size() >= 2) {
            axis.getInfo().Step = Math.abs((float)((((StiStripLineXF)axis.getInfo().StripLines.get(1)).getValue() - ((StiStripLineXF)axis.getInfo().StripLines.get(0)).getValue()) * axis.getInfo().Dpi));
            axis.getCore().CalculateStripPositions(topPosition, bottomPosition);
        } else {
            axis.getInfo().Step = 1.0;
            axis.getInfo().StripPositions = new double[0];
        }
    }

    private void CheckStartFromZeroYAxis(IStiAxis axis) {
        if (axis.getCore().GetStartFromZero()) {
            if (axis.getInfo().Maximum < 0.0) {
                axis.getInfo().Maximum = 0.0;
            }
            if (axis.getInfo().Minimum > 0.0) {
                axis.getInfo().Minimum = 0.0;
            }
        }
    }

    public final void CalculatePositions(IStiAxis axis, StiRefObject<ArrayList<StiStripPositionXF>> collection, int step) {
        collection.argvalue = new ArrayList();
        IStiArea tempVar = this.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        boolean revert = false;
        if (this.getArea() instanceof IStiAxisArea) {
            revert = axis instanceof IStiYAxis && axisArea.getReverseVert() || axis instanceof IStiXAxis && axisArea.getReverseHor();
        }
        int stepIndex = 0;
        int length = axis.getInfo().StripPositions.length;
        for (int index = 0; index < length; ++index) {
            if (stepIndex == 0) {
                StiStripPositionXF label = new StiStripPositionXF();
                int stripIndex = revert ? length - index - 1 : index;
                label.StripLine = (StiStripLineXF)axis.getInfo().StripLines.get(stripIndex);
                label.Position = axis.getInfo().StripPositions[stripIndex];
                if (revert) {
                    ((ArrayList)collection.argvalue).add(0, label);
                } else {
                    ((ArrayList)collection.argvalue).add(label);
                }
            }
            if (this.getArea().getCore() instanceof StiClusteredBarAreaCoreXF && axis instanceof IStiXAxis || !(this.getArea().getCore() instanceof StiClusteredBarAreaCoreXF) && axis instanceof IStiYAxis || ++stepIndex != step) continue;
            stepIndex = 0;
        }
    }

    private double CalculateDivider(IStiAxis axis) {
        IStiArea tempVar = this.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        int stripIndex = 0;
        if (axis.getInfo().StripLines != null) {
            for (StiStripLineXF stripLine : axis.getInfo().StripLines) {
                if (stripLine.getValue() == 0.0) {
                    return axis.getInfo().StripPositions[stripIndex];
                }
                ++stripIndex;
            }
        }
        if (axis instanceof IStiYAxis) {
            if (axisArea.getReverseVert()) {
                return (float)(-axis.getInfo().Minimum * axis.getInfo().Dpi);
            }
            return axis.getInfo().StripPositions == null || axis.getInfo().StripPositions.length == 0 ? (double)((float)(axis.getInfo().Minimum * axis.getInfo().Dpi)) : (double)((float)(axis.getInfo().StripPositions[axis.getInfo().StripPositions.length - 1] + axis.getInfo().Minimum * axis.getInfo().Dpi));
        }
        if (axis instanceof IStiXAxis) {
            if (axisArea.getReverseHor()) {
                return axis.getInfo().StripPositions == null || axis.getInfo().StripPositions.length == 0 ? (double)((float)(axis.getInfo().Minimum * axis.getInfo().Dpi)) : (double)((float)(axis.getInfo().StripPositions[axis.getInfo().StripPositions.length - 1] + axis.getInfo().Minimum * axis.getInfo().Dpi));
            }
            return (float)(-axis.getInfo().Minimum * axis.getInfo().Dpi);
        }
        return 0.0;
    }

    private static void RotateStripLines(IStiAxis axis) {
        StiStripLinesXF lines = new StiStripLinesXF();
        for (StiStripLineXF line : axis.getInfo().StripLines) {
            lines.add(0, line);
        }
        axis.getInfo().StripLines = lines;
    }

    public final double GetDividerX() {
        IStiArea tempVar = this.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        if (this instanceof StiClusteredBarAreaCoreXF && !(this instanceof StiGanttAreaCoreXF)) {
            return this.CalculateDivider(axisArea.getXAxis());
        }
        if (this instanceof StiGanttAreaCoreXF) {
            return this.CalculateDivider(axisArea.getXAxis());
        }
        return 0.0;
    }

    public final double GetDividerY() {
        IStiArea tempVar = this.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        if (this instanceof StiClusteredBarAreaCoreXF && !(this instanceof StiGanttAreaCoreXF)) {
            return 0.0;
        }
        return this.CalculateDivider(axisArea.getYAxis());
    }

    public final double GetDividerRightY() {
        IStiArea tempVar = this.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        if (this instanceof StiClusteredBarAreaCoreXF && !(this instanceof StiGanttAreaCoreXF)) {
            return 0.0;
        }
        return this.CalculateDivider(axisArea.getYRightAxis());
    }

    public final double getScrollDistanceX() {
        return this.getScrollDpiX() * this.getScrollValueX();
    }

    public final double getScrollDistanceY() {
        return this.getScrollDpiY() * this.getScrollValueY();
    }

    public final double getScrollRangeX() {
        return this.scrollRangeX;
    }

    public final double getScrollRangeY() {
        return this.scrollRangeY;
    }

    public final double getScrollViewX() {
        return this.scrollViewX;
    }

    public final double getScrollViewY() {
        return this.scrollViewY;
    }

    public final boolean getBlockScrollValueX() {
        return this.blockScrollValueX;
    }

    public final void setBlockScrollValueX(boolean value) {
        this.blockScrollValueX = value;
    }

    public final boolean getBlockScrollValueY() {
        return this.blockScrollValueY;
    }

    public final void setBlockScrollValueY(boolean value) {
        this.blockScrollValueY = value;
    }

    public final double getScrollValueX() {
        return this.scrollValueX;
    }

    public final void setScrollValueX(double value) {
        this.scrollValueX = value;
    }

    public final double getScrollValueY() {
        return this.scrollValueY;
    }

    public final void setScrollValueY(double value) {
        this.scrollValueY = value;
    }

    public final double getScrollDpiX() {
        return this.scrollDpiX;
    }

    public final double getScrollDpiY() {
        return this.scrollDpiY;
    }

    public final double getScrollDragStartValue() {
        return this.scrollDragStartValue;
    }

    public final void setScrollDragStartValue(double value) {
        this.scrollDragStartValue = value;
    }

    public StiAxisAreaCoreXF(IStiArea area) {
        super(area);
    }
}

