/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.enums.StiLegendHorAlignment;
import com.stimulsoft.report.chart.enums.StiLegendVertAlignment;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.StiChartGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.chartTitle.StiChartTitleGeom;
import com.stimulsoft.report.chart.geoms.legend.StiLegendGeom;
import com.stimulsoft.report.chart.geoms.table.StiChartTableGeom;
import com.stimulsoft.report.chart.interfaces.IStiApplyStyle;
import com.stimulsoft.report.chart.interfaces.IStiChart;
import com.stimulsoft.report.chart.interfaces.IStiSeriesElement;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.areas.StiAxisArea;
import com.stimulsoft.report.chart.view.series.StiSeriesCollection;
import java.util.ArrayList;
import java.util.List;

public class StiChartCoreXF
implements Cloneable,
IStiApplyStyle {
    private IStiChart chart;
    public StiRectangle fullRectangle;

    @Override
    public final void applyStyle(IStiChartStyle style) {
        this.getChart().setStyle(style);
        this.getChart().setBrush(style.getCore().getChartBrush());
        if (this.getChart().getTitle() != null) {
            this.getChart().getTitle().getCore().applyStyle(style);
        }
        if (this.getChart().getArea() != null) {
            this.getChart().getArea().getCore().applyStyle(style);
        }
        if (this.getChart().getLegend() != null) {
            this.getChart().getLegend().getCore().applyStyle(style);
        }
        if (this.getChart().getSeriesLabels() != null) {
            this.getChart().getSeriesLabels().getCore().applyStyle(style);
        }
        if (this.getChart().getSeries() != null) {
            this.getChart().getSeries().applyStyle(style);
        }
        if (this.getChart().getConstantLines() != null) {
            this.getChart().getConstantLines().applyStyle(style);
        }
        if (this.getChart().getStrips() != null) {
            this.getChart().getStrips().applyStyle(style);
        }
        if (this.getChart().getTable() != null) {
            this.getChart().getTable().getCore().applyStyle(style);
        }
    }

    public final StiCellGeom Render(StiContext context, StiRectangle rect, boolean useMargins) {
        StiSeriesCollection series;
        StiCellGeom tempVar3;
        StiCellGeom tempVar2;
        StiRectangle fullRectangle;
        StiChartGeom chartGeom = new StiChartGeom(rect.clone());
        chartGeom.CreateChildGeoms();
        if (useMargins) {
            double zoom = 1.0;
            fullRectangle = new StiRectangle(rect.x + (double)this.chart.getHorSpacing() * zoom, rect.y + (double)this.chart.getVertSpacing() * zoom, rect.width - (double)(this.chart.getHorSpacing() * 2) * zoom, rect.height - (double)(this.chart.getVertSpacing() * 2) * zoom);
        } else {
            fullRectangle = rect.clone();
        }
        this.fullRectangle = fullRectangle;
        StiCellGeom tempVar = this.chart.getTitle().getCore().Render(context, this.chart.getTitle(), fullRectangle);
        StiChartTitleGeom titleGeom = (StiChartTitleGeom)(tempVar instanceof StiChartTitleGeom ? tempVar : null);
        if (titleGeom != null) {
            switch (this.chart.getTitle().getDock()) {
                case Top: {
                    fullRectangle.y += titleGeom.getClientRectangle().height;
                    fullRectangle.height -= titleGeom.getClientRectangle().height;
                    break;
                }
                case Right: {
                    fullRectangle.width -= titleGeom.getClientRectangle().width;
                    break;
                }
                case Bottom: {
                    fullRectangle.height -= titleGeom.getClientRectangle().height;
                    break;
                }
                case Left: {
                    fullRectangle.x += titleGeom.getClientRectangle().width;
                    fullRectangle.width -= titleGeom.getClientRectangle().width;
                }
            }
            chartGeom.getChildGeoms().add(titleGeom);
        }
        StiLegendGeom legendGeom = null;
        StiRectangle areaRect = fullRectangle.clone();
        if (this.chart.getLegend() != null && (legendGeom = (StiLegendGeom)((tempVar2 = this.chart.getLegend().getCore().Render(context, fullRectangle)) instanceof StiLegendGeom ? tempVar2 : null)) != null) {
            StiRectangle legendRect = legendGeom.getClientRectangle();
            StiRefObject tempRef_fullRectangle = new StiRefObject((Object)fullRectangle);
            StiRefObject tempRef_areaRect = new StiRefObject((Object)areaRect);
            StiRefObject tempRef_legendRect = new StiRefObject((Object)legendRect);
            this.SetLegendRect(context, this.chart, (StiRefObject<StiRectangle>)tempRef_fullRectangle, (StiRefObject<StiRectangle>)tempRef_areaRect, (StiRefObject<StiRectangle>)tempRef_legendRect);
            fullRectangle = ((StiRectangle)tempRef_fullRectangle.argvalue).clone();
            areaRect = ((StiRectangle)tempRef_areaRect.argvalue).clone();
            legendRect = ((StiRectangle)tempRef_legendRect.argvalue).clone();
        }
        if (this.chart.getTable().getCore().ShowTable()) {
            areaRect.height -= this.chart.getTable().getCore().GetHeightTable(context);
        }
        StiAreaGeom areaGeom = null;
        if (this.chart.getArea() != null && (areaGeom = (StiAreaGeom)((tempVar3 = this.chart.getArea().getCore().Render(context, areaRect)) instanceof StiAreaGeom ? tempVar3 : null)) != null) {
            chartGeom.getChildGeoms().add(areaGeom);
        }
        List<StiCellGeom> seriesGeoms = chartGeom.getSeriesElementGeoms();
        for (int index = 0; index < seriesGeoms.size(); ++index) {
            IStiSeriesElement seriesElementGeom = (IStiSeriesElement)((Object)seriesGeoms.get(index));
            if (seriesElementGeom == null) continue;
            seriesElementGeom.setElementIndex(String.valueOf(index));
        }
        if (this.chart.getTable().getCore().ShowTable() && (series = this.chart.getSeries()) != null && series.size() > 0) {
            List<String> list = this.GetArguments(series);
            String[][] table = new String[this.chart.getSeries().size() + 1][list.size() + 1];
            for (int index = 0; index < list.size(); ++index) {
                table[0][index + 1] = list.get(index);
            }
            StiAxisArea area = (StiAxisArea)this.chart.getArea();
            int indexRow = 1;
            for (IStiSeries serie : this.chart.getSeries()) {
                table[indexRow][0] = serie.getCoreTitle();
                int indexColumn = 1;
                for (int index = 0; index < serie.getValues().length; ++index) {
                    Double val = area.getReverseHor() ? serie.getValues()[serie.getValues().length - index - 1] : serie.getValues()[index];
                    table[indexRow][indexColumn] = val.toString();
                    ++indexColumn;
                }
                ++indexRow;
            }
            double x = areaRect.x;
            if (this.chart.getTable().getCore().GetWidthCellLegend(context) < areaGeom.getClientRectangle().x - areaRect.x) {
                x = areaGeom.getClientRectangle().x - this.chart.getTable().getCore().GetWidthCellLegend(context);
            }
            if (area.getReverseHor() && area.getYRightAxis().getVisible()) {
                x = areaGeom.getClientRectangle().getLeft();
            }
            StiRectangle rectTable = new StiRectangle(x, areaGeom.getClientRectangle().getBottom(), this.chart.getTable().getCore().GetWidthCellLegend(context) + areaGeom.getClientRectangle().width, this.chart.getTable().getCore().GetHeightTable(context));
            StiChartTableGeom tableGeom = (StiChartTableGeom)this.chart.getTable().getCore().Render(context, rectTable, table);
            chartGeom.getChildGeoms().add(tableGeom);
        }
        chartGeom.CreateChildGeoms();
        if (legendGeom != null) {
            areaRect = areaGeom.getClientRectangle();
            StiRectangle legendRect = legendGeom.getClientRectangle();
            StiRefObject tempRef_fullRectangle2 = new StiRefObject((Object)fullRectangle);
            StiRefObject tempRef_areaRect2 = new StiRefObject((Object)areaRect);
            StiRefObject tempRef_legendRect2 = new StiRefObject((Object)legendRect);
            this.SetLegendRect(context, this.chart, (StiRefObject<StiRectangle>)tempRef_fullRectangle2, (StiRefObject<StiRectangle>)tempRef_areaRect2, (StiRefObject<StiRectangle>)tempRef_legendRect2);
            fullRectangle = (StiRectangle)tempRef_fullRectangle2.argvalue;
            areaRect = (StiRectangle)tempRef_areaRect2.argvalue;
            legendRect = (StiRectangle)tempRef_legendRect2.argvalue;
            legendGeom.setClientRectangle(legendRect);
            chartGeom.getChildGeoms().add(legendGeom);
        }
        return chartGeom;
    }

    private int GetMaxCountValues(StiSeriesCollection series) {
        int result = 0;
        for (IStiSeries stiSeries : series) {
            result = Math.max(result, stiSeries.getValues().length);
        }
        return result;
    }

    private List<String> GetArguments(StiSeriesCollection series) {
        ArrayList<String> result = new ArrayList<String>();
        int countValues = this.GetMaxCountValues(series);
        for (int index = 0; index < countValues; ++index) {
            if (((IStiSeries)series.get(0)).getArguments().length > index) {
                result.add(((IStiSeries)series.get(0)).getArguments()[index].toString());
                continue;
            }
            result.add(String.valueOf(index + 1));
        }
        return result;
    }

    private void SetLegendRect(StiContext context, IStiChart chart, StiRefObject<StiRectangle> fullRectangle, StiRefObject<StiRectangle> areaRect, StiRefObject<StiRectangle> legendRect) {
        double scaledChartHorSpacing = (double)chart.getHorSpacing() * context.Options.zoom;
        double scaledChartVertSpacing = (double)chart.getVertSpacing() * context.Options.zoom;
        switch (chart.getLegend().getHorAlignment()) {
            case LeftOutside: {
                ((StiRectangle)legendRect.argvalue).x = ((StiRectangle)fullRectangle.argvalue).x;
                ((StiRectangle)areaRect.argvalue).width -= ((StiRectangle)legendRect.argvalue).width + scaledChartHorSpacing;
                ((StiRectangle)areaRect.argvalue).x += ((StiRectangle)legendRect.argvalue).width + scaledChartHorSpacing;
                break;
            }
            case Left: {
                ((StiRectangle)legendRect.argvalue).x = ((StiRectangle)areaRect.argvalue).x + scaledChartHorSpacing;
                break;
            }
            case Center: {
                ((StiRectangle)legendRect.argvalue).x = ((StiRectangle)areaRect.argvalue).x + (((StiRectangle)areaRect.argvalue).width - ((StiRectangle)legendRect.argvalue).width) / 2.0;
                break;
            }
            case Right: {
                ((StiRectangle)legendRect.argvalue).x = ((StiRectangle)areaRect.argvalue).getRight() - scaledChartHorSpacing - ((StiRectangle)legendRect.argvalue).width;
                if (!chart.getLegend().getShowShadow() || chart.getLegend().getVertAlignment() != StiLegendVertAlignment.BottomOutside) break;
                ((StiRectangle)legendRect.argvalue).x -= 5.0;
                ((StiRectangle)areaRect.argvalue).width -= 5.0;
                break;
            }
            case RightOutside: {
                ((StiRectangle)legendRect.argvalue).x = ((StiRectangle)fullRectangle.argvalue).getRight() - ((StiRectangle)legendRect.argvalue).width;
                ((StiRectangle)areaRect.argvalue).width -= ((StiRectangle)legendRect.argvalue).width + scaledChartHorSpacing;
                if (!chart.getLegend().getShowShadow()) break;
                ((StiRectangle)legendRect.argvalue).x -= 5.0;
                ((StiRectangle)areaRect.argvalue).width -= 5.0;
            }
        }
        switch (chart.getLegend().getVertAlignment()) {
            case TopOutside: {
                ((StiRectangle)legendRect.argvalue).y = ((StiRectangle)fullRectangle.argvalue).y;
                ((StiRectangle)areaRect.argvalue).height -= ((StiRectangle)legendRect.argvalue).height + scaledChartVertSpacing;
                ((StiRectangle)areaRect.argvalue).y += ((StiRectangle)legendRect.argvalue).height + scaledChartVertSpacing;
                break;
            }
            case Top: {
                ((StiRectangle)legendRect.argvalue).y = ((StiRectangle)areaRect.argvalue).y + scaledChartVertSpacing;
                break;
            }
            case Center: {
                ((StiRectangle)legendRect.argvalue).y = ((StiRectangle)areaRect.argvalue).y + (((StiRectangle)areaRect.argvalue).height - ((StiRectangle)legendRect.argvalue).height) / 2.0;
                break;
            }
            case Bottom: {
                ((StiRectangle)legendRect.argvalue).y = ((StiRectangle)areaRect.argvalue).getBottom() - scaledChartVertSpacing - ((StiRectangle)legendRect.argvalue).height;
                if (!chart.getLegend().getShowShadow() || chart.getLegend().getHorAlignment() != StiLegendHorAlignment.LeftOutside && chart.getLegend().getHorAlignment() != StiLegendHorAlignment.RightOutside) break;
                ((StiRectangle)legendRect.argvalue).y -= 5.0;
                ((StiRectangle)areaRect.argvalue).height -= 5.0;
                break;
            }
            case BottomOutside: {
                ((StiRectangle)legendRect.argvalue).y = ((StiRectangle)fullRectangle.argvalue).getBottom() - ((StiRectangle)legendRect.argvalue).height;
                ((StiRectangle)areaRect.argvalue).height -= ((StiRectangle)legendRect.argvalue).height + scaledChartVertSpacing;
                if (!chart.getLegend().getShowShadow()) break;
                ((StiRectangle)legendRect.argvalue).y -= 5.0;
                ((StiRectangle)areaRect.argvalue).height -= 5.0;
            }
        }
        if (chart.getLegend().getVertAlignment() == StiLegendVertAlignment.BottomOutside || chart.getLegend().getVertAlignment() == StiLegendVertAlignment.TopOutside) {
            if (chart.getLegend().getHorAlignment() == StiLegendHorAlignment.Left) {
                ((StiRectangle)legendRect.argvalue).x -= scaledChartHorSpacing;
            }
            if (chart.getLegend().getHorAlignment() == StiLegendHorAlignment.Right) {
                ((StiRectangle)legendRect.argvalue).x += scaledChartHorSpacing;
            }
        } else if (chart.getLegend().getHorAlignment() == StiLegendHorAlignment.RightOutside || chart.getLegend().getHorAlignment() == StiLegendHorAlignment.LeftOutside) {
            if (chart.getLegend().getVertAlignment() == StiLegendVertAlignment.Top) {
                ((StiRectangle)legendRect.argvalue).y -= scaledChartVertSpacing;
            }
            if (chart.getLegend().getVertAlignment() == StiLegendVertAlignment.Bottom) {
                ((StiRectangle)legendRect.argvalue).y += scaledChartVertSpacing;
            }
        }
    }

    public final IStiChart getChart() {
        return this.chart;
    }

    public final void setChart(IStiChart value) {
        this.chart = value;
    }

    public StiChartCoreXF(IStiChart chart) {
        this.chart = chart;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

