/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiEAN13BarCodeType;
import com.stimulsoft.report.barCodes.enums.StiEanSupplementType;
import java.util.ArrayList;

public class StiUpcABarCodeType
extends StiEAN13BarCodeType {
    public StiUpcABarCodeType() {
        this(13.0, 1.0, StiEanSupplementType.None, null, false);
    }

    public StiUpcABarCodeType(double module, double height, StiEanSupplementType supplementType, String supplementCodeValue, boolean showQuietZoneIndicator) {
        super(module, height, supplementType, supplementCodeValue, showQuietZoneIndicator);
    }

    @Override
    public String getServiceName() {
        return "UPC-A";
    }

    @Override
    protected double getEanSpaceLeft() {
        return 9.0;
    }

    @Override
    protected double getEanSpaceRight() {
        return 9.0;
    }

    @Override
    public boolean getShowQuietZoneIndicator() {
        return false;
    }

    @Override
    public void setShowQuietZoneIndicator(boolean value) {
    }

    protected final ArrayList MakeUpcABars(String code, boolean isLast) {
        StiEAN13BarCodeType.EanBarInfo sym;
        int currentNumber;
        int index;
        int[] dig = new int[12];
        for (int tempIndex = 0; tempIndex < 12; ++tempIndex) {
            dig[tempIndex] = Integer.parseInt(String.valueOf(code.charAt(tempIndex)));
        }
        int sum = (dig[1] + dig[3] + dig[5] + dig[7] + dig[9] + dig[11]) * 3 + dig[0] + dig[2] + dig[4] + dig[6] + dig[8] + dig[10];
        int checkDigit = 10 - sum % 10;
        if (checkDigit == 10) {
            checkDigit = 0;
        }
        code = code.substring(0, 12) + (char)(checkDigit + 48);
        ArrayList<StiEAN13BarCodeType.EanBarInfo> barsArray = new ArrayList<StiEAN13BarCodeType.EanBarInfo>();
        barsArray.add(new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.SpaceLeft, code.charAt(1), false));
        barsArray.add(new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.GuardLeft, ' ', false));
        barsArray.add(new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.forValue(StiEAN13BarCodeType.Ean13Symbol.ComboA0.getValue() + Integer.parseInt(String.valueOf(code.charAt(1)))), ' ', false, true));
        for (index = 0; index < 5; ++index) {
            currentNumber = Integer.parseInt(String.valueOf(code.charAt(2 + index)));
            sym = new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.forValue(StiEAN13BarCodeType.Ean13Symbol.ComboA0.getValue() + currentNumber), code.charAt(2 + index), false);
            barsArray.add(sym);
        }
        barsArray.add(new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.GuardCenter, ' ', false));
        for (index = 0; index < 5; ++index) {
            currentNumber = Integer.parseInt(String.valueOf(code.charAt(7 + index)));
            sym = new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.forValue(StiEAN13BarCodeType.Ean13Symbol.ComboC0.getValue() + currentNumber), code.charAt(7 + index), false);
            barsArray.add(sym);
        }
        barsArray.add(new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.forValue(StiEAN13BarCodeType.Ean13Symbol.ComboC0.getValue() + Integer.parseInt(String.valueOf(code.charAt(12)))), ' ', false, true));
        barsArray.add(new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.GuardRight, ' ', false));
        if (isLast) {
            barsArray.add(new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.SpaceRight, code.charAt(12), false));
        } else {
            barsArray.add(new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.SpaceBeforeAdd, code.charAt(12), false));
        }
        return barsArray;
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        code = '0' + this.CheckCodeSymbols(code, "0123456789") + "000000000000";
        String suppCode = this.CheckCodeSymbols(this.getSupplementCode(), "0123456789") + "00000";
        ArrayList barsArray = null;
        if (this.getSupplementType() == StiEanSupplementType.None) {
            barsArray = this.MakeUpcABars(code, true);
        } else {
            barsArray = this.MakeUpcABars(code, false);
            if (this.getSupplementType() == StiEanSupplementType.TwoDigit) {
                this.MakeEanAdd2Bars(suppCode, barsArray, true);
            } else {
                this.MakeEanAdd5Bars(suppCode, barsArray, true);
            }
        }
        this.CalculateSizeEan(0.0, zoom, barsArray, rect, barCode);
        this.translateRect(context, rect, barCode);
        this.drawEanBars(context, barsArray, barCode);
        this.rollbackTransform(context);
    }

    @Override
    public String getDefaultCodeValue() {
        return "4523456789012";
    }
}

