/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;

public class StiStandard2of5BarCodeType
extends StiBarCodeTypeService {
    private double module = 13.0;
    private double height = 1.0;
    private double ratio = 2.2;
    protected String[] symTableSet = new String[]{"00110", "10001", "01001", "11000", "00101", "10100", "01100", "00011", "10010", "01010", "101000", "10001"};
    private static final double Standard2of5SpaceLeft = 10.0;
    private static final double Standard2of5SpaceRight = 10.0;
    private static final double Standard2of5SpaceTop = 0.0;
    private static final double Standard2of5SpaceBottom = 1.0;
    private static final double Standard2of5LineHeightShort = 40.0;
    private static final double Standard2of5LineHeightLong = 40.0;
    private static final double Standard2of5TextHeight = (double)8.33f;
    private static final double Standard2of5MainHeight = 50.0;
    private static final double Standard2of5TextPosition = 41.0;
    private static final double Standard2of5LineHeightForCut = 40.0;

    public StiStandard2of5BarCodeType() {
        this(13.0, 1.0, 2.2);
    }

    public StiStandard2of5BarCodeType(double module, double height, double ratio) {
        this.module = module;
        this.height = height;
        this.ratio = ratio;
    }

    public String getServiceName() {
        return "2of5 Standard";
    }

    @Override
    @StiDefaulValue(value="13.0")
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = value;
        if (value < 7.5) {
            this.module = 7.5;
        }
        if (value > 40.0) {
            this.module = 40.0;
        }
        this.setRatio(this.getRatio());
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = value;
        if (value < 0.5) {
            this.height = 0.5;
        }
        if (value > 2.0) {
            this.height = 2.0;
        }
    }

    @StiDefaulValue(value="2.2")
    @StiSerializable
    public final double getRatio() {
        return this.ratio;
    }

    public final void setRatio(double value) {
        this.ratio = value;
        double minRatio = this.getModule() > 20.0 ? 2.0f : 2.2f;
        if (value < minRatio) {
            this.ratio = minRatio;
        }
        if (value > 3.0) {
            this.ratio = 3.0;
        }
    }

    @Override
    public double getLabelFontHeight() {
        return 8.33f;
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        code = this.CheckCodeSymbols(code, "0123456789");
        StringBuilder barsArray = new StringBuilder();
        barsArray.append(this.symTableSet[10]);
        if (code.length() > 0) {
            for (int index = 0; index < code.length(); ++index) {
                String sym = this.symTableSet[Integer.parseInt(String.valueOf(code.charAt(index)))];
                StringBuilder sb = new StringBuilder("0000000000");
                sb.setCharAt(0, sym.charAt(0));
                sb.setCharAt(2, sym.charAt(1));
                sb.setCharAt(4, sym.charAt(2));
                sb.setCharAt(6, sym.charAt(3));
                sb.setCharAt(8, sym.charAt(4));
                barsArray.append((CharSequence)sb);
            }
        }
        barsArray.append(this.symTableSet[11]);
        boolean counter = true;
        for (int index = 0; index < barsArray.length(); ++index) {
            char currentsym = counter ? (barsArray.charAt(index) == '0' ? (char)'4' : '5') : (barsArray.charAt(index) == '0' ? (char)'0' : '1');
            barsArray.setCharAt(index, currentsym);
            counter = !counter;
        }
        this.CalculateSizeFull(10.0, 10.0, 0.0, 1.0, 40.0, 40.0, 41.0, 8.33f, 50.0, 40.0, this.getRatio(), zoom, code, code, barsArray.toString(), rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Module", this.getModule(), 13.0);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        jObject.AddPropertyFloat("Ratio", this.getRatio(), (double)2.2f);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("Height")) {
                this.height = property.floatValue().floatValue();
                continue;
            }
            if (!property.Name.equals("Ratio")) continue;
            this.ratio = property.floatValue().floatValue();
        }
    }

    @Override
    public String getDefaultCodeValue() {
        return "12345678";
    }
}

