/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.barCodes.GaloisField;
import com.stimulsoft.report.barCodes.ReedSolomonEncoder;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import com.stimulsoft.report.barCodes.enums.StiQRCodeErrorCorrectionLevel;
import com.stimulsoft.report.barCodes.enums.StiQRCodeSize;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;

public class StiQRCodeBarCodeType
extends StiBarCodeTypeService {
    private double module = 40.0;
    private double height = 1.0;
    private StiQRCodeErrorCorrectionLevel errorCorrectionLevel = StiQRCodeErrorCorrectionLevel.Level1;
    private StiQRCodeSize matrixSize = StiQRCodeSize.Automatic;

    public StiQRCodeBarCodeType() {
        this(40.0, StiQRCodeErrorCorrectionLevel.Level1, StiQRCodeSize.Automatic);
    }

    public StiQRCodeBarCodeType(double module, StiQRCodeErrorCorrectionLevel errorCorrectionLevel, StiQRCodeSize matrixSize) {
        this.module = module;
        this.errorCorrectionLevel = errorCorrectionLevel;
        this.matrixSize = matrixSize;
    }

    public String getServiceName() {
        return "QR Code";
    }

    @Override
    @StiDefaulValue(value="40.0")
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = value;
        if (value < 2.0) {
            this.module = 2.0;
        }
        if (value > 400.0) {
            this.module = 400.0;
        }
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = value;
    }

    @StiDefaulValue(value="Level1")
    @StiSerializable
    public final StiQRCodeErrorCorrectionLevel getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    public final void setErrorCorrectionLevel(StiQRCodeErrorCorrectionLevel value) {
        this.errorCorrectionLevel = value;
    }

    @StiDefaulValue(value="Automatic")
    @StiSerializable
    public final StiQRCodeSize getMatrixSize() {
        return this.matrixSize;
    }

    public final void setMatrixSize(StiQRCodeSize value) {
        this.matrixSize = value;
    }

    @Override
    public double getLabelFontHeight() {
        return 8.0;
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code;
        this.getBarCodeData().Code = code = this.GetCode(barCode);
        StiQRCode.ErrorCorrectionLevel errorCorrectionLevel2 = StiQRCode.ErrorCorrectionLevel.L;
        if (this.errorCorrectionLevel == StiQRCodeErrorCorrectionLevel.Level2) {
            errorCorrectionLevel2 = StiQRCode.ErrorCorrectionLevel.M;
        }
        if (this.errorCorrectionLevel == StiQRCodeErrorCorrectionLevel.Level3) {
            errorCorrectionLevel2 = StiQRCode.ErrorCorrectionLevel.Q;
        }
        if (this.errorCorrectionLevel == StiQRCodeErrorCorrectionLevel.Level4) {
            errorCorrectionLevel2 = StiQRCode.ErrorCorrectionLevel.H;
        }
        try {
            StiQRCode qrCode = new StiQRCode();
            StiQRCode.QREncoder.Encode(code, errorCorrectionLevel2, qrCode);
            StiQRCode.ByteMatrix bm = qrCode.GetMatrix();
            int[] matrix = new int[bm.GetWidth() * bm.GetHeight()];
            for (int y = 0; y < bm.GetHeight(); ++y) {
                int offset = y * bm.GetWidth();
                for (int x = 0; x < bm.GetWidth(); ++x) {
                    matrix[offset + x] = bm.Get(x, y);
                }
            }
            this.getBarCodeData().MatrixGrid = matrix;
            this.getBarCodeData().MatrixWidth = bm.GetWidth();
            this.getBarCodeData().MatrixHeight = bm.GetHeight();
            this.getBarCodeData().MatrixRatioY = 1;
            this.draw2DBarCode(context, rect, barCode, zoom);
        }
        catch (Exception e) {
            this.drawBarCodeError(context, rect, barCode);
        }
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        jObject.AddPropertyFloat("Module", this.getModule(), 40.0);
        jObject.AddPropertyEnum("ErrorCorrectionLevel", (Enum)this.getErrorCorrectionLevel(), (Enum)StiQRCodeErrorCorrectionLevel.Level1);
        jObject.AddPropertyEnum("MatrixSize", (Enum)this.getMatrixSize(), (Enum)StiQRCodeSize.Automatic);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("Height")) {
                this.height = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("ErrorCorrectionLevel")) {
                this.errorCorrectionLevel = StiQRCodeErrorCorrectionLevel.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("MatrixSize")) {
                this.matrixSize = StiQRCodeSize.valueOf((String)property.Value);
                continue;
            }
            if (!property.Name.equals("ImageMultipleFactor") && !property.Name.equals("Image")) continue;
        }
    }

    @Override
    public String getDefaultCodeValue() {
        return "12345678901";
    }

    private static final class StiQRCode {
        public static final int NUM_MASK_PATTERNS = 8;
        private Mode mode = null;
        private ErrorCorrectionLevel ecLevel = null;
        private int version = -1;
        private int matrixWidth = -1;
        private int maskPattern = -1;
        private int numTotalBytes = -1;
        private int numDataBytes = -1;
        private int numECBytes = -1;
        private int numRSBlocks = -1;
        private ByteMatrix matrix = null;

        public final Mode GetMode() {
            return this.mode;
        }

        public final ErrorCorrectionLevel GetECLevel() {
            return this.ecLevel;
        }

        public final int GetVersion() {
            return this.version;
        }

        public final int GetMatrixWidth() {
            return this.matrixWidth;
        }

        public final int GetMaskPattern() {
            return this.maskPattern;
        }

        public final int GetNumTotalBytes() {
            return this.numTotalBytes;
        }

        public final int GetNumDataBytes() {
            return this.numDataBytes;
        }

        public final int GetNumECBytes() {
            return this.numECBytes;
        }

        public final int GetNumRSBlocks() {
            return this.numRSBlocks;
        }

        public final ByteMatrix GetMatrix() {
            return this.matrix;
        }

        public final int At(int x, int y) {
            int value = this.matrix.Get(x, y);
            if (value != 0 && value != 1) {
                throw new IllegalArgumentException("Bad value");
            }
            return value;
        }

        public final boolean IsValid() {
            return this.mode != null && this.ecLevel != null && this.version != -1 && this.matrixWidth != -1 && this.maskPattern != -1 && this.numTotalBytes != -1 && this.numDataBytes != -1 && this.numECBytes != -1 && this.numRSBlocks != -1 && StiQRCode.IsValidMaskPattern(this.maskPattern) && this.numTotalBytes == this.numDataBytes + this.numECBytes && this.matrix != null && this.matrixWidth == this.matrix.GetWidth() && this.matrix.GetWidth() == this.matrix.GetHeight();
        }

        public final void SetMode(Mode value) {
            this.mode = value;
        }

        public final void SetECLevel(ErrorCorrectionLevel value) {
            this.ecLevel = value;
        }

        public final void SetVersion(int value) {
            this.version = value;
        }

        public final void SetMatrixWidth(int value) {
            this.matrixWidth = value;
        }

        public final void SetMaskPattern(int value) {
            this.maskPattern = value;
        }

        public final void SetNumTotalBytes(int value) {
            this.numTotalBytes = value;
        }

        public final void SetNumDataBytes(int value) {
            this.numDataBytes = value;
        }

        public final void SetNumECBytes(int value) {
            this.numECBytes = value;
        }

        public final void SetNumRSBlocks(int value) {
            this.numRSBlocks = value;
        }

        public final void SetMatrix(ByteMatrix value) {
            this.matrix = value;
        }

        public static boolean IsValidMaskPattern(int maskPattern) {
            return maskPattern >= 0 && maskPattern < 8;
        }

        public static final class MatrixUtil {
            private static final int[][] POSITION_DETECTION_PATTERN = new int[][]{{1, 1, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 1, 0, 1}, {1, 0, 1, 1, 1, 0, 1}, {1, 0, 1, 1, 1, 0, 1}, {1, 0, 0, 0, 0, 0, 1}, {1, 1, 1, 1, 1, 1, 1}};
            private static final int[][] HORIZONTAL_SEPARATION_PATTERN = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0}};
            private static final int[][] VERTICAL_SEPARATION_PATTERN = new int[][]{{0}, {0}, {0}, {0}, {0}, {0}, {0}};
            private static final int[][] POSITION_ADJUSTMENT_PATTERN = new int[][]{{1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 0, 1, 0, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}};
            private static final int[][] POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE = new int[][]{{-1, -1, -1, -1, -1, -1, -1}, {6, 18, -1, -1, -1, -1, -1}, {6, 22, -1, -1, -1, -1, -1}, {6, 26, -1, -1, -1, -1, -1}, {6, 30, -1, -1, -1, -1, -1}, {6, 34, -1, -1, -1, -1, -1}, {6, 22, 38, -1, -1, -1, -1}, {6, 24, 42, -1, -1, -1, -1}, {6, 26, 46, -1, -1, -1, -1}, {6, 28, 50, -1, -1, -1, -1}, {6, 30, 54, -1, -1, -1, -1}, {6, 32, 58, -1, -1, -1, -1}, {6, 34, 62, -1, -1, -1, -1}, {6, 26, 46, 66, -1, -1, -1}, {6, 26, 48, 70, -1, -1, -1}, {6, 26, 50, 74, -1, -1, -1}, {6, 30, 54, 78, -1, -1, -1}, {6, 30, 56, 82, -1, -1, -1}, {6, 30, 58, 86, -1, -1, -1}, {6, 34, 62, 90, -1, -1, -1}, {6, 28, 50, 72, 94, -1, -1}, {6, 26, 50, 74, 98, -1, -1}, {6, 30, 54, 78, 102, -1, -1}, {6, 28, 54, 80, 106, -1, -1}, {6, 32, 58, 84, 110, -1, -1}, {6, 30, 58, 86, 114, -1, -1}, {6, 34, 62, 90, 118, -1, -1}, {6, 26, 50, 74, 98, 122, -1}, {6, 30, 54, 78, 102, 126, -1}, {6, 26, 52, 78, 104, 130, -1}, {6, 30, 56, 82, 108, 134, -1}, {6, 34, 60, 86, 112, 138, -1}, {6, 30, 58, 86, 114, 142, -1}, {6, 34, 62, 90, 118, 146, -1}, {6, 30, 54, 78, 102, 126, 150}, {6, 24, 50, 76, 102, 128, 154}, {6, 28, 54, 80, 106, 132, 158}, {6, 32, 58, 84, 110, 136, 162}, {6, 26, 54, 82, 110, 138, 166}, {6, 30, 58, 86, 114, 142, 170}};
            private static final int[][] TYPE_INFO_COORDINATES = new int[][]{{8, 0}, {8, 1}, {8, 2}, {8, 3}, {8, 4}, {8, 5}, {8, 7}, {8, 8}, {7, 8}, {5, 8}, {4, 8}, {3, 8}, {2, 8}, {1, 8}, {0, 8}};
            private static final int VERSION_INFO_POLY = 7973;
            private static final int TYPE_INFO_POLY = 1335;
            private static final int TYPE_INFO_MASK_PATTERN = 21522;

            private MatrixUtil() {
            }

            public static void ClearMatrix(ByteMatrix matrix) {
                matrix.Clear(-1);
            }

            public static void BuildMatrix(BitVector dataBits, ErrorCorrectionLevel ecLevel, int version, int maskPattern, ByteMatrix matrix) {
                MatrixUtil.ClearMatrix(matrix);
                MatrixUtil.EmbedBasicPatterns(version, matrix);
                MatrixUtil.EmbedTypeInfo(ecLevel, maskPattern, matrix);
                MatrixUtil.MaybeEmbedVersionInfo(version, matrix);
                MatrixUtil.EmbedDataBits(dataBits, maskPattern, matrix);
            }

            public static void EmbedBasicPatterns(int version, ByteMatrix matrix) {
                MatrixUtil.EmbedPositionDetectionPatternsAndSeparators(matrix);
                MatrixUtil.EmbedDarkDotAtLeftBottomCorner(matrix);
                MatrixUtil.MaybeEmbedPositionAdjustmentPatterns(version, matrix);
                MatrixUtil.EmbedTimingPatterns(matrix);
            }

            public static void EmbedTypeInfo(ErrorCorrectionLevel ecLevel, int maskPattern, ByteMatrix matrix) {
                BitVector typeInfoBits = new BitVector();
                MatrixUtil.MakeTypeInfoBits(ecLevel, maskPattern, typeInfoBits);
                for (int i = 0; i < typeInfoBits.Size(); ++i) {
                    int y2;
                    int x2;
                    int bit = typeInfoBits.At(typeInfoBits.Size() - 1 - i);
                    int x1 = TYPE_INFO_COORDINATES[i][0];
                    int y1 = TYPE_INFO_COORDINATES[i][1];
                    matrix.Set(x1, y1, bit);
                    if (i < 8) {
                        x2 = matrix.GetWidth() - i - 1;
                        y2 = 8;
                        matrix.Set(x2, y2, bit);
                        continue;
                    }
                    x2 = 8;
                    y2 = matrix.GetHeight() - 7 + (i - 8);
                    matrix.Set(x2, y2, bit);
                }
            }

            public static void MaybeEmbedVersionInfo(int version, ByteMatrix matrix) {
                if (version < 7) {
                    return;
                }
                BitVector versionInfoBits = new BitVector();
                MatrixUtil.MakeVersionInfoBits(version, versionInfoBits);
                int bitIndex = 17;
                for (int i = 0; i < 6; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        int bit = versionInfoBits.At(bitIndex);
                        --bitIndex;
                        matrix.Set(i, matrix.GetHeight() - 11 + j, bit);
                        matrix.Set(matrix.GetHeight() - 11 + j, i, bit);
                    }
                }
            }

            public static void EmbedDataBits(BitVector dataBits, int maskPattern, ByteMatrix matrix) {
                int bitIndex = 0;
                int direction = -1;
                int y = matrix.GetHeight() - 1;
                for (int x = matrix.GetWidth() - 1; x > 0; x -= 2) {
                    if (x == 6) {
                        --x;
                    }
                    while (y >= 0 && y < matrix.GetHeight()) {
                        for (int i = 0; i < 2; ++i) {
                            int bit;
                            int xx = x - i;
                            if (!MatrixUtil.IsEmpty(matrix.Get(xx, y))) continue;
                            if (bitIndex < dataBits.Size()) {
                                bit = dataBits.At(bitIndex);
                                ++bitIndex;
                            } else {
                                bit = 0;
                            }
                            if (maskPattern != -1 && MaskUtil.GetDataMaskBit(maskPattern, xx, y)) {
                                bit ^= 1;
                            }
                            matrix.Set(xx, y, bit);
                        }
                        y += direction;
                    }
                    direction = -direction;
                    y += direction;
                }
                if (bitIndex != dataBits.Size()) {
                    throw new StiQRCodeException("Not all bits consumed: " + bitIndex + '/' + dataBits.Size());
                }
            }

            public static int FindMSBSet(int value) {
                int val = value;
                int numDigits = 0;
                while (val != 0) {
                    val >>= 1;
                    ++numDigits;
                }
                return numDigits;
            }

            public static int CalculateBCHCode(int value, int poly) {
                int msbSetInPoly = MatrixUtil.FindMSBSet(poly);
                value <<= msbSetInPoly - 1;
                while (MatrixUtil.FindMSBSet(value) >= msbSetInPoly) {
                    value ^= poly << MatrixUtil.FindMSBSet(value) - msbSetInPoly;
                }
                return value;
            }

            public static void MakeTypeInfoBits(ErrorCorrectionLevel ecLevel, int maskPattern, BitVector bits) {
                if (!StiQRCode.IsValidMaskPattern(maskPattern)) {
                    throw new StiQRCodeException("Invalid mask pattern");
                }
                int typeInfo = ecLevel.GetBits() << 3 | maskPattern;
                bits.AppendBits(typeInfo, 5);
                int bchCode = MatrixUtil.CalculateBCHCode(typeInfo, 1335);
                bits.AppendBits(bchCode, 10);
                BitVector maskBits = new BitVector();
                maskBits.AppendBits(21522, 15);
                bits.Xor(maskBits);
                if (bits.Size() != 15) {
                    throw new StiQRCodeException("should not happen but we got: " + bits.Size());
                }
            }

            public static void MakeVersionInfoBits(int version, BitVector bits) {
                bits.AppendBits(version, 6);
                int bchCode = MatrixUtil.CalculateBCHCode(version, 7973);
                bits.AppendBits(bchCode, 12);
                if (bits.Size() != 18) {
                    throw new StiQRCodeException("should not happen but we got: " + bits.Size());
                }
            }

            private static boolean IsEmpty(int value) {
                return value == -1;
            }

            private static boolean IsValidValue(int value) {
                return value == -1 || value == 0 || value == 1;
            }

            private static void EmbedTimingPatterns(ByteMatrix matrix) {
                for (int i = 8; i < matrix.GetWidth() - 8; ++i) {
                    int bit = (i + 1) % 2;
                    if (!MatrixUtil.IsValidValue(matrix.Get(i, 6))) {
                        throw new StiQRCodeException();
                    }
                    if (MatrixUtil.IsEmpty(matrix.Get(i, 6))) {
                        matrix.Set(i, 6, bit);
                    }
                    if (!MatrixUtil.IsValidValue(matrix.Get(6, i))) {
                        throw new StiQRCodeException();
                    }
                    if (!MatrixUtil.IsEmpty(matrix.Get(6, i))) continue;
                    matrix.Set(6, i, bit);
                }
            }

            private static void EmbedDarkDotAtLeftBottomCorner(ByteMatrix matrix) {
                if (matrix.Get(8, matrix.GetHeight() - 8) == 0) {
                    throw new StiQRCodeException();
                }
                matrix.Set(8, matrix.GetHeight() - 8, 1);
            }

            private static void EmbedHorizontalSeparationPattern(int xStart, int yStart, ByteMatrix matrix) {
                if (HORIZONTAL_SEPARATION_PATTERN[0].length != 8 || HORIZONTAL_SEPARATION_PATTERN.length != 1) {
                    throw new StiQRCodeException("Bad horizontal separation pattern");
                }
                for (int x = 0; x < 8; ++x) {
                    if (!MatrixUtil.IsEmpty(matrix.Get(xStart + x, yStart))) {
                        throw new StiQRCodeException();
                    }
                    matrix.Set(xStart + x, yStart, HORIZONTAL_SEPARATION_PATTERN[0][x]);
                }
            }

            private static void EmbedVerticalSeparationPattern(int xStart, int yStart, ByteMatrix matrix) {
                if (VERTICAL_SEPARATION_PATTERN[0].length != 1 || VERTICAL_SEPARATION_PATTERN.length != 7) {
                    throw new StiQRCodeException("Bad vertical separation pattern");
                }
                for (int y = 0; y < 7; ++y) {
                    if (!MatrixUtil.IsEmpty(matrix.Get(xStart, yStart + y))) {
                        throw new StiQRCodeException();
                    }
                    matrix.Set(xStart, yStart + y, VERTICAL_SEPARATION_PATTERN[y][0]);
                }
            }

            private static void EmbedPositionAdjustmentPattern(int xStart, int yStart, ByteMatrix matrix) {
                if (POSITION_ADJUSTMENT_PATTERN[0].length != 5 || POSITION_ADJUSTMENT_PATTERN.length != 5) {
                    throw new StiQRCodeException("Bad position adjustment");
                }
                for (int y = 0; y < 5; ++y) {
                    for (int x = 0; x < 5; ++x) {
                        if (!MatrixUtil.IsEmpty(matrix.Get(xStart + x, yStart + y))) {
                            throw new StiQRCodeException();
                        }
                        matrix.Set(xStart + x, yStart + y, POSITION_ADJUSTMENT_PATTERN[y][x]);
                    }
                }
            }

            private static void EmbedPositionDetectionPattern(int xStart, int yStart, ByteMatrix matrix) {
                if (POSITION_DETECTION_PATTERN[0].length != 7 || POSITION_DETECTION_PATTERN.length != 7) {
                    throw new StiQRCodeException("Bad position detection pattern");
                }
                for (int y = 0; y < 7; ++y) {
                    for (int x = 0; x < 7; ++x) {
                        if (!MatrixUtil.IsEmpty(matrix.Get(xStart + x, yStart + y))) {
                            throw new StiQRCodeException();
                        }
                        matrix.Set(xStart + x, yStart + y, POSITION_DETECTION_PATTERN[y][x]);
                    }
                }
            }

            private static void EmbedPositionDetectionPatternsAndSeparators(ByteMatrix matrix) {
                int pdpWidth = POSITION_DETECTION_PATTERN[0].length;
                MatrixUtil.EmbedPositionDetectionPattern(0, 0, matrix);
                MatrixUtil.EmbedPositionDetectionPattern(matrix.GetWidth() - pdpWidth, 0, matrix);
                MatrixUtil.EmbedPositionDetectionPattern(0, matrix.GetWidth() - pdpWidth, matrix);
                int hspWidth = HORIZONTAL_SEPARATION_PATTERN[0].length;
                MatrixUtil.EmbedHorizontalSeparationPattern(0, hspWidth - 1, matrix);
                MatrixUtil.EmbedHorizontalSeparationPattern(matrix.GetWidth() - hspWidth, hspWidth - 1, matrix);
                MatrixUtil.EmbedHorizontalSeparationPattern(0, matrix.GetWidth() - hspWidth, matrix);
                int vspSize = VERTICAL_SEPARATION_PATTERN.length;
                MatrixUtil.EmbedVerticalSeparationPattern(vspSize, 0, matrix);
                MatrixUtil.EmbedVerticalSeparationPattern(matrix.GetHeight() - vspSize - 1, 0, matrix);
                MatrixUtil.EmbedVerticalSeparationPattern(vspSize, matrix.GetHeight() - vspSize, matrix);
            }

            private static void MaybeEmbedPositionAdjustmentPatterns(int version, ByteMatrix matrix) {
                if (version < 2) {
                    return;
                }
                int index = version - 1;
                int[] coordinates = POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE[index];
                int numCoordinates = POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE[index].length;
                for (int i = 0; i < numCoordinates; ++i) {
                    for (int j = 0; j < numCoordinates; ++j) {
                        int y = coordinates[i];
                        int x = coordinates[j];
                        if (x == -1 || y == -1 || !MatrixUtil.IsEmpty(matrix.Get(x, y))) continue;
                        MatrixUtil.EmbedPositionAdjustmentPattern(x - 2, y - 2, matrix);
                    }
                }
            }
        }

        public static final class MaskUtil {
            private MaskUtil() {
            }

            public static int ApplyMaskPenaltyRule1(ByteMatrix matrix) {
                return MaskUtil.ApplyMaskPenaltyRule1Internal(matrix, true) + MaskUtil.ApplyMaskPenaltyRule1Internal(matrix, false);
            }

            public static int ApplyMaskPenaltyRule2(ByteMatrix matrix) {
                int penalty = 0;
                int[][] array = matrix.GetArray();
                int width = matrix.GetWidth();
                int height = matrix.GetHeight();
                for (int y = 0; y < height - 1; ++y) {
                    for (int x = 0; x < width - 1; ++x) {
                        int value = array[y][x];
                        if (value != array[y][x + 1] || value != array[y + 1][x] || value != array[y + 1][x + 1]) continue;
                        penalty += 3;
                    }
                }
                return penalty;
            }

            public static int ApplyMaskPenaltyRule3(ByteMatrix matrix) {
                int penalty = 0;
                int[][] array = matrix.GetArray();
                int width = matrix.GetWidth();
                int height = matrix.GetHeight();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (x + 6 < width && array[y][x] == 1 && array[y][x + 1] == 0 && array[y][x + 2] == 1 && array[y][x + 3] == 1 && array[y][x + 4] == 1 && array[y][x + 5] == 0 && array[y][x + 6] == 1 && (x + 10 < width && array[y][x + 7] == 0 && array[y][x + 8] == 0 && array[y][x + 9] == 0 && array[y][x + 10] == 0 || x - 4 >= 0 && array[y][x - 1] == 0 && array[y][x - 2] == 0 && array[y][x - 3] == 0 && array[y][x - 4] == 0)) {
                            penalty += 40;
                        }
                        if (y + 6 >= height || array[y][x] != 1 || array[y + 1][x] != 0 || array[y + 2][x] != 1 || array[y + 3][x] != 1 || array[y + 4][x] != 1 || array[y + 5][x] != 0 || array[y + 6][x] != 1 || (y + 10 >= height || array[y + 7][x] != 0 || array[y + 8][x] != 0 || array[y + 9][x] != 0 || array[y + 10][x] != 0) && (y - 4 < 0 || array[y - 1][x] != 0 || array[y - 2][x] != 0 || array[y - 3][x] != 0 || array[y - 4][x] != 0)) continue;
                        penalty += 40;
                    }
                }
                return penalty;
            }

            public static int ApplyMaskPenaltyRule4(ByteMatrix matrix) {
                int numDarkCells = 0;
                int[][] array = matrix.GetArray();
                int width = matrix.GetWidth();
                int height = matrix.GetHeight();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (array[y][x] != 1) continue;
                        ++numDarkCells;
                    }
                }
                int numTotalCells = matrix.GetHeight() * matrix.GetWidth();
                double darkRatio = numDarkCells / numTotalCells;
                return Math.abs((int)(darkRatio * 100.0 - 50.0)) / 5 * 10;
            }

            public static boolean GetDataMaskBit(int maskPattern, int x, int y) {
                int intermediate;
                if (!StiQRCode.IsValidMaskPattern(maskPattern)) {
                    throw new IllegalArgumentException("Invalid mask pattern");
                }
                switch (maskPattern) {
                    case 0: {
                        intermediate = y + x & 1;
                        break;
                    }
                    case 1: {
                        intermediate = y & 1;
                        break;
                    }
                    case 2: {
                        intermediate = x % 3;
                        break;
                    }
                    case 3: {
                        intermediate = (y + x) % 3;
                        break;
                    }
                    case 4: {
                        intermediate = (y >> 1) + x / 3 & 1;
                        break;
                    }
                    case 5: {
                        int temp = y * x;
                        intermediate = (temp & 1) + temp % 3;
                        break;
                    }
                    case 6: {
                        int temp = y * x;
                        intermediate = (temp & 1) + temp % 3 & 1;
                        break;
                    }
                    case 7: {
                        int temp = y * x;
                        intermediate = temp % 3 + (y + x & 1) & 1;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid mask pattern: " + maskPattern);
                    }
                }
                return intermediate == 0;
            }

            private static int ApplyMaskPenaltyRule1Internal(ByteMatrix matrix, boolean isHorizontal) {
                int penalty = 0;
                int numSameBitCells = 0;
                int prevBit = -1;
                int iLimit = isHorizontal ? matrix.GetHeight() : matrix.GetWidth();
                int jLimit = isHorizontal ? matrix.GetWidth() : matrix.GetHeight();
                int[][] array = matrix.GetArray();
                for (int i = 0; i < iLimit; ++i) {
                    for (int j = 0; j < jLimit; ++j) {
                        int bit;
                        int n = bit = isHorizontal ? array[i][j] : array[j][i];
                        if (bit == prevBit) {
                            if (++numSameBitCells == 5) {
                                penalty += 3;
                                continue;
                            }
                            if (numSameBitCells <= 5) continue;
                            ++penalty;
                            continue;
                        }
                        numSameBitCells = 1;
                        prevBit = bit;
                    }
                    numSameBitCells = 0;
                }
                return penalty;
            }
        }

        public static final class Mode {
            public static final Mode TERMINATOR = new Mode(new int[]{0, 0, 0}, 0, "TERMINATOR");
            public static final Mode NUMERIC = new Mode(new int[]{10, 12, 14}, 1, "NUMERIC");
            public static final Mode ALPHANUMERIC = new Mode(new int[]{9, 11, 13}, 2, "ALPHANUMERIC");
            public static final Mode STRUCTURED_APPEND = new Mode(new int[]{0, 0, 0}, 3, "STRUCTURED_APPEND");
            public static final Mode BYTE = new Mode(new int[]{8, 16, 16}, 4, "BYTE");
            public static final Mode ECI = new Mode(null, 7, "ECI");
            public static final Mode KANJI = new Mode(new int[]{8, 10, 12}, 8, "KANJI");
            public static final Mode FNC1_FIRST_POSITION = new Mode(null, 5, "FNC1_FIRST_POSITION");
            public static final Mode FNC1_SECOND_POSITION = new Mode(null, 9, "FNC1_SECOND_POSITION");
            private final int[] characterCountBitsForVersions;
            private final int bits;
            private final String name;

            private Mode(int[] characterCountBitsForVersions, int bits, String name) {
                this.characterCountBitsForVersions = characterCountBitsForVersions;
                this.bits = bits;
                this.name = name;
            }

            public static Mode ForBits(int bits) {
                switch (bits) {
                    case 0: {
                        return TERMINATOR;
                    }
                    case 1: {
                        return NUMERIC;
                    }
                    case 2: {
                        return ALPHANUMERIC;
                    }
                    case 3: {
                        return STRUCTURED_APPEND;
                    }
                    case 4: {
                        return BYTE;
                    }
                    case 5: {
                        return FNC1_FIRST_POSITION;
                    }
                    case 7: {
                        return ECI;
                    }
                    case 8: {
                        return KANJI;
                    }
                    case 9: {
                        return FNC1_SECOND_POSITION;
                    }
                }
                throw new IllegalArgumentException();
            }

            public int GetCharacterCountBits(Version version) {
                if (this.characterCountBitsForVersions == null) {
                    throw new IllegalArgumentException("Character count doesn't apply to this mode");
                }
                int number = version.GetVersionNumber();
                int offset = number <= 9 ? 0 : (number <= 26 ? 1 : 2);
                return this.characterCountBitsForVersions[offset];
            }

            public int GetBits() {
                return this.bits;
            }

            public String GetName() {
                return this.name;
            }

            public String toString() {
                return this.name;
            }
        }

        public static final class FormatInformation {
            private static final int FORMAT_INFO_MASK_QR = 21522;
            private static final int[][] FORMAT_INFO_DECODE_LOOKUP = new int[][]{{21522, 0}, {20773, 1}, {24188, 2}, {23371, 3}, {17913, 4}, {16590, 5}, {20375, 6}, {19104, 7}, {30660, 8}, {29427, 9}, {32170, 10}, {30877, 11}, {26159, 12}, {25368, 13}, {27713, 14}, {26998, 15}, {5769, 16}, {5054, 17}, {7399, 18}, {6608, 19}, {1890, 20}, {597, 21}, {3340, 22}, {2107, 23}, {13663, 24}, {12392, 25}, {16177, 26}, {14854, 27}, {9396, 28}, {8579, 29}, {11994, 30}, {11245, 31}};
            private static final int[] BITS_SET_IN_HALF_BYTE = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
            private final ErrorCorrectionLevel errorCorrectionLevel;
            private final int dataMask;

            private FormatInformation(int formatInfo) {
                this.errorCorrectionLevel = ErrorCorrectionLevel.ForBits(formatInfo >> 3 & 3);
                this.dataMask = formatInfo & 7;
            }

            public static int NumBitsDiffering(int a, int b) {
                return BITS_SET_IN_HALF_BYTE[(a ^= b) & 0xF] + BITS_SET_IN_HALF_BYTE[a >> 4 & 0xF] + BITS_SET_IN_HALF_BYTE[a >> 8 & 0xF] + BITS_SET_IN_HALF_BYTE[a >> 12 & 0xF] + BITS_SET_IN_HALF_BYTE[a >> 16 & 0xF] + BITS_SET_IN_HALF_BYTE[a >> 20 & 0xF] + BITS_SET_IN_HALF_BYTE[a >> 24 & 0xF] + BITS_SET_IN_HALF_BYTE[a >> 28 & 0xF];
            }

            public static FormatInformation DecodeFormatInformation(int maskedFormatInfo1, int maskedFormatInfo2) {
                FormatInformation formatInfo = FormatInformation.DoDecodeFormatInformation(maskedFormatInfo1, maskedFormatInfo2);
                if (formatInfo != null) {
                    return formatInfo;
                }
                return FormatInformation.DoDecodeFormatInformation(maskedFormatInfo1 ^ 0x5412, maskedFormatInfo2 ^ 0x5412);
            }

            private static FormatInformation DoDecodeFormatInformation(int maskedFormatInfo1, int maskedFormatInfo2) {
                int bestDifference = Integer.MAX_VALUE;
                int bestFormatInfo = 0;
                for (int i = 0; i < FORMAT_INFO_DECODE_LOOKUP.length; ++i) {
                    int[] decodeInfo = FORMAT_INFO_DECODE_LOOKUP[i];
                    int targetInfo = decodeInfo[0];
                    if (targetInfo == maskedFormatInfo1 || targetInfo == maskedFormatInfo2) {
                        return new FormatInformation(decodeInfo[1]);
                    }
                    int bitsDifference = FormatInformation.NumBitsDiffering(maskedFormatInfo1, targetInfo);
                    if (bitsDifference < bestDifference) {
                        bestFormatInfo = decodeInfo[1];
                        bestDifference = bitsDifference;
                    }
                    if (maskedFormatInfo1 == maskedFormatInfo2 || (bitsDifference = FormatInformation.NumBitsDiffering(maskedFormatInfo2, targetInfo)) >= bestDifference) continue;
                    bestFormatInfo = decodeInfo[1];
                    bestDifference = bitsDifference;
                }
                if (bestDifference <= 3) {
                    return new FormatInformation(bestFormatInfo);
                }
                return null;
            }

            public ErrorCorrectionLevel GetErrorCorrectionLevel() {
                return this.errorCorrectionLevel;
            }

            public int GetDataMask() {
                return this.dataMask;
            }

            public int hashCode() {
                return super.hashCode();
            }

            public boolean equals(Object o) {
                if (!(o instanceof FormatInformation)) {
                    return false;
                }
                FormatInformation other = (FormatInformation)o;
                return this.errorCorrectionLevel == other.errorCorrectionLevel && this.dataMask == other.dataMask;
            }
        }

        public static class CharacterSetECI {
            private static HashMap<String, CharacterSetECI> NAME_TO_ECI;
            private final String encodingName;
            private final int value;

            private static void Initialize() {
                HashMap<String, CharacterSetECI> n = new HashMap<String, CharacterSetECI>();
                CharacterSetECI.AddCharacterSet(0, "Cp437", n);
                CharacterSetECI.AddCharacterSet(1, new String[]{"ISO8859_1", "ISO-8859-1"}, n);
                CharacterSetECI.AddCharacterSet(2, "Cp437", n);
                CharacterSetECI.AddCharacterSet(3, new String[]{"ISO8859_1", "ISO-8859-1"}, n);
                CharacterSetECI.AddCharacterSet(4, new String[]{"ISO8859_2", "ISO-8859-2"}, n);
                CharacterSetECI.AddCharacterSet(5, new String[]{"ISO8859_3", "ISO-8859-3"}, n);
                CharacterSetECI.AddCharacterSet(6, new String[]{"ISO8859_4", "ISO-8859-4"}, n);
                CharacterSetECI.AddCharacterSet(7, new String[]{"ISO8859_5", "ISO-8859-5"}, n);
                CharacterSetECI.AddCharacterSet(8, new String[]{"ISO8859_6", "ISO-8859-6"}, n);
                CharacterSetECI.AddCharacterSet(9, new String[]{"ISO8859_7", "ISO-8859-7"}, n);
                CharacterSetECI.AddCharacterSet(10, new String[]{"ISO8859_8", "ISO-8859-8"}, n);
                CharacterSetECI.AddCharacterSet(11, new String[]{"ISO8859_9", "ISO-8859-9"}, n);
                CharacterSetECI.AddCharacterSet(12, new String[]{"ISO8859_10", "ISO-8859-10"}, n);
                CharacterSetECI.AddCharacterSet(13, new String[]{"ISO8859_11", "ISO-8859-11"}, n);
                CharacterSetECI.AddCharacterSet(15, new String[]{"ISO8859_13", "ISO-8859-13"}, n);
                CharacterSetECI.AddCharacterSet(16, new String[]{"ISO8859_14", "ISO-8859-14"}, n);
                CharacterSetECI.AddCharacterSet(17, new String[]{"ISO8859_15", "ISO-8859-15"}, n);
                CharacterSetECI.AddCharacterSet(18, new String[]{"ISO8859_16", "ISO-8859-16"}, n);
                CharacterSetECI.AddCharacterSet(20, new String[]{"SJIS", "Shift_JIS"}, n);
                NAME_TO_ECI = n;
            }

            private CharacterSetECI(int value, String encodingName) {
                this.value = value;
                this.encodingName = encodingName;
            }

            public final String GetEncodingName() {
                return this.encodingName;
            }

            public final int GetValue() {
                return this.value;
            }

            private static void AddCharacterSet(int value, String encodingName, HashMap<String, CharacterSetECI> n) {
                CharacterSetECI eci = new CharacterSetECI(value, encodingName);
                n.put(encodingName, eci);
            }

            private static void AddCharacterSet(int value, String[] encodingNames, HashMap<String, CharacterSetECI> n) {
                CharacterSetECI eci = new CharacterSetECI(value, encodingNames[0]);
                for (int i = 0; i < encodingNames.length; ++i) {
                    n.put(encodingNames[i], eci);
                }
            }

            public static CharacterSetECI GetCharacterSetECIByName(String name) {
                if (NAME_TO_ECI == null) {
                    CharacterSetECI.Initialize();
                }
                CharacterSetECI c = null;
                c = NAME_TO_ECI.get(name);
                return c;
            }
        }

        public static final class StiQRCodeException
        extends RuntimeException {
            public StiQRCodeException() {
            }

            public StiQRCodeException(String message) {
                super(message);
            }
        }

        public static final class Version {
            private static final int[] VERSION_DECODE_INFO = new int[]{31892, 34236, 39577, 42195, 48118, 51042, 55367, 58893, 63784, 68472, 70749, 76311, 79154, 84390, 87683, 92361, 96236, 102084, 102881, 110507, 110734, 117786, 119615, 126325, 127568, 133589, 136944, 141498, 145311, 150283, 152622, 158308, 161089, 167017};
            private static final Version[] VERSIONS = Version.BuildVersions();
            private final int versionNumber;
            private final int[] alignmentPatternCenters;
            private final ECBlocks[] ecBlocks;
            private final int totalCodewords;

            private Version(int versionNumber, int[] alignmentPatternCenters, ECBlocks ecBlocks1, ECBlocks ecBlocks2, ECBlocks ecBlocks3, ECBlocks ecBlocks4) {
                this.versionNumber = versionNumber;
                this.alignmentPatternCenters = alignmentPatternCenters;
                this.ecBlocks = new ECBlocks[]{ecBlocks1, ecBlocks2, ecBlocks3, ecBlocks4};
                int total = 0;
                int ecCodewords = ecBlocks1.GetECCodewordsPerBlock();
                ECB[] ecbArray = ecBlocks1.GetECBlocks();
                for (int i = 0; i < ecbArray.length; ++i) {
                    ECB ecBlock = ecbArray[i];
                    total += ecBlock.GetCount() * (ecBlock.GetDataCodewords() + ecCodewords);
                }
                this.totalCodewords = total;
            }

            public int GetVersionNumber() {
                return this.versionNumber;
            }

            public int[] GetAlignmentPatternCenters() {
                return this.alignmentPatternCenters;
            }

            public int GetTotalCodewords() {
                return this.totalCodewords;
            }

            public int GetDimensionForVersion() {
                return 17 + 4 * this.versionNumber;
            }

            public ECBlocks GetECBlocksForLevel(ErrorCorrectionLevel ecLevel) {
                return this.ecBlocks[ecLevel.Ordinal()];
            }

            public static Version GetProvisionalVersionForDimension(int dimension) {
                if (dimension % 4 != 1) {
                    throw new IllegalArgumentException();
                }
                return Version.GetVersionForNumber(dimension - 17 >> 2);
            }

            public static Version GetVersionForNumber(int versionNumber) {
                if (versionNumber < 1 || versionNumber > 40) {
                    throw new IllegalArgumentException();
                }
                return VERSIONS[versionNumber - 1];
            }

            private static Version DecodeVersionInformation(int versionBits) {
                int bestDifference = Integer.MAX_VALUE;
                int bestVersion = 0;
                for (int i = 0; i < VERSION_DECODE_INFO.length; ++i) {
                    int targetVersion = VERSION_DECODE_INFO[i];
                    if (targetVersion == versionBits) {
                        return Version.GetVersionForNumber(i + 7);
                    }
                    int bitsDifference = FormatInformation.NumBitsDiffering(versionBits, targetVersion);
                    if (bitsDifference >= bestDifference) continue;
                    bestVersion = i + 7;
                    bestDifference = bitsDifference;
                }
                if (bestDifference <= 3) {
                    return Version.GetVersionForNumber(bestVersion);
                }
                return null;
            }

            public String toString() {
                return new Integer(this.versionNumber).toString();
            }

            private static Version[] BuildVersions() {
                return new Version[]{new Version(1, new int[0], new ECBlocks(7, new ECB(1, 19)), new ECBlocks(10, new ECB(1, 16)), new ECBlocks(13, new ECB(1, 13)), new ECBlocks(17, new ECB(1, 9))), new Version(2, new int[]{6, 18}, new ECBlocks(10, new ECB(1, 34)), new ECBlocks(16, new ECB(1, 28)), new ECBlocks(22, new ECB(1, 22)), new ECBlocks(28, new ECB(1, 16))), new Version(3, new int[]{6, 22}, new ECBlocks(15, new ECB(1, 55)), new ECBlocks(26, new ECB(1, 44)), new ECBlocks(18, new ECB(2, 17)), new ECBlocks(22, new ECB(2, 13))), new Version(4, new int[]{6, 26}, new ECBlocks(20, new ECB(1, 80)), new ECBlocks(18, new ECB(2, 32)), new ECBlocks(26, new ECB(2, 24)), new ECBlocks(16, new ECB(4, 9))), new Version(5, new int[]{6, 30}, new ECBlocks(26, new ECB(1, 108)), new ECBlocks(24, new ECB(2, 43)), new ECBlocks(18, new ECB(2, 15), new ECB(2, 16)), new ECBlocks(22, new ECB(2, 11), new ECB(2, 12))), new Version(6, new int[]{6, 34}, new ECBlocks(18, new ECB(2, 68)), new ECBlocks(16, new ECB(4, 27)), new ECBlocks(24, new ECB(4, 19)), new ECBlocks(28, new ECB(4, 15))), new Version(7, new int[]{6, 22, 38}, new ECBlocks(20, new ECB(2, 78)), new ECBlocks(18, new ECB(4, 31)), new ECBlocks(18, new ECB(2, 14), new ECB(4, 15)), new ECBlocks(26, new ECB(4, 13), new ECB(1, 14))), new Version(8, new int[]{6, 24, 42}, new ECBlocks(24, new ECB(2, 97)), new ECBlocks(22, new ECB(2, 38), new ECB(2, 39)), new ECBlocks(22, new ECB(4, 18), new ECB(2, 19)), new ECBlocks(26, new ECB(4, 14), new ECB(2, 15))), new Version(9, new int[]{6, 26, 46}, new ECBlocks(30, new ECB(2, 116)), new ECBlocks(22, new ECB(3, 36), new ECB(2, 37)), new ECBlocks(20, new ECB(4, 16), new ECB(4, 17)), new ECBlocks(24, new ECB(4, 12), new ECB(4, 13))), new Version(10, new int[]{6, 28, 50}, new ECBlocks(18, new ECB(2, 68), new ECB(2, 69)), new ECBlocks(26, new ECB(4, 43), new ECB(1, 44)), new ECBlocks(24, new ECB(6, 19), new ECB(2, 20)), new ECBlocks(28, new ECB(6, 15), new ECB(2, 16))), new Version(11, new int[]{6, 30, 54}, new ECBlocks(20, new ECB(4, 81)), new ECBlocks(30, new ECB(1, 50), new ECB(4, 51)), new ECBlocks(28, new ECB(4, 22), new ECB(4, 23)), new ECBlocks(24, new ECB(3, 12), new ECB(8, 13))), new Version(12, new int[]{6, 32, 58}, new ECBlocks(24, new ECB(2, 92), new ECB(2, 93)), new ECBlocks(22, new ECB(6, 36), new ECB(2, 37)), new ECBlocks(26, new ECB(4, 20), new ECB(6, 21)), new ECBlocks(28, new ECB(7, 14), new ECB(4, 15))), new Version(13, new int[]{6, 34, 62}, new ECBlocks(26, new ECB(4, 107)), new ECBlocks(22, new ECB(8, 37), new ECB(1, 38)), new ECBlocks(24, new ECB(8, 20), new ECB(4, 21)), new ECBlocks(22, new ECB(12, 11), new ECB(4, 12))), new Version(14, new int[]{6, 26, 46, 66}, new ECBlocks(30, new ECB(3, 115), new ECB(1, 116)), new ECBlocks(24, new ECB(4, 40), new ECB(5, 41)), new ECBlocks(20, new ECB(11, 16), new ECB(5, 17)), new ECBlocks(24, new ECB(11, 12), new ECB(5, 13))), new Version(15, new int[]{6, 26, 48, 70}, new ECBlocks(22, new ECB(5, 87), new ECB(1, 88)), new ECBlocks(24, new ECB(5, 41), new ECB(5, 42)), new ECBlocks(30, new ECB(5, 24), new ECB(7, 25)), new ECBlocks(24, new ECB(11, 12), new ECB(7, 13))), new Version(16, new int[]{6, 26, 50, 74}, new ECBlocks(24, new ECB(5, 98), new ECB(1, 99)), new ECBlocks(28, new ECB(7, 45), new ECB(3, 46)), new ECBlocks(24, new ECB(15, 19), new ECB(2, 20)), new ECBlocks(30, new ECB(3, 15), new ECB(13, 16))), new Version(17, new int[]{6, 30, 54, 78}, new ECBlocks(28, new ECB(1, 107), new ECB(5, 108)), new ECBlocks(28, new ECB(10, 46), new ECB(1, 47)), new ECBlocks(28, new ECB(1, 22), new ECB(15, 23)), new ECBlocks(28, new ECB(2, 14), new ECB(17, 15))), new Version(18, new int[]{6, 30, 56, 82}, new ECBlocks(30, new ECB(5, 120), new ECB(1, 121)), new ECBlocks(26, new ECB(9, 43), new ECB(4, 44)), new ECBlocks(28, new ECB(17, 22), new ECB(1, 23)), new ECBlocks(28, new ECB(2, 14), new ECB(19, 15))), new Version(19, new int[]{6, 30, 58, 86}, new ECBlocks(28, new ECB(3, 113), new ECB(4, 114)), new ECBlocks(26, new ECB(3, 44), new ECB(11, 45)), new ECBlocks(26, new ECB(17, 21), new ECB(4, 22)), new ECBlocks(26, new ECB(9, 13), new ECB(16, 14))), new Version(20, new int[]{6, 34, 62, 90}, new ECBlocks(28, new ECB(3, 107), new ECB(5, 108)), new ECBlocks(26, new ECB(3, 41), new ECB(13, 42)), new ECBlocks(30, new ECB(15, 24), new ECB(5, 25)), new ECBlocks(28, new ECB(15, 15), new ECB(10, 16))), new Version(21, new int[]{6, 28, 50, 72, 94}, new ECBlocks(28, new ECB(4, 116), new ECB(4, 117)), new ECBlocks(26, new ECB(17, 42)), new ECBlocks(28, new ECB(17, 22), new ECB(6, 23)), new ECBlocks(30, new ECB(19, 16), new ECB(6, 17))), new Version(22, new int[]{6, 26, 50, 74, 98}, new ECBlocks(28, new ECB(2, 111), new ECB(7, 112)), new ECBlocks(28, new ECB(17, 46)), new ECBlocks(30, new ECB(7, 24), new ECB(16, 25)), new ECBlocks(24, new ECB(34, 13))), new Version(23, new int[]{6, 30, 54, 74, 102}, new ECBlocks(30, new ECB(4, 121), new ECB(5, 122)), new ECBlocks(28, new ECB(4, 47), new ECB(14, 48)), new ECBlocks(30, new ECB(11, 24), new ECB(14, 25)), new ECBlocks(30, new ECB(16, 15), new ECB(14, 16))), new Version(24, new int[]{6, 28, 54, 80, 106}, new ECBlocks(30, new ECB(6, 117), new ECB(4, 118)), new ECBlocks(28, new ECB(6, 45), new ECB(14, 46)), new ECBlocks(30, new ECB(11, 24), new ECB(16, 25)), new ECBlocks(30, new ECB(30, 16), new ECB(2, 17))), new Version(25, new int[]{6, 32, 58, 84, 110}, new ECBlocks(26, new ECB(8, 106), new ECB(4, 107)), new ECBlocks(28, new ECB(8, 47), new ECB(13, 48)), new ECBlocks(30, new ECB(7, 24), new ECB(22, 25)), new ECBlocks(30, new ECB(22, 15), new ECB(13, 16))), new Version(26, new int[]{6, 30, 58, 86, 114}, new ECBlocks(28, new ECB(10, 114), new ECB(2, 115)), new ECBlocks(28, new ECB(19, 46), new ECB(4, 47)), new ECBlocks(28, new ECB(28, 22), new ECB(6, 23)), new ECBlocks(30, new ECB(33, 16), new ECB(4, 17))), new Version(27, new int[]{6, 34, 62, 90, 118}, new ECBlocks(30, new ECB(8, 122), new ECB(4, 123)), new ECBlocks(28, new ECB(22, 45), new ECB(3, 46)), new ECBlocks(30, new ECB(8, 23), new ECB(26, 24)), new ECBlocks(30, new ECB(12, 15), new ECB(28, 16))), new Version(28, new int[]{6, 26, 50, 74, 98, 122}, new ECBlocks(30, new ECB(3, 117), new ECB(10, 118)), new ECBlocks(28, new ECB(3, 45), new ECB(23, 46)), new ECBlocks(30, new ECB(4, 24), new ECB(31, 25)), new ECBlocks(30, new ECB(11, 15), new ECB(31, 16))), new Version(29, new int[]{6, 30, 54, 78, 102, 126}, new ECBlocks(30, new ECB(7, 116), new ECB(7, 117)), new ECBlocks(28, new ECB(21, 45), new ECB(7, 46)), new ECBlocks(30, new ECB(1, 23), new ECB(37, 24)), new ECBlocks(30, new ECB(19, 15), new ECB(26, 16))), new Version(30, new int[]{6, 26, 52, 78, 104, 130}, new ECBlocks(30, new ECB(5, 115), new ECB(10, 116)), new ECBlocks(28, new ECB(19, 47), new ECB(10, 48)), new ECBlocks(30, new ECB(15, 24), new ECB(25, 25)), new ECBlocks(30, new ECB(23, 15), new ECB(25, 16))), new Version(31, new int[]{6, 30, 56, 82, 108, 134}, new ECBlocks(30, new ECB(13, 115), new ECB(3, 116)), new ECBlocks(28, new ECB(2, 46), new ECB(29, 47)), new ECBlocks(30, new ECB(42, 24), new ECB(1, 25)), new ECBlocks(30, new ECB(23, 15), new ECB(28, 16))), new Version(32, new int[]{6, 34, 60, 86, 112, 138}, new ECBlocks(30, new ECB(17, 115)), new ECBlocks(28, new ECB(10, 46), new ECB(23, 47)), new ECBlocks(30, new ECB(10, 24), new ECB(35, 25)), new ECBlocks(30, new ECB(19, 15), new ECB(35, 16))), new Version(33, new int[]{6, 30, 58, 86, 114, 142}, new ECBlocks(30, new ECB(17, 115), new ECB(1, 116)), new ECBlocks(28, new ECB(14, 46), new ECB(21, 47)), new ECBlocks(30, new ECB(29, 24), new ECB(19, 25)), new ECBlocks(30, new ECB(11, 15), new ECB(46, 16))), new Version(34, new int[]{6, 34, 62, 90, 118, 146}, new ECBlocks(30, new ECB(13, 115), new ECB(6, 116)), new ECBlocks(28, new ECB(14, 46), new ECB(23, 47)), new ECBlocks(30, new ECB(44, 24), new ECB(7, 25)), new ECBlocks(30, new ECB(59, 16), new ECB(1, 17))), new Version(35, new int[]{6, 30, 54, 78, 102, 126, 150}, new ECBlocks(30, new ECB(12, 121), new ECB(7, 122)), new ECBlocks(28, new ECB(12, 47), new ECB(26, 48)), new ECBlocks(30, new ECB(39, 24), new ECB(14, 25)), new ECBlocks(30, new ECB(22, 15), new ECB(41, 16))), new Version(36, new int[]{6, 24, 50, 76, 102, 128, 154}, new ECBlocks(30, new ECB(6, 121), new ECB(14, 122)), new ECBlocks(28, new ECB(6, 47), new ECB(34, 48)), new ECBlocks(30, new ECB(46, 24), new ECB(10, 25)), new ECBlocks(30, new ECB(2, 15), new ECB(64, 16))), new Version(37, new int[]{6, 28, 54, 80, 106, 132, 158}, new ECBlocks(30, new ECB(17, 122), new ECB(4, 123)), new ECBlocks(28, new ECB(29, 46), new ECB(14, 47)), new ECBlocks(30, new ECB(49, 24), new ECB(10, 25)), new ECBlocks(30, new ECB(24, 15), new ECB(46, 16))), new Version(38, new int[]{6, 32, 58, 84, 110, 136, 162}, new ECBlocks(30, new ECB(4, 122), new ECB(18, 123)), new ECBlocks(28, new ECB(13, 46), new ECB(32, 47)), new ECBlocks(30, new ECB(48, 24), new ECB(14, 25)), new ECBlocks(30, new ECB(42, 15), new ECB(32, 16))), new Version(39, new int[]{6, 26, 54, 82, 110, 138, 166}, new ECBlocks(30, new ECB(20, 117), new ECB(4, 118)), new ECBlocks(28, new ECB(40, 47), new ECB(7, 48)), new ECBlocks(30, new ECB(43, 24), new ECB(22, 25)), new ECBlocks(30, new ECB(10, 15), new ECB(67, 16))), new Version(40, new int[]{6, 30, 58, 86, 114, 142, 170}, new ECBlocks(30, new ECB(19, 118), new ECB(6, 119)), new ECBlocks(28, new ECB(18, 47), new ECB(31, 48)), new ECBlocks(30, new ECB(34, 24), new ECB(34, 25)), new ECBlocks(30, new ECB(20, 15), new ECB(61, 16)))};
            }

            public static final class ECB {
                private final int count;
                private final int dataCodewords;

                public ECB(int count, int dataCodewords) {
                    this.count = count;
                    this.dataCodewords = dataCodewords;
                }

                public int GetCount() {
                    return this.count;
                }

                public int GetDataCodewords() {
                    return this.dataCodewords;
                }
            }

            public static final class ECBlocks {
                private final int ecCodewordsPerBlock;
                private final ECB[] ecBlocks;

                public ECBlocks(int ecCodewordsPerBlock, ECB ecBlocks) {
                    this.ecCodewordsPerBlock = ecCodewordsPerBlock;
                    this.ecBlocks = new ECB[]{ecBlocks};
                }

                public ECBlocks(int ecCodewordsPerBlock, ECB ecBlocks1, ECB ecBlocks2) {
                    this.ecCodewordsPerBlock = ecCodewordsPerBlock;
                    this.ecBlocks = new ECB[]{ecBlocks1, ecBlocks2};
                }

                public int GetECCodewordsPerBlock() {
                    return this.ecCodewordsPerBlock;
                }

                public int GetNumBlocks() {
                    int total = 0;
                    for (int i = 0; i < this.ecBlocks.length; ++i) {
                        total += this.ecBlocks[i].GetCount();
                    }
                    return total;
                }

                public int GetTotalECCodewords() {
                    return this.ecCodewordsPerBlock * this.GetNumBlocks();
                }

                public ECB[] GetECBlocks() {
                    return this.ecBlocks;
                }
            }
        }

        public static final class BitVector {
            private int sizeInBits = 0;
            private int[] array = new int[32];
            private static final int DEFAULT_SIZE_IN_BYTES = 32;

            public int At(int index) {
                if (index < 0 || index >= this.sizeInBits) {
                    throw new IndexOutOfBoundsException("Bad index: " + index);
                }
                int value = this.array[index >> 3] & 0xFF;
                return value >> 7 - (index & 7) & 1;
            }

            public int Size() {
                return this.sizeInBits;
            }

            public int SizeInBytes() {
                return this.sizeInBits + 7 >> 3;
            }

            public void AppendBit(int bit) {
                if (bit != 0 && bit != 1) {
                    throw new IllegalArgumentException("Bad bit");
                }
                int numBitsInLastByte = this.sizeInBits & 7;
                if (numBitsInLastByte == 0) {
                    this.AppendByte(0);
                    this.sizeInBits -= 8;
                }
                int n = this.sizeInBits >> 3;
                this.array[n] = this.array[n] | bit << 7 - numBitsInLastByte;
                ++this.sizeInBits;
            }

            public void AppendBits(int value, int numBits) {
                if (numBits < 0 || numBits > 32) {
                    throw new IllegalArgumentException("Num bits must be between 0 and 32");
                }
                int numBitsLeft = numBits;
                while (numBitsLeft > 0) {
                    if ((this.sizeInBits & 7) == 0 && numBitsLeft >= 8) {
                        int newByte = value >> numBitsLeft - 8 & 0xFF;
                        this.AppendByte(newByte);
                        numBitsLeft -= 8;
                        continue;
                    }
                    int bit = value >> numBitsLeft - 1 & 1;
                    this.AppendBit(bit);
                    --numBitsLeft;
                }
            }

            public void AppendBitVector(BitVector bits) {
                int size = bits.Size();
                for (int i = 0; i < size; ++i) {
                    this.AppendBit(bits.At(i));
                }
            }

            public void Xor(BitVector other) {
                if (this.sizeInBits != other.Size()) {
                    throw new IllegalArgumentException("BitVector sizes don't match");
                }
                int sizeInBytes = this.sizeInBits + 7 >> 3;
                for (int i = 0; i < sizeInBytes; ++i) {
                    int n = i;
                    this.array[n] = this.array[n] ^ other.array[i];
                }
            }

            public String toString() {
                StringBuilder result = new StringBuilder(this.sizeInBits);
                for (int i = 0; i < this.sizeInBits; ++i) {
                    if (this.At(i) == 0) {
                        result.append('0');
                        continue;
                    }
                    if (this.At(i) == 1) {
                        result.append('1');
                        continue;
                    }
                    throw new IllegalArgumentException("Byte isn't 0 or 1");
                }
                return result.toString();
            }

            public int[] GetArray() {
                return this.array;
            }

            private void AppendByte(int value) {
                if (this.sizeInBits >> 3 == this.array.length) {
                    int[] newArray = new int[this.array.length << 1];
                    System.arraycopy(this.array, 0, newArray, 0, this.array.length);
                    this.array = newArray;
                }
                this.array[this.sizeInBits >> 3] = value;
                this.sizeInBits += 8;
            }
        }

        public static final class BlockPair {
            private final ByteArray dataBytes;
            private final ByteArray errorCorrectionBytes;

            public BlockPair(ByteArray data, ByteArray errorCorrection) {
                this.dataBytes = data;
                this.errorCorrectionBytes = errorCorrection;
            }

            public ByteArray GetDataBytes() {
                return this.dataBytes;
            }

            public ByteArray GetErrorCorrectionBytes() {
                return this.errorCorrectionBytes;
            }
        }

        public static final class ByteArray {
            private static final int INITIAL_SIZE = 32;
            private int[] bytes;
            private int size;

            public ByteArray() {
                this.bytes = null;
                this.size = 0;
            }

            public ByteArray(int size) {
                this.bytes = new int[size];
                this.size = size;
            }

            public ByteArray(int[] byteArray) {
                this.bytes = byteArray;
                this.size = this.bytes.length;
            }

            public int At(int index) {
                return this.bytes[index] & 0xFF;
            }

            public void Set(int index, int value) {
                this.bytes[index] = value;
            }

            public int Size() {
                return this.size;
            }

            public boolean IsEmpty() {
                return this.size == 0;
            }

            public void AppendByte(int value) {
                if (this.size == 0 || this.size >= this.bytes.length) {
                    int newSize = Math.max(32, this.size << 1);
                    this.Reserve(newSize);
                }
                this.bytes[this.size] = value;
                ++this.size;
            }

            public void Reserve(int capacity) {
                if (this.bytes == null || this.bytes.length < capacity) {
                    int[] newArray = new int[capacity];
                    if (this.bytes != null) {
                        System.arraycopy(this.bytes, 0, newArray, 0, this.bytes.length);
                    }
                    this.bytes = newArray;
                }
            }

            public void Set(int[] source, int offset, int count) {
                this.bytes = new int[count];
                this.size = count;
                for (int x = 0; x < count; ++x) {
                    this.bytes[x] = source[offset + x];
                }
            }
        }

        public static final class ByteMatrix {
            private final int[][] bytes;
            private final int width;
            private final int height;

            public ByteMatrix(int width, int height) {
                this.bytes = new int[height][];
                for (int k = 0; k < height; ++k) {
                    this.bytes[k] = new int[width];
                }
                this.width = width;
                this.height = height;
            }

            public int GetHeight() {
                return this.height;
            }

            public int GetWidth() {
                return this.width;
            }

            public int Get(int x, int y) {
                return this.bytes[y][x];
            }

            public int[][] GetArray() {
                return this.bytes;
            }

            public void Set(int x, int y, byte value) {
                this.bytes[y][x] = value;
            }

            public void Set(int x, int y, int value) {
                this.bytes[y][x] = value;
            }

            public void Clear(int value) {
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        this.bytes[y][x] = value;
                    }
                }
            }
        }

        public static final class ErrorCorrectionLevel {
            public static final ErrorCorrectionLevel L = new ErrorCorrectionLevel(0, 1, "L");
            public static final ErrorCorrectionLevel M = new ErrorCorrectionLevel(1, 0, "M");
            public static final ErrorCorrectionLevel Q = new ErrorCorrectionLevel(2, 3, "Q");
            public static final ErrorCorrectionLevel H = new ErrorCorrectionLevel(3, 2, "H");
            private static final ErrorCorrectionLevel[] FOR_BITS = new ErrorCorrectionLevel[]{M, L, H, Q};
            private final int ordinal;
            private final int bits;
            private final String name;

            private ErrorCorrectionLevel(int ordinal, int bits, String name) {
                this.ordinal = ordinal;
                this.bits = bits;
                this.name = name;
            }

            public int Ordinal() {
                return this.ordinal;
            }

            public int GetBits() {
                return this.bits;
            }

            public String GetName() {
                return this.name;
            }

            public String toString() {
                return this.name;
            }

            public static ErrorCorrectionLevel ForBits(int bits) {
                if (bits < 0 || bits >= FOR_BITS.length) {
                    throw new IndexOutOfBoundsException();
                }
                return FOR_BITS[bits];
            }
        }

        public static final class QREncoder {
            private static final int[] ALPHANUMERIC_TABLE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, -1, -1, -1, 37, 38, -1, -1, -1, -1, 39, 40, -1, 41, 42, 43, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 44, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, -1, -1, -1, -1, -1};
            private static final String DEFAULT_BYTE_MODE_ENCODING = "UTF-8";

            private QREncoder() {
            }

            private static int CalculateMaskPenalty(ByteMatrix matrix) {
                int penalty = 0;
                penalty += MaskUtil.ApplyMaskPenaltyRule1(matrix);
                penalty += MaskUtil.ApplyMaskPenaltyRule2(matrix);
                penalty += MaskUtil.ApplyMaskPenaltyRule3(matrix);
                return penalty += MaskUtil.ApplyMaskPenaltyRule4(matrix);
            }

            public static void Encode(String content, ErrorCorrectionLevel ecLevel, StiQRCode qrCode) {
                CharacterSetECI eci;
                if (content == null || content.length() == 0) {
                    throw new IllegalArgumentException("Found empty contents");
                }
                String encoding = Charset.isSupported(StiOptions.Engine.getBarcodeQRCodeDefaultByteModeEncoding()) ? StiOptions.Engine.getBarcodeQRCodeDefaultByteModeEncoding() : DEFAULT_BYTE_MODE_ENCODING;
                Mode mode = QREncoder.ChooseMode(content, encoding);
                BitVector dataBits = new BitVector();
                QREncoder.AppendBytes(content, mode, dataBits, encoding);
                int numInputBytes = dataBits.SizeInBytes();
                QREncoder.InitQRCode(numInputBytes, ecLevel, mode, qrCode);
                BitVector headerAndDataBits = new BitVector();
                if (mode == Mode.BYTE && !DEFAULT_BYTE_MODE_ENCODING.equals(encoding) && (eci = CharacterSetECI.GetCharacterSetECIByName(encoding)) != null) {
                    QREncoder.AppendECI(eci, headerAndDataBits);
                }
                QREncoder.AppendModeInfo(mode, headerAndDataBits);
                int numLetters = mode.equals(Mode.BYTE) ? dataBits.SizeInBytes() : content.length();
                QREncoder.AppendLengthInfo(numLetters, qrCode.GetVersion(), mode, headerAndDataBits);
                headerAndDataBits.AppendBitVector(dataBits);
                QREncoder.TerminateBits(qrCode.GetNumDataBytes(), headerAndDataBits);
                BitVector finalBits = new BitVector();
                QREncoder.InterleaveWithECBytes(headerAndDataBits, qrCode.GetNumTotalBytes(), qrCode.GetNumDataBytes(), qrCode.GetNumRSBlocks(), finalBits);
                ByteMatrix matrix = new ByteMatrix(qrCode.GetMatrixWidth(), qrCode.GetMatrixWidth());
                qrCode.SetMaskPattern(QREncoder.ChooseMaskPattern(finalBits, qrCode.GetECLevel(), qrCode.GetVersion(), matrix));
                MatrixUtil.BuildMatrix(finalBits, qrCode.GetECLevel(), qrCode.GetVersion(), qrCode.GetMaskPattern(), matrix);
                qrCode.SetMatrix(matrix);
                if (!qrCode.IsValid()) {
                    throw new StiQRCodeException("Invalid QR code: " + qrCode.toString());
                }
            }

            private static int GetAlphanumericCode(int code) {
                if (code < ALPHANUMERIC_TABLE.length) {
                    return ALPHANUMERIC_TABLE[code];
                }
                return -1;
            }

            public static Mode ChooseMode(String content) {
                return QREncoder.ChooseMode(content, null);
            }

            public static Mode ChooseMode(String content, String encoding) {
                if (new String("Shift_JIS").equals(encoding)) {
                    return QREncoder.IsOnlyDoubleByteKanji(content) ? Mode.KANJI : Mode.BYTE;
                }
                boolean hasNumeric = false;
                boolean hasAlphanumeric = false;
                for (int i = 0; i < content.length(); ++i) {
                    char c = content.charAt(i);
                    if (c >= '0' && c <= '9') {
                        hasNumeric = true;
                        continue;
                    }
                    if (QREncoder.GetAlphanumericCode(c) != -1) {
                        hasAlphanumeric = true;
                        continue;
                    }
                    return Mode.BYTE;
                }
                if (hasAlphanumeric) {
                    return Mode.ALPHANUMERIC;
                }
                if (hasNumeric) {
                    return Mode.NUMERIC;
                }
                return Mode.BYTE;
            }

            private static boolean IsOnlyDoubleByteKanji(String content) {
                int[] bytes;
                try {
                    bytes = StiBarCodeTypeService.toInts("Shift_JIS".getBytes(content));
                }
                catch (Exception e) {
                    return false;
                }
                int length = bytes.length;
                if (length % 2 != 0) {
                    return false;
                }
                for (int i = 0; i < length; i += 2) {
                    int byte1 = bytes[i] & 0xFF;
                    if (byte1 >= 129 && byte1 <= 159 || byte1 >= 224 && byte1 <= 235) continue;
                    return false;
                }
                return true;
            }

            private static int ChooseMaskPattern(BitVector bits, ErrorCorrectionLevel ecLevel, int version, ByteMatrix matrix) {
                int minPenalty = Integer.MAX_VALUE;
                int bestMaskPattern = -1;
                for (int maskPattern = 0; maskPattern < 8; ++maskPattern) {
                    MatrixUtil.BuildMatrix(bits, ecLevel, version, maskPattern, matrix);
                    int penalty = QREncoder.CalculateMaskPenalty(matrix);
                    if (penalty >= minPenalty) continue;
                    minPenalty = penalty;
                    bestMaskPattern = maskPattern;
                }
                return bestMaskPattern;
            }

            private static void InitQRCode(int numInputBytes, ErrorCorrectionLevel ecLevel, Mode mode, StiQRCode qrCode) {
                qrCode.SetECLevel(ecLevel);
                qrCode.SetMode(mode);
                for (int versionNum = 1; versionNum <= 40; ++versionNum) {
                    Version version = Version.GetVersionForNumber(versionNum);
                    int numBytes = version.GetTotalCodewords();
                    Version.ECBlocks ecBlocks = version.GetECBlocksForLevel(ecLevel);
                    int numEcBytes = ecBlocks.GetTotalECCodewords();
                    int numRSBlocks = ecBlocks.GetNumBlocks();
                    int numDataBytes = numBytes - numEcBytes;
                    if (numDataBytes < numInputBytes + 3) continue;
                    qrCode.SetVersion(versionNum);
                    qrCode.SetNumTotalBytes(numBytes);
                    qrCode.SetNumDataBytes(numDataBytes);
                    qrCode.SetNumRSBlocks(numRSBlocks);
                    qrCode.SetNumECBytes(numEcBytes);
                    qrCode.SetMatrixWidth(version.GetDimensionForVersion());
                    return;
                }
                throw new StiQRCodeException("Cannot find proper rs block info (input data too big?)");
            }

            private static void TerminateBits(int numDataBytes, BitVector bits) {
                int i;
                int capacity = numDataBytes << 3;
                if (bits.Size() > capacity) {
                    throw new StiQRCodeException("data bits cannot fit in the QR Code" + bits.Size() + " > " + capacity);
                }
                for (int i2 = 0; i2 < 4 && bits.Size() < capacity; ++i2) {
                    bits.AppendBit(0);
                }
                int numBitsInLastByte = bits.Size() % 8;
                if (numBitsInLastByte > 0) {
                    int numPaddingBits = 8 - numBitsInLastByte;
                    for (i = 0; i < numPaddingBits; ++i) {
                        bits.AppendBit(0);
                    }
                }
                if (bits.Size() % 8 != 0) {
                    throw new StiQRCodeException("Number of bits is not a multiple of 8");
                }
                int numPaddingBytes = numDataBytes - bits.SizeInBytes();
                for (i = 0; i < numPaddingBytes; ++i) {
                    if (i % 2 == 0) {
                        bits.AppendBits(236, 8);
                        continue;
                    }
                    bits.AppendBits(17, 8);
                }
                if (bits.Size() != capacity) {
                    throw new StiQRCodeException("Bits size does not equal capacity");
                }
            }

            private static void GetNumDataBytesAndNumECBytesForBlockID(int numTotalBytes, int numDataBytes, int numRSBlocks, int blockID, int[] numDataBytesInBlock, int[] numECBytesInBlock) {
                if (blockID >= numRSBlocks) {
                    throw new StiQRCodeException("Block ID too large");
                }
                int numRsBlocksInGroup2 = numTotalBytes % numRSBlocks;
                int numRsBlocksInGroup1 = numRSBlocks - numRsBlocksInGroup2;
                int numTotalBytesInGroup1 = numTotalBytes / numRSBlocks;
                int numDataBytesInGroup1 = numDataBytes / numRSBlocks;
                int numEcBytesInGroup1 = numTotalBytesInGroup1 - numDataBytesInGroup1;
                int numTotalBytesInGroup2 = numTotalBytesInGroup1 + 1;
                int numDataBytesInGroup2 = numDataBytesInGroup1 + 1;
                int numEcBytesInGroup2 = numTotalBytesInGroup2 - numDataBytesInGroup2;
                if (numEcBytesInGroup1 != numEcBytesInGroup2) {
                    throw new StiQRCodeException("EC bytes mismatch");
                }
                if (numRSBlocks != numRsBlocksInGroup1 + numRsBlocksInGroup2) {
                    throw new StiQRCodeException("RS blocks mismatch");
                }
                if (numTotalBytes != (numDataBytesInGroup1 + numEcBytesInGroup1) * numRsBlocksInGroup1 + (numDataBytesInGroup2 + numEcBytesInGroup2) * numRsBlocksInGroup2) {
                    throw new StiQRCodeException("Total bytes mismatch");
                }
                if (blockID < numRsBlocksInGroup1) {
                    numDataBytesInBlock[0] = numDataBytesInGroup1;
                    numECBytesInBlock[0] = numEcBytesInGroup1;
                } else {
                    numDataBytesInBlock[0] = numDataBytesInGroup2;
                    numECBytesInBlock[0] = numEcBytesInGroup2;
                }
            }

            private static void InterleaveWithECBytes(BitVector bits, int numTotalBytes, int numDataBytes, int numRSBlocks, BitVector result) {
                int i;
                if (bits.SizeInBytes() != numDataBytes) {
                    throw new StiQRCodeException("Number of bits and data bytes does not match");
                }
                int dataBytesOffset = 0;
                int maxNumDataBytes = 0;
                int maxNumEcBytes = 0;
                ArrayList<BlockPair> blocks = new ArrayList<BlockPair>(numRSBlocks);
                for (i = 0; i < numRSBlocks; ++i) {
                    int[] numDataBytesInBlock = new int[1];
                    int[] numEcBytesInBlock = new int[1];
                    QREncoder.GetNumDataBytesAndNumECBytesForBlockID(numTotalBytes, numDataBytes, numRSBlocks, i, numDataBytesInBlock, numEcBytesInBlock);
                    ByteArray dataBytes = new ByteArray();
                    dataBytes.Set(bits.GetArray(), dataBytesOffset, numDataBytesInBlock[0]);
                    ByteArray ecBytes = QREncoder.GenerateECBytes(dataBytes, numEcBytesInBlock[0]);
                    blocks.add(new BlockPair(dataBytes, ecBytes));
                    maxNumDataBytes = Math.max(maxNumDataBytes, dataBytes.Size());
                    maxNumEcBytes = Math.max(maxNumEcBytes, ecBytes.Size());
                    dataBytesOffset += numDataBytesInBlock[0];
                }
                if (numDataBytes != dataBytesOffset) {
                    throw new StiQRCodeException("Data bytes does not match offset");
                }
                for (i = 0; i < maxNumDataBytes; ++i) {
                    for (int j = 0; j < blocks.size(); ++j) {
                        ByteArray dataBytes = ((BlockPair)blocks.get(j)).GetDataBytes();
                        if (i >= dataBytes.Size()) continue;
                        result.AppendBits(dataBytes.At(i), 8);
                    }
                }
                for (i = 0; i < maxNumEcBytes; ++i) {
                    for (int j = 0; j < blocks.size(); ++j) {
                        ByteArray ecBytes = ((BlockPair)blocks.get(j)).GetErrorCorrectionBytes();
                        if (i >= ecBytes.Size()) continue;
                        result.AppendBits(ecBytes.At(i), 8);
                    }
                }
                if (numTotalBytes != result.SizeInBytes()) {
                    throw new StiQRCodeException("Interleaving error: " + numTotalBytes + " and " + result.SizeInBytes() + " differ.");
                }
            }

            private static ByteArray GenerateECBytes(ByteArray dataBytes, int numEcBytesInBlock) {
                int numDataBytes = dataBytes.Size();
                int[] toEncode = new int[numDataBytes + numEcBytesInBlock];
                for (int i = 0; i < numDataBytes; ++i) {
                    toEncode[i] = dataBytes.At(i);
                }
                new ReedSolomonEncoder(GaloisField.QRCode_256).Encode(toEncode, numEcBytesInBlock);
                ByteArray ecBytes = new ByteArray(numEcBytesInBlock);
                for (int i = 0; i < numEcBytesInBlock; ++i) {
                    ecBytes.Set(i, toEncode[numDataBytes + i]);
                }
                return ecBytes;
            }

            private static void AppendModeInfo(Mode mode, BitVector bits) {
                bits.AppendBits(mode.GetBits(), 4);
            }

            private static void AppendLengthInfo(int numLetters, int version, Mode mode, BitVector bits) {
                int numBits = mode.GetCharacterCountBits(Version.GetVersionForNumber(version));
                if (numLetters > (1 << numBits) - 1) {
                    throw new StiQRCodeException(numLetters + "is bigger than" + ((1 << numBits) - 1));
                }
                bits.AppendBits(numLetters, numBits);
            }

            private static void AppendBytes(String content, Mode mode, BitVector bits, String encoding) {
                if (mode.equals(Mode.NUMERIC)) {
                    QREncoder.AppendNumericBytes(content, bits);
                } else if (mode.equals(Mode.ALPHANUMERIC)) {
                    QREncoder.AppendAlphanumericBytes(content, bits);
                } else if (mode.equals(Mode.BYTE)) {
                    QREncoder.Append8BitBytes(content, bits, encoding);
                } else if (mode.equals(Mode.KANJI)) {
                    QREncoder.AppendKanjiBytes(content, bits);
                } else {
                    throw new StiQRCodeException("Invalid mode: " + mode);
                }
            }

            private static void AppendNumericBytes(String content, BitVector bits) {
                int length = content.length();
                int i = 0;
                while (i < length) {
                    int num2;
                    int num1 = content.charAt(i) - 48;
                    if (i + 2 < length) {
                        num2 = content.charAt(i + 1) - 48;
                        int num3 = content.charAt(i + 2) - 48;
                        bits.AppendBits(num1 * 100 + num2 * 10 + num3, 10);
                        i += 3;
                        continue;
                    }
                    if (i + 1 < length) {
                        num2 = content.charAt(i + 1) - 48;
                        bits.AppendBits(num1 * 10 + num2, 7);
                        i += 2;
                        continue;
                    }
                    bits.AppendBits(num1, 4);
                    ++i;
                }
            }

            private static void AppendAlphanumericBytes(String content, BitVector bits) {
                int length = content.length();
                int i = 0;
                while (i < length) {
                    int code1 = QREncoder.GetAlphanumericCode(content.charAt(i));
                    if (code1 == -1) {
                        throw new StiQRCodeException();
                    }
                    if (i + 1 < length) {
                        int code2 = QREncoder.GetAlphanumericCode(content.charAt(i + 1));
                        if (code2 == -1) {
                            throw new StiQRCodeException();
                        }
                        bits.AppendBits(code1 * 45 + code2, 11);
                        i += 2;
                        continue;
                    }
                    bits.AppendBits(code1, 6);
                    ++i;
                }
            }

            private static void Append8BitBytes(String content, BitVector bits, String encoding) {
                int[] bytes;
                try {
                    bytes = StiBarCodeTypeService.toInts(content.getBytes(encoding));
                }
                catch (Exception uee) {
                    throw new StiQRCodeException(uee.getMessage());
                }
                for (int i = 0; i < bytes.length; ++i) {
                    bits.AppendBits(bytes[i], 8);
                }
            }

            private static void AppendKanjiBytes(String content, BitVector bits) {
                int[] bytes;
                try {
                    bytes = StiBarCodeTypeService.toInts("Shift_JIS".getBytes(content));
                }
                catch (Exception uee) {
                    throw new StiQRCodeException(uee.getMessage());
                }
                int length = bytes.length;
                for (int i = 0; i < length; i += 2) {
                    int byte1 = bytes[i] & 0xFF;
                    int byte2 = bytes[i + 1] & 0xFF;
                    int code = byte1 << 8 | byte2;
                    int subtracted = -1;
                    if (code >= 33088 && code <= 40956) {
                        subtracted = code - 33088;
                    } else if (code >= 57408 && code <= 60351) {
                        subtracted = code - 49472;
                    }
                    if (subtracted == -1) {
                        throw new StiQRCodeException("Invalid byte sequence");
                    }
                    int encoded = (subtracted >> 8) * 192 + (subtracted & 0xFF);
                    bits.AppendBits(encoded, 13);
                }
            }

            private static void AppendECI(CharacterSetECI eci, BitVector bits) {
                bits.AppendBits(Mode.ECI.GetBits(), 4);
                bits.AppendBits(eci.GetValue(), 8);
            }
        }
    }

    protected static class StiQRCodeException
    extends RuntimeException {
        public StiQRCodeException() {
        }

        public StiQRCodeException(String message) {
            super(message);
        }

        public StiQRCodeException(String message, RuntimeException inner) {
            super(message, inner);
        }
    }
}

