/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiPlesseyBarCodeType;
import com.stimulsoft.report.barCodes.enums.StiPlesseyCheckSum;

public class StiMsiBarCodeType
extends StiPlesseyBarCodeType {
    private final String[] MsiTable = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};
    private final String MsiStartCode = "1";
    private final String MsiStopCode = "00";

    public StiMsiBarCodeType() {
        this(8.0, 1.0, StiPlesseyCheckSum.Modulo10, StiPlesseyCheckSum.None);
    }

    public StiMsiBarCodeType(double module, double height, StiPlesseyCheckSum checkSum1, StiPlesseyCheckSum checkSum2) {
        super(module, height, checkSum1, checkSum2);
    }

    @Override
    public String getServiceName() {
        return "Msi";
    }

    protected final String CodeToBarMsi(String inputCode) {
        StringBuilder outputBar = new StringBuilder();
        for (int index = 0; index < inputCode.length(); ++index) {
            StringBuilder currentsym = new StringBuilder();
            if (inputCode.charAt(index) == '1') {
                currentsym.append("71");
            } else {
                currentsym.append("53");
            }
            outputBar.append((CharSequence)currentsym);
        }
        return outputBar.toString();
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        int multiplier;
        long sum3;
        boolean odd;
        long multiplier2;
        long sum2;
        int sum;
        String code = this.GetCode(barCode);
        code = this.CheckCodeSymbols(code, this.PlesseySymbols);
        StringBuilder codeText = new StringBuilder(code);
        int codeLength = code.length();
        if (this.getCheckSum1() != StiPlesseyCheckSum.None) {
            ++codeLength;
        }
        if (this.getCheckSum2() != StiPlesseyCheckSum.None) {
            ++codeLength;
        }
        int[] fullCode = new int[codeLength];
        for (int index = 0; index < code.length(); ++index) {
            fullCode[index] = this.PlesseySymbols.indexOf(code.charAt(index));
        }
        if (this.getCheckSum1() != StiPlesseyCheckSum.None) {
            sum = 0;
            if (this.getCheckSum1() == StiPlesseyCheckSum.Modulo10) {
                long sum1 = 0L;
                sum2 = 0L;
                multiplier2 = 1L;
                odd = false;
                for (int index = code.length() - 1; index >= 0; --index) {
                    if (!odd) {
                        sum1 += (long)fullCode[index] * multiplier2;
                        multiplier2 *= 10L;
                    } else {
                        sum2 += (long)fullCode[index];
                    }
                    odd = !odd;
                }
                sum1 *= 2L;
                sum3 = 0L;
                while (sum1 >= 10L) {
                    sum3 += sum1 % 10L;
                    sum1 /= 10L;
                }
                sum = (int)(((sum3 += sum1) + sum2) % 10L);
                if (sum != 0) {
                    sum = 10 - sum;
                }
            }
            if (this.getCheckSum1() == StiPlesseyCheckSum.Modulo11) {
                int sum1 = 0;
                multiplier = 2;
                for (int index = code.length() - 1; index >= 0; --index) {
                    sum1 += fullCode[index] * multiplier;
                    if (++multiplier <= 7) continue;
                    multiplier = 2;
                }
                sum = sum1 % 11;
                if (sum != 0) {
                    sum = 11 - sum;
                }
            }
            fullCode[code.length()] = sum;
            codeText.append(this.PlesseySymbols.charAt(sum));
        }
        if (this.getCheckSum2() != StiPlesseyCheckSum.None) {
            sum = 0;
            if (this.getCheckSum2() == StiPlesseyCheckSum.Modulo10) {
                long sum1 = 0L;
                sum2 = 0L;
                multiplier2 = 1L;
                odd = false;
                for (int index = code.length(); index >= 0; --index) {
                    if (!odd) {
                        sum1 += (long)fullCode[index] * multiplier2;
                        multiplier2 *= 10L;
                    } else {
                        sum2 += (long)fullCode[index];
                    }
                    odd = !odd;
                }
                sum1 *= 2L;
                sum3 = 0L;
                while (sum1 >= 10L) {
                    sum3 += sum1 % 10L;
                    sum1 /= 10L;
                }
                sum = (int)(((sum3 += sum1) + sum2) % 10L);
                if (sum != 0) {
                    sum = 10 - sum;
                }
            }
            if (this.getCheckSum2() == StiPlesseyCheckSum.Modulo11) {
                int sum1 = 0;
                multiplier = 2;
                for (int index = code.length(); index >= 0; --index) {
                    sum1 += fullCode[index] * multiplier;
                    if (++multiplier <= 7) continue;
                    multiplier = 2;
                }
                sum = sum1 % 11;
                if (sum != 0) {
                    sum = 11 - sum;
                }
            }
            fullCode[code.length() + 1] = sum;
            codeText.append(this.PlesseySymbols.charAt(sum));
        }
        StringBuilder tempBarsArray = new StringBuilder();
        tempBarsArray.append("1");
        for (int index = 0; index < fullCode.length; ++index) {
            tempBarsArray.append(this.MsiTable[fullCode[index]]);
        }
        tempBarsArray.append("00");
        StringBuilder barsArray = new StringBuilder(this.CodeToBarMsi(tempBarsArray.toString()));
        this.CalculateSizeFull(20.0, 20.0, 0.0, 1.0, 70.0, 70.0, 71.0, 11.5, 84.0, 70.0, 1.667f, zoom, code, codeText.toString(), barsArray.toString(), rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public String getDefaultCodeValue() {
        return "1234567";
    }
}

