/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiGraphicsUnit;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiEAN13BarCodeType;
import com.stimulsoft.report.barCodes.StiIsbn13BarCodeType;
import com.stimulsoft.report.barCodes.enums.StiEanSupplementType;
import java.util.ArrayList;

public class StiIsbn10BarCodeType
extends StiIsbn13BarCodeType {
    public StiIsbn10BarCodeType() {
        this(13.0, 1.0, StiEanSupplementType.None, null, true);
    }

    public StiIsbn10BarCodeType(double module, double height, StiEanSupplementType supplementType, String supplementCodeValue, boolean showQuietZoneIndicator) {
        super(module, height, supplementType, supplementCodeValue, showQuietZoneIndicator);
    }

    @Override
    public String getServiceName() {
        return "ISBN-10";
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String fullCode = this.GetCode(barCode);
        String code = "978" + this.CheckCodeSymbols(fullCode, "0123456789") + "0000000000000";
        String suppCode = this.CheckCodeSymbols(this.getSupplementCode(), "0123456789") + "00000";
        ArrayList<StiEAN13BarCodeType.EanBarInfo> barsArray = null;
        if (this.getSupplementType() == StiEanSupplementType.None) {
            String tempRef_code = new String(code);
            barsArray = this.MakeEan13Bars(tempRef_code, true);
            code = tempRef_code;
        } else {
            String tempRef_code2 = new String(code);
            barsArray = this.MakeEan13Bars(tempRef_code2, false);
            code = tempRef_code2;
            if (this.getSupplementType() == StiEanSupplementType.TwoDigit) {
                this.MakeEanAdd2Bars(suppCode, barsArray, true);
            } else {
                this.MakeEanAdd5Bars(suppCode, barsArray, true);
            }
        }
        this.CalculateSizeEan(10.0, zoom, barsArray, rect, barCode);
        this.translateRect(context, rect, barCode);
        this.drawEanBars(context, barsArray, barCode);
        StiSolidBrush foreBrush = new StiSolidBrush(barCode.getForeColor());
        StiFont barCodeFont = new StiFont(barCode.getFont().getName(), barCode.getFont().getSize() * barCode.getBarCodeType().getLabelFontHeight() * this.getModule() / 104.0, barCode.getFont().getStyle(), StiGraphicsUnit.Point);
        String codeIsbn = "ISBN " + fullCode;
        this.baseDrawString(context, codeIsbn, barCodeFont, (StiBrush)foreBrush, new StiRectangle(0.0, 0.0, this.getBarCodeData().MainWidth, this.getBarCodeData().SpaceTextTop), StiTextHorAlignment.Center, StiVertAlignment.Top, zoom);
        this.rollbackTransform(context);
    }

    @Override
    public String getDefaultCodeValue() {
        return "0-7356-2153-5";
    }
}

