/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;

public class StiFIMBarCodeType
extends StiBarCodeTypeService {
    protected String FIMSymbols = "abcd";
    protected String[] FIMTable = new String[]{"4040114011404", "40140401404014", "40401401401404", "404040140140404"};
    protected static final double defaultFIMModule = 31.25;
    private double module = 31.25;
    private double height = 1.0;
    private boolean addClearZone = false;
    protected static final double FIMSpaceTop = 0.0;
    protected static final double FIMSpaceBottom = 0.0;
    protected static final double FIMLineHeightShort = 20.0;
    protected static final double FIMLineHeightLong = 20.0;
    protected static final double FIMTextPosition = 0.0;
    protected static final double FIMTextHeight = 8.0;
    protected static final double FIMMainHeight = 20.0;
    protected static final double FIMLineHeightForCut = 20.0;

    public StiFIMBarCodeType() {
        this(31.25, 1.0, false);
    }

    public StiFIMBarCodeType(double module, double height, boolean addClearZone) {
        this.module = module;
        this.height = height;
        this.addClearZone = addClearZone;
    }

    public String getServiceName() {
        return "FIM";
    }

    @Override
    @StiDefaulValue(value="10.0")
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = 31.25;
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = 1.0;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getAddClearZone() {
        return this.addClearZone;
    }

    public final void setAddClearZone(boolean value) {
        this.addClearZone = value;
    }

    @Override
    public double getLabelFontHeight() {
        return 8.0;
    }

    protected final double getFIMSpaceLeft() {
        if (this.addClearZone) {
            return 16.0;
        }
        return 1.0;
    }

    protected final double getFIMSpaceRight() {
        if (this.addClearZone) {
            return 7.0;
        }
        return 1.0;
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode).toLowerCase();
        code = this.CheckCodeSymbols(code, this.FIMSymbols) + 'a';
        String barsArray = "";
        if (code.charAt(0) == 'a') {
            barsArray = this.FIMTable[0];
        } else if (code.charAt(0) == 'b') {
            barsArray = this.FIMTable[1];
        } else if (code.charAt(0) == 'c') {
            barsArray = this.FIMTable[2];
        } else if (code.charAt(0) == 'd') {
            barsArray = this.FIMTable[3];
        }
        this.CalculateSizeFull(this.getFIMSpaceLeft(), this.getFIMSpaceRight(), 0.0, 0.0, 20.0, 20.0, 0.0, 8.0, 20.0, 20.0, 2.0, zoom, code, "", barsArray, rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Module", this.getModule(), 31.25);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        jObject.AddPropertyBool("AddClearZone", this.getAddClearZone());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("Height")) {
                this.height = property.floatValue().floatValue();
                continue;
            }
            if (!property.Name.equals("AddClearZone")) continue;
            this.addClearZone = (Boolean)property.Value;
        }
    }

    @Override
    public String getDefaultCodeValue() {
        return "A";
    }
}

